/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalComboBoxButton
extends JButton {
    protected JComboBox comboBox;
    protected JList listBox;
    protected CellRendererPane rendererPane;
    protected Icon comboIcon;
    protected boolean iconOnly;

    public final JComboBox getComboBox() {
        return this.comboBox;
    }

    public final void setComboBox(JComboBox cb) {
        this.comboBox = cb;
    }

    public final Icon getComboIcon() {
        return this.comboIcon;
    }

    public final void setComboIcon(Icon i) {
        this.comboIcon = i;
    }

    public final boolean isIconOnly() {
        return this.iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this.iconOnly = isIconOnly;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.iconOnly) {
            Rectangle bounds = this.getBounds();
            int x = (bounds.width - this.comboIcon.getIconWidth()) / 2;
            int y = (bounds.height - this.comboIcon.getIconHeight()) / 2;
            this.comboIcon.paintIcon(this.comboBox, g, x, y);
        } else {
            Object selected = this.comboBox.getModel().getSelectedItem();
            if (selected == null) {
                selected = "";
            }
            Rectangle bounds = this.comboBox.getBounds();
            Rectangle innerArea = SwingUtilities.calculateInnerArea(this, null);
            Insets insets = this.comboBox.getInsets();
            Rectangle renderArea = new Rectangle(innerArea.x, innerArea.y, innerArea.width - this.comboIcon.getIconWidth() - 4, innerArea.height);
            Component cellRenderer = this.comboBox.getRenderer().getListCellRendererComponent(this.listBox, selected, this.comboBox.getSelectedIndex(), false, false);
            cellRenderer.setBackground(this.comboBox.getBackground());
            cellRenderer.setEnabled(this.comboBox.isEnabled());
            this.rendererPane.paintComponent(g, cellRenderer, this, renderArea);
            if (this.comboBox.hasFocus()) {
                g.setColor(MetalLookAndFeel.getFocusColor());
                g.drawRect(innerArea.x, innerArea.y - 1, innerArea.width - 1, innerArea.height);
            }
            int iconX = bounds.width - insets.right - this.comboIcon.getIconWidth() - 7;
            int iconY = insets.top + (bounds.height - this.comboIcon.getIconHeight()) / 2;
            this.comboIcon.paintIcon(this.comboBox, g, iconX, iconY);
        }
    }

    public MetalComboBoxButton(JComboBox cb, Icon i, CellRendererPane pane, JList list2) {
        this(cb, i, cb.isEditable(), pane, list2);
    }

    public MetalComboBoxButton(JComboBox cb, Icon i, boolean onlyIcon, CellRendererPane pane, JList list2) {
        if (cb == null) {
            throw new NullPointerException("Null 'cb' argument");
        }
        this.comboBox = cb;
        this.comboIcon = i;
        this.iconOnly = onlyIcon;
        this.listBox = list2;
        this.rendererPane = pane;
    }
}

