/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;

public class MessageLoggerEngine
implements MessageLogger {
    private final Stack loggerStack = new Stack();
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();

    private MessageLogger peekLogger() {
        if (this.loggerStack.isEmpty()) {
            return Message.getDefaultLogger();
        }
        return (MessageLogger)this.loggerStack.peek();
    }

    @Override
    public final void warn(String string) {
        this.peekLogger().warn(string);
        this.problems.add("WARN:  " + string);
        this.warns.add(string);
    }

    @Override
    public void error(String string) {
        this.peekLogger().error(string);
        this.problems.add("\tERROR: " + string);
        this.errors.add(string);
    }

    @Override
    public final List getErrors() {
        return this.errors;
    }

    @Override
    public final List getProblems() {
        return this.problems;
    }

    @Override
    public final List getWarns() {
        return this.warns;
    }

    @Override
    public final void sumupProblems() {
        LogOptions.sumupProblems(this);
        this.clearProblems();
    }

    @Override
    public final void clearProblems() {
        Message.getDefaultLogger().clearProblems();
        Iterator iterator2 = this.loggerStack.iterator();
        while (iterator2.hasNext()) {
            ((MessageLogger)iterator2.next()).clearProblems();
        }
        this.problems.clear();
        this.errors.clear();
        this.warns.clear();
    }

    @Override
    public final void debug(String string) {
        this.peekLogger().debug(string);
    }

    @Override
    public final void deprecated(String string) {
        this.peekLogger().deprecated(string);
    }

    @Override
    public final void endProgress(String string) {
        this.peekLogger().endProgress(string);
    }

    @Override
    public final void info(String string) {
        this.peekLogger().info(string);
    }

    @Override
    public final void rawinfo(String string) {
        this.peekLogger().rawinfo(string);
    }

    @Override
    public final void log(String string, int n) {
        this.peekLogger().log(string, n);
    }

    @Override
    public final void progress() {
        this.peekLogger().progress();
    }

    @Override
    public final void rawlog(String string, int n) {
        this.peekLogger().rawlog(string, n);
    }

    @Override
    public final void verbose(String string) {
        this.peekLogger().verbose(string);
    }
}

