/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.LookupListenerList;
import org.openide.util.lookup.WaitableResult;

final class SimpleProxyLookup
extends Lookup {
    private Lookup.Provider provider;
    private Lookup delegate;
    private WeakHashMap<Lookup.Template<?>, Reference<ProxyResult<?>>> results;

    SimpleProxyLookup(Lookup.Provider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup checkLookup() {
        Lookup lookup = this.provider.getLookup();
        Iterator<Reference<ProxyResult<?>>> iterator = null;
        Object object = this;
        synchronized (object) {
            if (lookup != this.delegate) {
                this.delegate = lookup;
                if (this.results != null) {
                    iterator = new ArrayList(this.results.values()).iterator();
                }
            }
        }
        if (iterator != null) {
            LookupListener lookupListener;
            Reference<ProxyResult<?>> reference;
            object = new ArrayList();
            Iterator<Reference<ProxyResult<Object>>> iterator2 = iterator;
            while (iterator2.hasNext()) {
                reference = iterator2.next();
                if (reference == null || (lookupListener = reference.get()) == null || !((ProxyResult)lookupListener).updateLookup(null, null)) continue;
                ((ProxyResult)lookupListener).collectFires((Collection<Object>)object);
            }
            iterator2 = ((ArrayList)object).iterator();
            while (iterator2.hasNext()) {
                reference = (LookupEvent)((Object)iterator2.next());
                lookupListener = (LookupListener)((Object)iterator2.next());
                lookupListener.resultChanged((LookupEvent)((Object)reference));
            }
        }
        return lookup;
    }

    final synchronized Lookup getLookupDelegate() {
        return this.delegate;
    }

    private static <T> ProxyResult<T> cast(ProxyResult<?> proxyResult) {
        return proxyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        ProxyResult<T> proxyResult;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            Reference<ProxyResult<?>> reference;
            if (this.results == null) {
                this.results = new WeakHashMap();
            } else {
                ProxyResult<?> proxyResult2;
                reference = this.results.get(template);
                if (reference != null && (proxyResult2 = reference.get()) != null) {
                    return SimpleProxyLookup.cast(proxyResult2);
                }
            }
            proxyResult = new ProxyResult<T>(template);
            reference = new WeakReference(proxyResult);
            this.results.put(template, reference);
        }
        ((ProxyResult)proxyResult).checkResult();
        return proxyResult;
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        if (clazz == null) {
            this.checkLookup();
            return null;
        }
        return this.checkLookup().lookup(clazz);
    }

    @Override
    public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        return this.checkLookup().lookupItem(template);
    }

    private final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        final Lookup.Result source;
        final Reference<ProxyResult<T>> result;

        WeakResult(ProxyResult<T> proxyResult, Lookup.Result<T> result) {
            this.result = new WeakReference<ProxyResult<ProxyResult<T>>>(proxyResult);
            this.source = result;
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            ProxyResult<T> proxyResult = this.result.get();
            if (proxyResult != null) {
                proxyResult.beforeLookup(template);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> collection) {
            ProxyResult<T> proxyResult = this.result.get();
            if (proxyResult != null) {
                proxyResult.collectFires(collection);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public void addLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            ProxyResult<T> proxyResult = this.result.get();
            if (proxyResult != null) {
                proxyResult.resultChanged(lookupEvent);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean bl) {
            return this.allItems();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<? extends Object> allInstances(boolean bl) {
            return this.allInstances();
        }

        public String toString() {
            return "SimpleProxy$WeakResult[source=" + this.source + "]";
        }
    }

    private final class ProxyResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private final Lookup.Template<T> template;
        private Lookup.Result<T> delegate;
        private LookupListenerList listeners;
        private WeakResult<T> lastListener;

        ProxyResult(Lookup.Template<T> template) {
            this.template = template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup.Result<T> checkResult() {
            Lookup.Result[] resultArray = this;
            synchronized (this) {
                Lookup.Result<T> result = this.getDelegate();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                SimpleProxyLookup.this.checkLookup();
                resultArray = new Lookup.Result[]{null};
                this.updateLookup(result, resultArray);
                return resultArray[0];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateLookup(Lookup.Result result, Lookup.Result[] resultArray) {
            WeakResult<T> weakResult;
            Lookup.Result<T> result2;
            ArrayList arrayList;
            Collection collection = null;
            while (true) {
                WeakResult<T> weakResult2;
                Lookup.Result<T> result3;
                ProxyResult proxyResult = this;
                synchronized (proxyResult) {
                    arrayList = SimpleProxyLookup.this.getLookupDelegate();
                    result3 = this.getDelegate();
                    if (result3 != null && this.getLastListener() != null) {
                        weakResult2 = this.getLastListener();
                        result3.removeLookupListener(this.getLastListener());
                    } else {
                        weakResult2 = null;
                    }
                }
                if (collection == null) {
                    if (result != null) {
                        collection = result.allItems();
                    } else if (resultArray == null && result3 != null) {
                        collection = result3.allItems();
                    }
                }
                result2 = ((Lookup)((Object)arrayList)).lookup(this.template);
                proxyResult = this;
                synchronized (proxyResult) {
                    WeakResult<T> weakResult3 = this.getLastListener();
                    if (weakResult2 == weakResult3) {
                        weakResult = weakResult3 != null && weakResult3.source == result2 && weakResult3.result.get() == this ? weakResult3 : new WeakResult<T>(this, result2);
                        this.setLastListener(weakResult);
                        this.setDelegate(result2);
                        if (resultArray != null) {
                            resultArray[0] = result2;
                        }
                        break;
                    }
                }
            }
            result2.addLookupListener(weakResult);
            if (collection == null) {
                return false;
            }
            arrayList = result2.allItems();
            if (!(collection instanceof List)) {
                collection = collection == Collections.EMPTY_SET ? Collections.emptyList() : new ArrayList(collection);
            }
            if (!(arrayList instanceof List)) {
                arrayList = new ArrayList(arrayList);
            }
            return !collection.equals(arrayList);
        }

        @Override
        public void addLookupListener(LookupListener lookupListener) {
            this.getListeners(lookupListener, null);
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
            this.getListeners(null, lookupListener);
        }

        @Override
        public Collection<? extends T> allInstances() {
            return this.checkResult().allInstances();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return this.checkResult().allClasses();
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.checkResult().allItems();
        }

        @Override
        protected void beforeLookup(Lookup.Template template) {
            Lookup.Result<T> result = this.checkResult();
            if (result instanceof WaitableResult) {
                ((WaitableResult)result).beforeLookup(template);
            }
        }

        @Override
        public void resultChanged(LookupEvent lookupEvent) {
            this.collectFires(null);
        }

        @Override
        protected void collectFires(Collection<Object> collection) {
            LookupListenerList lookupListenerList = this.getListeners(null, null);
            if (lookupListenerList == null) {
                return;
            }
            Object[] objectArray = lookupListenerList.getListenerList();
            if (objectArray.length == 0) {
                return;
            }
            LookupEvent lookupEvent = new LookupEvent(this);
            AbstractLookup.notifyListeners(objectArray, lookupEvent, collection);
        }

        @Override
        protected Collection<? extends Object> allInstances(boolean bl) {
            return this.allInstances();
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean bl) {
            return this.allItems();
        }

        private synchronized LookupListenerList getListeners(LookupListener lookupListener, LookupListener lookupListener2) {
            if (lookupListener == null && this.listeners == null) {
                return null;
            }
            if (this.listeners == null) {
                this.listeners = new LookupListenerList();
            }
            if (lookupListener != null) {
                this.listeners.add(lookupListener);
            }
            if (lookupListener2 != null) {
                this.listeners.remove(lookupListener2);
            }
            return this.listeners;
        }

        private Lookup.Result<T> getDelegate() {
            assert (Thread.holdsLock(this));
            return this.delegate;
        }

        private void setDelegate(Lookup.Result<T> result) {
            assert (Thread.holdsLock(this));
            this.delegate = result;
        }

        private WeakResult<T> getLastListener() {
            assert (Thread.holdsLock(this));
            return this.lastListener;
        }

        private void setLastListener(WeakResult<T> weakResult) {
            assert (Thread.holdsLock(this));
            this.lastListener = weakResult;
        }
    }
}

