/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;

public class SSLOptions {
    private static final String SSL_PROTOCOL = "TLS";
    public static final String[] DEFAULT_SSL_CIPHER_SUITES = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};
    final SSLContext context;
    final String[] cipherSuites;

    public SSLOptions() {
        this(SSLOptions.makeDefaultContext(), DEFAULT_SSL_CIPHER_SUITES);
    }

    public SSLOptions(SSLContext context, String[] cipherSuites) {
        this.context = context;
        this.cipherSuites = cipherSuites;
    }

    private static SSLContext makeDefaultContext() throws IllegalStateException {
        try {
            SSLContext ctx = SSLContext.getInstance(SSL_PROTOCOL);
            ctx.init(null, null, null);
            return ctx;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("This JVM doesn't support TLS, this shouldn't happen");
        }
        catch (KeyManagementException e) {
            throw new IllegalStateException("Cannot initialize SSL Context", e);
        }
    }
}

