/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.ClusterSession;
import org.apache.catalina.cluster.session.SimpleTcpReplicationManager;
import org.apache.catalina.session.StandardSession;

public class ReplicatedSession
extends StandardSession
implements ClusterSession {
    private transient Manager mManager = null;
    protected boolean isDirty = false;
    private transient long lastAccessWasDistributed = System.currentTimeMillis();
    private boolean isPrimarySession = true;

    public ReplicatedSession(Manager manager) {
        super(manager);
        this.mManager = manager;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setIsDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setLastAccessWasDistributed(long time) {
        this.lastAccessWasDistributed = time;
    }

    public long getLastAccessWasDistributed() {
        return this.lastAccessWasDistributed;
    }

    public void removeAttribute(String name) {
        this.setIsDirty(true);
        super.removeAttribute(name);
    }

    public void removeAttribute(String name, boolean notify) {
        this.setIsDirty(true);
        super.removeAttribute(name, notify);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Value for attribute " + name + " is not serializable.");
        }
        this.setIsDirty(true);
        super.setAttribute(name, value);
    }

    public void setMaxInactiveInterval(int interval) {
        this.setIsDirty(true);
        super.setMaxInactiveInterval(interval);
    }

    public void setManager(SimpleTcpReplicationManager mgr) {
        this.mManager = mgr;
        super.setManager((Manager)mgr);
    }

    public void setPrincipal(Principal principal) {
        super.setPrincipal(principal);
        this.setIsDirty(true);
    }

    public void expire() {
        SimpleTcpReplicationManager mgr = (SimpleTcpReplicationManager)this.getManager();
        mgr.sessionInvalidated(this.getIdInternal());
        this.setIsDirty(true);
        super.expire();
    }

    public void invalidate() {
        SimpleTcpReplicationManager mgr = (SimpleTcpReplicationManager)this.getManager();
        mgr.sessionInvalidated(this.getIdInternal());
        this.setIsDirty(true);
        super.invalidate();
    }

    public void readObjectData(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        super.readObjectData(stream);
    }

    public void writeObjectData(ObjectOutputStream stream) throws IOException {
        super.writeObjectData(stream);
    }

    public void setId(String id, boolean tellNew) {
        if (this.id != null && this.manager != null) {
            this.manager.remove((Session)this);
        }
        this.id = id;
        if (this.manager != null) {
            this.manager.add((Session)this);
        }
        if (tellNew) {
            this.tellNew();
        }
    }

    public boolean isPrimarySession() {
        return this.isPrimarySession;
    }

    public void setPrimarySession(boolean primarySession) {
        this.isPrimarySession = primarySession;
    }

    protected void log(String message) {
        if (this.mManager != null && this.mManager instanceof SimpleTcpReplicationManager) {
            SimpleTcpReplicationManager cfr_ignored_0 = (SimpleTcpReplicationManager)this.mManager;
            SimpleTcpReplicationManager.log.debug((Object)("ReplicatedSession: " + message));
        } else {
            System.out.println("ReplicatedSession: " + message);
        }
    }

    protected void log(String message, Throwable x) {
        if (this.mManager != null && this.mManager instanceof SimpleTcpReplicationManager) {
            SimpleTcpReplicationManager cfr_ignored_0 = (SimpleTcpReplicationManager)this.mManager;
            SimpleTcpReplicationManager.log.error((Object)("ReplicatedSession: " + message), x);
        } else {
            System.out.println("ReplicatedSession: " + message);
            x.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ReplicatedSession id=");
        buf.append(this.getIdInternal()).append(" ref=").append(super.toString()).append("\n");
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = this.getAttribute(name);
            buf.append("\tname=").append(name).append("; value=").append(value).append("\n");
        }
        buf.append("\tLastAccess=").append(this.getLastAccessedTime()).append("\n");
        return buf.toString();
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public void setAccessCount(int accessCount) {
        this.accessCount = accessCount;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public long getThisAccessedTime() {
        return this.thisAccessedTime;
    }

    public void setThisAccessedTime(long thisAccessedTime) {
        this.thisAccessedTime = thisAccessedTime;
    }
}

