/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;

public class RefactoringUtil {
    private RefactoringUtil() {
    }

    public static Set<XPathExpression> collectMatchingExpressions(XPathExpression expression) {
        PsiElement usageBlock = XsltCodeInsightUtil.getUsageBlock(expression);
        if (usageBlock == null) {
            return Collections.emptySet();
        }
        ExpressionCollector visitor = new ExpressionCollector(expression);
        usageBlock.accept((PsiElementVisitor)visitor);
        return visitor.getMatches();
    }

    public static List<XPathVariableReference> collectVariableReferences(PsiElement block) {
        VariableReferenceCollector visitor = new VariableReferenceCollector();
        block.accept((PsiElementVisitor)visitor);
        ArrayList<XPathVariableReference> list = new ArrayList<XPathVariableReference>(visitor.getMatches());
        Collections.sort(list, XsltCodeInsightUtil.POSITION_COMPARATOR);
        return list;
    }

    public static XmlTag addParameter(XmlTag templateTag, XmlTag paramTag) throws IncorrectOperationException {
        return RefactoringUtil.addParameter(templateTag, paramTag, XsltCodeInsightUtil.findLastParam(templateTag));
    }

    public static XmlTag addParameter(XmlTag templateTag, XmlTag paramTag, XmlTag anchor) throws IncorrectOperationException {
        PsiElement c;
        paramTag = anchor != null ? (XmlTag)templateTag.addAfter((PsiElement)paramTag, (PsiElement)anchor) : ((c = XsltCodeInsightUtil.findFirstRealTagChild(templateTag)) != null ? (XmlTag)templateTag.addBefore((PsiElement)paramTag, c) : (XmlTag)templateTag.add((PsiElement)paramTag));
        paramTag = (XmlTag)CodeStyleManager.getInstance((Project)paramTag.getManager().getProject()).reformat((PsiElement)paramTag);
        return paramTag;
    }

    public static XmlTag addWithParam(XmlTag templateTag) throws IncorrectOperationException {
        PsiElement c;
        XmlTag withParamTag = templateTag.createChildTag("with-param", "http://www.w3.org/1999/XSL/Transform", null, false);
        XmlTag anchor = XsltCodeInsightUtil.findLastWithParam(templateTag);
        withParamTag = anchor != null ? (XmlTag)templateTag.addAfter((PsiElement)withParamTag, (PsiElement)anchor) : ((c = XsltCodeInsightUtil.findFirstRealTagChild(templateTag)) != null ? (XmlTag)templateTag.addBefore((PsiElement)withParamTag, c) : (XmlTag)templateTag.add((PsiElement)withParamTag));
        withParamTag = (XmlTag)CodeStyleManager.getInstance((Project)withParamTag.getManager().getProject()).reformat((PsiElement)withParamTag);
        return withParamTag;
    }

    static class ExpressionCollector
    extends DeepXPathVistor {
        private final XPathExpression myExpression;
        private final Set<XPathExpression> myList;

        ExpressionCollector(XPathExpression expression) {
            this.myExpression = expression;
            this.myList = new HashSet<XPathExpression>();
        }

        @Override
        protected void visitXPathExpression(XPathExpression expr) {
            if (expr != this.myExpression) {
                if (ExpressionCollector.isAccepted(expr) && ExpressionCollector.isEquivalent(expr, this.myExpression)) {
                    this.myList.add(expr);
                } else {
                    this.superVisitElement(expr);
                }
            }
        }

        private static boolean isAccepted(XPathExpression expr) {
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)expr, XmlAttribute.class, (boolean)true);
            return attribute != null && !XsltSupport.isPatternAttribute(attribute);
        }

        private static boolean isEquivalent(XPathExpression expr, XPathExpression expression) {
            return XsltCodeInsightUtil.areExpressionsEquivalent(expr, expression);
        }

        public Set<XPathExpression> getMatches() {
            return this.myList;
        }
    }

    static class VariableReferenceCollector
    extends DeepXPathVistor {
        private final Set<XPathVariableReference> myList = new HashSet<XPathVariableReference>();

        protected VariableReferenceCollector() {
        }

        @Override
        protected void visitXPathExpression(XPathExpression expr) {
            if (expr instanceof XPathVariableReference) {
                this.myList.add((XPathVariableReference)expr);
            }
        }

        public Set<XPathVariableReference> getMatches() {
            return this.myList;
        }
    }

    static abstract class DeepXPathVistor
    extends XmlRecursiveElementVisitor {
        protected DeepXPathVistor() {
        }

        protected void superVisitElement(PsiElement element) {
            super.visitElement(element);
        }

        public void visitElement(PsiElement element) {
            if (element instanceof XPathElement) {
                if (element instanceof XPathExpression) {
                    this.visitXPathExpression((XPathExpression)element);
                }
                element.acceptChildren((PsiElementVisitor)this);
            } else {
                super.visitElement(element);
            }
        }

        protected abstract void visitXPathExpression(XPathExpression var1);

        public void visitXmlAttribute(XmlAttribute attribute) {
            if (XsltSupport.isXPathAttribute(attribute)) {
                PsiFile[] xpathFiles;
                for (PsiFile xpathFile : xpathFiles = XsltSupport.getFiles(attribute)) {
                    xpathFile.accept((PsiElementVisitor)this);
                }
            }
        }
    }
}

