/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.util;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import java.util.Arrays;
import java.util.List;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownPsiUtil {
    public static final TokenSet PRESENTABLE_TYPES = MarkdownTokenTypeSets.HEADERS;
    public static final TokenSet TRANSPARENT_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.MARKDOWN_FILE, MarkdownElementTypes.UNORDERED_LIST, MarkdownElementTypes.ORDERED_LIST, MarkdownElementTypes.LIST_ITEM, MarkdownElementTypes.BLOCK_QUOTE});
    private static final List<TokenSet> HEADER_ORDER = Arrays.asList(TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.MARKDOWN_FILE_ELEMENT_TYPE}), MarkdownTokenTypeSets.HEADER_LEVEL_1_SET, MarkdownTokenTypeSets.HEADER_LEVEL_2_SET, MarkdownTokenTypeSets.HEADER_LEVEL_3_SET, MarkdownTokenTypeSets.HEADER_LEVEL_4_SET, MarkdownTokenTypeSets.HEADER_LEVEL_5_SET, MarkdownTokenTypeSets.HEADER_LEVEL_6_SET);

    public static void processContainer(@Nullable PsiElement myElement, @NotNull Consumer<? super PsiElement> consumer, @NotNull NullableConsumer<? super PsiElement> nextHeaderConsumer) {
        PsiElement structureContainer;
        if (consumer == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(0);
        }
        if (nextHeaderConsumer == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(1);
        }
        if (myElement == null) {
            return;
        }
        PsiElement psiElement = structureContainer = myElement instanceof MarkdownFile ? myElement.getFirstChild() : MarkdownPsiUtil.getParentOfType(myElement, TRANSPARENT_CONTAINERS);
        if (structureContainer == null) {
            return;
        }
        MarkdownHeaderImpl currentHeader = myElement instanceof MarkdownHeaderImpl ? (MarkdownHeaderImpl)myElement : null;
        MarkdownPsiUtil.processContainer(structureContainer, (PsiElement)currentHeader, currentHeader, consumer, nextHeaderConsumer);
    }

    private static void processContainer(@NotNull PsiElement container, @Nullable PsiElement sameLevelRestriction, @Nullable MarkdownPsiElement from, @NotNull Consumer<? super PsiElement> resultConsumer, @NotNull NullableConsumer<? super PsiElement> nextHeaderConsumer) {
        if (container == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(2);
        }
        if (resultConsumer == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(3);
        }
        if (nextHeaderConsumer == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(4);
        }
        PsiElement nextSibling = from == null ? container.getFirstChild() : from.getNextSibling();
        PsiElement maxContentLevel = null;
        while (nextSibling != null) {
            if (TRANSPARENT_CONTAINERS.contains(PsiUtilCore.getElementType((PsiElement)nextSibling)) && maxContentLevel == null) {
                MarkdownPsiUtil.processContainer(nextSibling, null, null, resultConsumer, nextHeaderConsumer);
            } else if (nextSibling instanceof MarkdownHeaderImpl) {
                if (sameLevelRestriction != null && MarkdownPsiUtil.isSameLevelOrHigher(nextSibling, sameLevelRestriction)) {
                    nextHeaderConsumer.consume((Object)nextSibling);
                    break;
                }
                if (maxContentLevel == null || MarkdownPsiUtil.isSameLevelOrHigher(nextSibling, maxContentLevel)) {
                    maxContentLevel = nextSibling;
                    IElementType type = nextSibling.getNode().getElementType();
                    if (PRESENTABLE_TYPES.contains(type)) {
                        resultConsumer.consume((Object)nextSibling);
                    }
                }
            }
            if ((nextSibling = nextSibling.getNextSibling()) != null) continue;
            nextHeaderConsumer.consume(null);
        }
    }

    private static boolean isSameLevelOrHigher(@NotNull PsiElement psiA, @NotNull PsiElement psiB) {
        if (psiA == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(5);
        }
        if (psiB == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(6);
        }
        IElementType typeA = psiA.getNode().getElementType();
        IElementType typeB = psiB.getNode().getElementType();
        return MarkdownPsiUtil.headerLevel(typeA) <= MarkdownPsiUtil.headerLevel(typeB);
    }

    private static int headerLevel(@NotNull IElementType curLevelType) {
        if (curLevelType == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(7);
        }
        for (int i = 0; i < HEADER_ORDER.size(); ++i) {
            if (!HEADER_ORDER.get(i).contains(curLevelType)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    @Nullable
    private static PsiElement getParentOfType(@NotNull PsiElement myElement, @NotNull TokenSet types) {
        ASTNode parentNode;
        if (myElement == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(8);
        }
        if (types == null) {
            MarkdownPsiUtil.$$$reportNull$$$0(9);
        }
        return (parentNode = TreeUtil.findParent((ASTNode)myElement.getNode(), (TokenSet)types)) == null ? null : parentNode.getPsi();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextHeaderConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiA";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiB";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curLevelType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/util/MarkdownPsiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processContainer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSameLevelOrHigher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "headerLevel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentOfType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

