/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCorePredefinedLibrariesProvider
extends JSPredefinedLibraryProvider {
    private static final String ON = "On";
    public static final String LIB_HTML = "HTML";
    public static final String LIB_NASHORN = "Nashorn";
    public static final String LIB_NODE = "Node.js Core";
    public static final String ECMASCRIPT5_JS = "lib.es5.d.ts";
    public static final String BROWSER_D_TS = "browser.d.ts";
    public static final String FLOW_UTILITIES_D_TS = "flow.utilities.d.ts";
    private static final String[][] ourPredefinedLibraries = new String[][]{{"HTML", "On", "lib.dom.d.ts", "lib.dom.iterable.d.ts", "lib.scripthost.d.ts", "lib.webworker.d.ts", "lib.webworker.importscripts.d.ts", "browser.d.ts", "xpath.d.ts", "websql.d.ts", "lib.esnext.bigint.d.ts"}};
    private static final String[] ES5_LIB_FILES = new String[]{"lib.es5.d.ts"};
    private static final String[] ourJSXLibraries = new String[]{"react.d.ts"};
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourJSXPredefLibFiles = JSCorePredefinedLibrariesProvider.newAtomicNotNullLazyValue(ourJSXLibraries);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourJSCorePredefLibFiles = JSCorePredefinedLibrariesProvider.newAtomicNotNullLazyValue(ES5_LIB_FILES);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourFlowJSCorePredefLibFiles = JSCorePredefinedLibrariesProvider.newAtomicNotNullLazyValue(new String[]{"flow.utilities.d.ts"});
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourFlowJSPredefLibFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
            File flowLibDir = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "flow");
            File[] flowLibFiles = flowLibDir.listFiles();
            if (flowLibFiles != null) {
                for (File file2 : flowLibFiles) {
                    VirtualFile flowLibFile = JSLibraryUtil.findFileByIO(file2, false);
                    if (flowLibFile == null) continue;
                    result2.add(flowLibFile);
                }
            }
            HashSet<VirtualFile> hashSet = result2;
            if (hashSet == null) {
                1.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$1", "compute"));
        }
    };
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourJSPredefLibFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
            for (String[] libDef : ourPredefinedLibraries) {
                assert (libDef.length >= 3);
                result2.addAll(JSCorePredefinedLibrariesProvider.getFiles(libDef));
            }
            result2.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
            result2.addAll(JSCorePredefinedLibrariesProvider.getFlowJSCorePredefinedLibraryFiles());
            result2.addAll(TypeScriptUtil.getLibFiles((Condition<? super String>)ES6_LIB_CONDITION, false));
            HashSet<VirtualFile> hashSet = result2;
            if (hashSet == null) {
                2.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$2", "compute"));
        }
    };
    private static final Condition<String> ES6_LIB_CONDITION = name -> JSCorePredefinedLibrariesProvider.isES6Lib(name);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourAllJSPredefLibFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
            for (String[] libDef : ourPredefinedLibraries) {
                assert (libDef.length >= 3);
                result2.addAll(JSCorePredefinedLibrariesProvider.getFiles(libDef));
            }
            result2.addAll(TypeScriptUtil.getLibFiles((Condition<? super String>)Conditions.alwaysTrue(), false));
            JSCorePredefinedLibrariesProvider.addFiles(result2, ourJSXLibraries);
            HashSet<VirtualFile> hashSet = result2;
            if (hashSet == null) {
                3.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$3", "compute"));
        }
    };
    private static final Map<String, Ref<VirtualFile>> ourLibFileCache = ContainerUtil.newConcurrentMap();

    public static boolean isECMAScriptLibraryFileName(String fileName) {
        for (VirtualFile file2 : (Set)ourJSPredefLibFiles.getValue()) {
            if (!fileName.equals(file2.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isWebLibraryFileName(String fileName) {
        return ArrayUtil.indexOf((Object[])ourPredefinedLibraries[0], (Object)fileName) >= 2;
    }

    public static boolean isCoreLibraryFile(@NotNull VirtualFile libFile) {
        if (libFile == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(0);
        }
        return JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(libFile) && !JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles().contains(libFile);
    }

    public static boolean isLibraryElement(@Nullable PsiElement element) {
        VirtualFile file2;
        PsiFile psiFile = element != null ? element.getContainingFile() : null;
        psiFile = psiFile != null ? psiFile.getOriginalFile() : null;
        VirtualFile virtualFile = file2 = psiFile != null ? psiFile.getVirtualFile() : null;
        if (file2 == null) {
            file2 = (VirtualFile)IndexingDataKeys.VIRTUAL_FILE.get((UserDataHolder)psiFile);
        }
        if (file2 == null && psiFile != null) {
            file2 = psiFile.getViewProvider().getVirtualFile();
        }
        if (file2 instanceof LightVirtualFile) {
            file2 = ((LightVirtualFile)file2).getOriginalFile();
        }
        return file2 != null && JSCorePredefinedLibrariesProvider.isCoreLibraryFile(file2);
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptPredefinedLibraryFiles() {
        Set set = (Set)ourJSPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getJSXPredefinedLibraryFiles() {
        Set set = (Set)ourJSXPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static VirtualFile getReactLibraryFile() {
        VirtualFile virtualFile = JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles().iterator().next();
        if (virtualFile == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptCorePredefinedLibraryFiles() {
        Set set = (Set)ourJSCorePredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getFlowJSCorePredefinedLibraryFiles() {
        Set set = (Set)ourFlowJSCorePredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(5);
        }
        return set;
    }

    public static Set<VirtualFile> getFlowJSPredefinedLibraryFiles() {
        return (Set)ourFlowJSPredefLibFiles.getValue();
    }

    @Override
    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(6);
        }
        ArrayList<ScriptingLibraryModel> predefinedLibraries = new ArrayList<ScriptingLibraryModel>();
        for (String[] libDef : ourPredefinedLibraries) {
            assert (libDef.length >= 3);
            String libName = libDef[0];
            String defaultFlag = libDef[1];
            Set<VirtualFile> libFiles2 = JSCorePredefinedLibrariesProvider.getFiles(libDef);
            predefinedLibraries.add(ScriptingLibraryModel.createPredefinedLibrary((String)libName, (VirtualFile[])VfsUtilCore.toVirtualFileArray(libFiles2), (boolean)ON.equals(defaultFlag)));
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = predefinedLibraries.toArray(ScriptingLibraryModel.EMPTY_ARRAY);
        if (scriptingLibraryModelArray == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(7);
        }
        return scriptingLibraryModelArray;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesToIndex() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles());
        files.addAll(JSCorePredefinedLibrariesProvider.getFlowJSPredefinedLibraryFiles());
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolve(@NotNull Project project) {
        if (project == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(9);
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        JSLanguageLevel level = JSRootConfiguration.getInstance(project).getLanguageLevel();
        if (level.isES6Compatible()) {
            files.addAll(TypeScriptUtil.getLibFiles(ES6_LIB_CONDITION, false));
        }
        files.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        files.addAll(JSCorePredefinedLibrariesProvider.getFlowJSCorePredefinedLibraryFiles());
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getAllJSPredefinedLibraryFiles() {
        Set set = (Set)ourAllJSPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    private static Set<VirtualFile> getFiles(String[] libDef) {
        assert (libDef.length >= 3);
        HashSet<VirtualFile> libFiles2 = new HashSet<VirtualFile>();
        for (int i = 2; i < libDef.length; ++i) {
            VirtualFile file2 = JSCorePredefinedLibrariesProvider.getPredefinedLibFile(libDef[i]);
            if (file2 == null) continue;
            libFiles2.add(file2);
        }
        HashSet<VirtualFile> hashSet = libFiles2;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @Nullable
    private static VirtualFile getPredefinedLibFile(@NotNull String libFileName) {
        Ref<VirtualFile> fileRef;
        if (libFileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(13);
        }
        if ((fileRef = JSCorePredefinedLibrariesProvider.getCachedFileRef(libFileName)) != null) {
            return (VirtualFile)fileRef.get();
        }
        VirtualFile file2 = JSCorePredefinedLibrariesProvider.findFileByURL(libFileName);
        return JSCorePredefinedLibrariesProvider.cacheFile(libFileName, file2);
    }

    private static boolean isES6Lib(@NotNull String fileName) {
        if (fileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(14);
        }
        if (ArrayUtil.contains((String)fileName, (String[])ES5_LIB_FILES)) {
            return true;
        }
        if (fileName.endsWith(".full.d.ts")) {
            return false;
        }
        String exactLibName = TypeScriptUtil.getLibraryName(fileName);
        if (StringUtil.isEmpty((String)exactLibName) || exactLibName.length() <= 4) {
            return false;
        }
        return TypeScriptUtil.isES6LibName(exactLibName);
    }

    @Nullable
    private static VirtualFile findFileByURL(@NotNull String libFileName) {
        if (libFileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(15);
        }
        File ioFile = new File(TypeScriptUtil.getTypeScriptExternalFolderFile(), libFileName);
        return JSLibraryUtil.findFileByIO(ioFile, false);
    }

    @Nullable
    private static Ref<VirtualFile> getCachedFileRef(@NotNull String fileName) {
        Ref<VirtualFile> ref;
        VirtualFile file2;
        if (fileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(16);
        }
        VirtualFile virtualFile = file2 = (ref = ourLibFileCache.get(fileName)) != null ? (VirtualFile)ref.get() : null;
        if (file2 != null && !file2.isValid()) {
            ourLibFileCache.remove(fileName);
            ref = null;
        }
        return ref;
    }

    @Contract(value="_, null -> null")
    @Nullable
    private static VirtualFile cacheFile(@NotNull String libFileName, @Nullable VirtualFile file2) {
        if (libFileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(17);
        }
        return JSLibraryUtil.cacheFile(libFileName, file2, ourLibFileCache);
    }

    private static void addFiles(@NotNull Set<VirtualFile> files, String ... predefinedFileNames) {
        if (files == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(18);
        }
        if (predefinedFileNames == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(19);
        }
        for (String predefinedFileName : predefinedFileNames) {
            VirtualFile file2 = JSCorePredefinedLibrariesProvider.getPredefinedLibFile(predefinedFileName);
            if (file2 == null) continue;
            files.add(file2);
        }
    }

    @NotNull
    private static AtomicNotNullLazyValue<Set<VirtualFile>> newAtomicNotNullLazyValue(final @NotNull String[] predefinedFileNames) {
        if (predefinedFileNames == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(20);
        }
        AtomicNotNullLazyValue<Set<VirtualFile>> atomicNotNullLazyValue = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

            @NotNull
            protected Set<VirtualFile> compute() {
                HashSet files = ContainerUtil.newHashSet((int)predefinedFileNames.length);
                JSCorePredefinedLibrariesProvider.addFiles(files, predefinedFileNames);
                Set<VirtualFile> set = Collections.unmodifiableSet(files);
                if (set == null) {
                    4.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$4", "compute"));
            }
        };
        if (atomicNotNullLazyValue == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(21);
        }
        return atomicNotNullLazyValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFileName";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptPredefinedLibraryFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSXPredefinedLibraryFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReactLibraryFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptCorePredefinedLibraryFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowJSCorePredefinedLibraryFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesToIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJSPredefinedLibraryFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "newAtomicNotNullLazyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCoreLibraryFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraries";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isES6Lib";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findFileByURL";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFileRef";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cacheFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "newAtomicNotNullLazyValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

