/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.export;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.graph.GraphSvgExporter;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class ExportToFileAction
extends AbstractGraphAction<Graph2D> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.graph.builder.actions.export.ExportToFileAction");
    private static final String[] EXTs = new String[]{"png", "jpg", "gif", "svg", "svgz"};
    private static final FileSaverDescriptor SAVE_DESCRIPTOR = new FileSaverDescriptor("Save as image", "Save diagram as image", EXTs);

    public ExportToFileAction() {
        this(null);
    }

    public ExportToFileAction(Graph2D graph) {
        super(graph, ActionsBundle.message((String)"action.Graph.export.to.file", (Object[])new Object[0]), AllIcons.ToolbarDecorator.Export);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        VirtualFileWrapper wrapper;
        File result;
        Project project = ExportToFileAction.getProject(e);
        if (project == null) {
            return;
        }
        VirtualFile vf = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        VirtualFile dir = vf == null ? null : vf.getParent();
        String name = "diagram";
        if (vf != null) {
            name = FileUtilRt.getNameWithoutExtension((String)vf.getPresentableName());
        }
        File file = result = (wrapper = FileChooserFactory.getInstance().createSaveFileDialog(SAVE_DESCRIPTOR, project).save(dir, name)) == null ? null : wrapper.getFile();
        if (result == null) {
            return;
        }
        if (!ArrayUtil.contains((String)FileUtilRt.getExtension((String)result.getName()).toLowerCase(), (String[])EXTs)) {
            result = new File(result.getPath() + ".png");
        }
        Graph2DView view = (Graph2DView)graph.getCurrentView();
        Point2D originalViewPoint2D = view.getViewPoint2D();
        double originalZoom = view.getZoom();
        JComponent comp = ExportToFileAction.tuneGraph2DView(view);
        try {
            String ext = FileUtilRt.getExtension((String)result.getName());
            if (StringUtil.startsWithIgnoreCase((String)ext, (String)"svg")) {
                GraphSvgExporter.getGraphSvgExporter().exportToSvg(graph, result.getPath(), ext);
            } else {
                ExportToFileAction.saveImage(result, comp);
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
        finally {
            view.setZoom(originalZoom);
            GraphViewUtil.updateWorldRect(view);
            view.setViewPoint2D(originalViewPoint2D.getX(), originalViewPoint2D.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveImage(File result, JComponent comp) throws IOException {
        Graphics2D graphics;
        BufferedImage bi;
        int width = comp.getWidth();
        int height = comp.getHeight();
        if (UIUtil.isRetina()) {
            bi = new BufferedImage(width * 2, height * 2, 1);
            graphics = (Graphics2D)bi.getGraphics();
            graphics.scale(2.0, 2.0);
        } else {
            bi = UIUtil.createImage((int)width, (int)height, (int)1);
            graphics = (Graphics2D)bi.getGraphics();
        }
        comp.paint(graphics);
        try (FileOutputStream os = new FileOutputStream(result.getPath());){
            ImageIO.write((RenderedImage)bi, FileUtilRt.getExtension((String)result.getName()), os);
        }
    }

    private static JComponent tuneGraph2DView(Graph2DView view) {
        view.setZoom(1.0);
        Rectangle box = view.getGraph2D().getBoundingBox();
        GraphViewUtil.updateWorldRect(view);
        view.setViewPoint2D(box.getX() - 20.0, box.getY() - 20.0);
        JComponent canvas = view.getCanvasComponent();
        canvas.setBounds(0, 0, (int)box.getWidth() + 40, (int)box.getHeight() + 40);
        return canvas;
    }
}

