/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.checkout;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.AbstractAction;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.cvsSupport2.ui.experts.checkout.CheckoutWizard;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.actions.VcsContext;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class CheckoutAction
extends AbstractAction {
    private CvsElement[] mySelectedElements;
    private File myCheckoutDirectory;
    private boolean myUseAlternativeCheckoutPath;

    public CheckoutAction() {
        super(true);
    }

    public CheckoutAction(CvsElement[] selectedElements, File checkoutDirectory, boolean useAlternativeCheckoutPath) {
        super(true);
        this.mySelectedElements = selectedElements;
        this.myCheckoutDirectory = checkoutDirectory;
        this.myUseAlternativeCheckoutPath = useAlternativeCheckoutPath;
    }

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.message((String)"operation.name.check.out.project", (Object[])new Object[0]);
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        Project project = context.getProject();
        CheckoutWizard checkoutWizard = new CheckoutWizard(project);
        if (!checkoutWizard.showAndGet()) {
            return CvsHandler.NULL;
        }
        this.myUseAlternativeCheckoutPath = checkoutWizard.useAlternativeCheckoutLocation();
        this.myCheckoutDirectory = checkoutWizard.getCheckoutDirectory();
        this.mySelectedElements = checkoutWizard.getSelectedElements();
        return CommandCvsHandler.createCheckoutHandler(checkoutWizard.getSelectedConfiguration(), this.collectCheckoutPaths(), this.myCheckoutDirectory, this.myUseAlternativeCheckoutPath, CvsApplicationLevelConfiguration.getInstance().MAKE_CHECKED_OUT_FILES_READONLY, project == null ? null : VcsConfiguration.getInstance((Project)project).getCheckoutOption());
    }

    private String[] collectCheckoutPaths() {
        String[] checkoutPaths = new String[this.mySelectedElements.length];
        for (int i = 0; i < this.mySelectedElements.length; ++i) {
            CvsElement selectedElement = this.mySelectedElements[i];
            checkoutPaths[i] = selectedElement.getCheckoutPath();
        }
        return checkoutPaths;
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        super.onActionPerformed(context, tabbedWindow, successfully, handler);
        CvsVcs2.getInstance(context.getProject()).getCheckoutProvider().refreshAfterCheckout(ProjectLevelVcsManager.getInstance((Project)context.getProject()).getCompositeCheckoutListener(), this.mySelectedElements, this.myCheckoutDirectory, this.myUseAlternativeCheckoutPath);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CheckoutAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        presentation.setVisible(true);
        presentation.setEnabled(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cvsSupport2/checkout/CheckoutAction", "update"));
    }
}

