/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpEval;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrow;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.FunctionReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.StatementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMatchingVisitor
extends PhpElementVisitor {
    private final GlobalMatchingVisitor myVisitor;

    public PhpMatchingVisitor(GlobalMatchingVisitor visitor) {
        this.myVisitor = visitor;
    }

    public void visitPhpEval(PhpEval patternEval) {
        PhpEval eval = this.getElement(PhpEval.class);
        if (!this.myVisitor.setResult(eval != null)) {
            return;
        }
        this.update(() -> {
            PhpExpression patternArgument = (PhpExpression)PhpPsiUtil.getChildByCondition((PsiElement)patternEval, (Condition<? super PsiElement>)((Condition)PhpExpression.class::isInstance));
            PhpExpression argument = (PhpExpression)PhpPsiUtil.getChildByCondition((PsiElement)eval, (Condition<? super PsiElement>)((Condition)PhpExpression.class::isInstance));
            return this.myVisitor.match((PsiElement)patternArgument, (PsiElement)argument);
        });
    }

    public void visitPhpExit(PhpExit patternExit) {
        PhpExit exit = this.getElement(PhpExit.class);
        if (!this.myVisitor.setResult(exit != null)) {
            return;
        }
        this.update(() -> this.myVisitor.match((PsiElement)patternExit.getArgument(), (PsiElement)exit.getArgument()));
    }

    public void visitPhpEmpty(PhpEmpty patternEmpty) {
        PhpEmpty empty = this.getElement(PhpEmpty.class);
        if (!this.myVisitor.setResult(empty != null)) {
            return;
        }
        this.update(() -> this.matchSequentiallyOptionally((PsiElement[])patternEmpty.getVariables(), (PsiElement[])empty.getVariables()));
    }

    public void visitPhpFunctionCall(FunctionReference patternFunctionCall) {
        FunctionReference functionCall = this.getElement(FunctionReference.class);
        if (functionCall != null) {
            PsiElement nameIdentifier = (PsiElement)ObjectUtils.notNull((Object)this.getNameIdentifierNode(functionCall), (Object)functionCall.getFirstChild());
            PsiElement patternNameIdentifier = (PsiElement)ObjectUtils.notNull((Object)this.getNameIdentifierNode(patternFunctionCall), (Object)patternFunctionCall.getFirstChild());
            this.matchTypedIdentifier(patternNameIdentifier, nameIdentifier);
            this.update(() -> this.matchSequentiallyOptionally(patternFunctionCall.getParameters(), functionCall.getParameters()));
        }
    }

    @Contract(value="null, _ -> false; _, null -> false")
    private boolean matchTypedIdentifier(@Nullable PsiElement patternIdentifier, @Nullable PsiElement identifier) {
        return patternIdentifier != null && identifier != null && this.matchTypedIdentifier(patternIdentifier, identifier, PsiElement::getText);
    }

    private <T extends PsiElement> boolean matchTypedIdentifier(@NotNull T patternIdentifier, @NotNull T identifier, java.util.function.Function<T, String> textSupplier) {
        if (patternIdentifier == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(0);
        }
        if (identifier == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(1);
        }
        String patternText = textSupplier.apply(patternIdentifier);
        String text = textSupplier.apply(identifier);
        return this.myVisitor.setResult(this.isTypedVar(patternIdentifier) ? this.handleTypedElement(patternIdentifier, identifier) : patternText != null && text != null && this.myVisitor.matchText(patternText, text));
    }

    private void update(@NotNull Supplier<Boolean> supplier) {
        if (supplier == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(2);
        }
        this.myVisitor.setResult(this.myVisitor.getResult() && supplier.get() != false);
    }

    @Nullable
    public PsiElement getNameIdentifierNode(FunctionReference patternFunctionCall) {
        ASTNode nameNode;
        ASTNode aSTNode = nameNode = patternFunctionCall != null ? patternFunctionCall.getNameNode() : null;
        if (nameNode == null) {
            PsiElement element = patternFunctionCall != null && patternFunctionCall.getChildren().length > 1 ? patternFunctionCall.getChildren()[1] : null;
            return element instanceof Variable ? ((Variable)element).getNameIdentifier() : null;
        }
        return nameNode.getPsi();
    }

    public void visitPhpMethodReference(MethodReference patternMethodCall) {
        MethodReference methodCall = this.getElement(MethodReference.class);
        if (methodCall == null || methodCall instanceof FunctionReferenceImpl) {
            return;
        }
        this.matchTypedIdentifier(this.getNameIdentifierNode((FunctionReference)patternMethodCall), this.getNameIdentifierNode((FunctionReference)methodCall));
        PhpExpression patternClassReference = patternMethodCall.getClassReference();
        PhpExpression classReference = methodCall.getClassReference();
        this.update(() -> this.matchClassReference(patternClassReference, classReference));
        this.update(() -> patternMethodCall.isStatic() == methodCall.isStatic());
        this.update(() -> this.matchSequentiallyOptionally(patternMethodCall.getParameters(), methodCall.getParameters()));
    }

    private boolean matchClassReference(@Nullable PhpExpression patternClassReference, @Nullable PhpExpression classReference) {
        return this.isTypedVar((PsiElement)patternClassReference) ? this.matchTypedIdentifier((PsiElement)patternClassReference, (PsiElement)classReference) : this.myVisitor.match((PsiElement)patternClassReference, (PsiElement)classReference);
    }

    public void visitPhpConstantReference(ConstantReference patternReference) {
        if (this.isTypedVar((PsiElement)patternReference)) {
            this.handleTypedElement((PsiElement)patternReference);
        } else {
            ConstantReference element = this.getElement(ConstantReference.class);
            if (element != null) {
                this.myVisitor.setResult(this.myVisitor.matchText((PsiElement)patternReference, (PsiElement)element));
            }
        }
    }

    public void visitPhpClassConstantReference(ClassConstantReference patternConstantReference) {
        MemberReference classConstantReference = (MemberReference)this.getElement(ClassConstantReference.class);
        if (classConstantReference == null) {
            return;
        }
        this.matchTypedIdentifier(patternConstantReference.getNameNode(), classConstantReference.getNameNode());
        PhpExpression patternClassReference = patternConstantReference.getClassReference();
        PhpExpression classReference = classConstantReference.getClassReference();
        this.update(() -> this.matchClassReference(patternClassReference, classReference));
    }

    public void visitPhpClassReference(ClassReference patternClassReference) {
        ClassReference classReference = this.getElement(ClassReference.class);
        if (classReference == null) {
            return;
        }
        this.matchTypedIdentifier(patternClassReference.getNameNode(), classReference.getNameNode());
    }

    private void handleTypedElement(@NotNull PsiElement patternTypedParameter) {
        if (patternTypedParameter == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(3);
        }
        this.handleTypedElement(patternTypedParameter, this.myVisitor.getElement());
    }

    private boolean handleTypedElement(@NotNull PsiElement patternTypedParameter, @NotNull PsiElement typedParameter) {
        MatchingHandler handler;
        if (patternTypedParameter == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(4);
        }
        if (typedParameter == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(5);
        }
        return (handler = this.getHandler(patternTypedParameter)) instanceof SubstitutionHandler && this.myVisitor.setResult(((SubstitutionHandler)handler).handle(typedParameter, this.myVisitor.getMatchContext()));
    }

    @Nullable
    private MatchingHandler getHandler(@NotNull PsiElement patternTypedParameter) {
        if (patternTypedParameter == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(6);
        }
        CompiledPattern pattern = this.myVisitor.getMatchContext().getPattern();
        return PhpMatchingVisitor.getDelegate(patternTypedParameter instanceof Variable ? pattern.getHandler(patternTypedParameter.getText()) : pattern.getHandlerSimple(patternTypedParameter));
    }

    @Nullable
    private static MatchingHandler getDelegate(@Nullable MatchingHandler handler) {
        return handler instanceof DelegatingHandler ? ((DelegatingHandler)handler).getDelegate() : handler;
    }

    @Contract(value="null -> false")
    public boolean isTypedVar(@Nullable PsiElement element) {
        return this.myVisitor.getMatchContext().getPattern().isTypedVar(element);
    }

    public void visitElement(PsiElement element) {
        if (StructuralSearchUtil.isIdentifier((PsiElement)element) && this.isTypedVar(element)) {
            this.handleTypedElement(element);
        } else {
            this.myVisitor.setResult(this.myVisitor.matchText(element, this.myVisitor.getElement()));
        }
    }

    public void visitPhpStatement(Statement patternStatement) {
        Statement statement = this.getElement(Statement.class);
        if (statement == null) {
            return;
        }
        if (PhpMatchingVisitor.isTypedVarStatement(patternStatement, this.myVisitor.getMatchContext().getPattern())) {
            this.handleTypedElement((PsiElement)patternStatement);
        } else {
            this.myVisitor.setResult(this.myVisitor.matchSons((PsiElement)patternStatement, (PsiElement)statement));
        }
    }

    public void visitPhpEchoStatement(PhpEchoStatement patternEcho) {
        PhpEchoStatement echo = this.getElement(PhpEchoStatement.class);
        if (echo == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.matchSequentially((PsiElement[])patternEcho.getArguments(), (PsiElement[])echo.getArguments()));
    }

    public void visitPhpField(Field patternField) {
        Field field = this.getElement(Field.class);
        if (field == null) {
            return;
        }
        this.myVisitor.setResult(patternField.getModifier() == field.getModifier());
        this.update(() -> this.matchTypedIdentifier(patternField.getNameIdentifier(), field.getNameIdentifier()));
    }

    public void visitPhpFunction(Function patternFunction) {
        Function function = this.getElement(Function.class);
        if (function == null) {
            return;
        }
        PsiElement patternFunctionNameIdentifier = patternFunction.getNameIdentifier();
        this.myVisitor.setResult(this.matchSequentiallyOptionally((PsiElement[])patternFunction.getParameters(), (PsiElement[])function.getParameters()));
        this.update(() -> this.matchBody((PsiElement)patternFunction, (PsiElement)function));
        this.update(() -> this.matchTypedIdentifier(patternFunctionNameIdentifier, function.getNameIdentifier()));
    }

    public void visitPhpClass(PhpClass patternClazz) {
        PhpClass clazz = this.getElement(PhpClass.class);
        if (clazz == null) {
            return;
        }
        this.matchTypedIdentifier(patternClazz.getNameIdentifier(), clazz.getNameIdentifier());
        this.update(() -> this.checkModifiers(patternClazz, clazz));
        this.update(() -> this.myVisitor.match((PsiElement)ContainerUtil.getFirstItem((List)patternClazz.getExtendsList().getReferenceElements()), (PsiElement)ContainerUtil.getFirstItem((List)clazz.getExtendsList().getReferenceElements())));
        this.update(() -> this.myVisitor.matchInAnyOrder((PsiElement[])patternClazz.getImplementsList().getReferenceElements().toArray(ClassReference.EMPTY_ARRAY), (PsiElement[])clazz.getImplementsList().getReferenceElements().toArray(ClassReference.EMPTY_ARRAY)));
        this.update(() -> this.myVisitor.matchInAnyOrder((PsiElement[])patternClazz.getOwnMethods(), (PsiElement[])clazz.getOwnMethods()));
        this.update(() -> this.myVisitor.matchInAnyOrder((PsiElement[])patternClazz.getOwnFields(), (PsiElement[])clazz.getOwnFields()));
    }

    public void visitPhpMethod(Method patternMethod) {
        Method method = this.getElement(Method.class);
        if (method == null) {
            return;
        }
        this.myVisitor.getMatchContext().pushResult();
        try {
            this.myVisitor.setResult(this.matchSequentiallyOptionally((PsiElement[])patternMethod.getParameters(), (PsiElement[])method.getParameters()));
            this.update(() -> method.getMethodType(true) == patternMethod.getMethodType(true));
            this.update(() -> this.myVisitor.match((PsiElement)patternMethod.getFirstPsiChild(), (PsiElement)method.getFirstPsiChild()));
            this.update(() -> this.myVisitor.match((PsiElement)patternMethod.getReturnType(), (PsiElement)method.getReturnType()));
            this.update(() -> this.matchBody((PsiElement)patternMethod, (PsiElement)method));
            this.matchOldStyleConstructor(patternMethod, method);
            if (this.myVisitor.getResult()) {
                return;
            }
            this.update(() -> this.isTypedVar(patternMethod.getNameIdentifier()) || this.myVisitor.matchText(patternMethod.getNameIdentifier(), method.getNameIdentifier()));
        }
        finally {
            this.myVisitor.scopeMatch(patternMethod.getNameIdentifier(), this.isTypedVar(patternMethod.getNameIdentifier()), method.getNameIdentifier());
        }
    }

    private boolean matchSequentiallyOptionally(PsiElement[] patternElements, PsiElement[] elements) {
        return patternElements.length == 0 || this.myVisitor.matchSequentially(patternElements, elements);
    }

    public void matchOldStyleConstructor(Method patternMethod, Method method) {
        PhpClass patternClazz = patternMethod.getContainingClass();
        if (patternClazz != null && patternMethod.getAccess().isPublic() && StringUtil.equals((CharSequence)patternClazz.getName(), (CharSequence)patternMethod.getName())) {
            PhpClass clazz = method.getContainingClass();
            if (clazz != null && StringUtil.equals((CharSequence)clazz.getName(), (CharSequence)method.getName()) && method.getAccess().isPublic()) {
                this.matchTypedIdentifier(patternClazz.getNameIdentifier(), clazz.getNameIdentifier());
            } else {
                this.myVisitor.setResult(false);
            }
        }
    }

    public boolean matchBody(PsiElement pattern, PsiElement element) {
        GroupStatement patternBody = (GroupStatement)PhpPsiUtil.getChildByCondition(pattern, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        return this.match(patternBody, body);
    }

    public boolean match(GroupStatement patternBody, GroupStatement body) {
        if (patternBody == null) {
            return true;
        }
        if (body == null) {
            return false;
        }
        return this.myVisitor.setResult(this.myVisitor.matchSequentially(patternBody.getStatements(), body.getStatements()));
    }

    public void visitPhpParameter(Parameter patternParameter) {
        Parameter parameter = this.getElement(Parameter.class);
        if (parameter == null) {
            return;
        }
        this.matchTypedIdentifier(patternParameter, parameter, Parameter::getName);
    }

    public void visitPhpVariable(Variable patternVariable) {
        Variable variable = this.getElement(Variable.class);
        if (variable == null) {
            return;
        }
        this.matchTypedIdentifier((PsiElement)patternVariable, (PsiElement)variable);
    }

    public void visitPhpIf(If patternIfStatement) {
        If ifStatement = this.getElement(If.class);
        if (ifStatement == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternIfStatement.getCondition(), (PsiElement)ifStatement.getCondition()) && this.matchSequentiallyOptionally((PsiElement[])patternIfStatement.getElseIfBranches(), (PsiElement[])ifStatement.getElseIfBranches()) && this.myVisitor.match((PsiElement)patternIfStatement.getElseBranch(), (PsiElement)ifStatement.getElseBranch()));
        this.update(() -> this.matchBody((PsiElement)patternIfStatement, (PsiElement)ifStatement));
    }

    public void visitPhpForeach(ForeachStatement patternForeach) {
        ForeachStatement foreach = this.getElement(ForeachStatement.class);
        if (foreach == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternForeach.getKey(), foreach.getArray()) && this.myVisitor.match((PsiElement)patternForeach.getKey(), (PsiElement)foreach.getKey()) && this.myVisitor.match((PsiElement)patternForeach.getKey(), (PsiElement)foreach.getValue()));
        this.update(() -> this.matchBody((PsiElement)patternForeach, (PsiElement)foreach));
    }

    public void visitPhpGroupStatement(GroupStatement patternGroupStatement) {
        GroupStatement groupStatement = this.getElement(GroupStatement.class);
        if (groupStatement == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.matchSequentially((PsiElement)ArrayUtil.getFirstElement((Object[])patternGroupStatement.getStatements()), (PsiElement)ArrayUtil.getFirstElement((Object[])groupStatement.getStatements())));
    }

    public void visitPhpElseIf(ElseIf patternElseIf) {
        ElseIf elseIf = this.getElement(ElseIf.class);
        if (elseIf == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternElseIf.getCondition(), (PsiElement)elseIf.getCondition()));
        this.update(() -> this.matchBody((PsiElement)patternElseIf, (PsiElement)elseIf));
    }

    public void visitPhpElse(Else patternElseStatement) {
        Else elseStatement = this.getElement(Else.class);
        if (elseStatement == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternElseStatement.getStatement(), (PsiElement)elseStatement.getStatement()));
    }

    public void visitPhpUnaryExpression(UnaryExpression patternExpr) {
        UnaryExpression expr = this.getElement(UnaryExpression.class);
        if (expr == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match(patternExpr.getOperation(), expr.getOperation()) && this.myVisitor.match((PsiElement)patternExpr.getValue(), (PsiElement)expr.getValue()));
    }

    public void visitPhpBinaryExpression(BinaryExpression patternBinaryExpression) {
        BinaryExpression binaryExpression = this.getElement(BinaryExpression.class);
        if (binaryExpression == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match(patternBinaryExpression.getLeftOperand(), binaryExpression.getLeftOperand()) && this.myVisitor.match(patternBinaryExpression.getOperation(), binaryExpression.getOperation()) && this.myVisitor.match(patternBinaryExpression.getRightOperand(), binaryExpression.getRightOperand()));
    }

    public boolean checkModifiers(PhpClass patternClazz, PhpClass clazz) {
        return clazz.isInterface() == patternClazz.isInterface() && clazz.isTrait() == patternClazz.isTrait() && clazz.isAbstract() == patternClazz.isAbstract() && clazz.isFinal() == patternClazz.isFinal();
    }

    public void visitPhpAssignmentExpression(AssignmentExpression patternAssignment) {
        AssignmentExpression assignment = this.getElement(AssignmentExpression.class);
        if (assignment == null) {
            return;
        }
        PhpPsiElement patternVariable = patternAssignment.getVariable();
        PhpPsiElement variable = assignment.getVariable();
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternAssignment.getValue(), (PsiElement)assignment.getValue()) && patternVariable != null && variable != null && this.myVisitor.match(PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)patternVariable, true), PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)variable, true)) && this.myVisitor.match((PsiElement)patternVariable, (PsiElement)variable));
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression patternExpression) {
        SelfAssignmentExpression expression = this.getElement(SelfAssignmentExpression.class);
        if (expression == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternExpression.getVariable(), (PsiElement)expression.getVariable()) && this.myVisitor.match(patternExpression.getOperation(), expression.getOperation()) && this.myVisitor.match((PsiElement)patternExpression.getValue(), (PsiElement)expression.getValue()));
    }

    public void visitPhpFor(For patternFor) {
        For aFor = this.getElement(For.class);
        if (aFor == null) {
            return;
        }
        this.myVisitor.setResult(this.matchSequentiallyOptionally((PsiElement[])patternFor.getInitialExpressions(), (PsiElement[])aFor.getInitialExpressions()) && this.matchSequentiallyOptionally((PsiElement[])patternFor.getConditionalExpressions(), (PsiElement[])aFor.getConditionalExpressions()) && this.matchSequentiallyOptionally((PsiElement[])patternFor.getRepeatedExpressions(), (PsiElement[])aFor.getRepeatedExpressions()) && this.matchBody((PsiElement)patternFor, (PsiElement)aFor));
    }

    public void visitPhpFieldReference(FieldReference patternFieldReference) {
        FieldReference fieldReference = this.getElement(FieldReference.class);
        if (fieldReference == null) {
            return;
        }
        this.myVisitor.setResult(this.matchClassReference(patternFieldReference.getClassReference(), fieldReference.getClassReference()) && this.matchTypedIdentifier(patternFieldReference.getNameNode(), fieldReference.getNameNode()) && patternFieldReference.isStatic() == fieldReference.isStatic());
    }

    private boolean matchTypedIdentifier(@Nullable ASTNode patternNode, @Nullable ASTNode node) {
        PsiElement patternNameIdentifier = patternNode != null ? patternNode.getPsi() : null;
        PsiElement nameIdentifier = node != null ? node.getPsi() : null;
        return this.matchTypedIdentifier(patternNameIdentifier, nameIdentifier);
    }

    public void visitPhpReturn(PhpReturn patternReturnStatement) {
        PhpReturn phpReturn = this.getElement(PhpReturn.class);
        if (phpReturn == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match(patternReturnStatement.getArgument(), phpReturn.getArgument()));
    }

    @Nullable
    private <T extends PhpPsiElement> T getElement(@NotNull Class<T> aClass) {
        PsiElement other;
        if (aClass == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(7);
        }
        return (T)(this.myVisitor.setResult(aClass.isInstance(other = this.myVisitor.getElement())) ? (PhpPsiElement)other : null);
    }

    public static boolean isTypedVarStatement(Statement statement, CompiledPattern pattern) {
        PsiElement[] children = statement.getChildren();
        return children.length > 0 && children.length < 3 && statement instanceof StatementImpl && children[0] instanceof ConstantReference && (children.length == 1 || children[1] instanceof PsiErrorElement) && pattern.isRealTypedVar((PsiElement)statement);
    }

    public void visitPhpStringLiteralExpression(StringLiteralExpression patternString) {
        StringLiteralExpression string = this.getElement(StringLiteralExpression.class);
        if (string == null) {
            return;
        }
        MatchingHandler handler = (MatchingHandler)patternString.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            this.myVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)string, 1, string.getTextLength() - 1, this.myVisitor.getMatchContext()));
        } else if (handler != null) {
            this.myVisitor.setResult(handler.match((PsiElement)patternString, (PsiElement)string, this.myVisitor.getMatchContext()));
        } else {
            this.myVisitor.setResult(this.myVisitor.matchText(patternString.getContents(), string.getContents()));
        }
    }

    public void visitPhpNewExpression(NewExpression patternNewExpression) {
        NewExpression newExpression = this.getElement(NewExpression.class);
        if (newExpression == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternNewExpression.getClassReference(), (PsiElement)newExpression.getClassReference()));
        this.update(() -> this.myVisitor.matchSonsOptionally((PsiElement)patternNewExpression.getParameterList(), (PsiElement)newExpression.getParameterList()));
    }

    public void visitPhpConstant(Constant patternConstant) {
        Constant constant = this.getElement(Constant.class);
        if (constant == null) {
            return;
        }
        if (patternConstant instanceof PhpDefine) {
            if (constant instanceof PhpDefine) {
                this.myVisitor.setResult(this.matchDefineConstant((PhpDefine)patternConstant, (PhpDefine)constant));
            } else {
                this.myVisitor.setResult(false);
            }
            return;
        }
        this.myVisitor.setResult(!(constant instanceof PhpDefine));
        this.update(() -> this.myVisitor.match(patternConstant.getValue(), constant.getValue()));
        this.update(() -> this.matchTypedIdentifier(patternConstant.getNameIdentifier(), constant.getNameIdentifier()));
    }

    private boolean matchDefineConstant(PhpDefine patternDefine, PhpDefine define) {
        FunctionReference patternReference = (FunctionReference)ObjectUtils.tryCast((Object)patternDefine.getFirstChild(), FunctionReference.class);
        FunctionReference reference = (FunctionReference)ObjectUtils.tryCast((Object)define.getFirstChild(), FunctionReference.class);
        if (reference == null || patternReference == null) {
            return false;
        }
        return this.matchSequentiallyOptionally(patternReference.getParameters(), reference.getParameters());
    }

    public void visitPhpTry(Try patternTryStatement) {
        Try aTry = this.getElement(Try.class);
        if (aTry == null) {
            return;
        }
        this.myVisitor.setResult(this.matchBody((PsiElement)patternTryStatement, (PsiElement)aTry));
        this.update(() -> this.matchSequentiallyOptionally((PsiElement[])patternTryStatement.getCatchClauses(), (PsiElement[])aTry.getCatchClauses()));
        this.update(() -> this.myVisitor.match((PsiElement)patternTryStatement.getFinallyBlock(), (PsiElement)aTry.getFinallyBlock()));
    }

    public void visitPhpCatch(Catch patternCatch) {
        Catch aCatch = this.getElement(Catch.class);
        if (aCatch == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternCatch.getException(), (PsiElement)aCatch.getException()));
        this.update(() -> this.matchSequentiallyOptionally((PsiElement[])patternCatch.getExceptionTypes().toArray(ClassReference.EMPTY_ARRAY), (PsiElement[])aCatch.getExceptionTypes().toArray(ClassReference.EMPTY_ARRAY)));
        this.update(() -> this.matchBody((PsiElement)patternCatch, (PsiElement)aCatch));
    }

    public void visitPhpFinally(Finally patternFinally) {
        Finally aFinally = this.getElement(Finally.class);
        if (aFinally == null) {
            return;
        }
        this.myVisitor.setResult(this.matchBody((PsiElement)patternFinally, (PsiElement)aFinally));
    }

    public void visitPhpYield(PhpYield patternYield) {
        this.matchStatementWithArgument(patternYield);
    }

    private <T extends StatementWithArgument> void matchStatementWithArgument(T patternElement) {
        StatementWithArgument element = (StatementWithArgument)this.getElement(patternElement.getClass());
        if (element == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match(patternElement.getArgument(), element.getArgument()));
    }

    public void visitPhpNamespace(PhpNamespace patternNamespace) {
        PhpNamespace namespace = this.getElement(PhpNamespace.class);
        if (namespace == null) {
            return;
        }
        this.matchTypedIdentifier(patternNamespace.getNameIdentifier(), namespace.getNameIdentifier());
        this.update(() -> PhpMatchingVisitor.matchBraces(patternNamespace, namespace));
        this.update(() -> this.matchSequentiallyOptionally(patternNamespace.getStatements(), namespace.getStatements()));
    }

    private static boolean matchBraces(@NotNull PhpNamespace patternNamespace, @NotNull PhpNamespace namespace) {
        PsiElement groupStatement;
        boolean patternBraced;
        if (patternNamespace == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(8);
        }
        if (namespace == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(9);
        }
        if ((patternBraced = patternNamespace.isBraced()) && !PhpPsiUtil.isOfType((groupStatement = patternNamespace.getLastChild()).getFirstChild(), PhpTokenTypes.chLBRACE)) {
            return true;
        }
        return patternBraced == namespace.isBraced();
    }

    private boolean matchSequentiallyOptionally(@Nullable GroupStatement patternGroupStatement, @Nullable GroupStatement groupStatement) {
        if (patternGroupStatement == null) {
            return true;
        }
        if (groupStatement == null) {
            return false;
        }
        return this.matchSequentiallyOptionally(patternGroupStatement.getStatements(), groupStatement.getStatements());
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression patternArrayAccessExpression) {
        ArrayAccessExpression arrayAccessExpression = this.getElement(ArrayAccessExpression.class);
        if (arrayAccessExpression == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternArrayAccessExpression.getValue(), (PsiElement)arrayAccessExpression.getValue()));
        this.update(() -> this.myVisitor.match((PsiElement)patternArrayAccessExpression.getIndex(), (PsiElement)arrayAccessExpression.getIndex()));
    }

    public void visitPhpArrayIndex(ArrayIndex patternIndex) {
        ArrayIndex index = this.getElement(ArrayIndex.class);
        if (index == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.matchSequentially((PsiElement)patternIndex.getValue(), (PsiElement)index.getValue()));
    }

    public void visitPhpUse(PhpUse patternUse) {
        PhpUse use = this.getElement(PhpUse.class);
        if (use == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.matchSequentially(patternUse.getNameIdentifier(), use.getNameIdentifier()));
        this.update(() -> patternUse.isTraitImport() == use.isTraitImport());
        PhpUseList patternUseList = PhpUseImpl.getUseList((PsiElement)patternUse);
        PhpUseList useList = PhpUseImpl.getUseList((PsiElement)use);
        this.update(() -> PhpGroupUseElement.getKeyword(patternUse, patternUseList).equals(PhpGroupUseElement.getKeyword(use, useList)));
        this.update(() -> this.myVisitor.match((PsiElement)patternUse.getTargetReference(), (PsiElement)use.getTargetReference()));
    }

    public void visitPhpUseList(PhpUseList patternUseList) {
        PhpUseList useList = this.getElement(PhpUseList.class);
        if (useList == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.matchSequentially((PsiElement[])patternUseList.getDeclarations(), (PsiElement[])useList.getDeclarations()));
    }

    public void visitPhpParenthesizedExpression(ParenthesizedExpression patternParenthesizedExpression) {
        ParenthesizedExpression parenthesizedExpression = this.getElement(ParenthesizedExpression.class);
        if (parenthesizedExpression == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternParenthesizedExpression.getArgument(), (PsiElement)parenthesizedExpression.getArgument()));
    }

    public void visitPhpThrow(PhpThrow throwStatement) {
        this.matchStatementWithArgument(throwStatement);
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression patternAssignment) {
        MultiassignmentExpression assignment = this.getElement(MultiassignmentExpression.class);
        if (assignment == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.matchSequentially(patternAssignment.getVariables().toArray(PsiElement.EMPTY_ARRAY), assignment.getVariables().toArray(PsiElement.EMPTY_ARRAY)));
        this.update(() -> this.myVisitor.match((PsiElement)patternAssignment.getValue(), (PsiElement)assignment.getValue()));
    }

    public void visitPhpExpression(PhpExpression patternExpression) {
        PhpExpression expression = this.getElement(PhpExpression.class);
        if (expression == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.matchText((PsiElement)patternExpression, (PsiElement)expression) || this.myVisitor.matchSons((PsiElement)patternExpression, (PsiElement)expression));
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression patternExpression) {
        ArrayCreationExpression expression = this.getElement(ArrayCreationExpression.class);
        if (expression == null) {
            return;
        }
        this.myVisitor.setResult(patternExpression.isShortSyntax() == expression.isShortSyntax());
        this.update(() -> this.myVisitor.matchSequentially(this.extractArrayValues(patternExpression), this.extractArrayValues(expression)));
    }

    @NotNull
    public PsiElement[] extractArrayValues(ArrayCreationExpression patternExpression) {
        PsiElement[] psiElementArray = ContainerUtil.map((Object[])patternExpression.getChildren(), child -> child instanceof ArrayHashElement ? child : child.getFirstChild()).toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            PhpMatchingVisitor.$$$reportNull$$$0(10);
        }
        return psiElementArray;
    }

    public void visitPhpTernaryExpression(TernaryExpression patternExpression) {
        TernaryExpression expression = this.getElement(TernaryExpression.class);
        if (expression == null) {
            return;
        }
        this.myVisitor.setResult(patternExpression.isShort() == expression.isShort());
        this.update(() -> this.myVisitor.match((PsiElement)patternExpression.getCondition(), (PsiElement)expression.getCondition()));
        this.update(() -> this.myVisitor.match((PsiElement)patternExpression.getTrueVariant(), (PsiElement)expression.getTrueVariant()));
        this.update(() -> this.myVisitor.match((PsiElement)patternExpression.getFalseVariant(), (PsiElement)expression.getFalseVariant()));
    }

    public void visitPhpWhile(While patternWhile) {
        While aWhile = this.getElement(While.class);
        if (aWhile == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternWhile.getCondition(), (PsiElement)aWhile.getCondition()));
        this.update(() -> this.matchBody((PsiElement)patternWhile, (PsiElement)aWhile));
    }

    public void visitPhpDoWhile(DoWhile patternWhile) {
        DoWhile aWhile = this.getElement(DoWhile.class);
        if (aWhile == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternWhile.getCondition(), (PsiElement)aWhile.getCondition()));
        this.update(() -> this.matchBody((PsiElement)patternWhile, (PsiElement)aWhile));
    }

    public void visitPhpContinue(PhpContinue patternContinue) {
        this.matchStatementWithArgument(patternContinue);
    }

    public void visitPhpBreak(PhpBreak patternBreak) {
        this.matchStatementWithArgument(patternBreak);
    }

    public void visitPhpSwitch(PhpSwitch patternSwitch) {
        PhpSwitch aSwitch = this.getElement(PhpSwitch.class);
        if (aSwitch == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match(patternSwitch.getArgument(), aSwitch.getArgument()));
        this.update(() -> this.matchSequentiallyOptionally((PsiElement[])patternSwitch.getCases(), (PsiElement[])aSwitch.getCases()));
        this.update(() -> this.myVisitor.match((PsiElement)patternSwitch.getDefaultCase(), (PsiElement)aSwitch.getDefaultCase()));
    }

    public void visitPhpIsset(PhpIsset patternIsset) {
        PhpIsset isset = this.getElement(PhpIsset.class);
        if (isset == null) {
            return;
        }
        this.matchSequentiallyOptionally((PsiElement[])patternIsset.getVariables(), (PsiElement[])isset.getVariables());
    }

    public void visitPhpUnset(PhpUnset patternUnset) {
        PhpUnset unset = this.getElement(PhpUnset.class);
        if (unset == null) {
            return;
        }
        this.myVisitor.setResult(this.matchSequentiallyOptionally((PsiElement[])patternUnset.getArguments(), (PsiElement[])unset.getArguments()));
    }

    public void visitPhpPrint(PhpPrintExpression patternPrint) {
        PhpPrintExpression printExpression = this.getElement(PhpPrintExpression.class);
        if (printExpression == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternPrint.getArgument(), (PsiElement)printExpression.getArgument()));
    }

    public void visitPhpGoto(PhpGoto patternGoto) {
        PhpGoto aGoto = this.getElement(PhpGoto.class);
        if (aGoto == null) {
            return;
        }
        this.matchTypedIdentifier(patternGoto.getNameNode(), aGoto.getNameNode());
    }

    public void visitPhpGotoLabel(PhpGotoLabel patternGotoLabel) {
        PhpGotoLabel gotoLabel = this.getElement(PhpGotoLabel.class);
        if (gotoLabel == null) {
            return;
        }
        this.matchTypedIdentifier(patternGotoLabel.getNameIdentifier(), gotoLabel.getNameIdentifier());
    }

    public void visitPhpElement(PhpPsiElement patternElement) {
        PhpPsiElement element = this.getElement(PhpPsiElement.class);
        if (element == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.matchSons((PsiElement)patternElement, (PsiElement)element));
    }

    public void visitPhpCase(PhpCase patternCase) {
        PhpCase phpCase = this.getElement(PhpCase.class);
        if (phpCase == null) {
            return;
        }
        this.myVisitor.setResult(PhpPsiUtil.isOfType((PsiElement)patternCase, PhpElementTypes.CASE_DEFAULT) == PhpPsiUtil.isOfType((PsiElement)phpCase, PhpElementTypes.CASE_DEFAULT));
        this.update(() -> this.myVisitor.match((PsiElement)patternCase.getCondition(), (PsiElement)phpCase.getCondition()));
        this.update(() -> this.myVisitor.match((PsiElement)patternCase.getStatement(), (PsiElement)phpCase.getStatement()));
    }

    public void visitPhpArrayHashElement(ArrayHashElement patternArrayHashElement) {
        ArrayHashElement arrayHashElement = this.getElement(ArrayHashElement.class);
        if (arrayHashElement == null) {
            return;
        }
        this.myVisitor.setResult(this.myVisitor.match((PsiElement)patternArrayHashElement.getKey(), (PsiElement)arrayHashElement.getKey()) && this.myVisitor.match((PsiElement)patternArrayHashElement.getValue(), (PsiElement)arrayHashElement.getValue()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternIdentifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternTypedParameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedParameter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternNamespace";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/PhpMatchingVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/PhpMatchingVisitor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractArrayValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchTypedIdentifier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleTypedElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchBraces";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

