/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCaseConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableTypeDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableInferredTypeAnalyzerProcessor
extends PhpTypeAnalyzerProcessor {
    @NotNull
    private final CharSequence myVariableName;
    @NotNull
    private final PhpScopeHolder myScopeHolder;

    public PhpVariableInferredTypeAnalyzerProcessor(@NotNull CharSequence variableName, @NotNull PhpScopeHolder scopeHolder) {
        if (variableName == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(0);
        }
        if (scopeHolder == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(1);
        }
        this.myVariableName = variableName;
        this.myScopeHolder = scopeHolder;
    }

    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpPsiElement curAnchor;
        if (this.myVariableName.equals(instruction.getVariableName()) && (curAnchor = instruction.getAnchor()) instanceof Variable && (instruction.getAccess().isWrite() || instruction.getAccess().isWriteRef())) {
            return this.processAccessInstruction((PhpAccessInstruction)instruction);
        }
        return true;
    }

    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
        PhpType type;
        if (PhpLangUtil.isThisReference(this.myVariableName)) {
            PhpClass containingClass;
            PhpScopeHolder curScopeHolder = this.myScopeHolder;
            while (!(curScopeHolder instanceof Method) && curScopeHolder instanceof Function && ((Function)curScopeHolder).isClosure()) {
                PsiElement parent = curScopeHolder.getParent();
                curScopeHolder = parent != null ? PhpPsiUtil.getScopeHolder(parent) : null;
            }
            if (curScopeHolder instanceof Method && (containingClass = ((Method)curScopeHolder).getContainingClass()) != null) {
                this.setType(containingClass.getType());
                return false;
            }
        } else if (PhpLangUtil.equalsVariableNames("GLOBALS", this.myVariableName)) {
            this.setType(PhpType.ARRAY);
            return false;
        }
        if (this.myScopeHolder instanceof PhpFile) {
            if (PhpLangUtil.isSuperGlobal(this.myVariableName)) {
                this.setType(PhpType.ARRAY);
                return false;
            }
            this.setType(new PhpType().add(PhpTypeSignatureKey.VARIABLE.sign(this.myVariableName)));
            return false;
        }
        if (this.myScopeHolder instanceof Method) {
            Method method = (Method)this.myScopeHolder;
            if (PhpLangUtil.isThisReference(this.myVariableName) && !method.isStatic()) {
                PhpClass aClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)method, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                if (aClass != null && PhpLangUtil.isThisReference(this.myVariableName)) {
                    this.setType(aClass.getType());
                    return false;
                }
                return false;
            }
            type = PhpVariableInferredTypeAnalyzerProcessor.getParameterType((Function)method, this.myVariableName);
            if (type != null) {
                this.setType(type);
                return false;
            }
        } else if (this.myScopeHolder instanceof Function) {
            Function function = (Function)this.myScopeHolder;
            type = PhpVariableInferredTypeAnalyzerProcessor.getParameterType(function, this.myVariableName);
            if (type != null) {
                this.setType(type);
                return false;
            }
            if (function.isClosure() && (type = PhpVariableInferredTypeAnalyzerProcessor.getImportedVariableType(function, this.myVariableName)) != null) {
                this.setType(type);
                return false;
            }
        }
        return false;
    }

    @Nullable
    private static PhpType getParameterType(@NotNull Function function, @NotNull CharSequence parameterName) {
        if (function == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(2);
        }
        if (parameterName == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(3);
        }
        for (Parameter parameter : function.getParameters()) {
            if (!PhpLangUtil.equalsVariableNames(parameterName, parameter.getName())) continue;
            return parameter.getType();
        }
        return null;
    }

    @Nullable
    private static PhpType getImportedVariableType(@NotNull Function function, @NotNull CharSequence variableName) {
        if (function == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(4);
        }
        if (variableName == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(5);
        }
        Collection<Variable> variables = PhpPsiUtil.getUsedVariables(function);
        for (Variable variable : variables) {
            if (variable == null || !PhpLangUtil.equalsVariableNames(variableName, variable.getName())) continue;
            return variable.getType();
        }
        return null;
    }

    public boolean processCaseConditionInstruction(PhpCaseConditionInstruction instruction) {
        PsiElement argument = instruction.getSwitchArgument();
        if (argument instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)argument).getName(), this.myVariableName) || argument instanceof ConstantReference && PhpLangUtil.isTrue((ConstantReference)argument)) {
            return this.performDataFlowAnalyze(instruction.getCaseArgument(), true);
        }
        return true;
    }

    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        return this.performDataFlowAnalyze(instruction.getCondition(), instruction.getResult());
    }

    private boolean performDataFlowAnalyze(@Nullable PsiElement condition, boolean result) {
        Map typeMap = (Map)PhpVariableTypeDFAnalyzer.INSTANCE.performDFA(condition, result);
        if (typeMap.containsKey(this.myVariableName)) {
            PhpType type = (PhpType)typeMap.get(this.myVariableName);
            this.setType(type);
            return !type.isNotExtendablePrimitiveType();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpVariableInferredTypeAnalyzerProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportedVariableType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

