/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.completion.smartEnter.PhpComplementor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpComplementorFactory {
    private static final PhpComplementor SEMICOLON_COMPLEMENTOR = new SemicolonComplementor();
    private static final PhpComplementor PAREN_EXPR_COMPLEMENTOR = new ParenExprComplementor();
    private static final PhpComplementor CONTROL_STATEMENT_COMPLEMENTOR = new ControlStatementComplementor();
    private static final PhpComplementor ELSE_COMPLEMENTOR = new ElseComplementor();
    private static final PhpComplementor DO_WHILE_COMPLEMENTOR = new DoWhileComplementor();
    private static final PhpComplementor FUNCTION_CALL_COMPLEMENTOR = new FunctionCallComplementor();
    private static final PhpComplementor NEW_EXPRESSION_COMPLEMENTOR = new NewExpressionComplementor();
    private static final PhpComplementor CONST_FIELD_COMPLEMENTOR = new ClassConstFieldComplementor();
    private static final PhpComplementor FUNCTION_COMPLEMENTOR = new FunctionComplementor();
    private static final PhpComplementor ARRAY_ELEMENT_COMPLEMENTOR = new ArrayElementComplementor();
    private static final PhpComplementor CLASS_COMPLEMENTOR = new ClassComplementor();
    private static final PhpComplementor SWITCH_CASE_COMPLEMENTOR = new SwitchCaseComplementor();
    private static final PhpComplementor SWITCH_COMPLEMENTOR = new SwitchComplementor();
    private static final PhpComplementor TRY_CATCH_COMPLEMENTOR = new TryCatchComplementor();
    private static final PhpComplementor ARRAY_CREATION_COMPLEMENTOR = new ArrayCreationComplementor();

    private PhpComplementorFactory() {
    }

    @Nullable
    public static PhpComplementor getComplementor(PsiElement element) {
        ASTNode node = element.getNode();
        if (node == null) {
            return null;
        }
        IElementType elType = node.getElementType();
        if (PhpComplementorFactory.isAssignmentStatement(element)) {
            return SEMICOLON_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.PARENTHESIZED_EXPRESSION) {
            return PAREN_EXPR_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.ELSE) {
            return ELSE_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.DO_WHILE) {
            return DO_WHILE_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.SWITCH) {
            return SWITCH_COMPLEMENTOR;
        }
        if (PhpComplementorFactory.isControlStatement(element)) {
            return CONTROL_STATEMENT_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.FUNCTION_CALL || elType == PhpElementTypes.METHOD_REFERENCE) {
            return FUNCTION_CALL_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.NEW_EXPRESSION) {
            return NEW_EXPRESSION_COMPLEMENTOR;
        }
        if (elType == PhpStubElementTypes.CLASS_CONST) {
            return CONST_FIELD_COMPLEMENTOR;
        }
        if (elType == PhpStubElementTypes.DEFINE || elType == PhpStubElementTypes.CONST) {
            return SEMICOLON_COMPLEMENTOR;
        }
        if (elType == PhpStubElementTypes.FUNCTION || elType == PhpStubElementTypes.CLASS_METHOD) {
            return FUNCTION_COMPLEMENTOR;
        }
        if (elType == PhpStubElementTypes.CLASS) {
            return CLASS_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.HASH_ARRAY_ELEMENT || PhpComplementorFactory.isSimpleArrayValue(node)) {
            return ARRAY_ELEMENT_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.CASE || elType == PhpElementTypes.CASE_DEFAULT) {
            return SWITCH_CASE_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.TRY) {
            return TRY_CATCH_COMPLEMENTOR;
        }
        if (elType == PhpElementTypes.ARRAY_CREATION_EXPRESSION) {
            return ARRAY_CREATION_COMPLEMENTOR;
        }
        if (PhpComplementorFactory.isStatement(element)) {
            return SEMICOLON_COMPLEMENTOR;
        }
        return null;
    }

    static boolean isSimpleArrayValue(@NotNull ASTNode node) {
        if (node == null) {
            PhpComplementorFactory.$$$reportNull$$$0(0);
        }
        if (node.getElementType() == PhpElementTypes.ARRAY_VALUE) {
            ASTNode parent = node.getTreeParent();
            return parent != null && parent.getElementType() == PhpElementTypes.ARRAY_CREATION_EXPRESSION;
        }
        return false;
    }

    public static boolean isStatement(PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null) {
            IElementType elType = node.getElementType();
            return PhpElementTypes.STATEMENTS.contains(elType) || elType == PhpElementTypes.CLASS_FIELDS || elType == PhpElementTypes.CLASS_CONSTANTS || elType == PhpStubElementTypes.FUNCTION || elType == PhpStubElementTypes.CLASS_METHOD || PhpComplementorFactory.isAssignmentStatement(element) || elType == PhpElementTypes.HASH_ARRAY_ELEMENT || PhpComplementorFactory.isSimpleArrayValue(node) || elType == PhpStubElementTypes.CLASS || elType == PhpElementTypes.CASE || elType == PhpElementTypes.CASE_DEFAULT || elType == PhpElementTypes.TRY;
        }
        return false;
    }

    public static boolean isControlStatement(PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null) {
            IElementType elType = node.getElementType();
            return elType == PhpElementTypes.IF || elType == PhpElementTypes.WHILE || elType == PhpElementTypes.ELSE_IF || elType == PhpElementTypes.FOR || elType == PhpElementTypes.FOREACH || elType == PhpElementTypes.DO_WHILE || elType == PhpElementTypes.ELSE || elType == PhpElementTypes.SWITCH;
        }
        return false;
    }

    private static boolean isAssignmentStatement(@NotNull PsiElement element) {
        PsiElement parent;
        ASTNode node;
        PsiElement child;
        if (element == null) {
            PhpComplementorFactory.$$$reportNull$$$0(1);
        }
        return element instanceof Statement ? (child = element.getFirstChild()) != null && (node = child.getNode()) != null && PhpElementTypes.ASSIGNMENTS.contains(node.getElementType()) : element instanceof AssignmentExpression && (parent = element.getParent()) instanceof GroupStatement;
    }

    private static boolean endsWith(PsiElement statement, IElementType elType) {
        PsiElement lastChild = PsiTreeUtil.lastChild((PsiElement)statement);
        ASTNode node = lastChild.getNode();
        if (node != null) {
            if (node.getElementType() == elType) {
                return true;
            }
            PsiElement next = PsiTreeUtil.nextVisibleLeaf((PsiElement)statement);
            if (PhpPsiUtil.isOfType(next, elType)) {
                return true;
            }
        }
        return false;
    }

    private static String completeAltSyntax(PsiElement element, @NotNull PsiElement colonElement) {
        String endKeywordText;
        if (colonElement == null) {
            PhpComplementorFactory.$$$reportNull$$$0(2);
        }
        String keywordText = element.getFirstChild().getText();
        IElementType statementType = element.getNode().getElementType();
        if (statementType == PhpElementTypes.ELSE_IF) {
            if (PhpPsiUtil.getNextSibling(element, PhpPsiUtil.PSI_ERROR_ELEMENT_INSTANCEOF) != null) {
                return "";
            }
            endKeywordText = "endif";
        } else {
            endKeywordText = "end" + keywordText;
        }
        PsiElement child = colonElement.getNextSibling();
        if (child != null) {
            if (child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            while (child != null) {
                IElementType childType = child.getNode().getElementType();
                if (statementType == PhpElementTypes.IF && childType == PhpTokenTypes.kwENDIF || statementType == PhpElementTypes.FOR && childType == PhpTokenTypes.kwENDFOR || statementType == PhpElementTypes.FOREACH && childType == PhpTokenTypes.kwENDFOREACH || statementType == PhpElementTypes.SWITCH && childType == PhpTokenTypes.kwENDSWITCH || statementType == PhpElementTypes.WHILE && childType == PhpTokenTypes.kwENDWHILE) {
                    return "";
                }
                child = child.getNextSibling();
            }
        }
        return "\n" + endKeywordText + ";";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colonElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimpleArrayValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignmentStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "completeAltSyntax";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ArrayCreationComplementor
    implements PhpComplementor {
        private ArrayCreationComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement firstChild = element.getFirstChild();
            if (firstChild != null) {
                PsiElement next;
                IElementType startsWith = firstChild.getNode().getElementType();
                if (startsWith == PhpTokenTypes.kwARRAY) {
                    PsiElement next2 = PhpPsiUtil.findNextSiblingOfAnyType(firstChild, PhpTokenTypes.chLPAREN);
                    if (next2 == null) {
                        if ("()" == null) {
                            ArrayCreationComplementor.$$$reportNull$$$0(0);
                        }
                        return "()";
                    }
                    if ((next2 = PhpPsiUtil.findNextSiblingOfAnyType(next2, PhpTokenTypes.chRPAREN)) == null) {
                        if (")" == null) {
                            ArrayCreationComplementor.$$$reportNull$$$0(1);
                        }
                        return ")";
                    }
                } else if (startsWith == PhpTokenTypes.chLBRACKET && (next = PhpPsiUtil.findNextSiblingOfAnyType(firstChild, PhpTokenTypes.chRBRACKET)) == null) {
                    if ("]" == null) {
                        ArrayCreationComplementor.$$$reportNull$$$0(2);
                    }
                    return "]";
                }
            }
            if ("" == null) {
                ArrayCreationComplementor.$$$reportNull$$$0(3);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$ArrayCreationComplementor", "getComplement"));
        }
    }

    private static class TryCatchComplementor
    implements PhpComplementor {
        private TryCatchComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            String finallyCompletion;
            PsiElement child = element.getFirstChild();
            assert (PhpPsiUtil.isOfType(child, PhpTokenTypes.kwTRY)) : "'try' keyword is expected.";
            if ((child = child.getNextSibling()) instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child == null || !PhpPsiUtil.isOfType(child, PhpElementTypes.ANY_GROUP_STATEMENT)) {
                if ("{} catch() {}" == null) {
                    TryCatchComplementor.$$$reportNull$$$0(0);
                }
                return "{} catch() {}";
            }
            PsiElement lastTryGroupChild = child.getLastChild();
            if (lastTryGroupChild == null || !PhpPsiUtil.isOfType(lastTryGroupChild, PhpTokenTypes.chRBRACE)) {
                if ("} cacth() {}" == null) {
                    TryCatchComplementor.$$$reportNull$$$0(1);
                }
                return "} cacth() {}";
            }
            if ((child = child.getNextSibling()) instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child == null || !PhpPsiUtil.isOfType(child, PhpElementTypes.CATCH)) {
                if ("catch() {}" == null) {
                    TryCatchComplementor.$$$reportNull$$$0(2);
                }
                return "catch() {}";
            }
            PsiElement lPar = PhpPsiUtil.getChildOfType(child, PhpTokenTypes.chLPAREN);
            if (lPar == null) {
                if ("() {}" == null) {
                    TryCatchComplementor.$$$reportNull$$$0(3);
                }
                return "() {}";
            }
            PsiElement rPar = PhpPsiUtil.getChildOfType(child, PhpTokenTypes.chRPAREN);
            if (rPar == null) {
                if (") {}" == null) {
                    TryCatchComplementor.$$$reportNull$$$0(4);
                }
                return ") {}";
            }
            String catchCompletion = TryCatchComplementor.completeGroupOf(child);
            if (catchCompletion != null) {
                String string = catchCompletion;
                if (string == null) {
                    TryCatchComplementor.$$$reportNull$$$0(5);
                }
                return string;
            }
            PsiElement finallyClause = element.getLastChild();
            if (PhpPsiUtil.isOfType(finallyClause, PhpElementTypes.FINALLY) && (finallyCompletion = TryCatchComplementor.completeGroupOf(finallyClause)) != null) {
                String string = finallyCompletion;
                if (string == null) {
                    TryCatchComplementor.$$$reportNull$$$0(6);
                }
                return string;
            }
            if ("" == null) {
                TryCatchComplementor.$$$reportNull$$$0(7);
            }
            return "";
        }

        @Nullable
        private static String completeGroupOf(PsiElement clause) {
            PsiElement clauseGroup = clause.getLastChild();
            if (clauseGroup == null || !PhpPsiUtil.isOfType(clauseGroup, PhpElementTypes.ANY_GROUP_STATEMENT)) {
                return "{}";
            }
            PsiElement lastGroupChild = clauseGroup.getLastChild();
            if (lastGroupChild == null || !PhpPsiUtil.isOfType(lastGroupChild, PhpTokenTypes.chRBRACE)) {
                return "}";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$TryCatchComplementor", "getComplement"));
        }
    }

    private static class SwitchCaseComplementor
    implements PhpComplementor {
        private SwitchCaseComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement child = element.getLastChild();
            if (child instanceof GroupStatement) {
                if ((child = child.getPrevSibling()) instanceof PsiWhiteSpace) {
                    child = child.getPrevSibling();
                }
                if (child instanceof PsiErrorElement) {
                    IElementType childType = (child = child.getPrevSibling()) != null ? child.getNode().getElementType() : null;
                    String string = childType == PhpTokenTypes.kwCASE ? " :" : ":";
                    if (string == null) {
                        SwitchCaseComplementor.$$$reportNull$$$0(0);
                    }
                    return string;
                }
            }
            if ("" == null) {
                SwitchCaseComplementor.$$$reportNull$$$0(1);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$SwitchCaseComplementor", "getComplement"));
        }
    }

    private static class SwitchComplementor
    implements PhpComplementor {
        private SwitchComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement colon = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.opCOLON);
            if (colon != null) {
                String string = PhpComplementorFactory.completeAltSyntax(element, colon);
                if (string == null) {
                    SwitchComplementor.$$$reportNull$$$0(0);
                }
                return string;
            }
            PsiElement lPar = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chLPAREN);
            if (lPar == null) {
                if ("(){}" == null) {
                    SwitchComplementor.$$$reportNull$$$0(1);
                }
                return "(){}";
            }
            PsiElement rPar = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chRPAREN);
            if (rPar == null) {
                if ("){}" == null) {
                    SwitchComplementor.$$$reportNull$$$0(2);
                }
                return "){}";
            }
            PsiElement lBrace = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chLBRACE);
            if (lBrace == null) {
                if ("{}" == null) {
                    SwitchComplementor.$$$reportNull$$$0(3);
                }
                return "{}";
            }
            PsiElement rBrace = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chRBRACE);
            if (rBrace == null) {
                if ("}" == null) {
                    SwitchComplementor.$$$reportNull$$$0(4);
                }
                return "}";
            }
            if ("" == null) {
                SwitchComplementor.$$$reportNull$$$0(5);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$SwitchComplementor", "getComplement"));
        }
    }

    private static class ClassComplementor
    implements PhpComplementor {
        private ClassComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement lastChild = element.getLastChild();
            if (lastChild instanceof PsiErrorElement && !PhpPsiUtil.isOfType(lastChild = lastChild.getPrevSibling(), PhpTokenTypes.chRBRACE)) {
                if ("{\n}" == null) {
                    ClassComplementor.$$$reportNull$$$0(0);
                }
                return "{\n}";
            }
            if ("" == null) {
                ClassComplementor.$$$reportNull$$$0(1);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$ClassComplementor", "getComplement"));
        }
    }

    private static class ArrayElementComplementor
    implements PhpComplementor {
        private ArrayElementComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement next = element.getNextSibling();
            if (next instanceof PsiWhiteSpace) {
                next = next.getNextSibling();
            }
            String string = next == null || !PhpPsiUtil.isOfType(next, PhpTokenTypes.opCOMMA) ? "," : "";
            if (string == null) {
                ArrayElementComplementor.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$ArrayElementComplementor", "getComplement"));
        }
    }

    private static class FunctionComplementor
    implements PhpComplementor {
        private FunctionComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            StringBuilder buf = new StringBuilder();
            PsiElement group = PhpPsiUtil.getChildOfType(element, PhpElementTypes.ANY_GROUP_STATEMENT);
            if (group == null) {
                PsiElement rPar;
                PsiElement lPar = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chLPAREN);
                if (lPar == null) {
                    buf.append('(');
                }
                if ((rPar = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chRPAREN)) == null) {
                    buf.append(')');
                }
                if (element instanceof Method && ((Method)element).isAbstract()) {
                    buf.append(';');
                    String string = buf.toString();
                    if (string == null) {
                        FunctionComplementor.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                buf.append("{\n}");
            }
            String string = buf.toString();
            if (string == null) {
                FunctionComplementor.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$FunctionComplementor", "getComplement"));
        }
    }

    private static class ClassConstFieldComplementor
    implements PhpComplementor {
        private ClassConstFieldComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement assign = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.opASGN);
            PsiElement parent = element.getParent();
            if (parent != null && PhpPsiUtil.getChildOfType(parent, PhpTokenTypes.opSEMICOLON) != null) {
                if ("" == null) {
                    ClassConstFieldComplementor.$$$reportNull$$$0(0);
                }
                return "";
            }
            if (assign == null) {
                if ("=" == null) {
                    ClassConstFieldComplementor.$$$reportNull$$$0(1);
                }
                return "=";
            }
            if ("" == null) {
                ClassConstFieldComplementor.$$$reportNull$$$0(2);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$ClassConstFieldComplementor", "getComplement"));
        }
    }

    private static class NewExpressionComplementor
    extends FunctionCallComplementor {
        private NewExpressionComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            if (!(element.getParent() instanceof ParenthesizedExpression)) {
                String string = super.getComplement(element);
                if (string == null) {
                    NewExpressionComplementor.$$$reportNull$$$0(0);
                }
                return string;
            }
            if ("" == null) {
                NewExpressionComplementor.$$$reportNull$$$0(1);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$NewExpressionComplementor", "getComplement"));
        }
    }

    private static class FunctionCallComplementor
    implements PhpComplementor {
        private FunctionCallComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement lPar = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chLPAREN);
            PsiElement rPar = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chRPAREN);
            if (lPar == null && rPar == null) {
                if ("()" == null) {
                    FunctionCallComplementor.$$$reportNull$$$0(0);
                }
                return "()";
            }
            if (rPar == null) {
                if (")" == null) {
                    FunctionCallComplementor.$$$reportNull$$$0(1);
                }
                return ")";
            }
            if ("" == null) {
                FunctionCallComplementor.$$$reportNull$$$0(2);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$FunctionCallComplementor", "getComplement"));
        }
    }

    private static class DoWhileComplementor
    implements PhpComplementor {
        private DoWhileComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement whileEl = PhpPsiUtil.getChildOfType(element, PhpElementTypes.WHILE);
            if (whileEl == null && (whileEl = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.kwWHILE)) == null) {
                StringBuilder buf = new StringBuilder();
                PsiElement group = PhpPsiUtil.getChildOfType(element, PhpElementTypes.ANY_GROUP_STATEMENT);
                if (group == null) {
                    buf.append("{}");
                }
                buf.append("while();");
                String string = buf.toString();
                if (string == null) {
                    DoWhileComplementor.$$$reportNull$$$0(0);
                }
                return string;
            }
            PsiElement lPar = PhpPsiUtil.findNextSiblingOfAnyType(whileEl, PhpTokenTypes.chLPAREN);
            if (lPar == null) {
                if ("();" == null) {
                    DoWhileComplementor.$$$reportNull$$$0(1);
                }
                return "();";
            }
            PsiElement rPar = PhpPsiUtil.findNextSiblingOfAnyType(lPar, PhpTokenTypes.chRPAREN);
            if (rPar == null) {
                if (");" == null) {
                    DoWhileComplementor.$$$reportNull$$$0(2);
                }
                return ");";
            }
            PsiElement semicolon = PhpPsiUtil.findNextSiblingOfAnyType(lPar, PhpTokenTypes.opSEMICOLON);
            if (semicolon == null) {
                if (";" == null) {
                    DoWhileComplementor.$$$reportNull$$$0(3);
                }
                return ";";
            }
            if ("" == null) {
                DoWhileComplementor.$$$reportNull$$$0(4);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$DoWhileComplementor", "getComplement"));
        }
    }

    private static class ElseComplementor
    implements PhpComplementor {
        private ElseComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement ifColon;
            PsiElement parent = element.getParent();
            if (PhpPsiUtil.isOfType(parent, PhpElementTypes.IF) && (ifColon = PhpPsiUtil.getChildOfType(parent, PhpTokenTypes.opCOLON)) != null) {
                String result = "";
                PsiElement elseColon = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.opCOLON);
                if (elseColon == null) {
                    result = ":";
                }
                String string = result = result + PhpComplementorFactory.completeAltSyntax(parent, ifColon);
                if (string == null) {
                    ElseComplementor.$$$reportNull$$$0(0);
                }
                return string;
            }
            PsiElement lastChild = element.getLastChild();
            if (lastChild instanceof PsiErrorElement) {
                if ("{}" == null) {
                    ElseComplementor.$$$reportNull$$$0(1);
                }
                return "{}";
            }
            if (lastChild instanceof GroupStatement && !PhpPsiUtil.isOfType(lastChild = lastChild.getLastChild(), PhpTokenTypes.chRBRACE)) {
                if ("}" == null) {
                    ElseComplementor.$$$reportNull$$$0(2);
                }
                return "}";
            }
            if ("" == null) {
                ElseComplementor.$$$reportNull$$$0(3);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$ElseComplementor", "getComplement"));
        }
    }

    private static class ControlStatementComplementor
    implements PhpComplementor {
        private ControlStatementComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            PsiElement colon;
            PsiElement rPar;
            StringBuilder buf = new StringBuilder();
            PsiElement lPar = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chLPAREN);
            if (lPar == null) {
                buf.append('(');
            }
            if ((rPar = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.chRPAREN)) == null) {
                buf.append(')');
            }
            if ((colon = PhpPsiUtil.getChildOfType(element, PhpTokenTypes.opCOLON)) == null) {
                PsiElement parent = element.getParent();
                PsiElement parentColon = PhpPsiUtil.getChildOfType(parent, PhpTokenTypes.opCOLON);
                if (parentColon != null) {
                    buf.append(':');
                    String string = buf.toString();
                    if (string == null) {
                        ControlStatementComplementor.$$$reportNull$$$0(0);
                    }
                    return string;
                }
            } else {
                String string = PhpComplementorFactory.completeAltSyntax(element, colon);
                if (string == null) {
                    ControlStatementComplementor.$$$reportNull$$$0(1);
                }
                return string;
            }
            PsiElement last = element.getLastChild();
            if (last == null) {
                if ("" == null) {
                    ControlStatementComplementor.$$$reportNull$$$0(2);
                }
                return "";
            }
            IElementType lastType = last.getNode().getElementType();
            if (!PhpElementTypes.ANY_GROUP_STATEMENT.contains(lastType) && lastType != PhpElementTypes.ELSE && lastType != PhpElementTypes.ELSE_IF) {
                buf.append("{}");
            }
            String string = buf.toString();
            if (string == null) {
                ControlStatementComplementor.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$ControlStatementComplementor", "getComplement"));
        }
    }

    private static class ParenExprComplementor
    implements PhpComplementor {
        private ParenExprComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            if (!PhpComplementorFactory.endsWith(element, PhpTokenTypes.chRPAREN)) {
                if (")" == null) {
                    ParenExprComplementor.$$$reportNull$$$0(0);
                }
                return ")";
            }
            if ("" == null) {
                ParenExprComplementor.$$$reportNull$$$0(1);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$ParenExprComplementor", "getComplement"));
        }
    }

    private static class SemicolonComplementor
    implements PhpComplementor {
        private SemicolonComplementor() {
        }

        @Override
        @NotNull
        public String getComplement(PsiElement element) {
            if (!PhpComplementorFactory.endsWith(element, PhpTokenTypes.opSEMICOLON)) {
                if (";" == null) {
                    SemicolonComplementor.$$$reportNull$$$0(0);
                }
                return ";";
            }
            if ("" == null) {
                SemicolonComplementor.$$$reportNull$$$0(1);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/completion/smartEnter/PhpComplementorFactory$SemicolonComplementor", "getComplement"));
        }
    }
}

