/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseDisplay;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBasePresenter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class PhpIntroduceBaseDialog
extends DialogWrapper
implements PhpIntroduceBaseDisplay {
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    protected PhpIntroduceBasePresenter.DisplayHandler myHandler;
    protected NameSuggestionsField myNameField;
    protected NameSuggestionsField.DataChanged myNameChangedListener;
    protected JCheckBox myReplaceOccurrencesCheckBox;
    protected Project myProject;

    public PhpIntroduceBaseDialog(Project project) {
        super(project, false);
        this.myProject = project;
        this.myReplaceOccurrencesCheckBox = new JCheckBox();
        this.myReplaceOccurrencesCheckBox.setVisible(false);
        this.myReplaceOccurrencesCheckBox.setFocusable(true);
    }

    protected final JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4);
        gbConstraints.anchor = 17;
        gbConstraints.fill = 1;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        JLabel namePrompt = new JLabel(RefactoringBundle.message((String)"name.prompt"));
        namePrompt.setLabelFor(this.myNameField.getComponent());
        panel.add((Component)namePrompt, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 1;
        panel.add((Component)this.myNameField.getComponent(), gbConstraints);
        gbConstraints.gridwidth = 2;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 2;
        panel.add((Component)this.myReplaceOccurrencesCheckBox, gbConstraints);
        return panel;
    }

    public final JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    protected void dispose() {
        this.myNameField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    protected void init() {
        super.init();
        this.setTitle(this.getTitle());
        this.myNameChangedListener = () -> this.scheduleValidation();
        this.myNameField.addDataChangedListener(this.myNameChangedListener);
        SwingUtilities.invokeLater(() -> this.scheduleValidation());
    }

    protected void doOKAction() {
        if (!this.doValidation()) {
            return;
        }
        switch (this.myHandler.handleOKAction(this)) {
            case ALLOW: {
                super.doOKAction();
                break;
            }
            case BREAK: {
                super.doCancelAction();
                break;
            }
            case RETURN: {
                return;
            }
        }
    }

    protected abstract String getHelpId();

    protected abstract boolean isReplaceAllOccurrencesByDefault();

    public abstract String getTitle();

    protected void scheduleValidation() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.doValidation(), 200, ModalityState.current());
    }

    private boolean doValidation() {
        Pair<Boolean, String> validateResult = this.myHandler.validate(this);
        this.setOKActionEnabled((Boolean)validateResult.getFirst());
        this.setErrorText((String)validateResult.getSecond());
        return (Boolean)validateResult.getFirst();
    }

    protected void setData(int expressionOccurrences, @NotNull String[] suggestedNames, @NotNull PhpIntroduceBasePresenter.DisplayHandler handler) {
        if (suggestedNames == null) {
            PhpIntroduceBaseDialog.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            PhpIntroduceBaseDialog.$$$reportNull$$$0(1);
        }
        this.myNameField = new NameSuggestionsField(suggestedNames, this.myProject);
        this.myHandler = handler;
        if (expressionOccurrences > 1) {
            this.myReplaceOccurrencesCheckBox.setVisible(true);
            this.myReplaceOccurrencesCheckBox.setText(PhpBundle.message("refactoring.extract.base.dialog.replace.all.occurrences", expressionOccurrences));
            this.myReplaceOccurrencesCheckBox.setSelected(this.isReplaceAllOccurrencesByDefault());
        }
    }

    @Override
    public String getName() {
        return this.myNameField.getEnteredName();
    }

    @Override
    public boolean isReplaceAllOccurrences() {
        return this.myReplaceOccurrencesCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "suggestedNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "handler";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/refactoring/introduce/PhpIntroduceBaseDialog";
        objectArray[2] = "setData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

