/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.clazz;

import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassSettings;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassUsageInfo;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassUsageInfoProvider;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveClassProcessor
extends PhpBaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.refactoring.move.clazz.PhpMoveClassProcessor");
    public static final String REFACTORING_NAME = PhpBundle.message("refactoring.move.class.name", new Object[0]);
    private final PhpMoveClassSettings mySettings;
    private final boolean mySearchInStringsAndComments;
    private final boolean mySearchForTextOccurrences;

    protected PhpMoveClassProcessor(@NotNull Project project, @NotNull PhpMoveClassSettings settings, boolean searchInStringsAndComments, boolean searchForTextOccurrences) {
        if (project == null) {
            PhpMoveClassProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PhpMoveClassProcessor.$$$reportNull$$$0(1);
        }
        super(project);
        this.mySettings = settings;
        this.mySearchInStringsAndComments = searchInStringsAndComments;
        this.mySearchForTextOccurrences = searchForTextOccurrences;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpMoveClassProcessor.$$$reportNull$$$0(2);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{PhpMoveClassProcessor.this.mySettings.getClassForRefactoring()};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return REFACTORING_NAME;
            }

            public String getCommentReferencesText(int usagesCount, int filesCount) {
                return PhpBundle.message("refactoring.move.class.in.non.code.message", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            PhpMoveClassProcessor.$$$reportNull$$$0(3);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        final ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        PhpClass clazz = this.mySettings.getClassForRefactoring();
        if (!clazz.isValid()) {
            LOG.warn("Target class psi element is invalid");
            if (UsageInfo.EMPTY_ARRAY == null) {
                PhpMoveClassProcessor.$$$reportNull$$$0(4);
            }
            return UsageInfo.EMPTY_ARRAY;
        }
        final PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)clazz);
        result.add(PhpMoveClassUsageInfoProvider.createDeclarationUsageInfo(scopeHolder, this.mySettings));
        CommonProcessors.FindProcessor<PsiReference> finder = new CommonProcessors.FindProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                PhpMoveClassUsageInfo info = PhpMoveClassUsageInfoProvider.createReferenceUsageInfo(scopeHolder, PhpMoveClassProcessor.this.mySettings, reference);
                if (info != null) {
                    result.add(info);
                }
                return false;
            }
        };
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)clazz.getProject());
        ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)clazz, (SearchScope)scope, false);
        ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).forEach((Processor)finder);
        String fqn = clazz.getFQN();
        if (fqn != null) {
            StringBuilder fqnBuilder = new StringBuilder();
            if (StringUtil.isNotEmpty((String)this.mySettings.getDestinationNamespace())) {
                fqnBuilder.append(this.mySettings.getDestinationNamespace()).append("\\");
            }
            fqnBuilder.append(clazz.getName());
            ArrayList<UsageInfo> nonCodeUsages = new ArrayList<UsageInfo>();
            String name = PhpLangUtil.toName(fqn);
            PhpMoveClassProcessor.findNonCodeUsages((PsiElement)clazz, name, fqnBuilder.toString(), nonCodeUsages, this.mySearchInStringsAndComments, this.mySearchForTextOccurrences);
            if (!nonCodeUsages.isEmpty()) {
                result.addAll(nonCodeUsages);
            }
        }
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            PhpMoveClassProcessor.$$$reportNull$$$0(5);
        }
        return usageInfoArray;
    }

    @Override
    protected void performMainRefactoring(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (usage instanceof PhpMoveClassUsageInfo) {
                ((PhpMoveClassUsageInfo)usage).firstStepProcess(this.myProject, this.mySettings.getDestinationNamespace(), this.mySettings.getClassForRefactoring());
                continue;
            }
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            this.myNonCodeUsageInfos.add((NonCodeUsageInfo)usage);
        }
    }

    @Override
    protected void performPostRefactoring(UsageInfo[] usages) {
        THashSet affectedFiles = new THashSet();
        String oldFQN = this.mySettings.getClassForRefactoring().getFQN();
        RefactoringElementListener listener = this.getTransaction().getElementListener((PsiElement)this.mySettings.getClassForRefactoring());
        for (UsageInfo usage : usages) {
            if (!(usage instanceof PhpMoveClassUsageInfo)) continue;
            try {
                PsiFile file = ((PhpMoveClassUsageInfo)usage).secondStepProcess(this.myProject, this.mySettings.getDestinationNamespace(), this.mySettings.getClassForRefactoring());
                if (file == null) continue;
                affectedFiles.add(file);
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorMessage((String)REFACTORING_NAME, (String)e.getMessage(), null, (Project)this.myProject);
            }
        }
        this.optimizeImports((Collection<PsiFile>)affectedFiles);
        this.fireListener(listener, oldFQN);
    }

    private void fireListener(final @Nullable RefactoringElementListener listener, final @NotNull String oldFQN) {
        if (oldFQN == null) {
            PhpMoveClassProcessor.$$$reportNull$$$0(6);
        }
        if (listener != null) {
            listener.elementMoved((PsiElement)this.mySettings.getClassForRefactoring());
            BasicUndoableAction action = new BasicUndoableAction(){

                public void undo() {
                    if (listener instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)listener).undoElementMovedOrRenamed((PsiElement)PhpMoveClassProcessor.this.mySettings.getClassForRefactoring(), oldFQN);
                    }
                }

                public void redo() {
                }
            };
            UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action);
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = REFACTORING_NAME;
        if (string == null) {
            PhpMoveClassProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fireListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

