/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.util.connection.ServerConnectionListener;
import com.jetbrains.php.util.connection.ServerConnectionStatus;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerConnection
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.util.connection.ServerConnection");
    private volatile ServerSocket myServerSocket;
    private final Object myLock = new Object();
    protected final EventDispatcher<ServerConnectionListener> myDispatcher = EventDispatcher.create(ServerConnectionListener.class);
    private ServerConnectionStatus myStatus = ServerConnectionStatus.STOPPED;

    protected ServerConnection() {
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
    }

    public final int getPort() {
        if (this.myServerSocket == null) {
            return -1;
        }
        return this.myServerSocket.getLocalPort();
    }

    public synchronized void startListening(int port) throws ExecutionException {
        LOG.debug("Starting '" + this.getDescriptiveName() + "' on port " + port);
        try {
            this.myServerSocket = new ServerSocket(port);
        }
        catch (Exception e) {
            throw new ExecutionException(PhpBundle.message("connection.port.is.busy", String.valueOf(port)));
        }
        ServerSocket serverSocket = this.myServerSocket;
        this.setStatus(ServerConnectionStatus.STARTED);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                while (this.myServerSocket != null) {
                    try {
                        Socket socket = serverSocket.accept();
                        socket.setTcpNoDelay(true);
                        this.registerSocket(socket);
                        ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            try {
                                LOG.debug(MessageFormat.format("Incoming connection on port {0} from {1}", String.valueOf(port), socket.getInetAddress().getHostAddress()));
                                this.handle(socket);
                            }
                            catch (IOException e) {
                                LOG.warn((Throwable)e);
                            }
                            finally {
                                try {
                                    LOG.debug("----socket closed");
                                    this.stopSocketListening(socket);
                                }
                                catch (IOException e) {
                                    boolean bl = true;
                                }
                            }
                        });
                    }
                    catch (SocketTimeoutException ignored) {
                        boolean bl = true;
                    }
                }
            }
            catch (IOException e) {
                if (this.myServerSocket != null) {
                    LOG.info("Error while listening on port " + port, (Throwable)e);
                }
            }
            finally {
                LOG.info("Stopped listening on port " + port);
                this.stopListening();
            }
        });
    }

    protected void registerSocket(@NotNull Socket socket) {
        if (socket == null) {
            ServerConnection.$$$reportNull$$$0(0);
        }
    }

    protected void stopSocketListening(@NotNull Socket socket) throws IOException {
        if (socket == null) {
            ServerConnection.$$$reportNull$$$0(1);
        }
        socket.close();
    }

    public synchronized void stopListening() {
        if (this.myServerSocket == null) {
            return;
        }
        LOG.debug("Stopping '" + this.getDescriptiveName() + "' on port " + this.myServerSocket.getLocalPort());
        this.setStatus(ServerConnectionStatus.STOPPED);
        ServerSocket serverSocket = this.myServerSocket;
        this.myServerSocket = null;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                serverSocket.close();
                LOG.debug("Stopped '" + this.getDescriptiveName() + "' on port " + serverSocket.getLocalPort());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Disposer.dispose((Disposable)this);
        });
    }

    public void dispose() {
    }

    protected abstract void handle(@NotNull Socket var1) throws IOException;

    @NotNull
    public abstract String getDescriptiveName();

    public void addListener(@NotNull ServerConnectionListener listener, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            ServerConnection.$$$reportNull$$$0(2);
        }
        if (parentDisposable != null) {
            this.myDispatcher.addListener((EventListener)listener, parentDisposable);
        } else {
            this.myDispatcher.addListener((EventListener)listener);
        }
    }

    public void removeListener(@NotNull ServerConnectionListener listener) {
        if (listener == null) {
            ServerConnection.$$$reportNull$$$0(3);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(ServerConnectionStatus status) {
        Object object = this.myLock;
        synchronized (object) {
            this.myStatus = status;
        }
        ((ServerConnectionListener)this.myDispatcher.getMulticaster()).statusChanged(this, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConnectionStatus getStatus() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.myLock;
        synchronized (object) {
            return this.getStatus() == ServerConnectionStatus.STARTED;
        }
    }

    public final void log(String text) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.hashCode());
        builder.append("#");
        builder.append(text);
        LOG.info(builder.toString());
    }

    public final void logEvent(String text) {
        this.log("---" + text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/util/connection/ServerConnection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSocket";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "stopSocketListening";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

