/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QNameUtil {
    private QNameUtil() {
    }

    @NotNull
    public static String getQualifiedName(@Nullable DbElement element2) {
        if (element2 instanceof DasDataSource) {
            String string = element2.getName();
            if (string == null) {
                QNameUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = QNameUtil.getQualifiedName((DasObject)element2);
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable DasObject element2) {
        String string = QNameUtil.getQualifiedName(element2, (Function<DasObject, String>)DasUtil.TO_NAME);
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable ObjectPath element2) {
        String string = element2 == null ? "" : element2.getDisplayName();
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable DasObject element2, DatabaseDialect dialect) {
        String string = QNameUtil.getQualifiedName(element2, (Function<DasObject, String>)((Function)object -> dialect.quoteIdentifier(object.getName(), false, true)));
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getQualifiedName(@Nullable DasObject element2, @NotNull Function<DasObject, String> namer) {
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(5);
        }
        List parents = DasUtil.dasParents((DasObject)element2).toList();
        StringBuilder sb = new StringBuilder();
        for (DasObject o : ContainerUtil.reverse((List)parents)) {
            if (sb.length() != 0) {
                sb.append(".");
            }
            sb.append((String)namer.fun((Object)o));
        }
        String string = sb.toString();
        if (string == null) {
            QNameUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean fqnStartsWith(@NotNull String fqn, @NotNull DasObject object, @NotNull Function<DasObject, String> namer, @NotNull CasingProvider provider) {
        int to;
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(7);
        }
        if (object == null) {
            QNameUtil.$$$reportNull$$$0(8);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(9);
        }
        if (provider == null) {
            QNameUtil.$$$reportNull$$$0(10);
        }
        return (to = QNameUtil.fqnMatch(fqn, object, namer, provider)) == 0 || QNameUtil.isDot(fqn, to);
    }

    public static boolean fqnEquals(@NotNull String fqn, @NotNull DasObject object, @NotNull Function<DasObject, String> namer, @NotNull CasingProvider provider) {
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(11);
        }
        if (object == null) {
            QNameUtil.$$$reportNull$$$0(12);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(13);
        }
        if (provider == null) {
            QNameUtil.$$$reportNull$$$0(14);
        }
        return QNameUtil.fqnMatch(fqn, object, namer, provider) == fqn.length();
    }

    private static int fqnMatch(@NotNull String fqn, @NotNull DasObject object, @NotNull Function<DasObject, String> namer, @NotNull CasingProvider provider) {
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(15);
        }
        if (object == null) {
            QNameUtil.$$$reportNull$$$0(16);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(17);
        }
        if (provider == null) {
            QNameUtil.$$$reportNull$$$0(18);
        }
        ArrayList parents = ContainerUtil.newArrayList((Iterable)DasUtil.dasParents((DasObject)object));
        Collections.reverse(parents);
        int from = 0;
        for (DasObject parent2 : parents) {
            int to = QNameUtil.fqnCmpStep(from, fqn, parent2, namer, provider);
            if (parent2 == object) {
                return to;
            }
            if (from == to) continue;
            if (!QNameUtil.isDot(fqn, to)) {
                return -1;
            }
            from = to + 1;
        }
        return -1;
    }

    private static boolean isDot(@NotNull String fqn, int from) {
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(19);
        }
        return from != -1 && from < fqn.length() && fqn.charAt(from) == '.';
    }

    public static int fqnCmpStep(int from, @NotNull String fqn, @NotNull DasObject object, @NotNull Function<DasObject, String> namer, @NotNull CasingProvider provider) {
        String name;
        int end;
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(20);
        }
        if (object == null) {
            QNameUtil.$$$reportNull$$$0(21);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(22);
        }
        if (provider == null) {
            QNameUtil.$$$reportNull$$$0(23);
        }
        if ((end = from + (name = (String)namer.fun((Object)object)).length()) > fqn.length()) {
            return -1;
        }
        Case c2 = provider.getCasing((ObjectKind)object.getKind(), (DasObject)object).quoted;
        boolean m = fqn.regionMatches(!c2.sensitive, from, name, 0, name.length());
        return m ? end : -1;
    }

    @NotNull
    public static JBIterable<DasObject> findByQName(@NotNull DasModel model, @NotNull String fqn, @NotNull Function<DasObject, String> namer) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(24);
        }
        if (fqn == null) {
            QNameUtil.$$$reportNull$$$0(25);
        }
        if (namer == null) {
            QNameUtil.$$$reportNull$$$0(26);
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().expand(object -> {
            if (fqn == null) {
                QNameUtil.$$$reportNull$$$0(49);
            }
            if (namer == null) {
                QNameUtil.$$$reportNull$$$0(50);
            }
            if (model == null) {
                QNameUtil.$$$reportNull$$$0(51);
            }
            return QNameUtil.fqnStartsWith(fqn, object, namer, (CasingProvider)model);
        })).filter(object -> {
            if (fqn == null) {
                QNameUtil.$$$reportNull$$$0(46);
            }
            if (namer == null) {
                QNameUtil.$$$reportNull$$$0(47);
            }
            if (model == null) {
                QNameUtil.$$$reportNull$$$0(48);
            }
            return QNameUtil.fqnEquals(fqn, object, namer, (CasingProvider)model);
        })).traverse();
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(27);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DasObject> findByPath(@NotNull DasModel model, @Nullable ObjectPath path) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(28);
        }
        JBIterable<DasObject> jBIterable = path == null ? JBIterable.empty() : QNameUtil.findByPath(model, path, (Function<ObjectPath, JBIterable<DasObject>>)((Function)p2 -> {
            if (model == null) {
                QNameUtil.$$$reportNull$$$0(45);
            }
            return QNameUtil.findByPath(model, p2);
        }));
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DasObject> findByPath(@NotNull DasModel model, @NotNull ObjectPath path, @NotNull Function<ObjectPath, JBIterable<DasObject>> findParent) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(30);
        }
        if (path == null) {
            QNameUtil.$$$reportNull$$$0(31);
        }
        if (findParent == null) {
            QNameUtil.$$$reportNull$$$0(32);
        }
        Condition byName = DbSqlUtil.byName(path.name, path.isQuoted(), path.getIdentity(), (CasingProvider)model);
        ObjectPath parent2 = path.parent;
        ObjectKind kind = path.kind;
        if (parent2 != null && parent2.kind != ObjectKind.NONE) {
            JBIterable jBIterable = QNameUtil.findChildren(model, findParent, parent2, kind).filter(byName);
            if (jBIterable == null) {
                QNameUtil.$$$reportNull$$$0(33);
            }
            return jBIterable;
        }
        String name = parent2 == null ? "" : parent2.name;
        boolean quoted = parent2 == null || parent2.isQuoted();
        String id = parent2 == null ? null : parent2.getIdentity();
        ObjectPath grandpa = parent2 == null ? null : parent2.parent;
        JBIterable jBIterable = model.getMetaModel().getParentKinds(kind).flatten(k -> {
            if (model == null) {
                QNameUtil.$$$reportNull$$$0(43);
            }
            if (findParent == null) {
                QNameUtil.$$$reportNull$$$0(44);
            }
            return QNameUtil.findChildren(model, findParent, ObjectPath.create((String)name, (ObjectKind)k, (boolean)quoted, (String)id, (ObjectPath)grandpa), kind);
        }).filter(byName);
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(34);
        }
        return jBIterable;
    }

    public static JBIterable<DasObject> findChildren(@NotNull DasModel model, @NotNull Function<ObjectPath, JBIterable<DasObject>> findParent, @NotNull ObjectPath parentPath, @NotNull ObjectKind kind) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(35);
        }
        if (findParent == null) {
            QNameUtil.$$$reportNull$$$0(36);
        }
        if (parentPath == null) {
            QNameUtil.$$$reportNull$$$0(37);
        }
        if (kind == null) {
            QNameUtil.$$$reportNull$$$0(38);
        }
        if (parentPath.kind == ObjectKind.ROOT) {
            return QNameUtil.getModelRoots(model, kind);
        }
        return ((JBIterable)findParent.fun((Object)parentPath)).flatten(o -> {
            if (kind == null) {
                QNameUtil.$$$reportNull$$$0(42);
            }
            return o.getDasChildren(kind);
        });
    }

    @NotNull
    public static JBIterable<DasObject> getModelRoots(@NotNull DasModel model, ObjectKind kind) {
        if (model == null) {
            QNameUtil.$$$reportNull$$$0(39);
        }
        if (model instanceof BasicModel && kind != ObjectKind.NONE) {
            JBIterable jBIterable = JBIterable.from(((BasicModel)model).getRoot().familyOf(kind));
            if (jBIterable == null) {
                QNameUtil.$$$reportNull$$$0(40);
            }
            return jBIterable;
        }
        JBIterable jBIterable = model.getModelRoots().filter(DasUtil.byKind((ObjectKind)kind));
        if (jBIterable == null) {
            QNameUtil.$$$reportNull$$$0(41);
        }
        return jBIterable;
    }

    @Contract(value="null->false")
    public static boolean isFakeName(@Nullable String name) {
        return name != null && StringUtil.startsWith((CharSequence)name, (CharSequence)"#FAKE_");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/QNameUtil";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 22: 
            case 26: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namer";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 25: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 10: 
            case 14: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 24: 
            case 28: 
            case 30: 
            case 35: 
            case 39: 
            case 43: 
            case 45: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findParent";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/QNameUtil";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findByQName";
                break;
            }
            case 29: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findByPath";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fqnStartsWith";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fqnEquals";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fqnMatch";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDot";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fqnCmpStep";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findByQName";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findByPath";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findChildren";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getModelRoots";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findChildren$5";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findByPath$4";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findByPath$3";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findByQName$2";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findByQName$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

