/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra.psi;

import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.cassandra.CassandraDialect;
import com.intellij.sql.dialects.cassandra.psi.CassCollectionLiteral;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CassSetOrMapLiteral
extends CassCollectionLiteral {
    public CassSetOrMapLiteral(@NotNull IElementType elementType) {
        if (elementType == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    protected boolean isInsideLiteral(PsiElement place) {
        if (super.isInsideLiteral(place)) {
            return true;
        }
        PsiElement parent2 = place.getParent();
        if (!(parent2 instanceof SqlSetAssignment)) {
            return false;
        }
        SqlSetAssignment setAssignment = (SqlSetAssignment)parent2;
        if (place != setAssignment.getLValue()) {
            return false;
        }
        return setAssignment.getParent() == this;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        for (PsiElement child : this.getChildren()) {
            if (child instanceof SqlSetAssignment) {
                SqlSetAssignment setAssignment = (SqlSetAssignment)child;
                SqlElement lValue = setAssignment.getLValue();
                if (lValue instanceof SqlReferenceExpression) {
                    SqlTableType sqlTableType = this.getSqlTableType();
                    if (sqlTableType == null) {
                        CassSetOrMapLiteral.$$$reportNull$$$0(1);
                    }
                    return sqlTableType;
                }
                SqlParametrizedType sqlParametrizedType = CassSetOrMapLiteral.getSqlMapType(lValue, setAssignment.getRValue());
                if (sqlParametrizedType == null) {
                    CassSetOrMapLiteral.$$$reportNull$$$0(2);
                }
                return sqlParametrizedType;
            }
            if (!(child instanceof SqlExpression)) continue;
            SqlParametrizedType sqlParametrizedType = CassSetOrMapLiteral.getSqlSetType((SqlExpression)child);
            if (sqlParametrizedType == null) {
                CassSetOrMapLiteral.$$$reportNull$$$0(3);
            }
            return sqlParametrizedType;
        }
        SqlTableTypeBase.Empty empty = new SqlTableTypeBase.Empty();
        if (empty == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(4);
        }
        return empty;
    }

    private static SqlParametrizedType getSqlMapType(@NotNull SqlElement lValue, @Nullable SqlElement rValue) {
        if (lValue == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(5);
        }
        SqlPrimitiveType keyType = SqlType.UNKNOWN;
        SqlPrimitiveType valueType = SqlType.UNKNOWN;
        if (lValue instanceof SqlExpression) {
            keyType = ((SqlExpression)lValue).getSqlType();
        }
        if (rValue instanceof SqlExpression) {
            valueType = ((SqlExpression)rValue).getSqlType();
        }
        String specification = String.format("map<%s, %s>", keyType.getDataType(), valueType.getDataType());
        return SqlTypeFactory.of(DataTypeFactory.of(specification), CassandraDialect.INSTANCE, ContainerUtil.list((Object[])new SqlType[]{keyType, valueType}));
    }

    @NotNull
    private static SqlParametrizedType getSqlSetType(SqlExpression expression) {
        SqlType itemType = expression.getSqlType();
        String specification = String.format("set<%s>", itemType.getDataType());
        SqlParametrizedType sqlParametrizedType = SqlTypeFactory.of(DataTypeFactory.of(specification), CassandraDialect.INSTANCE, ContainerUtil.list((Object[])new SqlType[]{itemType}));
        if (sqlParametrizedType == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(6);
        }
        return sqlParametrizedType;
    }

    @NotNull
    private SqlTableType getSqlTableType() {
        ArrayList columns = ContainerUtil.newArrayList();
        SqlSetAssignment[] mapElements = (SqlSetAssignment[])PsiTreeUtil.getChildrenOfType((PsiElement)this, SqlSetAssignment.class);
        if (mapElements == null) {
            SqlTableTypeBase.Empty empty = new SqlTableTypeBase.Empty();
            if (empty == null) {
                CassSetOrMapLiteral.$$$reportNull$$$0(7);
            }
            return empty;
        }
        for (SqlSetAssignment element2 : mapElements) {
            SqlElement rValue = element2.getRValue();
            if (rValue == null) {
                SqlTableTypeBase.Empty empty = new SqlTableTypeBase.Empty();
                if (empty == null) {
                    CassSetOrMapLiteral.$$$reportNull$$$0(8);
                }
                return empty;
            }
            SqlType type = rValue instanceof SqlExpression ? ((SqlExpression)rValue).getSqlType() : SqlTypeFactory.defaultType(SqlType.Category.UNKNOWN, SqlImplUtil.getSqlDialectSafe((PsiElement)this));
            columns.add(new SqlImplUtil.Column(element2.getLValue().getName(), type, (PsiElement)rValue, null));
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(null, columns, (PsiElement)this);
        if (sqlTableType == null) {
            CassSetOrMapLiteral.$$$reportNull$$$0(9);
        }
        return sqlTableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/psi/CassSetOrMapLiteral";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/psi/CassSetOrMapLiteral";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlSetType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTableType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSqlMapType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

