/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.sql.psi.stubs.SqlFileStub;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFileElementType
extends IStubFileElementType<SqlFileStub> {
    public static final Key<Language> HOST_LANGUAGE = Key.create((String)"FORCED_HOST_LANGUAGE");
    private static final Key<Boolean> PL_SUB_DIALECT = Key.create((String)"PL_SUB_DIALECT");
    public static final int VERSION = 16;

    public SqlFileElementType(@NonNls String debugName, Language language) {
        super(debugName, language);
    }

    public int getStubVersion() {
        return 16;
    }

    public void indexStub(@NotNull SqlFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            SqlFileElementType.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            SqlFileElementType.$$$reportNull$$$0(1);
        }
    }

    public boolean shouldBuildStubFor(VirtualFile file) {
        return DbSrcUtils.isDbSrcFile(file) || file.getUserData(SqlDialectMappings.SQL_DIALECT_KEY) != null;
    }

    public PsiBuilder parseLight(ASTNode chameleon) {
        PsiElement psi = chameleon.getPsi();
        Language language = this.getLanguageForParser(psi);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        PsiElement host = SqlFileElementType.getHostElement(psi);
        Lexer lexer = this.createLexer(parserDefinition, psi, host);
        boolean isPl = SqlFileElementType.isPlSubDialect(psi, host);
        SqlFileElementType.setPlSubDialect(psi, isPl);
        PsiParser parser = this.createParser(parserDefinition, psi, host, isPl);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(psi.getProject(), chameleon, lexer, language, chameleon.getChars());
        ((LightPsiParser)parser).parseLight((IElementType)this, builder);
        return builder;
    }

    public static void setPlSubDialect(PsiElement psi, boolean isPl) {
        PL_SUB_DIALECT.set((UserDataHolder)psi, (Object)(isPl ? Boolean.valueOf(true) : null));
    }

    public static boolean isInPl(PsiElement psi) {
        PsiElement root2 = PsiTreeUtil.getNonStrictParentOfType((PsiElement)psi, (Class[])new Class[]{LazyParseablePsiElement.class, SqlFile.class});
        return Boolean.TRUE.equals(PL_SUB_DIALECT.get((UserDataHolder)root2));
    }

    private static boolean isPlSubDialect(PsiElement psi, PsiElement host) {
        return Boolean.TRUE.equals(PL_SUB_DIALECT.get((UserDataHolder)(psi instanceof LazyParseablePsiElement || host == null ? psi : host)));
    }

    protected PsiParser createParser(@NotNull ParserDefinition parserDefinition, @NotNull PsiElement psi, @Nullable PsiElement host, boolean isPl) {
        if (parserDefinition == null) {
            SqlFileElementType.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            SqlFileElementType.$$$reportNull$$$0(3);
        }
        return parserDefinition.createParser(psi.getProject());
    }

    @NotNull
    protected Lexer createLexer(@NotNull ParserDefinition parserDefinition, @NotNull PsiElement psi, @Nullable PsiElement host) {
        if (parserDefinition == null) {
            SqlFileElementType.$$$reportNull$$$0(4);
        }
        if (psi == null) {
            SqlFileElementType.$$$reportNull$$$0(5);
        }
        Project project = psi.getProject();
        Language hostLanguage = host != null ? SqlPreprocessingLexer.getHostLanguage(host) : (Language)psi.getUserData(HOST_LANGUAGE);
        Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(project, parserDefinition, hostLanguage);
        if (lexer == null) {
            SqlFileElementType.$$$reportNull$$$0(6);
        }
        return lexer;
    }

    @Nullable
    private static PsiElement getHostElement(PsiElement psi) {
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)psi);
        if (host == null && !(psi instanceof PsiFile)) {
            host = psi.getParent();
        }
        return host;
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            SqlFileElementType.$$$reportNull$$$0(7);
        }
        if (psi == null) {
            SqlFileElementType.$$$reportNull$$$0(8);
        }
        return this.parseLight(chameleon).getTreeBuilt().getFirstChildNode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlFileElementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlFileElementType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createParser";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doParseContents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

