/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.IndexId;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V>
extends IndexId<K, V> {
    private static final IntObjectMap<ID> ourRegistry = ContainerUtil.createConcurrentIntObjectMap();
    private static final TObjectIntHashMap<String> ourNameToIdRegistry = new TObjectIntHashMap();
    static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    private final short myUniqueId;

    @NotNull
    private static File getEnumFile() {
        File indexFolder = PathManager.getIndexRoot();
        File file = new File(indexFolder, "indices.enum");
        if (file == null) {
            ID.$$$reportNull$$$0(0);
        }
        return file;
    }

    protected ID(@NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(1);
        }
        super(name);
        this.myUniqueId = ID.stringToId(name);
        ID old = (ID)((Object)ourRegistry.put((int)this.myUniqueId, (Object)this));
        assert (old == null) : "ID with name '" + name + "' is already registered";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short stringToId(@NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(2);
        }
        TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
        synchronized (tObjectIntHashMap) {
            if (ourNameToIdRegistry.containsKey((Object)name)) {
                return (short)ourNameToIdRegistry.get((Object)name);
            }
            int n = ourNameToIdRegistry.size() + 1;
            assert (n <= Short.MAX_VALUE) : "Number of indices exceeded: " + n;
            ourNameToIdRegistry.put((Object)name, n);
            ID.writeEnumFile();
            return (short)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reinitializeDiskStorage() {
        TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
        synchronized (tObjectIntHashMap) {
            ID.writeEnumFile();
        }
    }

    private static void writeEnumFile() {
        try {
            File f = ID.getEnumFile();
            try (BufferedWriter w = new BufferedWriter(new FileWriter(f));){
                String[] names = new String[ourNameToIdRegistry.size()];
                ourNameToIdRegistry.forEachEntry((key, value) -> {
                    names[value - 1] = key;
                    return true;
                });
                for (String name : names) {
                    w.write(name);
                    w.newLine();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <K, V> ID<K, V> create(@NonNls @NotNull String name) {
        ID<K, V> found;
        if (name == null) {
            ID.$$$reportNull$$$0(3);
        }
        ID<K, V> iD = (found = ID.findByName(name)) == null ? new ID<K, V>(name) : found;
        if (iD == null) {
            ID.$$$reportNull$$$0(4);
        }
        return iD;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(5);
        }
        return ID.findById(ID.stringToId(name));
    }

    public int hashCode() {
        return this.myUniqueId;
    }

    public String toString() {
        return this.getName();
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    public static ID<?, ?> findById(int id) {
        return (ID)((Object)ourRegistry.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File indices = ID.getEnumFile();
        try {
            TObjectIntHashMap nameToIdRegistry = new TObjectIntHashMap();
            try (BufferedReader reader = new BufferedReader(new FileReader(indices));){
                String name2;
                int cnt = 1;
                while ((name2 = reader.readLine()) != null) {
                    nameToIdRegistry.put((Object)name2, cnt);
                    ++cnt;
                }
            }
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.ensureCapacity(nameToIdRegistry.size());
                nameToIdRegistry.forEachEntry((name, index2) -> {
                    ourNameToIdRegistry.put(name, index2);
                    return true;
                });
            }
        }
        catch (IOException e) {
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.clear();
                ID.writeEnumFile();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/ID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/ID";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stringToId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

