/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.lang.javascript.hierarchy.call.JSCallHierarchyNodeDescriptor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSCallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)JSCallerMethodsTreeStructure.class.getName());
    private final String myScopeType;

    public JSCallerMethodsTreeStructure(Project project, JSFunction method, String scopeType) {
        super(project, (HierarchyNodeDescriptor)new JSCallHierarchyNodeDescriptor(project, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        PsiElement enclosingElement;
        if (descriptor2 == null) {
            JSCallerMethodsTreeStructure.$$$reportNull$$$0(0);
        }
        if (!((enclosingElement = ((JSCallHierarchyNodeDescriptor)descriptor2).getEnclosingElement()) instanceof JSFunction)) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                JSCallerMethodsTreeStructure.$$$reportNull$$$0(1);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        JSFunction method = (JSFunction)enclosingElement;
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.myProject);
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(this.myScopeType)) {
            JSFunction baseMethod = (JSFunction)((JSCallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
            JSClass containingClass = JSResolveUtil.getClassOfContext((PsiElement)baseMethod);
            searchScope = containingClass == null ? GlobalSearchScope.EMPTY_SCOPE : new LocalSearchScope((PsiElement)containingClass);
        } else if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(this.myScopeType)) {
            searchScope = GlobalSearchScopesCore.projectProductionScope((Project)this.myProject);
        } else if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(this.myScopeType)) {
            searchScope = GlobalSearchScopesCore.projectTestScope((Project)this.myProject);
        } else {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)this.myScopeType);
            if (namedScope != null) {
                searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)namedScope);
            }
        }
        Collection<JSFunction> methodsToFind = JSInheritanceUtil.findTopMethods(method);
        HashMap methodToDescriptorMap = new HashMap();
        for (JSFunction methodToFind : methodsToFind) {
            ReferencesSearch.search((PsiElement)methodToFind, (SearchScope)searchScope, (boolean)true).forEach(reference -> {
                PsiElement key;
                if (descriptor2 == null) {
                    JSCallerMethodsTreeStructure.$$$reportNull$$$0(3);
                }
                if (!(reference instanceof JSReferenceExpression)) {
                    return true;
                }
                PsiElement element = reference.getElement();
                if (!(element.getParent() instanceof JSCallExpression)) {
                    return true;
                }
                JSExpression qualifier = ((JSReferenceExpression)reference).getQualifier();
                if (qualifier instanceof JSSuperExpression) {
                    PsiElement psiElement;
                    PsiReference psiReference = qualifier.getReference();
                    PsiElement psiElement2 = psiElement = psiReference == null ? null : psiReference.resolve();
                    if (psiElement instanceof JSClass) {
                        JSClass superClass = (JSClass)psiElement;
                        JSClass methodClass = JSResolveUtil.getClassOfContext((PsiElement)method);
                        if (methodClass != null && JSInheritanceUtil.isParentClass(methodClass, superClass)) {
                            return true;
                        }
                    }
                }
                if ((key = JSCallHierarchyNodeDescriptor.getEnclosingElement(element)) == null) {
                    LOG.debug("Enclosing element for element " + element.getText() + " in file " + element.getContainingFile() + " is null");
                    return true;
                }
                Map map = methodToDescriptorMap;
                synchronized (map) {
                    JSCallHierarchyNodeDescriptor d = (JSCallHierarchyNodeDescriptor)((Object)((Object)methodToDescriptorMap.get(key)));
                    if (d == null) {
                        d = new JSCallHierarchyNodeDescriptor(this.myProject, descriptor2, element, false, true);
                        methodToDescriptorMap.put(key, d);
                    } else {
                        d.incrementUsageCount();
                    }
                    d.addReference((PsiReference)reference);
                }
                return true;
            });
        }
        Object[] objectArray = ArrayUtil.toObjectArray(methodToDescriptorMap.values());
        if (objectArray == null) {
            JSCallerMethodsTreeStructure.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/hierarchy/call/JSCallerMethodsTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/hierarchy/call/JSCallerMethodsTreeStructure";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildChildren$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

