/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import java.util.ArrayList;

class TemplateSegments {
    private final ArrayList<RangeMarker> mySegments = new ArrayList();
    private final Editor myEditor;

    TemplateSegments(Editor editor) {
        this.myEditor = editor;
    }

    int getSegmentStart(int i) {
        RangeMarker rangeMarker = this.mySegments.get(i);
        return rangeMarker.getStartOffset();
    }

    int getSegmentEnd(int i) {
        RangeMarker rangeMarker = this.mySegments.get(i);
        return rangeMarker.getEndOffset();
    }

    boolean isValid(int i) {
        return this.mySegments.get(i).isValid();
    }

    void removeAll() {
        for (RangeMarker segment : this.mySegments) {
            segment.dispose();
        }
        this.mySegments.clear();
    }

    void addSegment(int start2, int end) {
        RangeMarker rangeMarker = this.myEditor.getDocument().createRangeMarker(start2, end);
        this.mySegments.add(rangeMarker);
    }

    void setSegmentsGreedy(boolean greedy) {
        for (RangeMarker segment : this.mySegments) {
            segment.setGreedyToRight(greedy);
            segment.setGreedyToLeft(greedy);
        }
    }

    boolean isInvalid() {
        for (RangeMarker marker : this.mySegments) {
            if (marker.isValid()) continue;
            return true;
        }
        return false;
    }

    void replaceSegmentAt(int index, int start2, int end) {
        this.replaceSegmentAt(index, start2, end, false);
    }

    void replaceSegmentAt(int index, int start2, int end, boolean preserveGreediness) {
        RangeMarker rangeMarker = this.mySegments.get(index);
        boolean greedyToLeft = rangeMarker.isGreedyToLeft();
        boolean greedyToRight = rangeMarker.isGreedyToRight();
        rangeMarker.dispose();
        Document doc = this.myEditor.getDocument();
        rangeMarker = doc.createRangeMarker(start2, end);
        rangeMarker.setGreedyToLeft(greedyToLeft || !preserveGreediness);
        rangeMarker.setGreedyToRight(greedyToRight || !preserveGreediness);
        this.mySegments.set(index, rangeMarker);
    }

    void setNeighboursGreedy(int segmentNumber, boolean greedy) {
        if (segmentNumber > 0) {
            RangeMarker left = this.mySegments.get(segmentNumber - 1);
            left.setGreedyToLeft(greedy);
            left.setGreedyToRight(greedy);
        }
        if (segmentNumber + 1 < this.mySegments.size()) {
            RangeMarker right = this.mySegments.get(segmentNumber + 1);
            right.setGreedyToLeft(greedy);
            right.setGreedyToRight(greedy);
        }
    }

    void lockSegmentAtTheSameOffsetIfAny(int number) {
        if (number == -1) {
            return;
        }
        RangeMarker current = this.mySegments.get(number);
        int offset = current.getStartOffset();
        for (int i = 0; i < this.mySegments.size(); ++i) {
            RangeMarker segment;
            int startOffset2;
            if (i == number || offset != (startOffset2 = (segment = this.mySegments.get(i)).getStartOffset())) continue;
            segment.setGreedyToLeft(false);
        }
    }

    int getSegmentsCount() {
        return this.mySegments.size();
    }
}

