/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.testDiscovery.instrumentation.TestDiscoveryInstrumentationUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.util.Printer;
import org.jetbrains.coverage.org.objectweb.asm.util.Textifier;
import org.jetbrains.coverage.org.objectweb.asm.util.TraceClassVisitor;

public class CheckSumCalculator
extends ClassVisitor {
    private final Map<String, byte[]> checksums = new HashMap<String, byte[]>();
    private final MessageDigest messageDigest;
    private final String className;

    public CheckSumCalculator(int api, String className) {
        super(api, new TraceClassVisitor(null, new ChecksumPrinter(api), null));
        this.className = className;
        try {
            this.messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, byte[]> getChecksums() {
        return this.checksums;
    }

    private Printer getPrinter() {
        return ((TraceClassVisitor)this.cv).p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveChecksum(String name) {
        PrintWriter pw = null;
        try {
            StringWriter sw = new StringWriter();
            pw = new PrintWriter(sw);
            this.getPrinter().print(pw);
            this.checksums.put(name, this.messageDigest.digest(sw.toString().getBytes()));
        }
        finally {
            this.getPrinter().getText().clear();
            if (pw != null) {
                pw.close();
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        if (!this.checksums.containsKey(this.className)) {
            this.saveChecksum(this.className);
        }
        return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

            @Override
            public void visitEnd() {
                super.visitEnd();
                CheckSumCalculator.this.saveChecksum(TestDiscoveryInstrumentationUtils.getMethodId(name, desc));
            }
        };
    }

    private static class ChecksumPrinter
    extends Textifier {
        ChecksumPrinter(int api) {
            super(api);
        }

        @Override
        public void visitLineNumber(int line, Label start) {
        }

        @Override
        protected Textifier createTextifier() {
            return new ChecksumPrinter(this.api);
        }
    }
}

