/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import com.intellij.rt.coverage.testDiscovery.instrumentation.CheckSumCalculator;
import com.intellij.rt.coverage.testDiscovery.instrumentation.InstrumentedMethodsCollector;
import com.intellij.rt.coverage.testDiscovery.instrumentation.InstrumentedMethodsFilter;
import com.intellij.rt.coverage.testDiscovery.instrumentation.SourceFilesCollector;
import java.util.Collections;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class TestDiscoveryInstrumenter
extends ClassVisitor {
    static final int ADDED_CODE_STACK_SIZE = 6;
    private final String myClassName;
    final String myInternalClassName;
    int myClassVersion;
    private final InstrumentedMethodsFilter myMethodFilter;
    volatile boolean myInstrumentConstructors;
    private int myCurrentMethodCount;
    static final String METHODS_VISITED = "__$methodsVisited$__";
    static final String METHODS_VISITED_CLASS = "[Z";
    private static final String METHODS_VISITED_INIT = "__$initMethodsVisited$__";
    private final boolean myInterface;
    private boolean myCreatedMethod = false;
    private final String[] myMethodNames;

    public TestDiscoveryInstrumenter(ClassWriter classWriter, ClassReader cr, String className) {
        super(458752, classWriter);
        this.myMethodFilter = new InstrumentedMethodsFilter(className);
        this.myClassName = className;
        this.myInternalClassName = className.replace('.', '/');
        this.myInterface = (cr.getAccess() & 0x200) != 0;
        this.myMethodNames = this.inspectClass(cr);
    }

    private String[] inspectClass(ClassReader cr) {
        CheckSumCalculator checksumCalculator = new CheckSumCalculator(this.api, this.myClassName);
        SourceFilesCollector sourceFilesCollector = new SourceFilesCollector(this.api, checksumCalculator, this.myClassName);
        InstrumentedMethodsCollector methodCollector = new InstrumentedMethodsCollector(this.api, sourceFilesCollector, this, this.myClassName);
        cr.accept(methodCollector, 0);
        TestDiscoveryProjectData.getProjectData().addClassMetadata(Collections.singletonList(new ClassMetadata(this.myClassName, sourceFilesCollector.getSources(), checksumCalculator.getChecksums())));
        return methodCollector.instrumentedMethods();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myMethodFilter.visit(version, access, name, signature, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        if ("<clinit>".equals(name) || METHODS_VISITED_INIT.equals(name)) {
            return mv;
        }
        InstrumentedMethodsFilter.Decision decision = this.myMethodFilter.shouldVisitMethod(access, name, desc, signature, exceptions, this.myInstrumentConstructors);
        if (decision != InstrumentedMethodsFilter.Decision.YES) {
            return mv;
        }
        return new MethodVisitor(458752, mv){
            final int myMethodId;
            {
                this.myMethodId = TestDiscoveryInstrumenter.this.myCurrentMethodCount++;
            }

            @Override
            public void visitCode() {
                TestDiscoveryInstrumenter.this.ensureArrayInitialized(this.mv);
                this.mv.visitFieldInsn(178, TestDiscoveryInstrumenter.this.getFieldClassName(), TestDiscoveryInstrumenter.METHODS_VISITED, TestDiscoveryInstrumenter.METHODS_VISITED_CLASS);
                TestDiscoveryInstrumenter.pushInstruction(this, this.myMethodId);
                this.visitInsn(4);
                this.visitInsn(84);
                super.visitCode();
            }
        };
    }

    protected void ensureArrayInitialized(MethodVisitor mv) {
        if (this.myInterface && !this.myCreatedMethod) {
            this.myCreatedMethod = true;
            this.createInitFieldMethod(4105);
        }
        mv.visitMethodInsn(184, this.myInternalClassName, METHODS_VISITED_INIT, "()V", false);
    }

    protected String getFieldClassName() {
        return this.myInternalClassName;
    }

    @Override
    public void visitEnd() {
        if (this.myMethodNames.length > 0) {
            this.generateMembers();
        }
        super.visitEnd();
    }

    protected void generateMembers() {
        int access = this.myInterface ? 4121 : 4234;
        this.visitField(access, METHODS_VISITED, METHODS_VISITED_CLASS, null, null);
        if (!this.myInterface) {
            this.createInitFieldMethod(4106);
        }
    }

    private void createInitFieldMethod(int access) {
        MethodVisitor mv = this.visitMethod(access, METHODS_VISITED_INIT, "()V", null, null);
        mv.visitFieldInsn(178, this.getFieldClassName(), METHODS_VISITED, METHODS_VISITED_CLASS);
        Label alreadyInitialized = new Label();
        mv.visitJumpInsn(199, alreadyInitialized);
        this.initArray(mv);
        mv.visitLabel(alreadyInitialized);
        mv.visitInsn(177);
        mv.visitMaxs(6, 0);
        mv.visitEnd();
    }

    void initArray(MethodVisitor mv) {
        mv.visitLdcInsn(this.myClassName);
        TestDiscoveryInstrumenter.pushInstruction(mv, this.myMethodNames.length);
        mv.visitIntInsn(188, 4);
        TestDiscoveryInstrumenter.pushInstruction(mv, this.myMethodNames.length);
        mv.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < this.myMethodNames.length; ++i) {
            mv.visitInsn(89);
            TestDiscoveryInstrumenter.pushInstruction(mv, i);
            mv.visitLdcInsn(this.myMethodNames[i]);
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/TestDiscoveryProjectData", "trace", "(Ljava/lang/String;[Z[Ljava/lang/String;)[Z", false);
        mv.visitFieldInsn(179, this.getFieldClassName(), METHODS_VISITED, METHODS_VISITED_CLASS);
    }

    private static void pushInstruction(MethodVisitor mv, int operand) {
        if (operand < 127) {
            mv.visitIntInsn(16, operand);
        } else {
            mv.visitIntInsn(17, operand);
        }
    }
}

