/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.client.DatabaseScriptingSessionClient;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.AbstractMessageBusSession;
import com.intellij.database.console.session.DatabaseSessionView;
import com.intellij.database.console.session.MessageBusSession;
import com.intellij.database.console.session.VisibleDatabaseSession;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.run.session.SessionStateWatcher;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001+B'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB/\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB'\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010!H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u000bH\u0016J\b\u0010&\u001a\u00020\u000bH\u0016J\b\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lcom/intellij/database/console/session/VisibleMessageBusSession;", "Lcom/intellij/database/console/session/MessageBusSession;", "Lcom/intellij/database/console/session/VisibleDatabaseSession;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "kernel", "Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;", "title", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;Ljava/lang/String;)V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/console/session/AbstractMessageBusSession$SessionKernel;Lcom/intellij/execution/console/LanguageConsoleView;)V", "stateWatcher", "Lcom/intellij/database/run/session/SessionStateWatcher;", "view", "Lcom/intellij/database/console/session/DatabaseSessionView;", "getView", "()Lcom/intellij/database/console/session/DatabaseSessionView;", "virtualFile", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "attach", "", "client", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "clientByFile", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "currentClient", "getData", "", "dataId", "getDisplayName", "getErrorsLogger", "Lcom/intellij/database/datagrid/DataAuditor;", "isValid", "", "MyConsoleHistoryController", "intellij.database.impl"})
public final class VisibleMessageBusSession
extends MessageBusSession
implements VisibleDatabaseSession,
DataProvider {
    private final LanguageConsoleView consoleView;
    @NotNull
    private final DatabaseSessionView view;
    private final SessionStateWatcher stateWatcher;

    @Override
    @NotNull
    public DatabaseSessionView getView() {
        return this.view;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.consoleView.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"consoleView.virtualFile");
        return virtualFile;
    }

    @Override
    public boolean isValid() {
        return this.getView().isValid() && super.isValid();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "session: " + super.getDisplayName();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        return PlatformDataKeys.HELP_ID.is(dataId) ? "reference.runToolWindow.jdbcTab" : (SessionClientHolder.CLIENT_KEY.is(dataId) ? this.currentClient() : (CommonDataKeys.VIRTUAL_FILE.is(dataId) ? this.getVirtualFile() : null));
    }

    @Override
    public void attach(@NotNull DatabaseSessionClient<?> client) {
        Intrinsics.checkParameterIsNotNull(client, (String)"client");
        super.attach(client);
        this.getView().setupActions();
    }

    @Override
    @NotNull
    protected DataAuditor getErrorsLogger() {
        DataAuditor.ConsoleLogger consoleLogger = this.getView().getHistoryLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleLogger, (String)"view.historyLogger");
        return consoleLogger;
    }

    private final VisibleDatabaseSessionClient currentClient() {
        VisibleDatabaseSessionClient visibleDatabaseSessionClient;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        FileEditor selected = fileEditorManager.getSelectedEditor();
        FileEditor fileEditor = selected;
        if (fileEditor != null && (fileEditor = fileEditor.getFile()) != null) {
            FileEditor fileEditor2;
            FileEditor it;
            FileEditor fileEditor3 = it = (fileEditor2 = fileEditor);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor3, (String)"it");
            visibleDatabaseSessionClient = this.clientByFile((VirtualFile)fileEditor3);
        } else {
            visibleDatabaseSessionClient = null;
        }
        return visibleDatabaseSessionClient;
    }

    private final VisibleDatabaseSessionClient clientByFile(VirtualFile file) {
        Object v0;
        block1: {
            Sequence $receiver$iv = SequencesKt.filterIsInstance((Sequence)ArraysKt.asSequence((Object[])this.getVisibleClients()), VisibleDatabaseSessionClient.class);
            for (Object element$iv : $receiver$iv) {
                VisibleDatabaseSessionClient it = (VisibleDatabaseSessionClient)element$iv;
                if (!Intrinsics.areEqual((Object)it.getVirtualFile(), (Object)file)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public VisibleMessageBusSession(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull AbstractMessageBusSession.SessionKernel kernel, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)kernel, (String)"kernel");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        this(project, dataSource, kernel, (LanguageConsoleView)new LanguageConsoleImpl(project, title, (Language)DbSqlUtil.getSqlDialect(dataSource)));
    }

    public VisibleMessageBusSession(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull AbstractMessageBusSession.SessionKernel kernel, @NotNull String title, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)kernel, (String)"kernel");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this(project, dataSource, kernel, (LanguageConsoleView)new LanguageConsoleImpl(project, title, file));
    }

    private VisibleMessageBusSession(Project project, LocalDataSource dataSource, AbstractMessageBusSession.SessionKernel kernel, LanguageConsoleView consoleView) {
        String string = consoleView.getTitle();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"consoleView.title");
        super(project, dataSource, kernel, string);
        this.consoleView = consoleView;
        this.view = new DatabaseSessionView(consoleView, this, this.getMessageBus());
        RunnerLayoutUi runnerLayoutUi = this.getView().getUi();
        Intrinsics.checkExpressionValueIsNotNull((Object)runnerLayoutUi, (String)"view.ui");
        runnerLayoutUi.getContentManager().addDataProvider((DataProvider)this);
        RunnerLayoutUi runnerLayoutUi2 = this.getView().getUi();
        Intrinsics.checkExpressionValueIsNotNull((Object)runnerLayoutUi2, (String)"view.ui");
        AnAction anAction = ActionManager.getInstance().getAction("Console.TabPopupGroup");
        if (anAction == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        runnerLayoutUi2.getOptions().setTabPopupActions((ActionGroup)anAction);
        new MyConsoleHistoryController(dataSource).setMultiline(true).install();
        this.stateWatcher = new SessionStateWatcher(this);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/VisibleMessageBusSession$MyConsoleHistoryController;", "Lcom/intellij/execution/console/ConsoleHistoryController;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/database/console/session/VisibleMessageBusSession;Lcom/intellij/database/dataSource/LocalDataSource;)V", "insertTextMultiline", "", "text", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.database.impl"})
    private final class MyConsoleHistoryController
    extends ConsoleHistoryController {
        protected int insertTextMultiline(@NotNull String text2, @NotNull Editor editor, @NotNull Document document) {
            VisibleDatabaseSessionClient visibleDatabaseSessionClient;
            VisibleDatabaseSessionClient visibleDatabaseSessionClient2;
            VirtualFile file;
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            VirtualFile virtualFile = file = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile it = virtualFile2 = virtualFile;
                visibleDatabaseSessionClient2 = VisibleMessageBusSession.this.clientByFile(it);
            } else {
                visibleDatabaseSessionClient2 = visibleDatabaseSessionClient = null;
            }
            if (!(visibleDatabaseSessionClient2 instanceof DatabaseScriptingSessionClient)) {
                visibleDatabaseSessionClient = null;
            }
            DatabaseScriptingSessionClient databaseScriptingSessionClient = (DatabaseScriptingSessionClient)visibleDatabaseSessionClient;
            if (databaseScriptingSessionClient == null) {
                TextRange textRange = TextRange.EMPTY_RANGE;
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"TextRange.EMPTY_RANGE");
                return textRange.getStartOffset();
            }
            DatabaseScriptingSessionClient client = databaseScriptingSessionClient;
            TextRange textRange = ScriptModelUtil.getSelectedStatementsRange(client, DatabaseSettings.getDefaultExecOption());
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"ScriptModelUtil.getSelec\u2026s.getDefaultExecOption())");
            TextRange range = textRange;
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text2);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getStartOffset() + text2.length());
            return range.getStartOffset();
        }

        public MyConsoleHistoryController(LocalDataSource dataSource) {
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            super((ConsoleRootType)DbConsoleRootType.getInstance(), dataSource.getUniqueId(), VisibleMessageBusSession.this.consoleView);
        }
    }
}

