/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.inspections;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.UrlEditorInspector;
import com.intellij.database.dialects.mssql.ssrp.SsrpInfo;
import com.intellij.database.dialects.mssql.ssrp.SsrpInfoCache;
import com.intellij.database.dialects.mssql.ssrp.ui.SsrpPortParamEditor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class DriverPortInstanceInspector
extends UrlEditorInspector {
    protected static final Pair<String, Consumer<DataInterchange>> DETECT_PORT_FIX = Pair.create((Object)"Detect Port", interchange -> {
        String port = SsrpPortParamEditor.getSsrpPort(interchange);
        if (port != null) {
            interchange.putProperty("port", port);
        }
    });

    @Override
    protected void runInspection(@NotNull DatabaseDriver driver, @NotNull UrlEditorModel model, @NotNull UrlEditorInspector.InspectionConsumer consumer2) {
        if (driver == null) {
            DriverPortInstanceInspector.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DriverPortInstanceInspector.$$$reportNull$$$0(1);
        }
        if (consumer2 == null) {
            DriverPortInstanceInspector.$$$reportNull$$$0(2);
        }
        String port = model.getParameter("port");
        String instance = model.getParameter("instance");
        String host = model.getParameter("host");
        if (StringUtil.isNotEmpty((String)port) && StringUtil.isNotEmpty((String)instance) && StringUtil.isNotEmpty((String)host)) {
            String ssrpPort;
            SsrpInfo info = SsrpInfoCache.get();
            if (info == null) {
                return;
            }
            SsrpInfo.SsrpServer ssrpServer = info.getServer(host);
            SsrpInfo.SsrpInstance ssrpInstance = ssrpServer == null ? null : ssrpServer.getInstance(instance);
            String string = ssrpPort = ssrpInstance == null ? null : ssrpInstance.getAttribute("tcp");
            if (ssrpPort != null && !port.equals(ssrpPort)) {
                this.addWarning(consumer2);
            }
        }
    }

    protected abstract void addWarning(@NotNull UrlEditorInspector.InspectionConsumer var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "driver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/mssql/inspections/DriverPortInstanceInspector";
        objectArray[2] = "runInspection";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

