/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingModelDumper;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock$WhenMappings;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010=\u001a\u00020>H&J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020AH&J\u0010\u0010B\u001a\u00020 2\u0006\u0010C\u001a\u00020\u0000H\u0016J\u0006\u0010D\u001a\u00020EJ\b\u0010F\u001a\u00020>H\u0002J\b\u0010G\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0016H\u0016J\b\u0010K\u001a\u00020EH\u0016J\n\u0010L\u001a\u0004\u0018\u00010EH\u0014J\u0006\u0010M\u001a\u00020 J\u0012\u0010N\u001a\u0004\u0018\u00010E2\u0006\u0010O\u001a\u00020PH\u0016J\u001c\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010S\u001a\u0004\u0018\u00010\u00012\u0006\u0010T\u001a\u00020\u0001H\u0016J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00000VH&J\b\u0010W\u001a\u00020.H\u0016J\n\u0010X\u001a\u0004\u0018\u00010&H\u0016J\b\u0010Y\u001a\u0004\u0018\u00010&J\b\u0010Z\u001a\u00020\u000fH\u0016J\b\u0010[\u001a\u00020\u000fH\u0016J\b\u0010\\\u001a\u00020>H&J\b\u0010]\u001a\u00020\u000fH\u0016J\b\u0010^\u001a\u00020\u000fH\u0016J\b\u0010_\u001a\u00020EH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0014\u0010+\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\rR\u0012\u0010-\u001a\u00020.X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u0082\u0001\u0003`a\b\u00a8\u0006b"}, d2={"Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/formatting/Block;", "()V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "firstLeafBlock", "Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "getFirstLeafBlock", "()Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "firstNestedBlock", "getFirstNestedBlock", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "isFirst", "", "()Z", "lastLeafBlock", "getLastLeafBlock", "lastNestedBlock", "getLastNestedBlock", "minLength", "", "getMinLength", "()I", "myAlign", "Lcom/intellij/formatting/Alignment;", "getMyAlign", "()Lcom/intellij/formatting/Alignment;", "setMyAlign", "(Lcom/intellij/formatting/Alignment;)V", "myIndent", "Lcom/intellij/formatting/Indent;", "getMyIndent", "()Lcom/intellij/formatting/Indent;", "setMyIndent", "(Lcom/intellij/formatting/Indent;)V", "myWrap", "Lcom/intellij/formatting/Wrap;", "getMyWrap", "()Lcom/intellij/formatting/Wrap;", "setMyWrap", "(Lcom/intellij/formatting/Wrap;)V", "parent", "getParent", "range", "Lcom/intellij/openapi/util/TextRange;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "setRole", "(Lcom/intellij/sql/formatter/model/BlockRole;)V", "shape", "Lcom/intellij/sql/formatter/model/BlockShape;", "getShape", "()Lcom/intellij/sql/formatter/model/BlockShape;", "setShape", "(Lcom/intellij/sql/formatter/model/BlockShape;)V", "analyze", "", "contains", "char", "", "defaultChildIndent", "block", "dump", "", "ensureModelProcessed", "getAlignment", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "getDebugName", "getDebugNameSuffix", "getIndent", "getNewLineIdent", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "getSubBlocks", "", "getTextRange", "getTransitiveWrap", "getWrap", "incomplete", "isIncomplete", "refine", "requiresFollowingBreak", "requiresPrecedingBreak", "toString", "Lcom/intellij/sql/formatter/model/SqlRootBlock;", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "intellij.database.sql.impl"})
public abstract class SqlBlock
implements Block {
    @NotNull
    private BlockRole role = BlockRole.NOTHING;
    @NotNull
    private BlockShape shape = BlockShape.NOT_DECIDED;
    @Nullable
    private Wrap myWrap;
    @Nullable
    private Indent myIndent;
    @Nullable
    private Alignment myAlign;

    @Nullable
    public abstract SqlBlock getParent();

    @NotNull
    public abstract SqlFormattingContext getContext();

    @NotNull
    public abstract TextRange getRange();

    public abstract int getMinLength();

    @NotNull
    public final BlockRole getRole() {
        return this.role;
    }

    public final void setRole(@NotNull BlockRole blockRole) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blockRole), (String)"<set-?>");
        this.role = blockRole;
    }

    @NotNull
    public final BlockShape getShape() {
        return this.shape;
    }

    public final void setShape(@NotNull BlockShape blockShape) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)blockShape), (String)"<set-?>");
        this.shape = blockShape;
    }

    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @NotNull
    public abstract List<SqlBlock> getSubBlocks();

    @Nullable
    public final Wrap getMyWrap() {
        return this.myWrap;
    }

    public final void setMyWrap(@Nullable Wrap wrap) {
        this.myWrap = wrap;
    }

    @Nullable
    public final Indent getMyIndent() {
        return this.myIndent;
    }

    public final void setMyIndent(@Nullable Indent indent) {
        this.myIndent = indent;
    }

    @Nullable
    public final Alignment getMyAlign() {
        return this.myAlign;
    }

    public final void setMyAlign(@Nullable Alignment alignment) {
        this.myAlign = alignment;
    }

    @Nullable
    public final Wrap getWrap() {
        if (this.myWrap == null) {
            this.ensureModelProcessed();
        }
        return this.myWrap;
    }

    @NotNull
    public final Indent getIndent() {
        Indent indent;
        Object object;
        if (this.myIndent == null) {
            this.ensureModelProcessed();
        }
        if ((object = this.myIndent) == null) {
            SqlBlock sqlBlock = this.getParent();
            object = indent = sqlBlock != null ? sqlBlock.defaultChildIndent(this) : null;
        }
        if (object == null) {
            indent = SqlFormattingFunKt.getNONE_INDENT();
        }
        return indent;
    }

    @Nullable
    public final Alignment getAlignment() {
        if (this.myAlign == null) {
            this.ensureModelProcessed();
        }
        return this.myAlign;
    }

    private final void ensureModelProcessed() {
        block2: {
            if (!this.getContext().getJustAdjust()) break block2;
            SqlBlock sqlBlock = this.getParent();
            if (sqlBlock != null) {
                sqlBlock.analyze();
            }
            SqlBlock sqlBlock2 = this.getParent();
            if (sqlBlock2 != null) {
                sqlBlock2.refine();
            }
        }
    }

    public boolean requiresPrecedingBreak() {
        return SqlFormattingModelFunKt.isAlways(this.myWrap);
    }

    public boolean requiresFollowingBreak() {
        return false;
    }

    public boolean incomplete() {
        return false;
    }

    @Nullable
    public String getNewLineIdent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkParameterIsNotNull((Object)blocks, (String)"blocks");
        return null;
    }

    public abstract void analyze();

    public abstract void refine();

    @Nullable
    public Wrap getTransitiveWrap() {
        SqlBlock sqlBlock = this.getParent();
        return sqlBlock != null ? sqlBlock.getTransitiveWrap() : null;
    }

    public final boolean isFirst() {
        boolean bl;
        if (this.getParent() != null) {
            SqlBlock sqlBlock = this.getParent();
            if (sqlBlock == null) {
                Intrinsics.throwNpe();
            }
            bl = sqlBlock.getFirstNestedBlock() == this;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public abstract SqlBlock getFirstNestedBlock();

    @Nullable
    public abstract SqlBlock getLastNestedBlock();

    @Nullable
    public SqlLeafBlock getFirstLeafBlock() {
        SqlBlock sqlBlock = this.getFirstNestedBlock();
        return sqlBlock != null ? sqlBlock.getFirstLeafBlock() : null;
    }

    @Nullable
    public SqlLeafBlock getLastLeafBlock() {
        SqlBlock sqlBlock = this.getLastNestedBlock();
        return sqlBlock != null ? sqlBlock.getLastLeafBlock() : null;
    }

    public abstract boolean contains(char var1);

    @NotNull
    public final String dump() {
        String string = FormattingModelDumper.dumpFormattingModelToString((Block)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FormattingModelDumper.du\u2026attingModelToString(this)");
        return string;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.getRange();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkParameterIsNotNull((Object)child2, (String)"child2");
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(SqlFormattingFunKt.getNONE_INDENT(), null);
    }

    public boolean isIncomplete() {
        return false;
    }

    @NotNull
    public String getDebugName() {
        char c2;
        StringBuilder b2 = new StringBuilder();
        if (this.role.getExists()) {
            b2.append(this.role.getCode()).append(':').append(' ');
        }
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.javaClass.simpleName");
        String simpleName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"Sql"), (CharSequence)"Block");
        b2.append(simpleName);
        String suffix = this.getDebugNameSuffix();
        if (suffix != null) {
            b2.append('(').append(suffix).append(')');
        }
        if (this.getMinLength() > 0 && this.getMinLength() < Integer.MAX_VALUE) {
            b2.append(' ').append('[').append(this.getMinLength()).append(']');
        }
        switch (SqlBlock$WhenMappings.$EnumSwitchMapping$0[this.shape.ordinal()]) {
            case 1: {
                c2 = '\u0000';
                break;
            }
            case 2: {
                c2 = '\u25b1';
                break;
            }
            case 3: {
                c2 = '\u25d2';
                break;
            }
            case 4: {
                c2 = '\u25a3';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        char shapeChar = c2;
        if (this.shape.getExists()) {
            b2.append(' ').append(shapeChar).append(' ');
        }
        String string2 = b2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"b.toString()");
        return string2;
    }

    @Nullable
    protected String getDebugNameSuffix() {
        return null;
    }

    @NotNull
    public String toString() {
        return this.getDebugName();
    }

    private SqlBlock() {
    }

    public /* synthetic */ SqlBlock(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

