/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.command.ListNetworksCmd;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.util.FiltersEncoder;
import com.github.dockerjava.jaxrs.AbstrSyncDockerCmdExec;
import com.google.common.net.UrlEscapers;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListNetworksCmdExec
extends AbstrSyncDockerCmdExec<ListNetworksCmd, List<Network>>
implements ListNetworksCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListNetworksCmdExec.class);

    public ListNetworksCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Network> execute(ListNetworksCmd command) {
        WebTarget webTarget = this.getBaseResource().path("/networks");
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", new Object[]{UrlEscapers.urlPathSegmentEscaper().escape(FiltersEncoder.jsonEncode(command.getFilters()))});
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List networks = (List)webTarget.request().accept(new String[]{"application/json"}).get((GenericType)new GenericType<List<Network>>(){});
        LOGGER.trace("Response: {}", (Object)networks);
        return networks;
    }
}

