/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.presentation.DiagramLineType;
import java.awt.Color;
import java.awt.Shape;
import org.jetbrains.annotations.Nullable;

public abstract class DiagramRelationshipInfoAdapter
implements DiagramRelationshipInfo {
    private final String myName;
    private final DiagramLineType myLineType;
    private final String myLabel;
    private final int myWidth;
    private final String myFromLabel;
    private final String myToLabel;

    public DiagramRelationshipInfoAdapter(String name, DiagramLineType lineType, @Nullable String label, @Nullable String fromLabel, @Nullable String toLabel, int width) {
        this.myFromLabel = fromLabel;
        this.myToLabel = toLabel;
        this.myName = name == null ? "UNDEFINED" : name;
        this.myLineType = lineType == null ? DiagramLineType.SOLID : lineType;
        this.myLabel = label == null ? "" : label;
        this.myWidth = width;
    }

    public DiagramRelationshipInfoAdapter(String name, @Nullable DiagramLineType lineType, @Nullable String label) {
        this(name, lineType, label, null, null, 1);
    }

    public DiagramRelationshipInfoAdapter(String name, @Nullable DiagramLineType lineType, @Nullable String toLabel, @Nullable String fromLabel) {
        this(name, lineType, null, fromLabel, toLabel, 1);
    }

    public DiagramRelationshipInfoAdapter(String name, DiagramLineType lineType) {
        this(name, lineType, null);
    }

    public DiagramRelationshipInfoAdapter(String name) {
        this(name, null, null);
    }

    @Override
    public DiagramLineType getLineType() {
        return this.myLineType;
    }

    @Override
    public String getLabel() {
        return this.myLabel;
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public String getFromLabel() {
        return this.myToLabel;
    }

    @Override
    public String getToLabel() {
        return this.myFromLabel;
    }

    @Override
    public Color getLabelColor() {
        return null;
    }

    @Override
    public Color getFromLabelColor() {
        return null;
    }

    @Override
    public Color getToLabelColor() {
        return null;
    }

    @Override
    public abstract Shape getStartArrow();

    @Override
    public Shape getEndArrow() {
        return null;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramRelationshipInfoAdapter adapter = (DiagramRelationshipInfoAdapter)o;
        if (this.myWidth != adapter.myWidth) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(adapter.myName) : adapter.myName != null) {
            return false;
        }
        if (this.myLineType != adapter.myLineType) {
            return false;
        }
        if (this.myLabel != null ? !this.myLabel.equals(adapter.myLabel) : adapter.myLabel != null) {
            return false;
        }
        if (this.myFromLabel != null ? !this.myFromLabel.equals(adapter.myFromLabel) : adapter.myFromLabel != null) {
            return false;
        }
        return !(this.myToLabel != null ? !this.myToLabel.equals(adapter.myToLabel) : adapter.myToLabel != null);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myLineType != null ? this.myLineType.hashCode() : 0);
        result = 31 * result + (this.myLabel != null ? this.myLabel.hashCode() : 0);
        result = 31 * result + this.myWidth;
        result = 31 * result + (this.myFromLabel != null ? this.myFromLabel.hashCode() : 0);
        result = 31 * result + (this.myToLabel != null ? this.myToLabel.hashCode() : 0);
        return result;
    }
}

