=begin
 This is a machine generated stub using stdlib-doc for <b>class Socket</b>
 Sources used:  ruby-2.6.0-preview2
 Created by IntelliJ Ruby Stubs Generator.
=end

require 'basic_socket'
# Class +Socket+ provides access to the underlying operating system
# socket implementations.  It can be used to provide more operating system
# specific functionality than the protocol-specific socket classes.
# 
# The constants defined under Socket::Constants are also defined under
# Socket.  For example, Socket::AF_INET is usable as well as
# Socket::Constants::AF_INET.  See Socket::Constants for the list of
# constants.
# 
# === What's a socket?
# 
# Sockets are endpoints of a bidirectional communication channel.
# Sockets can communicate within a process, between processes on the same
# machine or between different machines.  There are many types of socket:
# TCPSocket, UDPSocket or UNIXSocket for example.
# 
# Sockets have their own vocabulary:
# 
# *domain:*
# The family of protocols:
# *    Socket::PF_INET
# *    Socket::PF_INET6
# *    Socket::PF_UNIX
# *    etc.
# 
# *type:*
# The type of communications between the two endpoints, typically
# *    Socket::SOCK_STREAM
# *    Socket::SOCK_DGRAM.
# 
# *protocol:*
# Typically _zero_.
# This may be used to identify a variant of a protocol.
# 
# *hostname:*
# The identifier of a network interface:
# *    a string (hostname, IPv4 or IPv6 address or +broadcast+
#      which specifies a broadcast address)
# *    a zero-length string which specifies INADDR_ANY
# *    an integer (interpreted as binary address in host byte order).
# 
# === Quick start
# 
# Many of the classes, such as TCPSocket, UDPSocket or UNIXSocket,
# ease the use of sockets comparatively to the equivalent C programming interface.
# 
# Let's create an internet socket using the IPv4 protocol in a C-like manner:
# 
#   require 'socket'
# 
#   s = Socket.new Socket::AF_INET, Socket::SOCK_STREAM
#   s.connect Socket.pack_sockaddr_in(80, 'example.com')
# 
# You could also use the TCPSocket class:
# 
#   s = TCPSocket.new 'example.com', 80
# 
# A simple server might look like this:
# 
#   require 'socket'
# 
#   server = TCPServer.new 2000 # Server bound to port 2000
# 
#   loop do
#     client = server.accept    # Wait for a client to connect
#     client.puts "Hello !"
#     client.puts "Time is #{Time.now}"
#     client.close
#   end
# 
# A simple client may look like this:
# 
#   require 'socket'
# 
#   s = TCPSocket.new 'localhost', 2000
# 
#   while line = s.gets # Read lines from socket
#     puts line         # and print them
#   end
# 
#   s.close             # close socket when done
# 
# === Exception Handling
# 
# Ruby's Socket implementation raises exceptions based on the error
# generated by the system dependent implementation.  This is why the
# methods are documented in a way that isolate Unix-based system
# exceptions from Windows based exceptions. If more information on a
# particular exception is needed, please refer to the Unix manual pages or
# the Windows WinSock reference.
# 
# === Convenience methods
# 
# Although the general way to create socket is Socket.new,
# there are several methods of socket creation for most cases.
# 
# TCP client socket::
#   Socket.tcp, TCPSocket.open
# TCP server socket::
#   Socket.tcp_server_loop, TCPServer.open
# UNIX client socket::
#   Socket.unix, UNIXSocket.open
# UNIX server socket::
#   Socket.unix_server_loop, UNIXServer.open
# 
# === Documentation by
# 
# * Zach Dennis
# * Sam Roberts
# * <em>Programming Ruby</em> from The Pragmatic Bookshelf.
# 
# Much material in this documentation is taken with permission from
# <em>Programming Ruby</em> from The Pragmatic Bookshelf.
class Socket < BasicSocket
    # A stream socket provides a sequenced, reliable two-way connection for a byte stream   
    SOCK_STREAM = nil #value is unknown, used for indexing.
    # A datagram socket provides connectionless, unreliable messaging   
    SOCK_DGRAM = nil #value is unknown, used for indexing.
    # A raw socket provides low-level access for direct access or implementing network protocols   
    SOCK_RAW = nil #value is unknown, used for indexing.
    # A reliable datagram socket provides reliable delivery of messages   
    SOCK_RDM = nil #value is unknown, used for indexing.
    # A sequential packet socket provides sequenced, reliable two-way connection for datagrams   
    SOCK_SEQPACKET = nil #value is unknown, used for indexing.
    # Device-level packet access   
    SOCK_PACKET = nil #value is unknown, used for indexing.
    # Unspecified protocol, any supported address family   
    AF_UNSPEC = nil #value is unknown, used for indexing.
    # Unspecified protocol, any supported address family   
    PF_UNSPEC = nil #value is unknown, used for indexing.
    # IPv4 protocol   
    AF_INET = nil #value is unknown, used for indexing.
    # IPv4 protocol   
    PF_INET = nil #value is unknown, used for indexing.
    # IPv6 protocol   
    AF_INET6 = nil #value is unknown, used for indexing.
    # IPv6 protocol   
    PF_INET6 = nil #value is unknown, used for indexing.
    # UNIX sockets   
    AF_UNIX = nil #value is unknown, used for indexing.
    # UNIX sockets   
    PF_UNIX = nil #value is unknown, used for indexing.
    # AX.25 protocol   
    AF_AX25 = nil #value is unknown, used for indexing.
    # AX.25 protocol   
    PF_AX25 = nil #value is unknown, used for indexing.
    # IPX protocol   
    AF_IPX = nil #value is unknown, used for indexing.
    # IPX protocol   
    PF_IPX = nil #value is unknown, used for indexing.
    # AppleTalk protocol   
    AF_APPLETALK = nil #value is unknown, used for indexing.
    # AppleTalk protocol   
    PF_APPLETALK = nil #value is unknown, used for indexing.
    # Host-internal protocols   
    AF_LOCAL = nil #value is unknown, used for indexing.
    # Host-internal protocols   
    PF_LOCAL = nil #value is unknown, used for indexing.
    # ARPANET IMP protocol   
    AF_IMPLINK = nil #value is unknown, used for indexing.
    # ARPANET IMP protocol   
    PF_IMPLINK = nil #value is unknown, used for indexing.
    # PARC Universal Packet protocol   
    AF_PUP = nil #value is unknown, used for indexing.
    # PARC Universal Packet protocol   
    PF_PUP = nil #value is unknown, used for indexing.
    # MIT CHAOS protocols   
    AF_CHAOS = nil #value is unknown, used for indexing.
    # MIT CHAOS protocols   
    PF_CHAOS = nil #value is unknown, used for indexing.
    # XEROX NS protocols   
    AF_NS = nil #value is unknown, used for indexing.
    # XEROX NS protocols   
    PF_NS = nil #value is unknown, used for indexing.
    # ISO Open Systems Interconnection protocols   
    AF_ISO = nil #value is unknown, used for indexing.
    # ISO Open Systems Interconnection protocols   
    PF_ISO = nil #value is unknown, used for indexing.
    # ISO Open Systems Interconnection protocols   
    AF_OSI = nil #value is unknown, used for indexing.
    # ISO Open Systems Interconnection protocols   
    PF_OSI = nil #value is unknown, used for indexing.
    # European Computer Manufacturers protocols   
    AF_ECMA = nil #value is unknown, used for indexing.
    # European Computer Manufacturers protocols   
    PF_ECMA = nil #value is unknown, used for indexing.
    # Datakit protocol   
    AF_DATAKIT = nil #value is unknown, used for indexing.
    # Datakit protocol   
    PF_DATAKIT = nil #value is unknown, used for indexing.
    # CCITT (now ITU-T) protocols   
    AF_CCITT = nil #value is unknown, used for indexing.
    # CCITT (now ITU-T) protocols   
    PF_CCITT = nil #value is unknown, used for indexing.
    # IBM SNA protocol   
    AF_SNA = nil #value is unknown, used for indexing.
    # IBM SNA protocol   
    PF_SNA = nil #value is unknown, used for indexing.
    # DECnet protocol   
    AF_DEC = nil #value is unknown, used for indexing.
    # DECnet protocol   
    PF_DEC = nil #value is unknown, used for indexing.
    # DEC Direct Data Link Interface protocol   
    AF_DLI = nil #value is unknown, used for indexing.
    # DEC Direct Data Link Interface protocol   
    PF_DLI = nil #value is unknown, used for indexing.
    # Local Area Transport protocol   
    AF_LAT = nil #value is unknown, used for indexing.
    # Local Area Transport protocol   
    PF_LAT = nil #value is unknown, used for indexing.
    # NSC Hyperchannel protocol   
    AF_HYLINK = nil #value is unknown, used for indexing.
    # NSC Hyperchannel protocol   
    PF_HYLINK = nil #value is unknown, used for indexing.
    # Internal routing protocol   
    AF_ROUTE = nil #value is unknown, used for indexing.
    # Internal routing protocol   
    PF_ROUTE = nil #value is unknown, used for indexing.
    # Link layer interface   
    AF_LINK = nil #value is unknown, used for indexing.
    # Link layer interface   
    PF_LINK = nil #value is unknown, used for indexing.
    # Connection-oriented IP   
    AF_COIP = nil #value is unknown, used for indexing.
    # Connection-oriented IP   
    PF_COIP = nil #value is unknown, used for indexing.
    # Computer Network Technology   
    AF_CNT = nil #value is unknown, used for indexing.
    # Computer Network Technology   
    PF_CNT = nil #value is unknown, used for indexing.
    # Simple Internet Protocol   
    AF_SIP = nil #value is unknown, used for indexing.
    # Simple Internet Protocol   
    PF_SIP = nil #value is unknown, used for indexing.
    # Network driver raw access   
    AF_NDRV = nil #value is unknown, used for indexing.
    # Network driver raw access   
    PF_NDRV = nil #value is unknown, used for indexing.
    # Integrated Services Digital Network   
    AF_ISDN = nil #value is unknown, used for indexing.
    # Integrated Services Digital Network   
    PF_ISDN = nil #value is unknown, used for indexing.
    # Native ATM access   
    AF_NATM = nil #value is unknown, used for indexing.
    # Native ATM access   
    PF_NATM = nil #value is unknown, used for indexing.
    AF_SYSTEM = nil #value is unknown, used for indexing.
    PF_SYSTEM = nil #value is unknown, used for indexing.
    # NetBIOS   
    AF_NETBIOS = nil #value is unknown, used for indexing.
    # NetBIOS   
    PF_NETBIOS = nil #value is unknown, used for indexing.
    # Point-to-Point Protocol   
    AF_PPP = nil #value is unknown, used for indexing.
    # Point-to-Point Protocol   
    PF_PPP = nil #value is unknown, used for indexing.
    # Asynchronous Transfer Mode   
    AF_ATM = nil #value is unknown, used for indexing.
    # Asynchronous Transfer Mode   
    PF_ATM = nil #value is unknown, used for indexing.
    # Netgraph sockets   
    AF_NETGRAPH = nil #value is unknown, used for indexing.
    # Netgraph sockets   
    PF_NETGRAPH = nil #value is unknown, used for indexing.
    # Maximum address family for this platform   
    AF_MAX = nil #value is unknown, used for indexing.
    # Maximum address family for this platform   
    PF_MAX = nil #value is unknown, used for indexing.
    # Direct link-layer access   
    AF_PACKET = nil #value is unknown, used for indexing.
    # Direct link-layer access   
    PF_PACKET = nil #value is unknown, used for indexing.
    # CCITT (ITU-T) E.164 recommendation   
    AF_E164 = nil #value is unknown, used for indexing.
    # eXpress Transfer Protocol   
    PF_XTP = nil #value is unknown, used for indexing.
    PF_RTIP = nil #value is unknown, used for indexing.
    PF_PIP = nil #value is unknown, used for indexing.
    PF_KEY = nil #value is unknown, used for indexing.
    # Process out-of-band data   
    MSG_OOB = nil #value is unknown, used for indexing.
    # Peek at incoming message   
    MSG_PEEK = nil #value is unknown, used for indexing.
    # Send without using the routing tables   
    MSG_DONTROUTE = nil #value is unknown, used for indexing.
    # Data completes record   
    MSG_EOR = nil #value is unknown, used for indexing.
    # Data discarded before delivery   
    MSG_TRUNC = nil #value is unknown, used for indexing.
    # Control data lost before delivery   
    MSG_CTRUNC = nil #value is unknown, used for indexing.
    # Wait for full request or error   
    MSG_WAITALL = nil #value is unknown, used for indexing.
    # This message should be non-blocking   
    MSG_DONTWAIT = nil #value is unknown, used for indexing.
    # Data completes connection   
    MSG_EOF = nil #value is unknown, used for indexing.
    # Start of a hold sequence.  Dumps to so_temp   
    MSG_FLUSH = nil #value is unknown, used for indexing.
    # Hold fragment in so_temp   
    MSG_HOLD = nil #value is unknown, used for indexing.
    # Send the packet in so_temp   
    MSG_SEND = nil #value is unknown, used for indexing.
    # Data ready to be read   
    MSG_HAVEMORE = nil #value is unknown, used for indexing.
    # Data remains in the current packet   
    MSG_RCVMORE = nil #value is unknown, used for indexing.
    # End of record   
    MSG_COMPAT = nil #value is unknown, used for indexing.
    # Wait for full request   
    MSG_PROXY = nil #value is unknown, used for indexing.
    MSG_FIN = nil #value is unknown, used for indexing.
    MSG_SYN = nil #value is unknown, used for indexing.
    # Confirm path validity   
    MSG_CONFIRM = nil #value is unknown, used for indexing.
    MSG_RST = nil #value is unknown, used for indexing.
    # Fetch message from error queue   
    MSG_ERRQUEUE = nil #value is unknown, used for indexing.
    # Do not generate SIGPIPE   
    MSG_NOSIGNAL = nil #value is unknown, used for indexing.
    # Sender will send more   
    MSG_MORE = nil #value is unknown, used for indexing.
    # Reduce step of the handshake process   
    MSG_FASTOPEN = nil #value is unknown, used for indexing.
    # Socket-level options   
    SOL_SOCKET = nil #value is unknown, used for indexing.
    # IP socket options   
    SOL_IP = nil #value is unknown, used for indexing.
    # IPX socket options   
    SOL_IPX = nil #value is unknown, used for indexing.
    # AX.25 socket options   
    SOL_AX25 = nil #value is unknown, used for indexing.
    # AppleTalk socket options   
    SOL_ATALK = nil #value is unknown, used for indexing.
    # TCP socket options   
    SOL_TCP = nil #value is unknown, used for indexing.
    # UDP socket options   
    SOL_UDP = nil #value is unknown, used for indexing.
    # Dummy protocol for IP   
    IPPROTO_IP = nil #value is unknown, used for indexing.
    # Control message protocol   
    IPPROTO_ICMP = nil #value is unknown, used for indexing.
    # Group Management Protocol   
    IPPROTO_IGMP = nil #value is unknown, used for indexing.
    # Gateway to Gateway Protocol   
    IPPROTO_GGP = nil #value is unknown, used for indexing.
    # TCP   
    IPPROTO_TCP = nil #value is unknown, used for indexing.
    # Exterior Gateway Protocol   
    IPPROTO_EGP = nil #value is unknown, used for indexing.
    # PARC Universal Packet protocol   
    IPPROTO_PUP = nil #value is unknown, used for indexing.
    # UDP   
    IPPROTO_UDP = nil #value is unknown, used for indexing.
    # XNS IDP   
    IPPROTO_IDP = nil #value is unknown, used for indexing.
    # "hello" routing protocol   
    IPPROTO_HELLO = nil #value is unknown, used for indexing.
    # Sun net disk protocol   
    IPPROTO_ND = nil #value is unknown, used for indexing.
    # ISO transport protocol class 4   
    IPPROTO_TP = nil #value is unknown, used for indexing.
    # Xpress Transport Protocol   
    IPPROTO_XTP = nil #value is unknown, used for indexing.
    # ISO cnlp   
    IPPROTO_EON = nil #value is unknown, used for indexing.
    IPPROTO_BIP = nil #value is unknown, used for indexing.
    # IP6 auth header   
    IPPROTO_AH = nil #value is unknown, used for indexing.
    # IP6 destination option   
    IPPROTO_DSTOPTS = nil #value is unknown, used for indexing.
    # IP6 Encapsulated Security Payload   
    IPPROTO_ESP = nil #value is unknown, used for indexing.
    # IP6 fragmentation header   
    IPPROTO_FRAGMENT = nil #value is unknown, used for indexing.
    # IP6 hop-by-hop options   
    IPPROTO_HOPOPTS = nil #value is unknown, used for indexing.
    # ICMP6   
    IPPROTO_ICMPV6 = nil #value is unknown, used for indexing.
    # IP6 header   
    IPPROTO_IPV6 = nil #value is unknown, used for indexing.
    # IP6 no next header   
    IPPROTO_NONE = nil #value is unknown, used for indexing.
    # IP6 routing header   
    IPPROTO_ROUTING = nil #value is unknown, used for indexing.
    # Raw IP packet   
    IPPROTO_RAW = nil #value is unknown, used for indexing.
    # Maximum IPPROTO constant   
    IPPROTO_MAX = nil #value is unknown, used for indexing.
    # Default minimum address for bind or connect   
    IPPORT_RESERVED = nil #value is unknown, used for indexing.
    # Default maximum address for bind or connect   
    IPPORT_USERRESERVED = nil #value is unknown, used for indexing.
    # A socket bound to INADDR_ANY receives packets from all interfaces and sends from the default IP address   
    INADDR_ANY = nil #value is unknown, used for indexing.
    # The network broadcast address   
    INADDR_BROADCAST = nil #value is unknown, used for indexing.
    # The loopback address   
    INADDR_LOOPBACK = nil #value is unknown, used for indexing.
    # The reserved multicast group   
    INADDR_UNSPEC_GROUP = nil #value is unknown, used for indexing.
    # Multicast group for all systems on this subset   
    INADDR_ALLHOSTS_GROUP = nil #value is unknown, used for indexing.
    # The last local network multicast group   
    INADDR_MAX_LOCAL_GROUP = nil #value is unknown, used for indexing.
    # A bitmask for matching no valid IP address   
    INADDR_NONE = nil #value is unknown, used for indexing.
    # IP options to be included in packets   
    IP_OPTIONS = nil #value is unknown, used for indexing.
    # Header is included with data   
    IP_HDRINCL = nil #value is unknown, used for indexing.
    # IP type-of-service   
    IP_TOS = nil #value is unknown, used for indexing.
    # IP time-to-live   
    IP_TTL = nil #value is unknown, used for indexing.
    # Receive all IP options with datagram   
    IP_RECVOPTS = nil #value is unknown, used for indexing.
    # Receive all IP options for response   
    IP_RECVRETOPTS = nil #value is unknown, used for indexing.
    # Receive IP destination address with datagram   
    IP_RECVDSTADDR = nil #value is unknown, used for indexing.
    # IP options to be included in datagrams   
    IP_RETOPTS = nil #value is unknown, used for indexing.
    # Minimum TTL allowed for received packets   
    IP_MINTTL = nil #value is unknown, used for indexing.
    # Don't fragment packets   
    IP_DONTFRAG = nil #value is unknown, used for indexing.
    # Source address for outgoing UDP datagrams   
    IP_SENDSRCADDR = nil #value is unknown, used for indexing.
    # Force outgoing broadcast datagrams to have the undirected broadcast address   
    IP_ONESBCAST = nil #value is unknown, used for indexing.
    # Receive IP TTL with datagrams   
    IP_RECVTTL = nil #value is unknown, used for indexing.
    # Receive interface information with datagrams   
    IP_RECVIF = nil #value is unknown, used for indexing.
    # Receive link-layer address with datagrams   
    IP_RECVSLLA = nil #value is unknown, used for indexing.
    # Set the port range for sockets with unspecified port numbers   
    IP_PORTRANGE = nil #value is unknown, used for indexing.
    # IP multicast interface   
    IP_MULTICAST_IF = nil #value is unknown, used for indexing.
    # IP multicast TTL   
    IP_MULTICAST_TTL = nil #value is unknown, used for indexing.
    # IP multicast loopback   
    IP_MULTICAST_LOOP = nil #value is unknown, used for indexing.
    # Add a multicast group membership   
    IP_ADD_MEMBERSHIP = nil #value is unknown, used for indexing.
    # Drop a multicast group membership   
    IP_DROP_MEMBERSHIP = nil #value is unknown, used for indexing.
    # Default multicast TTL   
    IP_DEFAULT_MULTICAST_TTL = nil #value is unknown, used for indexing.
    # Default multicast loopback   
    IP_DEFAULT_MULTICAST_LOOP = nil #value is unknown, used for indexing.
    # Maximum number multicast groups a socket can join   
    IP_MAX_MEMBERSHIPS = nil #value is unknown, used for indexing.
    # Notify transit routers to more closely examine the contents of an IP packet   
    IP_ROUTER_ALERT = nil #value is unknown, used for indexing.
    # Receive packet information with datagrams   
    IP_PKTINFO = nil #value is unknown, used for indexing.
    # Receive packet options with datagrams   
    IP_PKTOPTIONS = nil #value is unknown, used for indexing.
    # Path MTU discovery   
    IP_MTU_DISCOVER = nil #value is unknown, used for indexing.
    # Enable extended reliable error message passing   
    IP_RECVERR = nil #value is unknown, used for indexing.
    # Receive TOS with incoming packets   
    IP_RECVTOS = nil #value is unknown, used for indexing.
    # The Maximum Transmission Unit of the socket   
    IP_MTU = nil #value is unknown, used for indexing.
    # Allow binding to nonexistent IP addresses   
    IP_FREEBIND = nil #value is unknown, used for indexing.
    # IPsec security policy   
    IP_IPSEC_POLICY = nil #value is unknown, used for indexing.
    IP_XFRM_POLICY = nil #value is unknown, used for indexing.
    # Retrieve security context with datagram   
    IP_PASSSEC = nil #value is unknown, used for indexing.
    # Transparent proxy   
    IP_TRANSPARENT = nil #value is unknown, used for indexing.
    # Never send DF frames   
    IP_PMTUDISC_DONT = nil #value is unknown, used for indexing.
    # Use per-route hints   
    IP_PMTUDISC_WANT = nil #value is unknown, used for indexing.
    # Always send DF frames   
    IP_PMTUDISC_DO = nil #value is unknown, used for indexing.
    # Unblock IPv4 multicast packets with a give source address   
    IP_UNBLOCK_SOURCE = nil #value is unknown, used for indexing.
    # Block IPv4 multicast packets with a give source address   
    IP_BLOCK_SOURCE = nil #value is unknown, used for indexing.
    # Add a multicast group membership   
    IP_ADD_SOURCE_MEMBERSHIP = nil #value is unknown, used for indexing.
    # Drop a multicast group membership   
    IP_DROP_SOURCE_MEMBERSHIP = nil #value is unknown, used for indexing.
    # Multicast source filtering   
    IP_MSFILTER = nil #value is unknown, used for indexing.
    # Join a multicast group   
    MCAST_JOIN_GROUP = nil #value is unknown, used for indexing.
    # Block multicast packets from this source   
    MCAST_BLOCK_SOURCE = nil #value is unknown, used for indexing.
    # Unblock multicast packets from this source   
    MCAST_UNBLOCK_SOURCE = nil #value is unknown, used for indexing.
    # Leave a multicast group   
    MCAST_LEAVE_GROUP = nil #value is unknown, used for indexing.
    # Join a multicast source group   
    MCAST_JOIN_SOURCE_GROUP = nil #value is unknown, used for indexing.
    # Leave a multicast source group   
    MCAST_LEAVE_SOURCE_GROUP = nil #value is unknown, used for indexing.
    # Multicast source filtering   
    MCAST_MSFILTER = nil #value is unknown, used for indexing.
    # Exclusive multicast source filter   
    MCAST_EXCLUDE = nil #value is unknown, used for indexing.
    # Inclusive multicast source filter   
    MCAST_INCLUDE = nil #value is unknown, used for indexing.
    # Debug info recording   
    SO_DEBUG = nil #value is unknown, used for indexing.
    # Allow local address reuse   
    SO_REUSEADDR = nil #value is unknown, used for indexing.
    # Allow local address and port reuse   
    SO_REUSEPORT = nil #value is unknown, used for indexing.
    # Get the socket type   
    SO_TYPE = nil #value is unknown, used for indexing.
    # Get and clear the error status   
    SO_ERROR = nil #value is unknown, used for indexing.
    # Use interface addresses   
    SO_DONTROUTE = nil #value is unknown, used for indexing.
    # Permit sending of broadcast messages   
    SO_BROADCAST = nil #value is unknown, used for indexing.
    # Send buffer size   
    SO_SNDBUF = nil #value is unknown, used for indexing.
    # Receive buffer size   
    SO_RCVBUF = nil #value is unknown, used for indexing.
    # Send buffer size without wmem_max limit (Linux 2.6.14)   
    SO_SNDBUFFORCE = nil #value is unknown, used for indexing.
    # Receive buffer size without rmem_max limit (Linux 2.6.14)   
    SO_RCVBUFFORCE = nil #value is unknown, used for indexing.
    # Keep connections alive   
    SO_KEEPALIVE = nil #value is unknown, used for indexing.
    # Leave received out-of-band data in-line   
    SO_OOBINLINE = nil #value is unknown, used for indexing.
    # Disable checksums   
    SO_NO_CHECK = nil #value is unknown, used for indexing.
    # The protocol-defined priority for all packets on this socket   
    SO_PRIORITY = nil #value is unknown, used for indexing.
    # Linger on close if data is present   
    SO_LINGER = nil #value is unknown, used for indexing.
    # Receive SCM_CREDENTIALS messages   
    SO_PASSCRED = nil #value is unknown, used for indexing.
    # The credentials of the foreign process connected to this socket   
    SO_PEERCRED = nil #value is unknown, used for indexing.
    # Receive low-water mark   
    SO_RCVLOWAT = nil #value is unknown, used for indexing.
    # Send low-water mark   
    SO_SNDLOWAT = nil #value is unknown, used for indexing.
    # Receive timeout   
    SO_RCVTIMEO = nil #value is unknown, used for indexing.
    # Send timeout   
    SO_SNDTIMEO = nil #value is unknown, used for indexing.
    # Socket has had listen() called on it   
    SO_ACCEPTCONN = nil #value is unknown, used for indexing.
    # Bypass hardware when possible   
    SO_USELOOPBACK = nil #value is unknown, used for indexing.
    # There is an accept filter   
    SO_ACCEPTFILTER = nil #value is unknown, used for indexing.
    # Retain unread data   
    SO_DONTTRUNC = nil #value is unknown, used for indexing.
    # Give a hint when more data is ready   
    SO_WANTMORE = nil #value is unknown, used for indexing.
    # OOB data is wanted in MSG_FLAG on receive   
    SO_WANTOOBFLAG = nil #value is unknown, used for indexing.
    # Get first packet byte count   
    SO_NREAD = nil #value is unknown, used for indexing.
    # Install socket-level Network Kernel Extension   
    SO_NKE = nil #value is unknown, used for indexing.
    # Don't SIGPIPE on EPIPE   
    SO_NOSIGPIPE = nil #value is unknown, used for indexing.
    SO_SECURITY_AUTHENTICATION = nil #value is unknown, used for indexing.
    SO_SECURITY_ENCRYPTION_TRANSPORT = nil #value is unknown, used for indexing.
    SO_SECURITY_ENCRYPTION_NETWORK = nil #value is unknown, used for indexing.
    # Only send packets from the given interface   
    SO_BINDTODEVICE = nil #value is unknown, used for indexing.
    # Attach an accept filter   
    SO_ATTACH_FILTER = nil #value is unknown, used for indexing.
    # Detach an accept filter   
    SO_DETACH_FILTER = nil #value is unknown, used for indexing.
    # Obtain filter set by SO_ATTACH_FILTER (Linux 3.8)   
    SO_GET_FILTER = nil #value is unknown, used for indexing.
    # Name of the connecting user   
    SO_PEERNAME = nil #value is unknown, used for indexing.
    # Receive timestamp with datagrams (timeval)   
    SO_TIMESTAMP = nil #value is unknown, used for indexing.
    # Receive nanosecond timestamp with datagrams (timespec)   
    SO_TIMESTAMPNS = nil #value is unknown, used for indexing.
    # Receive timestamp with datagrams (bintime)   
    SO_BINTIME = nil #value is unknown, used for indexing.
    # Receive user credentials with datagram   
    SO_RECVUCRED = nil #value is unknown, used for indexing.
    # Mandatory Access Control exemption for unlabeled peers   
    SO_MAC_EXEMPT = nil #value is unknown, used for indexing.
    # Bypass zone boundaries   
    SO_ALLZONES = nil #value is unknown, used for indexing.
    # Obtain the security credentials (Linux 2.6.2)   
    SO_PEERSEC = nil #value is unknown, used for indexing.
    # Toggle security context passing (Linux 2.6.18)   
    SO_PASSSEC = nil #value is unknown, used for indexing.
    # Set the mark for mark-based routing (Linux 2.6.25)   
    SO_MARK = nil #value is unknown, used for indexing.
    # Time stamping of incoming and outgoing packets (Linux 2.6.30)   
    SO_TIMESTAMPING = nil #value is unknown, used for indexing.
    # Protocol given for socket() (Linux 2.6.32)   
    SO_PROTOCOL = nil #value is unknown, used for indexing.
    # Domain given for socket() (Linux 2.6.32)   
    SO_DOMAIN = nil #value is unknown, used for indexing.
    # Toggle cmsg for number of packets dropped (Linux 2.6.33)   
    SO_RXQ_OVFL = nil #value is unknown, used for indexing.
    # Toggle cmsg for wifi status (Linux 3.3)   
    SO_WIFI_STATUS = nil #value is unknown, used for indexing.
    # Set the peek offset (Linux 3.4)   
    SO_PEEK_OFF = nil #value is unknown, used for indexing.
    # Set netns of a socket (Linux 3.4)   
    SO_NOFCS = nil #value is unknown, used for indexing.
    # Lock the filter attached to a socket (Linux 3.9)   
    SO_LOCK_FILTER = nil #value is unknown, used for indexing.
    # Make select() detect socket error queue with errorfds (Linux 3.10)   
    SO_SELECT_ERR_QUEUE = nil #value is unknown, used for indexing.
    # Set the threshold in microseconds for low latency polling (Linux 3.11)   
    SO_BUSY_POLL = nil #value is unknown, used for indexing.
    # Cap the rate computed by transport layer. [bytes per second] (Linux 3.13)   
    SO_MAX_PACING_RATE = nil #value is unknown, used for indexing.
    # Query supported BPF extensions (Linux 3.14)   
    SO_BPF_EXTENSIONS = nil #value is unknown, used for indexing.
    # Interactive socket priority   
    SOPRI_INTERACTIVE = nil #value is unknown, used for indexing.
    # Normal socket priority   
    SOPRI_NORMAL = nil #value is unknown, used for indexing.
    # Background socket priority   
    SOPRI_BACKGROUND = nil #value is unknown, used for indexing.
    IPX_TYPE = nil #value is unknown, used for indexing.
    # Don't delay sending to coalesce packets   
    TCP_NODELAY = nil #value is unknown, used for indexing.
    # Set maximum segment size   
    TCP_MAXSEG = nil #value is unknown, used for indexing.
    # Don't send partial frames (Linux 2.2, glibc 2.2)   
    TCP_CORK = nil #value is unknown, used for indexing.
    # Don't notify a listening socket until data is ready (Linux 2.4, glibc 2.2)   
    TCP_DEFER_ACCEPT = nil #value is unknown, used for indexing.
    # Retrieve information about this socket (Linux 2.4, glibc 2.2)   
    TCP_INFO = nil #value is unknown, used for indexing.
    # Maximum number of keepalive probes allowed before dropping a connection (Linux 2.4, glibc 2.2)   
    TCP_KEEPCNT = nil #value is unknown, used for indexing.
    # Idle time before keepalive probes are sent (Linux 2.4, glibc 2.2)   
    TCP_KEEPIDLE = nil #value is unknown, used for indexing.
    # Time between keepalive probes (Linux 2.4, glibc 2.2)   
    TCP_KEEPINTVL = nil #value is unknown, used for indexing.
    # Lifetime of orphaned FIN_WAIT2 sockets (Linux 2.4, glibc 2.2)   
    TCP_LINGER2 = nil #value is unknown, used for indexing.
    # Use MD5 digests (RFC2385, Linux 2.6.20, glibc 2.7)   
    TCP_MD5SIG = nil #value is unknown, used for indexing.
    # Don't use TCP options   
    TCP_NOOPT = nil #value is unknown, used for indexing.
    # Don't push the last block of write   
    TCP_NOPUSH = nil #value is unknown, used for indexing.
    # Enable quickack mode (Linux 2.4.4, glibc 2.3)   
    TCP_QUICKACK = nil #value is unknown, used for indexing.
    # Number of SYN retransmits before a connection is dropped (Linux 2.4, glibc 2.2)   
    TCP_SYNCNT = nil #value is unknown, used for indexing.
    # Clamp the size of the advertised window (Linux 2.4, glibc 2.2)   
    TCP_WINDOW_CLAMP = nil #value is unknown, used for indexing.
    # Reduce step of the handshake process (Linux 3.7, glibc 2.18)   
    TCP_FASTOPEN = nil #value is unknown, used for indexing.
    # TCP congestion control algorithm (Linux 2.6.13, glibc 2.6)   
    TCP_CONGESTION = nil #value is unknown, used for indexing.
    # TCP Cookie Transactions (Linux 2.6.33, glibc 2.18)   
    TCP_COOKIE_TRANSACTIONS = nil #value is unknown, used for indexing.
    # Sequence of a queue for repair mode (Linux 3.5, glibc 2.18)   
    TCP_QUEUE_SEQ = nil #value is unknown, used for indexing.
    # Repair mode (Linux 3.5, glibc 2.18)   
    TCP_REPAIR = nil #value is unknown, used for indexing.
    # Options for repair mode (Linux 3.5, glibc 2.18)   
    TCP_REPAIR_OPTIONS = nil #value is unknown, used for indexing.
    # Queue for repair mode (Linux 3.5, glibc 2.18)   
    TCP_REPAIR_QUEUE = nil #value is unknown, used for indexing.
    # Duplicated acknowledgments handling for thin-streams (Linux 2.6.34, glibc 2.18)   
    TCP_THIN_DUPACK = nil #value is unknown, used for indexing.
    # Linear timeouts for thin-streams (Linux 2.6.34, glibc 2.18)   
    TCP_THIN_LINEAR_TIMEOUTS = nil #value is unknown, used for indexing.
    # TCP timestamp (Linux 3.9, glibc 2.18)   
    TCP_TIMESTAMP = nil #value is unknown, used for indexing.
    # Max timeout before a TCP connection is aborted (Linux 2.6.37, glibc 2.18)   
    TCP_USER_TIMEOUT = nil #value is unknown, used for indexing.
    # Don't send partial frames (Linux 2.5.44, glibc 2.11)   
    UDP_CORK = nil #value is unknown, used for indexing.
    # Address family for hostname not supported   
    EAI_ADDRFAMILY = nil #value is unknown, used for indexing.
    # Temporary failure in name resolution   
    EAI_AGAIN = nil #value is unknown, used for indexing.
    # Invalid flags   
    EAI_BADFLAGS = nil #value is unknown, used for indexing.
    # Non-recoverable failure in name resolution   
    EAI_FAIL = nil #value is unknown, used for indexing.
    # Address family not supported   
    EAI_FAMILY = nil #value is unknown, used for indexing.
    # Memory allocation failure   
    EAI_MEMORY = nil #value is unknown, used for indexing.
    # No address associated with hostname   
    EAI_NODATA = nil #value is unknown, used for indexing.
    # Hostname nor servname, or not known   
    EAI_NONAME = nil #value is unknown, used for indexing.
    # Argument buffer overflow   
    EAI_OVERFLOW = nil #value is unknown, used for indexing.
    # Servname not supported for socket type   
    EAI_SERVICE = nil #value is unknown, used for indexing.
    # Socket type not supported   
    EAI_SOCKTYPE = nil #value is unknown, used for indexing.
    # System error returned in errno   
    EAI_SYSTEM = nil #value is unknown, used for indexing.
    # Invalid value for hints   
    EAI_BADHINTS = nil #value is unknown, used for indexing.
    # Resolved protocol is unknown   
    EAI_PROTOCOL = nil #value is unknown, used for indexing.
    # Maximum error code from getaddrinfo   
    EAI_MAX = nil #value is unknown, used for indexing.
    # Get address to use with bind()   
    AI_PASSIVE = nil #value is unknown, used for indexing.
    # Fill in the canonical name   
    AI_CANONNAME = nil #value is unknown, used for indexing.
    # Prevent host name resolution   
    AI_NUMERICHOST = nil #value is unknown, used for indexing.
    # Prevent service name resolution   
    AI_NUMERICSERV = nil #value is unknown, used for indexing.
    # Valid flag mask for getaddrinfo (not for application use)   
    AI_MASK = nil #value is unknown, used for indexing.
    # Allow all addresses   
    AI_ALL = nil #value is unknown, used for indexing.
    # Accept IPv4 mapped addresses if the kernel supports it   
    AI_V4MAPPED_CFG = nil #value is unknown, used for indexing.
    # Accept only if any address is assigned   
    AI_ADDRCONFIG = nil #value is unknown, used for indexing.
    # Accept IPv4-mapped IPv6 addresses   
    AI_V4MAPPED = nil #value is unknown, used for indexing.
    # Default flags for getaddrinfo   
    AI_DEFAULT = nil #value is unknown, used for indexing.
    # Maximum length of a hostname   
    NI_MAXHOST = nil #value is unknown, used for indexing.
    # Maximum length of a service name   
    NI_MAXSERV = nil #value is unknown, used for indexing.
    # An FQDN is not required for local hosts, return only the local part   
    NI_NOFQDN = nil #value is unknown, used for indexing.
    # Return a numeric address   
    NI_NUMERICHOST = nil #value is unknown, used for indexing.
    # A name is required   
    NI_NAMEREQD = nil #value is unknown, used for indexing.
    # Return the service name as a digit string   
    NI_NUMERICSERV = nil #value is unknown, used for indexing.
    # The service specified is a datagram service (looks up UDP ports)   
    NI_DGRAM = nil #value is unknown, used for indexing.
    # Shut down the reading side of the socket   
    SHUT_RD = nil #value is unknown, used for indexing.
    # Shut down the writing side of the socket   
    SHUT_WR = nil #value is unknown, used for indexing.
    # Shut down the both sides of the socket   
    SHUT_RDWR = nil #value is unknown, used for indexing.
    # Join a group membership   
    IPV6_JOIN_GROUP = nil #value is unknown, used for indexing.
    # Leave a group membership   
    IPV6_LEAVE_GROUP = nil #value is unknown, used for indexing.
    # IP6 multicast hops   
    IPV6_MULTICAST_HOPS = nil #value is unknown, used for indexing.
    # IP6 multicast interface   
    IPV6_MULTICAST_IF = nil #value is unknown, used for indexing.
    # IP6 multicast loopback   
    IPV6_MULTICAST_LOOP = nil #value is unknown, used for indexing.
    # IP6 unicast hops   
    IPV6_UNICAST_HOPS = nil #value is unknown, used for indexing.
    # Only bind IPv6 with a wildcard bind   
    IPV6_V6ONLY = nil #value is unknown, used for indexing.
    # Checksum offset for raw sockets   
    IPV6_CHECKSUM = nil #value is unknown, used for indexing.
    # Don't fragment packets   
    IPV6_DONTFRAG = nil #value is unknown, used for indexing.
    # Destination option   
    IPV6_DSTOPTS = nil #value is unknown, used for indexing.
    # Hop limit   
    IPV6_HOPLIMIT = nil #value is unknown, used for indexing.
    # Hop-by-hop option   
    IPV6_HOPOPTS = nil #value is unknown, used for indexing.
    # Next hop address   
    IPV6_NEXTHOP = nil #value is unknown, used for indexing.
    # Retrieve current path MTU   
    IPV6_PATHMTU = nil #value is unknown, used for indexing.
    # Receive packet information with datagram   
    IPV6_PKTINFO = nil #value is unknown, used for indexing.
    # Receive all IP6 options for response   
    IPV6_RECVDSTOPTS = nil #value is unknown, used for indexing.
    # Receive hop limit with datagram   
    IPV6_RECVHOPLIMIT = nil #value is unknown, used for indexing.
    # Receive hop-by-hop options   
    IPV6_RECVHOPOPTS = nil #value is unknown, used for indexing.
    # Receive destination IP address and incoming interface   
    IPV6_RECVPKTINFO = nil #value is unknown, used for indexing.
    # Receive routing header   
    IPV6_RECVRTHDR = nil #value is unknown, used for indexing.
    # Receive traffic class   
    IPV6_RECVTCLASS = nil #value is unknown, used for indexing.
    # Allows removal of sticky routing headers   
    IPV6_RTHDR = nil #value is unknown, used for indexing.
    # Allows removal of sticky destination options header   
    IPV6_RTHDRDSTOPTS = nil #value is unknown, used for indexing.
    # Routing header type 0   
    IPV6_RTHDR_TYPE_0 = nil #value is unknown, used for indexing.
    # Receive current path MTU with datagram   
    IPV6_RECVPATHMTU = nil #value is unknown, used for indexing.
    # Specify the traffic class   
    IPV6_TCLASS = nil #value is unknown, used for indexing.
    # Use the minimum MTU size   
    IPV6_USE_MIN_MTU = nil #value is unknown, used for indexing.
    # Maximum length of an IPv4 address string   
    INET_ADDRSTRLEN = nil #value is unknown, used for indexing.
    # Maximum length of an IPv6 address string   
    INET6_ADDRSTRLEN = nil #value is unknown, used for indexing.
    # Maximum interface name size   
    IFNAMSIZ = nil #value is unknown, used for indexing.
    # Maximum interface name size   
    IF_NAMESIZE = nil #value is unknown, used for indexing.
    # Maximum connection requests that may be queued for a socket   
    SOMAXCONN = nil #value is unknown, used for indexing.
    # Access rights   
    SCM_RIGHTS = nil #value is unknown, used for indexing.
    # Timestamp (timeval)   
    SCM_TIMESTAMP = nil #value is unknown, used for indexing.
    # Timespec (timespec)   
    SCM_TIMESTAMPNS = nil #value is unknown, used for indexing.
    # Timestamp (timespec list) (Linux 2.6.30)   
    SCM_TIMESTAMPING = nil #value is unknown, used for indexing.
    # Timestamp (bintime)   
    SCM_BINTIME = nil #value is unknown, used for indexing.
    # The sender's credentials   
    SCM_CREDENTIALS = nil #value is unknown, used for indexing.
    # Process credentials   
    SCM_CREDS = nil #value is unknown, used for indexing.
    # User credentials   
    SCM_UCRED = nil #value is unknown, used for indexing.
    # Wifi status (Linux 3.3)   
    SCM_WIFI_STATUS = nil #value is unknown, used for indexing.
    # Retrieve peer credentials   
    LOCAL_PEERCRED = nil #value is unknown, used for indexing.
    # Pass credentials to receiver   
    LOCAL_CREDS = nil #value is unknown, used for indexing.
    # Connect blocks until accepted   
    LOCAL_CONNWAIT = nil #value is unknown, used for indexing.
    # 802.1Q VLAN device   
    IFF_802_1Q_VLAN = nil #value is unknown, used for indexing.
    # receive all multicast packets   
    IFF_ALLMULTI = nil #value is unknown, used for indexing.
    # use alternate physical connection   
    IFF_ALTPHYS = nil #value is unknown, used for indexing.
    # auto media select active   
    IFF_AUTOMEDIA = nil #value is unknown, used for indexing.
    # bonding master or slave   
    IFF_BONDING = nil #value is unknown, used for indexing.
    # device used as bridge port   
    IFF_BRIDGE_PORT = nil #value is unknown, used for indexing.
    # broadcast address valid   
    IFF_BROADCAST = nil #value is unknown, used for indexing.
    # unconfigurable using ioctl(2)   
    IFF_CANTCONFIG = nil #value is unknown, used for indexing.
    # turn on debugging   
    IFF_DEBUG = nil #value is unknown, used for indexing.
    # disable netpoll at run-time   
    IFF_DISABLE_NETPOLL = nil #value is unknown, used for indexing.
    # disallow bridging this ether dev   
    IFF_DONT_BRIDGE = nil #value is unknown, used for indexing.
    # driver signals dormant   
    IFF_DORMANT = nil #value is unknown, used for indexing.
    # tx hardware queue is full   
    IFF_DRV_OACTIVE = nil #value is unknown, used for indexing.
    # resources allocated   
    IFF_DRV_RUNNING = nil #value is unknown, used for indexing.
    # interface is winding down   
    IFF_DYING = nil #value is unknown, used for indexing.
    # dialup device with changing addresses   
    IFF_DYNAMIC = nil #value is unknown, used for indexing.
    # ethernet bridging device   
    IFF_EBRIDGE = nil #value is unknown, used for indexing.
    # echo sent packets   
    IFF_ECHO = nil #value is unknown, used for indexing.
    # ISATAP interface (RFC4214)   
    IFF_ISATAP = nil #value is unknown, used for indexing.
    # per link layer defined bit 0   
    IFF_LINK0 = nil #value is unknown, used for indexing.
    # per link layer defined bit 1   
    IFF_LINK1 = nil #value is unknown, used for indexing.
    # per link layer defined bit 2   
    IFF_LINK2 = nil #value is unknown, used for indexing.
    # hardware address change when it's running   
    IFF_LIVE_ADDR_CHANGE = nil #value is unknown, used for indexing.
    # loopback net   
    IFF_LOOPBACK = nil #value is unknown, used for indexing.
    # driver signals L1 up   
    IFF_LOWER_UP = nil #value is unknown, used for indexing.
    # device used as macvlan port   
    IFF_MACVLAN_PORT = nil #value is unknown, used for indexing.
    # master of a load balancer   
    IFF_MASTER = nil #value is unknown, used for indexing.
    # bonding master, 802.3ad.   
    IFF_MASTER_8023AD = nil #value is unknown, used for indexing.
    # bonding master, balance-alb.   
    IFF_MASTER_ALB = nil #value is unknown, used for indexing.
    # bonding master, ARP mon in use   
    IFF_MASTER_ARPMON = nil #value is unknown, used for indexing.
    # user-requested monitor mode   
    IFF_MONITOR = nil #value is unknown, used for indexing.
    # supports multicast   
    IFF_MULTICAST = nil #value is unknown, used for indexing.
    # no address resolution protocol   
    IFF_NOARP = nil #value is unknown, used for indexing.
    # avoid use of trailers   
    IFF_NOTRAILERS = nil #value is unknown, used for indexing.
    # transmission in progress   
    IFF_OACTIVE = nil #value is unknown, used for indexing.
    # device used as Open vSwitch datapath port   
    IFF_OVS_DATAPATH = nil #value is unknown, used for indexing.
    # point-to-point link   
    IFF_POINTOPOINT = nil #value is unknown, used for indexing.
    # can set media type   
    IFF_PORTSEL = nil #value is unknown, used for indexing.
    # user-requested promisc mode   
    IFF_PPROMISC = nil #value is unknown, used for indexing.
    # receive all packets   
    IFF_PROMISC = nil #value is unknown, used for indexing.
    # interface is being renamed   
    IFF_RENAMING = nil #value is unknown, used for indexing.
    # routing entry installed   
    IFF_ROUTE = nil #value is unknown, used for indexing.
    # resources allocated   
    IFF_RUNNING = nil #value is unknown, used for indexing.
    # can't hear own transmissions   
    IFF_SIMPLEX = nil #value is unknown, used for indexing.
    # slave of a load balancer   
    IFF_SLAVE = nil #value is unknown, used for indexing.
    # bonding slave not the curr. active   
    IFF_SLAVE_INACTIVE = nil #value is unknown, used for indexing.
    # need ARPs for validation   
    IFF_SLAVE_NEEDARP = nil #value is unknown, used for indexing.
    # interface manages own routes   
    IFF_SMART = nil #value is unknown, used for indexing.
    # static ARP   
    IFF_STATICARP = nil #value is unknown, used for indexing.
    # sending custom FCS   
    IFF_SUPP_NOFCS = nil #value is unknown, used for indexing.
    # used as team port   
    IFF_TEAM_PORT = nil #value is unknown, used for indexing.
    # sharing skbs on transmit   
    IFF_TX_SKB_SHARING = nil #value is unknown, used for indexing.
    # unicast filtering   
    IFF_UNICAST_FLT = nil #value is unknown, used for indexing.
    # interface is up   
    IFF_UP = nil #value is unknown, used for indexing.
    # WAN HDLC device   
    IFF_WAN_HDLC = nil #value is unknown, used for indexing.
    # dev_hard_start_xmit() is allowed to release skb->dst   
    IFF_XMIT_DST_RELEASE = nil #value is unknown, used for indexing.
    # volatile flags   
    IFF_VOLATILE = nil #value is unknown, used for indexing.
    # flags not changeable   
    IFF_CANTCHANGE = nil #value is unknown, used for indexing.
    # Socket.getifaddrs => [ifaddr1, ...]
    # 
    # Returns an array of interface addresses.
    # An element of the array is an instance of Socket::Ifaddr.
    # 
    # This method can be used to find multicast-enabled interfaces:
    # 
    #   pp Socket.getifaddrs.reject {|ifaddr|
    #     !ifaddr.addr.ip? || (ifaddr.flags & Socket::IFF_MULTICAST == 0)
    #   }.map {|ifaddr| [ifaddr.name, ifaddr.ifindex, ifaddr.addr] }
    #   #=> [["eth0", 2, #<Addrinfo: 221.186.184.67>],
    #   #    ["eth0", 2, #<Addrinfo: fe80::216:3eff:fe95:88bb%eth0>]]
    # 
    # Example result on GNU/Linux:
    #   pp Socket.getifaddrs
    #   #=> [#<Socket::Ifaddr lo UP,LOOPBACK,RUNNING,0x10000 PACKET[protocol=0 lo hatype=772 HOST hwaddr=00:00:00:00:00:00]>,
    #   #    #<Socket::Ifaddr eth0 UP,BROADCAST,RUNNING,MULTICAST,0x10000 PACKET[protocol=0 eth0 hatype=1 HOST hwaddr=00:16:3e:95:88:bb] broadcast=PACKET[protocol=0 eth0 hatype=1 HOST hwaddr=ff:ff:ff:ff:ff:ff]>,
    #   #    #<Socket::Ifaddr sit0 NOARP PACKET[protocol=0 sit0 hatype=776 HOST hwaddr=00:00:00:00]>,
    #   #    #<Socket::Ifaddr lo UP,LOOPBACK,RUNNING,0x10000 127.0.0.1 netmask=255.0.0.0>,
    #   #    #<Socket::Ifaddr eth0 UP,BROADCAST,RUNNING,MULTICAST,0x10000 221.186.184.67 netmask=255.255.255.240 broadcast=221.186.184.79>,
    #   #    #<Socket::Ifaddr lo UP,LOOPBACK,RUNNING,0x10000 ::1 netmask=ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff>,
    #   #    #<Socket::Ifaddr eth0 UP,BROADCAST,RUNNING,MULTICAST,0x10000 fe80::216:3eff:fe95:88bb%eth0 netmask=ffff:ffff:ffff:ffff::>]
    # 
    # Example result on FreeBSD:
    #   pp Socket.getifaddrs
    #   #=> [#<Socket::Ifaddr usbus0 UP,0x10000 LINK[usbus0]>,
    #   #    #<Socket::Ifaddr re0 UP,BROADCAST,RUNNING,MULTICAST,0x800 LINK[re0 3a:d0:40:9a:fe:e8]>,
    #   #    #<Socket::Ifaddr re0 UP,BROADCAST,RUNNING,MULTICAST,0x800 10.250.10.18 netmask=255.255.255.? (7 bytes for 16 bytes sockaddr_in) broadcast=10.250.10.255>,
    #   #    #<Socket::Ifaddr re0 UP,BROADCAST,RUNNING,MULTICAST,0x800 fe80:2::38d0:40ff:fe9a:fee8 netmask=ffff:ffff:ffff:ffff::>,
    #   #    #<Socket::Ifaddr re0 UP,BROADCAST,RUNNING,MULTICAST,0x800 2001:2e8:408:10::12 netmask=UNSPEC>,
    #   #    #<Socket::Ifaddr plip0 POINTOPOINT,MULTICAST,0x800 LINK[plip0]>,
    #   #    #<Socket::Ifaddr lo0 UP,LOOPBACK,RUNNING,MULTICAST LINK[lo0]>,
    #   #    #<Socket::Ifaddr lo0 UP,LOOPBACK,RUNNING,MULTICAST ::1 netmask=ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff>,
    #   #    #<Socket::Ifaddr lo0 UP,LOOPBACK,RUNNING,MULTICAST fe80:4::1 netmask=ffff:ffff:ffff:ffff::>,
    #   #    #<Socket::Ifaddr lo0 UP,LOOPBACK,RUNNING,MULTICAST 127.0.0.1 netmask=255.?.?.? (5 bytes for 16 bytes sockaddr_in)>]
    def self.getifaddrs()
        #This is a stub, used for indexing
    end
    # Socket.new(domain, socktype [, protocol]) => socket
    # 
    # Creates a new socket object.
    # 
    # _domain_ should be a communications domain such as: :INET, :INET6, :UNIX, etc.
    # 
    # _socktype_ should be a socket type such as: :STREAM, :DGRAM, :RAW, etc.
    # 
    # _protocol_ is optional and should be a protocol defined in the domain.
    # If protocol is not given, 0 is used internally.
    # 
    #   Socket.new(:INET, :STREAM) # TCP socket
    #   Socket.new(:INET, :DGRAM)  # UDP socket
    #   Socket.new(:UNIX, :STREAM) # UNIX stream socket
    #   Socket.new(:UNIX, :DGRAM)  # UNIX datagram socket
    def initialize(p1, p2, p3 = v3)
        #This is a stub, used for indexing
    end
    # socket.connect(remote_sockaddr) => 0
    # 
    # Requests a connection to be made on the given +remote_sockaddr+. Returns 0 if
    # successful, otherwise an exception is raised.
    # 
    # === Parameter
    # * +remote_sockaddr+ - the +struct+ sockaddr contained in a string or Addrinfo object
    # 
    # === Example:
    #   # Pull down Google's web page
    #   require 'socket'
    #   include Socket::Constants
    #   socket = Socket.new( AF_INET, SOCK_STREAM, 0 )
    #   sockaddr = Socket.pack_sockaddr_in( 80, 'www.google.com' )
    #   socket.connect( sockaddr )
    #   socket.write( "GET / HTTP/1.0\r\n\r\n" )
    #   results = socket.read
    # 
    # === Unix-based Exceptions
    # On unix-based systems the following system exceptions may be raised if
    # the call to _connect_ fails:
    # * Errno::EACCES - search permission is denied for a component of the prefix
    #   path or write access to the +socket+ is denied
    # * Errno::EADDRINUSE - the _sockaddr_ is already in use
    # * Errno::EADDRNOTAVAIL - the specified _sockaddr_ is not available from the
    #   local machine
    # * Errno::EAFNOSUPPORT - the specified _sockaddr_ is not a valid address for
    #   the address family of the specified +socket+
    # * Errno::EALREADY - a connection is already in progress for the specified
    #   socket
    # * Errno::EBADF - the +socket+ is not a valid file descriptor
    # * Errno::ECONNREFUSED - the target _sockaddr_ was not listening for connections
    #   refused the connection request
    # * Errno::ECONNRESET - the remote host reset the connection request
    # * Errno::EFAULT - the _sockaddr_ cannot be accessed
    # * Errno::EHOSTUNREACH - the destination host cannot be reached (probably
    #   because the host is down or a remote router cannot reach it)
    # * Errno::EINPROGRESS - the O_NONBLOCK is set for the +socket+ and the
    #   connection cannot be immediately established; the connection will be
    #   established asynchronously
    # * Errno::EINTR - the attempt to establish the connection was interrupted by
    #   delivery of a signal that was caught; the connection will be established
    #   asynchronously
    # * Errno::EISCONN - the specified +socket+ is already connected
    # * Errno::EINVAL - the address length used for the _sockaddr_ is not a valid
    #   length for the address family or there is an invalid family in _sockaddr_
    # * Errno::ENAMETOOLONG - the pathname resolved had a length which exceeded
    #   PATH_MAX
    # * Errno::ENETDOWN - the local interface used to reach the destination is down
    # * Errno::ENETUNREACH - no route to the network is present
    # * Errno::ENOBUFS - no buffer space is available
    # * Errno::ENOSR - there were insufficient STREAMS resources available to
    #   complete the operation
    # * Errno::ENOTSOCK - the +socket+ argument does not refer to a socket
    # * Errno::EOPNOTSUPP - the calling +socket+ is listening and cannot be connected
    # * Errno::EPROTOTYPE - the _sockaddr_ has a different type than the socket
    #   bound to the specified peer address
    # * Errno::ETIMEDOUT - the attempt to connect time out before a connection
    #   was made.
    # 
    # On unix-based systems if the address family of the calling +socket+ is
    # AF_UNIX the follow exceptions may be raised if the call to _connect_
    # fails:
    # * Errno::EIO - an i/o error occurred while reading from or writing to the
    #   file system
    # * Errno::ELOOP - too many symbolic links were encountered in translating
    #   the pathname in _sockaddr_
    # * Errno::ENAMETOOLLONG - a component of a pathname exceeded NAME_MAX
    #   characters, or an entire pathname exceeded PATH_MAX characters
    # * Errno::ENOENT - a component of the pathname does not name an existing file
    #   or the pathname is an empty string
    # * Errno::ENOTDIR - a component of the path prefix of the pathname in _sockaddr_
    #   is not a directory
    # 
    # === Windows Exceptions
    # On Windows systems the following system exceptions may be raised if
    # the call to _connect_ fails:
    # * Errno::ENETDOWN - the network is down
    # * Errno::EADDRINUSE - the socket's local address is already in use
    # * Errno::EINTR - the socket was cancelled
    # * Errno::EINPROGRESS - a blocking socket is in progress or the service provider
    #   is still processing a callback function. Or a nonblocking connect call is
    #   in progress on the +socket+.
    # * Errno::EALREADY - see Errno::EINVAL
    # * Errno::EADDRNOTAVAIL - the remote address is not a valid address, such as
    #   ADDR_ANY TODO check ADDRANY TO INADDR_ANY
    # * Errno::EAFNOSUPPORT - addresses in the specified family cannot be used with
    #   with this +socket+
    # * Errno::ECONNREFUSED - the target _sockaddr_ was not listening for connections
    #   refused the connection request
    # * Errno::EFAULT - the socket's internal address or address length parameter
    #   is too small or is not a valid part of the user space address
    # * Errno::EINVAL - the +socket+ is a listening socket
    # * Errno::EISCONN - the +socket+ is already connected
    # * Errno::ENETUNREACH - the network cannot be reached from this host at this time
    # * Errno::EHOSTUNREACH - no route to the network is present
    # * Errno::ENOBUFS - no buffer space is available
    # * Errno::ENOTSOCK - the +socket+ argument does not refer to a socket
    # * Errno::ETIMEDOUT - the attempt to connect time out before a connection
    #   was made.
    # * Errno::EWOULDBLOCK - the socket is marked as nonblocking and the
    #   connection cannot be completed immediately
    # * Errno::EACCES - the attempt to connect the datagram socket to the
    #   broadcast address failed
    # 
    # === See
    # * connect manual pages on unix-based systems
    # * connect function in Microsoft's Winsock functions reference
    def connect(remote_sockaddr)
        #This is a stub, used for indexing
    end
    # socket.bind(local_sockaddr) => 0
    # 
    # Binds to the given local address.
    # 
    # === Parameter
    # * +local_sockaddr+ - the +struct+ sockaddr contained in a string or an Addrinfo object
    # 
    # === Example
    #   require 'socket'
    # 
    #   # use Addrinfo
    #   socket = Socket.new(:INET, :STREAM, 0)
    #   socket.bind(Addrinfo.tcp("127.0.0.1", 2222))
    #   p socket.local_address #=> #<Addrinfo: 127.0.0.1:2222 TCP>
    # 
    #   # use struct sockaddr
    #   include Socket::Constants
    #   socket = Socket.new( AF_INET, SOCK_STREAM, 0 )
    #   sockaddr = Socket.pack_sockaddr_in( 2200, 'localhost' )
    #   socket.bind( sockaddr )
    # 
    # === Unix-based Exceptions
    # On unix-based based systems the following system exceptions may be raised if
    # the call to _bind_ fails:
    # * Errno::EACCES - the specified _sockaddr_ is protected and the current
    #   user does not have permission to bind to it
    # * Errno::EADDRINUSE - the specified _sockaddr_ is already in use
    # * Errno::EADDRNOTAVAIL - the specified _sockaddr_ is not available from the
    #   local machine
    # * Errno::EAFNOSUPPORT - the specified _sockaddr_ is not a valid address for
    #   the family of the calling +socket+
    # * Errno::EBADF - the _sockaddr_ specified is not a valid file descriptor
    # * Errno::EFAULT - the _sockaddr_ argument cannot be accessed
    # * Errno::EINVAL - the +socket+ is already bound to an address, and the
    #   protocol does not support binding to the new _sockaddr_ or the +socket+
    #   has been shut down.
    # * Errno::EINVAL - the address length is not a valid length for the address
    #   family
    # * Errno::ENAMETOOLONG - the pathname resolved had a length which exceeded
    #   PATH_MAX
    # * Errno::ENOBUFS - no buffer space is available
    # * Errno::ENOSR - there were insufficient STREAMS resources available to
    #   complete the operation
    # * Errno::ENOTSOCK - the +socket+ does not refer to a socket
    # * Errno::EOPNOTSUPP - the socket type of the +socket+ does not support
    #   binding to an address
    # 
    # On unix-based based systems if the address family of the calling +socket+ is
    # Socket::AF_UNIX the follow exceptions may be raised if the call to _bind_
    # fails:
    # * Errno::EACCES - search permission is denied for a component of the prefix
    #   path or write access to the +socket+ is denied
    # * Errno::EDESTADDRREQ - the _sockaddr_ argument is a null pointer
    # * Errno::EISDIR - same as Errno::EDESTADDRREQ
    # * Errno::EIO - an i/o error occurred
    # * Errno::ELOOP - too many symbolic links were encountered in translating
    #   the pathname in _sockaddr_
    # * Errno::ENAMETOOLLONG - a component of a pathname exceeded NAME_MAX
    #   characters, or an entire pathname exceeded PATH_MAX characters
    # * Errno::ENOENT - a component of the pathname does not name an existing file
    #   or the pathname is an empty string
    # * Errno::ENOTDIR - a component of the path prefix of the pathname in _sockaddr_
    #   is not a directory
    # * Errno::EROFS - the name would reside on a read only filesystem
    # 
    # === Windows Exceptions
    # On Windows systems the following system exceptions may be raised if
    # the call to _bind_ fails:
    # * Errno::ENETDOWN-- the network is down
    # * Errno::EACCES - the attempt to connect the datagram socket to the
    #   broadcast address failed
    # * Errno::EADDRINUSE - the socket's local address is already in use
    # * Errno::EADDRNOTAVAIL - the specified address is not a valid address for this
    #   computer
    # * Errno::EFAULT - the socket's internal address or address length parameter
    #   is too small or is not a valid part of the user space addressed
    # * Errno::EINVAL - the +socket+ is already bound to an address
    # * Errno::ENOBUFS - no buffer space is available
    # * Errno::ENOTSOCK - the +socket+ argument does not refer to a socket
    # 
    # === See
    # * bind manual pages on unix-based systems
    # * bind function in Microsoft's Winsock functions reference
    def bind(local_sockaddr)
        #This is a stub, used for indexing
    end
    # socket.listen( int ) => 0
    # 
    # Listens for connections, using the specified +int+ as the backlog. A call
    # to _listen_ only applies if the +socket+ is of type SOCK_STREAM or
    # SOCK_SEQPACKET.
    # 
    # === Parameter
    # * +backlog+ - the maximum length of the queue for pending connections.
    # 
    # === Example 1
    #   require 'socket'
    #   include Socket::Constants
    #   socket = Socket.new( AF_INET, SOCK_STREAM, 0 )
    #   sockaddr = Socket.pack_sockaddr_in( 2200, 'localhost' )
    #   socket.bind( sockaddr )
    #   socket.listen( 5 )
    # 
    # === Example 2 (listening on an arbitrary port, unix-based systems only):
    #   require 'socket'
    #   include Socket::Constants
    #   socket = Socket.new( AF_INET, SOCK_STREAM, 0 )
    #   socket.listen( 1 )
    # 
    # === Unix-based Exceptions
    # On unix based systems the above will work because a new +sockaddr+ struct
    # is created on the address ADDR_ANY, for an arbitrary port number as handed
    # off by the kernel. It will not work on Windows, because Windows requires that
    # the +socket+ is bound by calling _bind_ before it can _listen_.
    # 
    # If the _backlog_ amount exceeds the implementation-dependent maximum
    # queue length, the implementation's maximum queue length will be used.
    # 
    # On unix-based based systems the following system exceptions may be raised if the
    # call to _listen_ fails:
    # * Errno::EBADF - the _socket_ argument is not a valid file descriptor
    # * Errno::EDESTADDRREQ - the _socket_ is not bound to a local address, and
    #   the protocol does not support listening on an unbound socket
    # * Errno::EINVAL - the _socket_ is already connected
    # * Errno::ENOTSOCK - the _socket_ argument does not refer to a socket
    # * Errno::EOPNOTSUPP - the _socket_ protocol does not support listen
    # * Errno::EACCES - the calling process does not have appropriate privileges
    # * Errno::EINVAL - the _socket_ has been shut down
    # * Errno::ENOBUFS - insufficient resources are available in the system to
    #   complete the call
    # 
    # === Windows Exceptions
    # On Windows systems the following system exceptions may be raised if
    # the call to _listen_ fails:
    # * Errno::ENETDOWN - the network is down
    # * Errno::EADDRINUSE - the socket's local address is already in use. This
    #   usually occurs during the execution of _bind_ but could be delayed
    #   if the call to _bind_ was to a partially wildcard address (involving
    #   ADDR_ANY) and if a specific address needs to be committed at the
    #   time of the call to _listen_
    # * Errno::EINPROGRESS - a Windows Sockets 1.1 call is in progress or the
    #   service provider is still processing a callback function
    # * Errno::EINVAL - the +socket+ has not been bound with a call to _bind_.
    # * Errno::EISCONN - the +socket+ is already connected
    # * Errno::EMFILE - no more socket descriptors are available
    # * Errno::ENOBUFS - no buffer space is available
    # * Errno::ENOTSOC - +socket+ is not a socket
    # * Errno::EOPNOTSUPP - the referenced +socket+ is not a type that supports
    #   the _listen_ method
    # 
    # === See
    # * listen manual pages on unix-based systems
    # * listen function in Microsoft's Winsock functions reference
    def listen( int )
        #This is a stub, used for indexing
    end
    # socket.accept => [client_socket, client_addrinfo]
    # 
    # Accepts a next connection.
    # Returns a new Socket object and Addrinfo object.
    # 
    #   serv = Socket.new(:INET, :STREAM, 0)
    #   serv.listen(5)
    #   c = Socket.new(:INET, :STREAM, 0)
    #   c.connect(serv.connect_address)
    #   p serv.accept #=> [#<Socket:fd 6>, #<Addrinfo: 127.0.0.1:48555 TCP>]
    def accept()
        #This is a stub, used for indexing
    end
    # socket.sysaccept => [client_socket_fd, client_addrinfo]
    # 
    # Accepts an incoming connection returning an array containing the (integer)
    # file descriptor for the incoming connection, _client_socket_fd_,
    # and an Addrinfo, _client_addrinfo_.
    # 
    # === Example
    #   # In one script, start this first
    #   require 'socket'
    #   include Socket::Constants
    #   socket = Socket.new( AF_INET, SOCK_STREAM, 0 )
    #   sockaddr = Socket.pack_sockaddr_in( 2200, 'localhost' )
    #   socket.bind( sockaddr )
    #   socket.listen( 5 )
    #   client_fd, client_addrinfo = socket.sysaccept
    #   client_socket = Socket.for_fd( client_fd )
    #   puts "The client said, '#{client_socket.readline.chomp}'"
    #   client_socket.puts "Hello from script one!"
    #   socket.close
    # 
    #   # In another script, start this second
    #   require 'socket'
    #   include Socket::Constants
    #   socket = Socket.new( AF_INET, SOCK_STREAM, 0 )
    #   sockaddr = Socket.pack_sockaddr_in( 2200, 'localhost' )
    #   socket.connect( sockaddr )
    #   socket.puts "Hello from script 2."
    #   puts "The server said, '#{socket.readline.chomp}'"
    #   socket.close
    # 
    # Refer to Socket#accept for the exceptions that may be thrown if the call
    # to _sysaccept_ fails.
    # 
    # === See
    # * Socket#accept
    def sysaccept()
        #This is a stub, used for indexing
    end
    # socket.recvfrom(maxlen) => [mesg, sender_addrinfo]
    # socket.recvfrom(maxlen, flags) => [mesg, sender_addrinfo]
    # 
    # Receives up to _maxlen_ bytes from +socket+. _flags_ is zero or more
    # of the +MSG_+ options. The first element of the results, _mesg_, is the data
    # received. The second element, _sender_addrinfo_, contains protocol-specific
    # address information of the sender.
    # 
    # === Parameters
    # * +maxlen+ - the maximum number of bytes to receive from the socket
    # * +flags+ - zero or more of the +MSG_+ options
    # 
    # === Example
    #   # In one file, start this first
    #   require 'socket'
    #   include Socket::Constants
    #   socket = Socket.new( AF_INET, SOCK_STREAM, 0 )
    #   sockaddr = Socket.pack_sockaddr_in( 2200, 'localhost' )
    #   socket.bind( sockaddr )
    #   socket.listen( 5 )
    #   client, client_addrinfo = socket.accept
    #   data = client.recvfrom( 20 )[0].chomp
    #   puts "I only received 20 bytes '#{data}'"
    #   sleep 1
    #   socket.close
    # 
    #   # In another file, start this second
    #   require 'socket'
    #   include Socket::Constants
    #   socket = Socket.new( AF_INET, SOCK_STREAM, 0 )
    #   sockaddr = Socket.pack_sockaddr_in( 2200, 'localhost' )
    #   socket.connect( sockaddr )
    #   socket.puts "Watch this get cut short!"
    #   socket.close
    # 
    # === Unix-based Exceptions
    # On unix-based based systems the following system exceptions may be raised if the
    # call to _recvfrom_ fails:
    # * Errno::EAGAIN - the +socket+ file descriptor is marked as O_NONBLOCK and no
    #   data is waiting to be received; or MSG_OOB is set and no out-of-band data
    #   is available and either the +socket+ file descriptor is marked as
    #   O_NONBLOCK or the +socket+ does not support blocking to wait for
    #   out-of-band-data
    # * Errno::EWOULDBLOCK - see Errno::EAGAIN
    # * Errno::EBADF - the +socket+ is not a valid file descriptor
    # * Errno::ECONNRESET - a connection was forcibly closed by a peer
    # * Errno::EFAULT - the socket's internal buffer, address or address length
    #   cannot be accessed or written
    # * Errno::EINTR - a signal interrupted _recvfrom_ before any data was available
    # * Errno::EINVAL - the MSG_OOB flag is set and no out-of-band data is available
    # * Errno::EIO - an i/o error occurred while reading from or writing to the
    #   filesystem
    # * Errno::ENOBUFS - insufficient resources were available in the system to
    #   perform the operation
    # * Errno::ENOMEM - insufficient memory was available to fulfill the request
    # * Errno::ENOSR - there were insufficient STREAMS resources available to
    #   complete the operation
    # * Errno::ENOTCONN - a receive is attempted on a connection-mode socket that
    #   is not connected
    # * Errno::ENOTSOCK - the +socket+ does not refer to a socket
    # * Errno::EOPNOTSUPP - the specified flags are not supported for this socket type
    # * Errno::ETIMEDOUT - the connection timed out during connection establishment
    #   or due to a transmission timeout on an active connection
    # 
    # === Windows Exceptions
    # On Windows systems the following system exceptions may be raised if
    # the call to _recvfrom_ fails:
    # * Errno::ENETDOWN - the network is down
    # * Errno::EFAULT - the internal buffer and from parameters on +socket+ are not
    #   part of the user address space, or the internal fromlen parameter is
    #   too small to accommodate the peer address
    # * Errno::EINTR - the (blocking) call was cancelled by an internal call to
    #   the WinSock function WSACancelBlockingCall
    # * Errno::EINPROGRESS - a blocking Windows Sockets 1.1 call is in progress or
    #   the service provider is still processing a callback function
    # * Errno::EINVAL - +socket+ has not been bound with a call to _bind_, or an
    #   unknown flag was specified, or MSG_OOB was specified for a socket with
    #   SO_OOBINLINE enabled, or (for byte stream-style sockets only) the internal
    #   len parameter on +socket+ was zero or negative
    # * Errno::EISCONN - +socket+ is already connected. The call to _recvfrom_ is
    #   not permitted with a connected socket on a socket that is connection
    #   oriented or connectionless.
    # * Errno::ENETRESET - the connection has been broken due to the keep-alive
    #   activity detecting a failure while the operation was in progress.
    # * Errno::EOPNOTSUPP - MSG_OOB was specified, but +socket+ is not stream-style
    #   such as type SOCK_STREAM. OOB data is not supported in the communication
    #   domain associated with +socket+, or +socket+ is unidirectional and
    #   supports only send operations
    # * Errno::ESHUTDOWN - +socket+ has been shutdown. It is not possible to
    #   call _recvfrom_ on a socket after _shutdown_ has been invoked.
    # * Errno::EWOULDBLOCK - +socket+ is marked as nonblocking and a  call to
    #   _recvfrom_ would block.
    # * Errno::EMSGSIZE - the message was too large to fit into the specified buffer
    #   and was truncated.
    # * Errno::ETIMEDOUT - the connection has been dropped, because of a network
    #   failure or because the system on the other end went down without
    #   notice
    # * Errno::ECONNRESET - the virtual circuit was reset by the remote side
    #   executing a hard or abortive close. The application should close the
    #   socket; it is no longer usable. On a UDP-datagram socket this error
    #   indicates a previous send operation resulted in an ICMP Port Unreachable
    #   message.
    def recvfrom(*several_variants)
        #This is a stub, used for indexing
    end
    # Socket.socketpair(domain, type, protocol) => [socket1, socket2]
    # 
    # Creates a pair of sockets connected each other.
    # 
    # _domain_ should be a communications domain such as: :INET, :INET6, :UNIX, etc.
    # 
    # _socktype_ should be a socket type such as: :STREAM, :DGRAM, :RAW, etc.
    # 
    # _protocol_ should be a protocol defined in the domain,
    # defaults to 0 for the domain.
    # 
    #   s1, s2 = Socket.pair(:UNIX, :STREAM, 0)
    #   s1.send "a", 0
    #   s1.send "b", 0
    #   s1.close
    #   p s2.recv(10) #=> "ab"
    #   p s2.recv(10) #=> ""
    #   p s2.recv(10) #=> ""
    # 
    #   s1, s2 = Socket.pair(:UNIX, :DGRAM, 0)
    #   s1.send "a", 0
    #   s1.send "b", 0
    #   p s2.recv(10) #=> "a"
    #   p s2.recv(10) #=> "b"
    def self.socketpair(domain, type, protocol)
        #This is a stub, used for indexing
    end
    # Socket.pair(domain, type, protocol)       => [socket1, socket2]
    # 
    # Creates a pair of sockets connected each other.
    # 
    # _domain_ should be a communications domain such as: :INET, :INET6, :UNIX, etc.
    # 
    # _socktype_ should be a socket type such as: :STREAM, :DGRAM, :RAW, etc.
    # 
    # _protocol_ should be a protocol defined in the domain,
    # defaults to 0 for the domain.
    # 
    #   s1, s2 = Socket.pair(:UNIX, :STREAM, 0)
    #   s1.send "a", 0
    #   s1.send "b", 0
    #   s1.close
    #   p s2.recv(10) #=> "ab"
    #   p s2.recv(10) #=> ""
    #   p s2.recv(10) #=> ""
    # 
    #   s1, s2 = Socket.pair(:UNIX, :DGRAM, 0)
    #   s1.send "a", 0
    #   s1.send "b", 0
    #   p s2.recv(10) #=> "a"
    #   p s2.recv(10) #=> "b"
    def self.pair(domain, type, protocol)
        #This is a stub, used for indexing
    end
    # Socket.gethostname => hostname
    # 
    # Returns the hostname.
    # 
    #   p Socket.gethostname #=> "hal"
    # 
    # Note that it is not guaranteed to be able to convert to IP address using gethostbyname, getaddrinfo, etc.
    # If you need local IP address, use Socket.ip_address_list.
    def self.gethostname()
        #This is a stub, used for indexing
    end
    # Socket.gethostbyname(hostname) => [official_hostname, alias_hostnames, address_family, *address_list]
    # 
    # Use Addrinfo.getaddrinfo instead.
    # This method is deprecated for the following reasons:
    # 
    # - The 3rd element of the result is the address family of the first address.
    #   The address families of the rest of the addresses are not returned.
    # - Uncommon address representation:
    #   4/16-bytes binary string to represent IPv4/IPv6 address.
    # - gethostbyname() may take a long time and it may block other threads.
    #   (GVL cannot be released since gethostbyname() is not thread safe.)
    # - This method uses gethostbyname() function already removed from POSIX.
    # 
    # This method obtains the host information for _hostname_.
    # 
    #   p Socket.gethostbyname("hal") #=> ["localhost", ["hal"], 2, "\x7F\x00\x00\x01"]
    def self.gethostbyname(hostname)
        #This is a stub, used for indexing
    end
    # Socket.gethostbyaddr(address_string [, address_family]) => hostent
    # 
    # Use Addrinfo#getnameinfo instead.
    # This method is deprecated for the following reasons:
    # 
    # - Uncommon address representation:
    #   4/16-bytes binary string to represent IPv4/IPv6 address.
    # - gethostbyaddr() may take a long time and it may block other threads.
    #   (GVL cannot be released since gethostbyname() is not thread safe.)
    # - This method uses gethostbyname() function already removed from POSIX.
    # 
    # This method obtains the host information for _address_.
    # 
    #   p Socket.gethostbyaddr([221,186,184,68].pack("CCCC"))
    #   #=> ["carbon.ruby-lang.org", [], 2, "\xDD\xBA\xB8D"]
    # 
    #   p Socket.gethostbyaddr([127,0,0,1].pack("CCCC"))
    #   ["localhost", [], 2, "\x7F\x00\x00\x01"]
    #   p Socket.gethostbyaddr(([0]*15+[1]).pack("C"*16))
    #   #=> ["localhost", ["ip6-localhost", "ip6-loopback"], 10,
    #        "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01"]
    def self.gethostbyaddr(p1, p2 = v2)
        #This is a stub, used for indexing
    end
    # Socket.getservbyname(service_name)                => port_number
    # Socket.getservbyname(service_name, protocol_name) => port_number
    # 
    # Obtains the port number for _service_name_.
    # 
    # If _protocol_name_ is not given, "tcp" is assumed.
    # 
    #   Socket.getservbyname("smtp")          #=> 25
    #   Socket.getservbyname("shell")         #=> 514
    #   Socket.getservbyname("syslog", "udp") #=> 514
    def self.getservbyname(*several_variants)
        #This is a stub, used for indexing
    end
    # Socket.getservbyport(port [, protocol_name]) => service
    # 
    # Obtains the port number for _port_.
    # 
    # If _protocol_name_ is not given, "tcp" is assumed.
    # 
    #   Socket.getservbyport(80)         #=> "www"
    #   Socket.getservbyport(514, "tcp") #=> "shell"
    #   Socket.getservbyport(514, "udp") #=> "syslog"
    def self.getservbyport(p1, p2 = v2)
        #This is a stub, used for indexing
    end
    # Socket.getaddrinfo(nodename, servname[, family[, socktype[, protocol[, flags[, reverse_lookup]]]]]) => array
    # 
    # Obtains address information for _nodename_:_servname_.
    # 
    # Note that Addrinfo.getaddrinfo provides the same functionality in
    # an object oriented style.
    # 
    # _family_ should be an address family such as: :INET, :INET6, etc.
    # 
    # _socktype_ should be a socket type such as: :STREAM, :DGRAM, :RAW, etc.
    # 
    # _protocol_ should be a protocol defined in the family,
    # and defaults to 0 for the family.
    # 
    # _flags_ should be bitwise OR of Socket::AI_* constants.
    # 
    #   Socket.getaddrinfo("www.ruby-lang.org", "http", nil, :STREAM)
    #   #=> [["AF_INET", 80, "carbon.ruby-lang.org", "221.186.184.68", 2, 1, 6]] # PF_INET/SOCK_STREAM/IPPROTO_TCP
    # 
    #   Socket.getaddrinfo("localhost", nil)
    #   #=> [["AF_INET", 0, "localhost", "127.0.0.1", 2, 1, 6],  # PF_INET/SOCK_STREAM/IPPROTO_TCP
    #   #    ["AF_INET", 0, "localhost", "127.0.0.1", 2, 2, 17], # PF_INET/SOCK_DGRAM/IPPROTO_UDP
    #   #    ["AF_INET", 0, "localhost", "127.0.0.1", 2, 3, 0]]  # PF_INET/SOCK_RAW/IPPROTO_IP
    # 
    # _reverse_lookup_ directs the form of the third element, and has to
    # be one of below.  If _reverse_lookup_ is omitted, the default value is +nil+.
    # 
    #   +true+, +:hostname+:  hostname is obtained from numeric address using reverse lookup, which may take a time.
    #   +false+, +:numeric+:  hostname is same as numeric address.
    #   +nil+:              obey to the current +do_not_reverse_lookup+ flag.
    # 
    # If Addrinfo object is preferred, use Addrinfo.getaddrinfo.
    def self.getaddrinfo(p1, p2, p3 = v3, p4 = v4, p5 = v5, p6 = v6, p7 = v7)
        #This is a stub, used for indexing
    end
    # Socket.getnameinfo(sockaddr [, flags]) => [hostname, servicename]
    # 
    # Obtains name information for _sockaddr_.
    # 
    # _sockaddr_ should be one of follows.
    # - packed sockaddr string such as Socket.sockaddr_in(80, "127.0.0.1")
    # - 3-elements array such as ["AF_INET", 80, "127.0.0.1"]
    # - 4-elements array such as ["AF_INET", 80, ignored, "127.0.0.1"]
    # 
    # _flags_ should be bitwise OR of Socket::NI_* constants.
    # 
    # Note:
    # The last form is compatible with IPSocket#addr and IPSocket#peeraddr.
    # 
    #   Socket.getnameinfo(Socket.sockaddr_in(80, "127.0.0.1"))       #=> ["localhost", "www"]
    #   Socket.getnameinfo(["AF_INET", 80, "127.0.0.1"])              #=> ["localhost", "www"]
    #   Socket.getnameinfo(["AF_INET", 80, "localhost", "127.0.0.1"]) #=> ["localhost", "www"]
    # 
    # If Addrinfo object is preferred, use Addrinfo#getnameinfo.
    def self.getnameinfo(p1, p2 = v2)
        #This is a stub, used for indexing
    end
    # Socket.sockaddr_in(port, host)      => sockaddr
    # 
    # Packs _port_ and _host_ as an AF_INET/AF_INET6 sockaddr string.
    # 
    #   Socket.sockaddr_in(80, "127.0.0.1")
    #   #=> "\x02\x00\x00P\x7F\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00"
    # 
    #   Socket.sockaddr_in(80, "::1")
    #   #=> "\n\x00\x00P\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00"
    def self.sockaddr_in(port, host)
        #This is a stub, used for indexing
    end
    # Socket.pack_sockaddr_in(port, host) => sockaddr
    # 
    # Packs _port_ and _host_ as an AF_INET/AF_INET6 sockaddr string.
    # 
    #   Socket.sockaddr_in(80, "127.0.0.1")
    #   #=> "\x02\x00\x00P\x7F\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00"
    # 
    #   Socket.sockaddr_in(80, "::1")
    #   #=> "\n\x00\x00P\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00"
    def self.pack_sockaddr_in(port, host)
        #This is a stub, used for indexing
    end
    # Socket.unpack_sockaddr_in(sockaddr) => [port, ip_address]
    # 
    # Unpacks _sockaddr_ into port and ip_address.
    # 
    # _sockaddr_ should be a string or an addrinfo for AF_INET/AF_INET6.
    # 
    #   sockaddr = Socket.sockaddr_in(80, "127.0.0.1")
    #   p sockaddr #=> "\x02\x00\x00P\x7F\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00"
    #   p Socket.unpack_sockaddr_in(sockaddr) #=> [80, "127.0.0.1"]
    def self.unpack_sockaddr_in(sockaddr)
        #This is a stub, used for indexing
    end
    # Socket.sockaddr_un(path)      => sockaddr
    # 
    # Packs _path_ as an AF_UNIX sockaddr string.
    # 
    #   Socket.sockaddr_un("/tmp/sock") #=> "\x01\x00/tmp/sock\x00\x00..."
    def self.sockaddr_un(path)
        #This is a stub, used for indexing
    end
    # Socket.pack_sockaddr_un(path) => sockaddr
    # 
    # Packs _path_ as an AF_UNIX sockaddr string.
    # 
    #   Socket.sockaddr_un("/tmp/sock") #=> "\x01\x00/tmp/sock\x00\x00..."
    def self.pack_sockaddr_un(path)
        #This is a stub, used for indexing
    end
    # Socket.unpack_sockaddr_un(sockaddr) => path
    # 
    # Unpacks _sockaddr_ into path.
    # 
    # _sockaddr_ should be a string or an addrinfo for AF_UNIX.
    # 
    #   sockaddr = Socket.sockaddr_un("/tmp/sock")
    #   p Socket.unpack_sockaddr_un(sockaddr) #=> "/tmp/sock"
    def self.unpack_sockaddr_un(sockaddr)
        #This is a stub, used for indexing
    end
    # Socket.ip_address_list => array
    # 
    # Returns local IP addresses as an array.
    # 
    # The array contains Addrinfo objects.
    # 
    #  pp Socket.ip_address_list
    #  #=> [#<Addrinfo: 127.0.0.1>,
    #       #<Addrinfo: 192.168.0.128>,
    #       #<Addrinfo: ::1>,
    #       ...]
    def self.ip_address_list()
        #This is a stub, used for indexing
    end
    # Socket::AncillaryData represents the ancillary data (control information)
    # used by sendmsg and recvmsg system call.  It contains socket #family,
    # control message (cmsg) #level, cmsg #type and cmsg #data.
    class AncillaryData
        # Socket::AncillaryData.new(family, cmsg_level, cmsg_type, cmsg_data) -> ancillarydata
        # 
        # _family_ should be an integer, a string or a symbol.
        # - Socket::AF_INET, "AF_INET", "INET", :AF_INET, :INET
        # - Socket::AF_UNIX, "AF_UNIX", "UNIX", :AF_UNIX, :UNIX
        # - etc.
        # 
        # _cmsg_level_ should be an integer, a string or a symbol.
        # - Socket::SOL_SOCKET, "SOL_SOCKET", "SOCKET", :SOL_SOCKET and :SOCKET
        # - Socket::IPPROTO_IP, "IP" and :IP
        # - Socket::IPPROTO_IPV6, "IPV6" and :IPV6
        # - Socket::IPPROTO_TCP, "TCP" and :TCP
        # - etc.
        # 
        # _cmsg_type_ should be an integer, a string or a symbol.
        # If a string/symbol is specified, it is interpreted depend on _cmsg_level_.
        # - Socket::SCM_RIGHTS, "SCM_RIGHTS", "RIGHTS", :SCM_RIGHTS, :RIGHTS for SOL_SOCKET
        # - Socket::IP_RECVTTL, "RECVTTL" and :RECVTTL for IPPROTO_IP
        # - Socket::IPV6_PKTINFO, "PKTINFO" and :PKTINFO for IPPROTO_IPV6
        # - etc.
        # 
        # _cmsg_data_ should be a string.
        # 
        #   p Socket::AncillaryData.new(:INET, :TCP, :NODELAY, "")
        #   #=> #<Socket::AncillaryData: INET TCP NODELAY "">
        # 
        #   p Socket::AncillaryData.new(:INET6, :IPV6, :PKTINFO, "")
        #   #=> #<Socket::AncillaryData: INET6 IPV6 PKTINFO "">
        def initialize(family, cmsg_level, cmsg_type, cmsg_data)
            #This is a stub, used for indexing
        end
        # ancillarydata.inspect => string
        # 
        # returns a string which shows ancillarydata in human-readable form.
        # 
        #   p Socket::AncillaryData.new(:INET6, :IPV6, :PKTINFO, "").inspect
        #   #=> "#<Socket::AncillaryData: INET6 IPV6 PKTINFO \"\">"
        def inspect()
            #This is a stub, used for indexing
        end
        # ancillarydata.family => integer
        # 
        # returns the socket family as an integer.
        # 
        #   p Socket::AncillaryData.new(:INET6, :IPV6, :PKTINFO, "").family
        #   #=> 10
        def family()
            #This is a stub, used for indexing
        end
        # ancillarydata.level => integer
        # 
        # returns the cmsg level as an integer.
        # 
        #   p Socket::AncillaryData.new(:INET6, :IPV6, :PKTINFO, "").level
        #   #=> 41
        def level()
            #This is a stub, used for indexing
        end
        # ancillarydata.type => integer
        # 
        # returns the cmsg type as an integer.
        # 
        #   p Socket::AncillaryData.new(:INET6, :IPV6, :PKTINFO, "").type
        #   #=> 2
        def type()
            #This is a stub, used for indexing
        end
        # ancillarydata.data => string
        # 
        # returns the cmsg data as a string.
        # 
        #   p Socket::AncillaryData.new(:INET6, :IPV6, :PKTINFO, "").data
        #   #=> ""
        def data()
            #This is a stub, used for indexing
        end
        # ancillarydata.cmsg_is?(level, type) => true or false
        # 
        # tests the level and type of _ancillarydata_.
        # 
        #   ancdata = Socket::AncillaryData.new(:INET6, :IPV6, :PKTINFO, "")
        #   ancdata.cmsg_is?(Socket::IPPROTO_IPV6, Socket::IPV6_PKTINFO) #=> true
        #   ancdata.cmsg_is?(:IPV6, :PKTINFO)       #=> true
        #   ancdata.cmsg_is?(:IP, :PKTINFO)         #=> false
        #   ancdata.cmsg_is?(:SOCKET, :RIGHTS)      #=> false
        def cmsg_is?(level, type)
            #This is a stub, used for indexing
        end
        # Socket::AncillaryData.int(family, cmsg_level, cmsg_type, integer) => ancillarydata
        # 
        # Creates a new Socket::AncillaryData object which contains a int as data.
        # 
        # The size and endian is dependent on the host.
        # 
        #   require 'socket'
        # 
        #   p Socket::AncillaryData.int(:UNIX, :SOCKET, :RIGHTS, STDERR.fileno)
        #   #=> #<Socket::AncillaryData: UNIX SOCKET RIGHTS 2>
        def self.int(family, cmsg_level, cmsg_type, integer)
            #This is a stub, used for indexing
        end
        # ancillarydata.int => integer
        # 
        # Returns the data in _ancillarydata_ as an int.
        # 
        # The size and endian is dependent on the host.
        # 
        #   ancdata = Socket::AncillaryData.int(:UNIX, :SOCKET, :RIGHTS, STDERR.fileno)
        #   p ancdata.int #=> 2
        def int()
            #This is a stub, used for indexing
        end
        # Socket::AncillaryData.unix_rights(io1, io2, ...) => ancillarydata
        # 
        # Creates a new Socket::AncillaryData object which contains file descriptors as data.
        # 
        #   p Socket::AncillaryData.unix_rights(STDERR)
        #   #=> #<Socket::AncillaryData: UNIX SOCKET RIGHTS 2>
        def self.unix_rights(io1, io2, *smth)
            #This is a stub, used for indexing
        end
        # ancillarydata.unix_rights => array-of-IOs or nil
        # 
        # returns the array of IO objects for SCM_RIGHTS control message in UNIX domain socket.
        # 
        # The class of the IO objects in the array is IO or Socket.
        # 
        # The array is attached to _ancillarydata_ when it is instantiated.
        # For example, BasicSocket#recvmsg attach the array when
        # receives a SCM_RIGHTS control message and :scm_rights=>true option is given.
        # 
        #   # recvmsg needs :scm_rights=>true for unix_rights
        #   s1, s2 = UNIXSocket.pair
        #   p s1                                         #=> #<UNIXSocket:fd 3>
        #   s1.sendmsg "stdin and a socket", 0, nil, Socket::AncillaryData.unix_rights(STDIN, s1)
        #   _, _, _, ctl = s2.recvmsg(:scm_rights=>true)
        #   p ctl                                        #=> #<Socket::AncillaryData: UNIX SOCKET RIGHTS 6 7>
        #   p ctl.unix_rights                            #=> [#<IO:fd 6>, #<Socket:fd 7>]
        #   p File.identical?(STDIN, ctl.unix_rights[0]) #=> true
        #   p File.identical?(s1, ctl.unix_rights[1])    #=> true
        # 
        #   # If :scm_rights=>true is not given, unix_rights returns nil
        #   s1, s2 = UNIXSocket.pair
        #   s1.sendmsg "stdin and a socket", 0, nil, Socket::AncillaryData.unix_rights(STDIN, s1)
        #   _, _, _, ctl = s2.recvmsg
        #   p ctl #=> #<Socket::AncillaryData: UNIX SOCKET RIGHTS 6 7>
        #   p ctl.unix_rights #=> nil
        def unix_rights()
            #This is a stub, used for indexing
        end
        # ancillarydata.timestamp => time
        # 
        # returns the timestamp as a time object.
        # 
        # _ancillarydata_ should be one of following type:
        # - SOL_SOCKET/SCM_TIMESTAMP (microsecond) GNU/Linux, FreeBSD, NetBSD, OpenBSD, Solaris, MacOS X
        # - SOL_SOCKET/SCM_TIMESTAMPNS (nanosecond) GNU/Linux
        # - SOL_SOCKET/SCM_BINTIME (2**(-64) second) FreeBSD
        # 
        #   Addrinfo.udp("127.0.0.1", 0).bind {|s1|
        #     Addrinfo.udp("127.0.0.1", 0).bind {|s2|
        #       s1.setsockopt(:SOCKET, :TIMESTAMP, true)
        #       s2.send "a", 0, s1.local_address
        #       ctl = s1.recvmsg.last
        #       p ctl    #=> #<Socket::AncillaryData: INET SOCKET TIMESTAMP 2009-02-24 17:35:46.775581>
        #       t = ctl.timestamp
        #       p t      #=> 2009-02-24 17:35:46 +0900
        #       p t.usec #=> 775581
        #       p t.nsec #=> 775581000
        #     }
        #   }
        def timestamp()
            #This is a stub, used for indexing
        end
        # Socket::AncillaryData.ip_pktinfo(addr, ifindex) => ancdata
        # Socket::AncillaryData.ip_pktinfo(addr, ifindex, spec_dst) => ancdata
        # 
        # Returns new ancillary data for IP_PKTINFO.
        # 
        # If spec_dst is not given, addr is used.
        # 
        # IP_PKTINFO is not standard.
        # 
        # Supported platform: GNU/Linux
        # 
        #   addr = Addrinfo.ip("127.0.0.1")
        #   ifindex = 0
        #   spec_dst = Addrinfo.ip("127.0.0.1")
        #   p Socket::AncillaryData.ip_pktinfo(addr, ifindex, spec_dst)
        #   #=> #<Socket::AncillaryData: INET IP PKTINFO 127.0.0.1 ifindex:0 spec_dst:127.0.0.1>
        def self.ip_pktinfo(*several_variants)
            #This is a stub, used for indexing
        end
        # ancdata.ip_pktinfo => [addr, ifindex, spec_dst]
        # 
        # Extracts addr, ifindex and spec_dst from IP_PKTINFO ancillary data.
        # 
        # IP_PKTINFO is not standard.
        # 
        # Supported platform: GNU/Linux
        # 
        #   addr = Addrinfo.ip("127.0.0.1")
        #   ifindex = 0
        #   spec_dest = Addrinfo.ip("127.0.0.1")
        #   ancdata = Socket::AncillaryData.ip_pktinfo(addr, ifindex, spec_dest)
        #   p ancdata.ip_pktinfo
        #   #=> [#<Addrinfo: 127.0.0.1>, 0, #<Addrinfo: 127.0.0.1>]
        def ip_pktinfo()
            #This is a stub, used for indexing
        end
        # Socket::AncillaryData.ipv6_pktinfo(addr, ifindex) => ancdata
        # 
        # Returns new ancillary data for IPV6_PKTINFO.
        # 
        # IPV6_PKTINFO is defined by RFC 3542.
        # 
        #   addr = Addrinfo.ip("::1")
        #   ifindex = 0
        #   p Socket::AncillaryData.ipv6_pktinfo(addr, ifindex)
        #   #=> #<Socket::AncillaryData: INET6 IPV6 PKTINFO ::1 ifindex:0>
        def self.ipv6_pktinfo(addr, ifindex)
            #This is a stub, used for indexing
        end
        # ancdata.ipv6_pktinfo => [addr, ifindex]
        # 
        # Extracts addr and ifindex from IPV6_PKTINFO ancillary data.
        # 
        # IPV6_PKTINFO is defined by RFC 3542.
        # 
        #   addr = Addrinfo.ip("::1")
        #   ifindex = 0
        #   ancdata = Socket::AncillaryData.ipv6_pktinfo(addr, ifindex)
        #   p ancdata.ipv6_pktinfo #=> [#<Addrinfo: ::1>, 0]
        def ipv6_pktinfo()
            #This is a stub, used for indexing
        end
        # ancdata.ipv6_pktinfo_addr => addr
        # 
        # Extracts addr from IPV6_PKTINFO ancillary data.
        # 
        # IPV6_PKTINFO is defined by RFC 3542.
        # 
        #   addr = Addrinfo.ip("::1")
        #   ifindex = 0
        #   ancdata = Socket::AncillaryData.ipv6_pktinfo(addr, ifindex)
        #   p ancdata.ipv6_pktinfo_addr #=> #<Addrinfo: ::1>
        def ipv6_pktinfo_addr()
            #This is a stub, used for indexing
        end
        # ancdata.ipv6_pktinfo_ifindex => addr
        # 
        # Extracts ifindex from IPV6_PKTINFO ancillary data.
        # 
        # IPV6_PKTINFO is defined by RFC 3542.
        # 
        #   addr = Addrinfo.ip("::1")
        #   ifindex = 0
        #   ancdata = Socket::AncillaryData.ipv6_pktinfo(addr, ifindex)
        #   p ancdata.ipv6_pktinfo_ifindex #=> 0
        def ipv6_pktinfo_ifindex()
            #This is a stub, used for indexing
        end
    end
    # Socket::Constants provides socket-related constants.  All possible
    # socket constants are listed in the documentation but they may not all
    # be present on your platform.
    # 
    # If the underlying platform doesn't define a constant the corresponding
    # Ruby constant is not defined.
    module Constants
        # A stream socket provides a sequenced, reliable two-way connection for a byte stream   
        SOCK_STREAM = nil #value is unknown, used for indexing.
        # A datagram socket provides connectionless, unreliable messaging   
        SOCK_DGRAM = nil #value is unknown, used for indexing.
        # A raw socket provides low-level access for direct access or implementing network protocols   
        SOCK_RAW = nil #value is unknown, used for indexing.
        # A reliable datagram socket provides reliable delivery of messages   
        SOCK_RDM = nil #value is unknown, used for indexing.
        # A sequential packet socket provides sequenced, reliable two-way connection for datagrams   
        SOCK_SEQPACKET = nil #value is unknown, used for indexing.
        # Device-level packet access   
        SOCK_PACKET = nil #value is unknown, used for indexing.
        # Unspecified protocol, any supported address family   
        AF_UNSPEC = nil #value is unknown, used for indexing.
        # Unspecified protocol, any supported address family   
        PF_UNSPEC = nil #value is unknown, used for indexing.
        # IPv4 protocol   
        AF_INET = nil #value is unknown, used for indexing.
        # IPv4 protocol   
        PF_INET = nil #value is unknown, used for indexing.
        # IPv6 protocol   
        AF_INET6 = nil #value is unknown, used for indexing.
        # IPv6 protocol   
        PF_INET6 = nil #value is unknown, used for indexing.
        # UNIX sockets   
        AF_UNIX = nil #value is unknown, used for indexing.
        # UNIX sockets   
        PF_UNIX = nil #value is unknown, used for indexing.
        # AX.25 protocol   
        AF_AX25 = nil #value is unknown, used for indexing.
        # AX.25 protocol   
        PF_AX25 = nil #value is unknown, used for indexing.
        # IPX protocol   
        AF_IPX = nil #value is unknown, used for indexing.
        # IPX protocol   
        PF_IPX = nil #value is unknown, used for indexing.
        # AppleTalk protocol   
        AF_APPLETALK = nil #value is unknown, used for indexing.
        # AppleTalk protocol   
        PF_APPLETALK = nil #value is unknown, used for indexing.
        # Host-internal protocols   
        AF_LOCAL = nil #value is unknown, used for indexing.
        # Host-internal protocols   
        PF_LOCAL = nil #value is unknown, used for indexing.
        # ARPANET IMP protocol   
        AF_IMPLINK = nil #value is unknown, used for indexing.
        # ARPANET IMP protocol   
        PF_IMPLINK = nil #value is unknown, used for indexing.
        # PARC Universal Packet protocol   
        AF_PUP = nil #value is unknown, used for indexing.
        # PARC Universal Packet protocol   
        PF_PUP = nil #value is unknown, used for indexing.
        # MIT CHAOS protocols   
        AF_CHAOS = nil #value is unknown, used for indexing.
        # MIT CHAOS protocols   
        PF_CHAOS = nil #value is unknown, used for indexing.
        # XEROX NS protocols   
        AF_NS = nil #value is unknown, used for indexing.
        # XEROX NS protocols   
        PF_NS = nil #value is unknown, used for indexing.
        # ISO Open Systems Interconnection protocols   
        AF_ISO = nil #value is unknown, used for indexing.
        # ISO Open Systems Interconnection protocols   
        PF_ISO = nil #value is unknown, used for indexing.
        # ISO Open Systems Interconnection protocols   
        AF_OSI = nil #value is unknown, used for indexing.
        # ISO Open Systems Interconnection protocols   
        PF_OSI = nil #value is unknown, used for indexing.
        # European Computer Manufacturers protocols   
        AF_ECMA = nil #value is unknown, used for indexing.
        # European Computer Manufacturers protocols   
        PF_ECMA = nil #value is unknown, used for indexing.
        # Datakit protocol   
        AF_DATAKIT = nil #value is unknown, used for indexing.
        # Datakit protocol   
        PF_DATAKIT = nil #value is unknown, used for indexing.
        # CCITT (now ITU-T) protocols   
        AF_CCITT = nil #value is unknown, used for indexing.
        # CCITT (now ITU-T) protocols   
        PF_CCITT = nil #value is unknown, used for indexing.
        # IBM SNA protocol   
        AF_SNA = nil #value is unknown, used for indexing.
        # IBM SNA protocol   
        PF_SNA = nil #value is unknown, used for indexing.
        # DECnet protocol   
        AF_DEC = nil #value is unknown, used for indexing.
        # DECnet protocol   
        PF_DEC = nil #value is unknown, used for indexing.
        # DEC Direct Data Link Interface protocol   
        AF_DLI = nil #value is unknown, used for indexing.
        # DEC Direct Data Link Interface protocol   
        PF_DLI = nil #value is unknown, used for indexing.
        # Local Area Transport protocol   
        AF_LAT = nil #value is unknown, used for indexing.
        # Local Area Transport protocol   
        PF_LAT = nil #value is unknown, used for indexing.
        # NSC Hyperchannel protocol   
        AF_HYLINK = nil #value is unknown, used for indexing.
        # NSC Hyperchannel protocol   
        PF_HYLINK = nil #value is unknown, used for indexing.
        # Internal routing protocol   
        AF_ROUTE = nil #value is unknown, used for indexing.
        # Internal routing protocol   
        PF_ROUTE = nil #value is unknown, used for indexing.
        # Link layer interface   
        AF_LINK = nil #value is unknown, used for indexing.
        # Link layer interface   
        PF_LINK = nil #value is unknown, used for indexing.
        # Connection-oriented IP   
        AF_COIP = nil #value is unknown, used for indexing.
        # Connection-oriented IP   
        PF_COIP = nil #value is unknown, used for indexing.
        # Computer Network Technology   
        AF_CNT = nil #value is unknown, used for indexing.
        # Computer Network Technology   
        PF_CNT = nil #value is unknown, used for indexing.
        # Simple Internet Protocol   
        AF_SIP = nil #value is unknown, used for indexing.
        # Simple Internet Protocol   
        PF_SIP = nil #value is unknown, used for indexing.
        # Network driver raw access   
        AF_NDRV = nil #value is unknown, used for indexing.
        # Network driver raw access   
        PF_NDRV = nil #value is unknown, used for indexing.
        # Integrated Services Digital Network   
        AF_ISDN = nil #value is unknown, used for indexing.
        # Integrated Services Digital Network   
        PF_ISDN = nil #value is unknown, used for indexing.
        # Native ATM access   
        AF_NATM = nil #value is unknown, used for indexing.
        # Native ATM access   
        PF_NATM = nil #value is unknown, used for indexing.
        AF_SYSTEM = nil #value is unknown, used for indexing.
        PF_SYSTEM = nil #value is unknown, used for indexing.
        # NetBIOS   
        AF_NETBIOS = nil #value is unknown, used for indexing.
        # NetBIOS   
        PF_NETBIOS = nil #value is unknown, used for indexing.
        # Point-to-Point Protocol   
        AF_PPP = nil #value is unknown, used for indexing.
        # Point-to-Point Protocol   
        PF_PPP = nil #value is unknown, used for indexing.
        # Asynchronous Transfer Mode   
        AF_ATM = nil #value is unknown, used for indexing.
        # Asynchronous Transfer Mode   
        PF_ATM = nil #value is unknown, used for indexing.
        # Netgraph sockets   
        AF_NETGRAPH = nil #value is unknown, used for indexing.
        # Netgraph sockets   
        PF_NETGRAPH = nil #value is unknown, used for indexing.
        # Maximum address family for this platform   
        AF_MAX = nil #value is unknown, used for indexing.
        # Maximum address family for this platform   
        PF_MAX = nil #value is unknown, used for indexing.
        # Direct link-layer access   
        AF_PACKET = nil #value is unknown, used for indexing.
        # Direct link-layer access   
        PF_PACKET = nil #value is unknown, used for indexing.
        # CCITT (ITU-T) E.164 recommendation   
        AF_E164 = nil #value is unknown, used for indexing.
        # eXpress Transfer Protocol   
        PF_XTP = nil #value is unknown, used for indexing.
        PF_RTIP = nil #value is unknown, used for indexing.
        PF_PIP = nil #value is unknown, used for indexing.
        PF_KEY = nil #value is unknown, used for indexing.
        # Process out-of-band data   
        MSG_OOB = nil #value is unknown, used for indexing.
        # Peek at incoming message   
        MSG_PEEK = nil #value is unknown, used for indexing.
        # Send without using the routing tables   
        MSG_DONTROUTE = nil #value is unknown, used for indexing.
        # Data completes record   
        MSG_EOR = nil #value is unknown, used for indexing.
        # Data discarded before delivery   
        MSG_TRUNC = nil #value is unknown, used for indexing.
        # Control data lost before delivery   
        MSG_CTRUNC = nil #value is unknown, used for indexing.
        # Wait for full request or error   
        MSG_WAITALL = nil #value is unknown, used for indexing.
        # This message should be non-blocking   
        MSG_DONTWAIT = nil #value is unknown, used for indexing.
        # Data completes connection   
        MSG_EOF = nil #value is unknown, used for indexing.
        # Start of a hold sequence.  Dumps to so_temp   
        MSG_FLUSH = nil #value is unknown, used for indexing.
        # Hold fragment in so_temp   
        MSG_HOLD = nil #value is unknown, used for indexing.
        # Send the packet in so_temp   
        MSG_SEND = nil #value is unknown, used for indexing.
        # Data ready to be read   
        MSG_HAVEMORE = nil #value is unknown, used for indexing.
        # Data remains in the current packet   
        MSG_RCVMORE = nil #value is unknown, used for indexing.
        # End of record   
        MSG_COMPAT = nil #value is unknown, used for indexing.
        # Wait for full request   
        MSG_PROXY = nil #value is unknown, used for indexing.
        MSG_FIN = nil #value is unknown, used for indexing.
        MSG_SYN = nil #value is unknown, used for indexing.
        # Confirm path validity   
        MSG_CONFIRM = nil #value is unknown, used for indexing.
        MSG_RST = nil #value is unknown, used for indexing.
        # Fetch message from error queue   
        MSG_ERRQUEUE = nil #value is unknown, used for indexing.
        # Do not generate SIGPIPE   
        MSG_NOSIGNAL = nil #value is unknown, used for indexing.
        # Sender will send more   
        MSG_MORE = nil #value is unknown, used for indexing.
        # Reduce step of the handshake process   
        MSG_FASTOPEN = nil #value is unknown, used for indexing.
        # Socket-level options   
        SOL_SOCKET = nil #value is unknown, used for indexing.
        # IP socket options   
        SOL_IP = nil #value is unknown, used for indexing.
        # IPX socket options   
        SOL_IPX = nil #value is unknown, used for indexing.
        # AX.25 socket options   
        SOL_AX25 = nil #value is unknown, used for indexing.
        # AppleTalk socket options   
        SOL_ATALK = nil #value is unknown, used for indexing.
        # TCP socket options   
        SOL_TCP = nil #value is unknown, used for indexing.
        # UDP socket options   
        SOL_UDP = nil #value is unknown, used for indexing.
        # Dummy protocol for IP   
        IPPROTO_IP = nil #value is unknown, used for indexing.
        # Control message protocol   
        IPPROTO_ICMP = nil #value is unknown, used for indexing.
        # Group Management Protocol   
        IPPROTO_IGMP = nil #value is unknown, used for indexing.
        # Gateway to Gateway Protocol   
        IPPROTO_GGP = nil #value is unknown, used for indexing.
        # TCP   
        IPPROTO_TCP = nil #value is unknown, used for indexing.
        # Exterior Gateway Protocol   
        IPPROTO_EGP = nil #value is unknown, used for indexing.
        # PARC Universal Packet protocol   
        IPPROTO_PUP = nil #value is unknown, used for indexing.
        # UDP   
        IPPROTO_UDP = nil #value is unknown, used for indexing.
        # XNS IDP   
        IPPROTO_IDP = nil #value is unknown, used for indexing.
        # "hello" routing protocol   
        IPPROTO_HELLO = nil #value is unknown, used for indexing.
        # Sun net disk protocol   
        IPPROTO_ND = nil #value is unknown, used for indexing.
        # ISO transport protocol class 4   
        IPPROTO_TP = nil #value is unknown, used for indexing.
        # Xpress Transport Protocol   
        IPPROTO_XTP = nil #value is unknown, used for indexing.
        # ISO cnlp   
        IPPROTO_EON = nil #value is unknown, used for indexing.
        IPPROTO_BIP = nil #value is unknown, used for indexing.
        # IP6 auth header   
        IPPROTO_AH = nil #value is unknown, used for indexing.
        # IP6 destination option   
        IPPROTO_DSTOPTS = nil #value is unknown, used for indexing.
        # IP6 Encapsulated Security Payload   
        IPPROTO_ESP = nil #value is unknown, used for indexing.
        # IP6 fragmentation header   
        IPPROTO_FRAGMENT = nil #value is unknown, used for indexing.
        # IP6 hop-by-hop options   
        IPPROTO_HOPOPTS = nil #value is unknown, used for indexing.
        # ICMP6   
        IPPROTO_ICMPV6 = nil #value is unknown, used for indexing.
        # IP6 header   
        IPPROTO_IPV6 = nil #value is unknown, used for indexing.
        # IP6 no next header   
        IPPROTO_NONE = nil #value is unknown, used for indexing.
        # IP6 routing header   
        IPPROTO_ROUTING = nil #value is unknown, used for indexing.
        # Raw IP packet   
        IPPROTO_RAW = nil #value is unknown, used for indexing.
        # Maximum IPPROTO constant   
        IPPROTO_MAX = nil #value is unknown, used for indexing.
        # Default minimum address for bind or connect   
        IPPORT_RESERVED = nil #value is unknown, used for indexing.
        # Default maximum address for bind or connect   
        IPPORT_USERRESERVED = nil #value is unknown, used for indexing.
        # A socket bound to INADDR_ANY receives packets from all interfaces and sends from the default IP address   
        INADDR_ANY = nil #value is unknown, used for indexing.
        # The network broadcast address   
        INADDR_BROADCAST = nil #value is unknown, used for indexing.
        # The loopback address   
        INADDR_LOOPBACK = nil #value is unknown, used for indexing.
        # The reserved multicast group   
        INADDR_UNSPEC_GROUP = nil #value is unknown, used for indexing.
        # Multicast group for all systems on this subset   
        INADDR_ALLHOSTS_GROUP = nil #value is unknown, used for indexing.
        # The last local network multicast group   
        INADDR_MAX_LOCAL_GROUP = nil #value is unknown, used for indexing.
        # A bitmask for matching no valid IP address   
        INADDR_NONE = nil #value is unknown, used for indexing.
        # IP options to be included in packets   
        IP_OPTIONS = nil #value is unknown, used for indexing.
        # Header is included with data   
        IP_HDRINCL = nil #value is unknown, used for indexing.
        # IP type-of-service   
        IP_TOS = nil #value is unknown, used for indexing.
        # IP time-to-live   
        IP_TTL = nil #value is unknown, used for indexing.
        # Receive all IP options with datagram   
        IP_RECVOPTS = nil #value is unknown, used for indexing.
        # Receive all IP options for response   
        IP_RECVRETOPTS = nil #value is unknown, used for indexing.
        # Receive IP destination address with datagram   
        IP_RECVDSTADDR = nil #value is unknown, used for indexing.
        # IP options to be included in datagrams   
        IP_RETOPTS = nil #value is unknown, used for indexing.
        # Minimum TTL allowed for received packets   
        IP_MINTTL = nil #value is unknown, used for indexing.
        # Don't fragment packets   
        IP_DONTFRAG = nil #value is unknown, used for indexing.
        # Source address for outgoing UDP datagrams   
        IP_SENDSRCADDR = nil #value is unknown, used for indexing.
        # Force outgoing broadcast datagrams to have the undirected broadcast address   
        IP_ONESBCAST = nil #value is unknown, used for indexing.
        # Receive IP TTL with datagrams   
        IP_RECVTTL = nil #value is unknown, used for indexing.
        # Receive interface information with datagrams   
        IP_RECVIF = nil #value is unknown, used for indexing.
        # Receive link-layer address with datagrams   
        IP_RECVSLLA = nil #value is unknown, used for indexing.
        # Set the port range for sockets with unspecified port numbers   
        IP_PORTRANGE = nil #value is unknown, used for indexing.
        # IP multicast interface   
        IP_MULTICAST_IF = nil #value is unknown, used for indexing.
        # IP multicast TTL   
        IP_MULTICAST_TTL = nil #value is unknown, used for indexing.
        # IP multicast loopback   
        IP_MULTICAST_LOOP = nil #value is unknown, used for indexing.
        # Add a multicast group membership   
        IP_ADD_MEMBERSHIP = nil #value is unknown, used for indexing.
        # Drop a multicast group membership   
        IP_DROP_MEMBERSHIP = nil #value is unknown, used for indexing.
        # Default multicast TTL   
        IP_DEFAULT_MULTICAST_TTL = nil #value is unknown, used for indexing.
        # Default multicast loopback   
        IP_DEFAULT_MULTICAST_LOOP = nil #value is unknown, used for indexing.
        # Maximum number multicast groups a socket can join   
        IP_MAX_MEMBERSHIPS = nil #value is unknown, used for indexing.
        # Notify transit routers to more closely examine the contents of an IP packet   
        IP_ROUTER_ALERT = nil #value is unknown, used for indexing.
        # Receive packet information with datagrams   
        IP_PKTINFO = nil #value is unknown, used for indexing.
        # Receive packet options with datagrams   
        IP_PKTOPTIONS = nil #value is unknown, used for indexing.
        # Path MTU discovery   
        IP_MTU_DISCOVER = nil #value is unknown, used for indexing.
        # Enable extended reliable error message passing   
        IP_RECVERR = nil #value is unknown, used for indexing.
        # Receive TOS with incoming packets   
        IP_RECVTOS = nil #value is unknown, used for indexing.
        # The Maximum Transmission Unit of the socket   
        IP_MTU = nil #value is unknown, used for indexing.
        # Allow binding to nonexistent IP addresses   
        IP_FREEBIND = nil #value is unknown, used for indexing.
        # IPsec security policy   
        IP_IPSEC_POLICY = nil #value is unknown, used for indexing.
        IP_XFRM_POLICY = nil #value is unknown, used for indexing.
        # Retrieve security context with datagram   
        IP_PASSSEC = nil #value is unknown, used for indexing.
        # Transparent proxy   
        IP_TRANSPARENT = nil #value is unknown, used for indexing.
        # Never send DF frames   
        IP_PMTUDISC_DONT = nil #value is unknown, used for indexing.
        # Use per-route hints   
        IP_PMTUDISC_WANT = nil #value is unknown, used for indexing.
        # Always send DF frames   
        IP_PMTUDISC_DO = nil #value is unknown, used for indexing.
        # Unblock IPv4 multicast packets with a give source address   
        IP_UNBLOCK_SOURCE = nil #value is unknown, used for indexing.
        # Block IPv4 multicast packets with a give source address   
        IP_BLOCK_SOURCE = nil #value is unknown, used for indexing.
        # Add a multicast group membership   
        IP_ADD_SOURCE_MEMBERSHIP = nil #value is unknown, used for indexing.
        # Drop a multicast group membership   
        IP_DROP_SOURCE_MEMBERSHIP = nil #value is unknown, used for indexing.
        # Multicast source filtering   
        IP_MSFILTER = nil #value is unknown, used for indexing.
        # Join a multicast group   
        MCAST_JOIN_GROUP = nil #value is unknown, used for indexing.
        # Block multicast packets from this source   
        MCAST_BLOCK_SOURCE = nil #value is unknown, used for indexing.
        # Unblock multicast packets from this source   
        MCAST_UNBLOCK_SOURCE = nil #value is unknown, used for indexing.
        # Leave a multicast group   
        MCAST_LEAVE_GROUP = nil #value is unknown, used for indexing.
        # Join a multicast source group   
        MCAST_JOIN_SOURCE_GROUP = nil #value is unknown, used for indexing.
        # Leave a multicast source group   
        MCAST_LEAVE_SOURCE_GROUP = nil #value is unknown, used for indexing.
        # Multicast source filtering   
        MCAST_MSFILTER = nil #value is unknown, used for indexing.
        # Exclusive multicast source filter   
        MCAST_EXCLUDE = nil #value is unknown, used for indexing.
        # Inclusive multicast source filter   
        MCAST_INCLUDE = nil #value is unknown, used for indexing.
        # Debug info recording   
        SO_DEBUG = nil #value is unknown, used for indexing.
        # Allow local address reuse   
        SO_REUSEADDR = nil #value is unknown, used for indexing.
        # Allow local address and port reuse   
        SO_REUSEPORT = nil #value is unknown, used for indexing.
        # Get the socket type   
        SO_TYPE = nil #value is unknown, used for indexing.
        # Get and clear the error status   
        SO_ERROR = nil #value is unknown, used for indexing.
        # Use interface addresses   
        SO_DONTROUTE = nil #value is unknown, used for indexing.
        # Permit sending of broadcast messages   
        SO_BROADCAST = nil #value is unknown, used for indexing.
        # Send buffer size   
        SO_SNDBUF = nil #value is unknown, used for indexing.
        # Receive buffer size   
        SO_RCVBUF = nil #value is unknown, used for indexing.
        # Send buffer size without wmem_max limit (Linux 2.6.14)   
        SO_SNDBUFFORCE = nil #value is unknown, used for indexing.
        # Receive buffer size without rmem_max limit (Linux 2.6.14)   
        SO_RCVBUFFORCE = nil #value is unknown, used for indexing.
        # Keep connections alive   
        SO_KEEPALIVE = nil #value is unknown, used for indexing.
        # Leave received out-of-band data in-line   
        SO_OOBINLINE = nil #value is unknown, used for indexing.
        # Disable checksums   
        SO_NO_CHECK = nil #value is unknown, used for indexing.
        # The protocol-defined priority for all packets on this socket   
        SO_PRIORITY = nil #value is unknown, used for indexing.
        # Linger on close if data is present   
        SO_LINGER = nil #value is unknown, used for indexing.
        # Receive SCM_CREDENTIALS messages   
        SO_PASSCRED = nil #value is unknown, used for indexing.
        # The credentials of the foreign process connected to this socket   
        SO_PEERCRED = nil #value is unknown, used for indexing.
        # Receive low-water mark   
        SO_RCVLOWAT = nil #value is unknown, used for indexing.
        # Send low-water mark   
        SO_SNDLOWAT = nil #value is unknown, used for indexing.
        # Receive timeout   
        SO_RCVTIMEO = nil #value is unknown, used for indexing.
        # Send timeout   
        SO_SNDTIMEO = nil #value is unknown, used for indexing.
        # Socket has had listen() called on it   
        SO_ACCEPTCONN = nil #value is unknown, used for indexing.
        # Bypass hardware when possible   
        SO_USELOOPBACK = nil #value is unknown, used for indexing.
        # There is an accept filter   
        SO_ACCEPTFILTER = nil #value is unknown, used for indexing.
        # Retain unread data   
        SO_DONTTRUNC = nil #value is unknown, used for indexing.
        # Give a hint when more data is ready   
        SO_WANTMORE = nil #value is unknown, used for indexing.
        # OOB data is wanted in MSG_FLAG on receive   
        SO_WANTOOBFLAG = nil #value is unknown, used for indexing.
        # Get first packet byte count   
        SO_NREAD = nil #value is unknown, used for indexing.
        # Install socket-level Network Kernel Extension   
        SO_NKE = nil #value is unknown, used for indexing.
        # Don't SIGPIPE on EPIPE   
        SO_NOSIGPIPE = nil #value is unknown, used for indexing.
        SO_SECURITY_AUTHENTICATION = nil #value is unknown, used for indexing.
        SO_SECURITY_ENCRYPTION_TRANSPORT = nil #value is unknown, used for indexing.
        SO_SECURITY_ENCRYPTION_NETWORK = nil #value is unknown, used for indexing.
        # Only send packets from the given interface   
        SO_BINDTODEVICE = nil #value is unknown, used for indexing.
        # Attach an accept filter   
        SO_ATTACH_FILTER = nil #value is unknown, used for indexing.
        # Detach an accept filter   
        SO_DETACH_FILTER = nil #value is unknown, used for indexing.
        # Obtain filter set by SO_ATTACH_FILTER (Linux 3.8)   
        SO_GET_FILTER = nil #value is unknown, used for indexing.
        # Name of the connecting user   
        SO_PEERNAME = nil #value is unknown, used for indexing.
        # Receive timestamp with datagrams (timeval)   
        SO_TIMESTAMP = nil #value is unknown, used for indexing.
        # Receive nanosecond timestamp with datagrams (timespec)   
        SO_TIMESTAMPNS = nil #value is unknown, used for indexing.
        # Receive timestamp with datagrams (bintime)   
        SO_BINTIME = nil #value is unknown, used for indexing.
        # Receive user credentials with datagram   
        SO_RECVUCRED = nil #value is unknown, used for indexing.
        # Mandatory Access Control exemption for unlabeled peers   
        SO_MAC_EXEMPT = nil #value is unknown, used for indexing.
        # Bypass zone boundaries   
        SO_ALLZONES = nil #value is unknown, used for indexing.
        # Obtain the security credentials (Linux 2.6.2)   
        SO_PEERSEC = nil #value is unknown, used for indexing.
        # Toggle security context passing (Linux 2.6.18)   
        SO_PASSSEC = nil #value is unknown, used for indexing.
        # Set the mark for mark-based routing (Linux 2.6.25)   
        SO_MARK = nil #value is unknown, used for indexing.
        # Time stamping of incoming and outgoing packets (Linux 2.6.30)   
        SO_TIMESTAMPING = nil #value is unknown, used for indexing.
        # Protocol given for socket() (Linux 2.6.32)   
        SO_PROTOCOL = nil #value is unknown, used for indexing.
        # Domain given for socket() (Linux 2.6.32)   
        SO_DOMAIN = nil #value is unknown, used for indexing.
        # Toggle cmsg for number of packets dropped (Linux 2.6.33)   
        SO_RXQ_OVFL = nil #value is unknown, used for indexing.
        # Toggle cmsg for wifi status (Linux 3.3)   
        SO_WIFI_STATUS = nil #value is unknown, used for indexing.
        # Set the peek offset (Linux 3.4)   
        SO_PEEK_OFF = nil #value is unknown, used for indexing.
        # Set netns of a socket (Linux 3.4)   
        SO_NOFCS = nil #value is unknown, used for indexing.
        # Lock the filter attached to a socket (Linux 3.9)   
        SO_LOCK_FILTER = nil #value is unknown, used for indexing.
        # Make select() detect socket error queue with errorfds (Linux 3.10)   
        SO_SELECT_ERR_QUEUE = nil #value is unknown, used for indexing.
        # Set the threshold in microseconds for low latency polling (Linux 3.11)   
        SO_BUSY_POLL = nil #value is unknown, used for indexing.
        # Cap the rate computed by transport layer. [bytes per second] (Linux 3.13)   
        SO_MAX_PACING_RATE = nil #value is unknown, used for indexing.
        # Query supported BPF extensions (Linux 3.14)   
        SO_BPF_EXTENSIONS = nil #value is unknown, used for indexing.
        # Interactive socket priority   
        SOPRI_INTERACTIVE = nil #value is unknown, used for indexing.
        # Normal socket priority   
        SOPRI_NORMAL = nil #value is unknown, used for indexing.
        # Background socket priority   
        SOPRI_BACKGROUND = nil #value is unknown, used for indexing.
        IPX_TYPE = nil #value is unknown, used for indexing.
        # Don't delay sending to coalesce packets   
        TCP_NODELAY = nil #value is unknown, used for indexing.
        # Set maximum segment size   
        TCP_MAXSEG = nil #value is unknown, used for indexing.
        # Don't send partial frames (Linux 2.2, glibc 2.2)   
        TCP_CORK = nil #value is unknown, used for indexing.
        # Don't notify a listening socket until data is ready (Linux 2.4, glibc 2.2)   
        TCP_DEFER_ACCEPT = nil #value is unknown, used for indexing.
        # Retrieve information about this socket (Linux 2.4, glibc 2.2)   
        TCP_INFO = nil #value is unknown, used for indexing.
        # Maximum number of keepalive probes allowed before dropping a connection (Linux 2.4, glibc 2.2)   
        TCP_KEEPCNT = nil #value is unknown, used for indexing.
        # Idle time before keepalive probes are sent (Linux 2.4, glibc 2.2)   
        TCP_KEEPIDLE = nil #value is unknown, used for indexing.
        # Time between keepalive probes (Linux 2.4, glibc 2.2)   
        TCP_KEEPINTVL = nil #value is unknown, used for indexing.
        # Lifetime of orphaned FIN_WAIT2 sockets (Linux 2.4, glibc 2.2)   
        TCP_LINGER2 = nil #value is unknown, used for indexing.
        # Use MD5 digests (RFC2385, Linux 2.6.20, glibc 2.7)   
        TCP_MD5SIG = nil #value is unknown, used for indexing.
        # Don't use TCP options   
        TCP_NOOPT = nil #value is unknown, used for indexing.
        # Don't push the last block of write   
        TCP_NOPUSH = nil #value is unknown, used for indexing.
        # Enable quickack mode (Linux 2.4.4, glibc 2.3)   
        TCP_QUICKACK = nil #value is unknown, used for indexing.
        # Number of SYN retransmits before a connection is dropped (Linux 2.4, glibc 2.2)   
        TCP_SYNCNT = nil #value is unknown, used for indexing.
        # Clamp the size of the advertised window (Linux 2.4, glibc 2.2)   
        TCP_WINDOW_CLAMP = nil #value is unknown, used for indexing.
        # Reduce step of the handshake process (Linux 3.7, glibc 2.18)   
        TCP_FASTOPEN = nil #value is unknown, used for indexing.
        # TCP congestion control algorithm (Linux 2.6.13, glibc 2.6)   
        TCP_CONGESTION = nil #value is unknown, used for indexing.
        # TCP Cookie Transactions (Linux 2.6.33, glibc 2.18)   
        TCP_COOKIE_TRANSACTIONS = nil #value is unknown, used for indexing.
        # Sequence of a queue for repair mode (Linux 3.5, glibc 2.18)   
        TCP_QUEUE_SEQ = nil #value is unknown, used for indexing.
        # Repair mode (Linux 3.5, glibc 2.18)   
        TCP_REPAIR = nil #value is unknown, used for indexing.
        # Options for repair mode (Linux 3.5, glibc 2.18)   
        TCP_REPAIR_OPTIONS = nil #value is unknown, used for indexing.
        # Queue for repair mode (Linux 3.5, glibc 2.18)   
        TCP_REPAIR_QUEUE = nil #value is unknown, used for indexing.
        # Duplicated acknowledgments handling for thin-streams (Linux 2.6.34, glibc 2.18)   
        TCP_THIN_DUPACK = nil #value is unknown, used for indexing.
        # Linear timeouts for thin-streams (Linux 2.6.34, glibc 2.18)   
        TCP_THIN_LINEAR_TIMEOUTS = nil #value is unknown, used for indexing.
        # TCP timestamp (Linux 3.9, glibc 2.18)   
        TCP_TIMESTAMP = nil #value is unknown, used for indexing.
        # Max timeout before a TCP connection is aborted (Linux 2.6.37, glibc 2.18)   
        TCP_USER_TIMEOUT = nil #value is unknown, used for indexing.
        # Don't send partial frames (Linux 2.5.44, glibc 2.11)   
        UDP_CORK = nil #value is unknown, used for indexing.
        # Address family for hostname not supported   
        EAI_ADDRFAMILY = nil #value is unknown, used for indexing.
        # Temporary failure in name resolution   
        EAI_AGAIN = nil #value is unknown, used for indexing.
        # Invalid flags   
        EAI_BADFLAGS = nil #value is unknown, used for indexing.
        # Non-recoverable failure in name resolution   
        EAI_FAIL = nil #value is unknown, used for indexing.
        # Address family not supported   
        EAI_FAMILY = nil #value is unknown, used for indexing.
        # Memory allocation failure   
        EAI_MEMORY = nil #value is unknown, used for indexing.
        # No address associated with hostname   
        EAI_NODATA = nil #value is unknown, used for indexing.
        # Hostname nor servname, or not known   
        EAI_NONAME = nil #value is unknown, used for indexing.
        # Argument buffer overflow   
        EAI_OVERFLOW = nil #value is unknown, used for indexing.
        # Servname not supported for socket type   
        EAI_SERVICE = nil #value is unknown, used for indexing.
        # Socket type not supported   
        EAI_SOCKTYPE = nil #value is unknown, used for indexing.
        # System error returned in errno   
        EAI_SYSTEM = nil #value is unknown, used for indexing.
        # Invalid value for hints   
        EAI_BADHINTS = nil #value is unknown, used for indexing.
        # Resolved protocol is unknown   
        EAI_PROTOCOL = nil #value is unknown, used for indexing.
        # Maximum error code from getaddrinfo   
        EAI_MAX = nil #value is unknown, used for indexing.
        # Get address to use with bind()   
        AI_PASSIVE = nil #value is unknown, used for indexing.
        # Fill in the canonical name   
        AI_CANONNAME = nil #value is unknown, used for indexing.
        # Prevent host name resolution   
        AI_NUMERICHOST = nil #value is unknown, used for indexing.
        # Prevent service name resolution   
        AI_NUMERICSERV = nil #value is unknown, used for indexing.
        # Valid flag mask for getaddrinfo (not for application use)   
        AI_MASK = nil #value is unknown, used for indexing.
        # Allow all addresses   
        AI_ALL = nil #value is unknown, used for indexing.
        # Accept IPv4 mapped addresses if the kernel supports it   
        AI_V4MAPPED_CFG = nil #value is unknown, used for indexing.
        # Accept only if any address is assigned   
        AI_ADDRCONFIG = nil #value is unknown, used for indexing.
        # Accept IPv4-mapped IPv6 addresses   
        AI_V4MAPPED = nil #value is unknown, used for indexing.
        # Default flags for getaddrinfo   
        AI_DEFAULT = nil #value is unknown, used for indexing.
        # Maximum length of a hostname   
        NI_MAXHOST = nil #value is unknown, used for indexing.
        # Maximum length of a service name   
        NI_MAXSERV = nil #value is unknown, used for indexing.
        # An FQDN is not required for local hosts, return only the local part   
        NI_NOFQDN = nil #value is unknown, used for indexing.
        # Return a numeric address   
        NI_NUMERICHOST = nil #value is unknown, used for indexing.
        # A name is required   
        NI_NAMEREQD = nil #value is unknown, used for indexing.
        # Return the service name as a digit string   
        NI_NUMERICSERV = nil #value is unknown, used for indexing.
        # The service specified is a datagram service (looks up UDP ports)   
        NI_DGRAM = nil #value is unknown, used for indexing.
        # Shut down the reading side of the socket   
        SHUT_RD = nil #value is unknown, used for indexing.
        # Shut down the writing side of the socket   
        SHUT_WR = nil #value is unknown, used for indexing.
        # Shut down the both sides of the socket   
        SHUT_RDWR = nil #value is unknown, used for indexing.
        # Join a group membership   
        IPV6_JOIN_GROUP = nil #value is unknown, used for indexing.
        # Leave a group membership   
        IPV6_LEAVE_GROUP = nil #value is unknown, used for indexing.
        # IP6 multicast hops   
        IPV6_MULTICAST_HOPS = nil #value is unknown, used for indexing.
        # IP6 multicast interface   
        IPV6_MULTICAST_IF = nil #value is unknown, used for indexing.
        # IP6 multicast loopback   
        IPV6_MULTICAST_LOOP = nil #value is unknown, used for indexing.
        # IP6 unicast hops   
        IPV6_UNICAST_HOPS = nil #value is unknown, used for indexing.
        # Only bind IPv6 with a wildcard bind   
        IPV6_V6ONLY = nil #value is unknown, used for indexing.
        # Checksum offset for raw sockets   
        IPV6_CHECKSUM = nil #value is unknown, used for indexing.
        # Don't fragment packets   
        IPV6_DONTFRAG = nil #value is unknown, used for indexing.
        # Destination option   
        IPV6_DSTOPTS = nil #value is unknown, used for indexing.
        # Hop limit   
        IPV6_HOPLIMIT = nil #value is unknown, used for indexing.
        # Hop-by-hop option   
        IPV6_HOPOPTS = nil #value is unknown, used for indexing.
        # Next hop address   
        IPV6_NEXTHOP = nil #value is unknown, used for indexing.
        # Retrieve current path MTU   
        IPV6_PATHMTU = nil #value is unknown, used for indexing.
        # Receive packet information with datagram   
        IPV6_PKTINFO = nil #value is unknown, used for indexing.
        # Receive all IP6 options for response   
        IPV6_RECVDSTOPTS = nil #value is unknown, used for indexing.
        # Receive hop limit with datagram   
        IPV6_RECVHOPLIMIT = nil #value is unknown, used for indexing.
        # Receive hop-by-hop options   
        IPV6_RECVHOPOPTS = nil #value is unknown, used for indexing.
        # Receive destination IP address and incoming interface   
        IPV6_RECVPKTINFO = nil #value is unknown, used for indexing.
        # Receive routing header   
        IPV6_RECVRTHDR = nil #value is unknown, used for indexing.
        # Receive traffic class   
        IPV6_RECVTCLASS = nil #value is unknown, used for indexing.
        # Allows removal of sticky routing headers   
        IPV6_RTHDR = nil #value is unknown, used for indexing.
        # Allows removal of sticky destination options header   
        IPV6_RTHDRDSTOPTS = nil #value is unknown, used for indexing.
        # Routing header type 0   
        IPV6_RTHDR_TYPE_0 = nil #value is unknown, used for indexing.
        # Receive current path MTU with datagram   
        IPV6_RECVPATHMTU = nil #value is unknown, used for indexing.
        # Specify the traffic class   
        IPV6_TCLASS = nil #value is unknown, used for indexing.
        # Use the minimum MTU size   
        IPV6_USE_MIN_MTU = nil #value is unknown, used for indexing.
        # Maximum length of an IPv4 address string   
        INET_ADDRSTRLEN = nil #value is unknown, used for indexing.
        # Maximum length of an IPv6 address string   
        INET6_ADDRSTRLEN = nil #value is unknown, used for indexing.
        # Maximum interface name size   
        IFNAMSIZ = nil #value is unknown, used for indexing.
        # Maximum interface name size   
        IF_NAMESIZE = nil #value is unknown, used for indexing.
        # Maximum connection requests that may be queued for a socket   
        SOMAXCONN = nil #value is unknown, used for indexing.
        # Access rights   
        SCM_RIGHTS = nil #value is unknown, used for indexing.
        # Timestamp (timeval)   
        SCM_TIMESTAMP = nil #value is unknown, used for indexing.
        # Timespec (timespec)   
        SCM_TIMESTAMPNS = nil #value is unknown, used for indexing.
        # Timestamp (timespec list) (Linux 2.6.30)   
        SCM_TIMESTAMPING = nil #value is unknown, used for indexing.
        # Timestamp (bintime)   
        SCM_BINTIME = nil #value is unknown, used for indexing.
        # The sender's credentials   
        SCM_CREDENTIALS = nil #value is unknown, used for indexing.
        # Process credentials   
        SCM_CREDS = nil #value is unknown, used for indexing.
        # User credentials   
        SCM_UCRED = nil #value is unknown, used for indexing.
        # Wifi status (Linux 3.3)   
        SCM_WIFI_STATUS = nil #value is unknown, used for indexing.
        # Retrieve peer credentials   
        LOCAL_PEERCRED = nil #value is unknown, used for indexing.
        # Pass credentials to receiver   
        LOCAL_CREDS = nil #value is unknown, used for indexing.
        # Connect blocks until accepted   
        LOCAL_CONNWAIT = nil #value is unknown, used for indexing.
        # 802.1Q VLAN device   
        IFF_802_1Q_VLAN = nil #value is unknown, used for indexing.
        # receive all multicast packets   
        IFF_ALLMULTI = nil #value is unknown, used for indexing.
        # use alternate physical connection   
        IFF_ALTPHYS = nil #value is unknown, used for indexing.
        # auto media select active   
        IFF_AUTOMEDIA = nil #value is unknown, used for indexing.
        # bonding master or slave   
        IFF_BONDING = nil #value is unknown, used for indexing.
        # device used as bridge port   
        IFF_BRIDGE_PORT = nil #value is unknown, used for indexing.
        # broadcast address valid   
        IFF_BROADCAST = nil #value is unknown, used for indexing.
        # unconfigurable using ioctl(2)   
        IFF_CANTCONFIG = nil #value is unknown, used for indexing.
        # turn on debugging   
        IFF_DEBUG = nil #value is unknown, used for indexing.
        # disable netpoll at run-time   
        IFF_DISABLE_NETPOLL = nil #value is unknown, used for indexing.
        # disallow bridging this ether dev   
        IFF_DONT_BRIDGE = nil #value is unknown, used for indexing.
        # driver signals dormant   
        IFF_DORMANT = nil #value is unknown, used for indexing.
        # tx hardware queue is full   
        IFF_DRV_OACTIVE = nil #value is unknown, used for indexing.
        # resources allocated   
        IFF_DRV_RUNNING = nil #value is unknown, used for indexing.
        # interface is winding down   
        IFF_DYING = nil #value is unknown, used for indexing.
        # dialup device with changing addresses   
        IFF_DYNAMIC = nil #value is unknown, used for indexing.
        # ethernet bridging device   
        IFF_EBRIDGE = nil #value is unknown, used for indexing.
        # echo sent packets   
        IFF_ECHO = nil #value is unknown, used for indexing.
        # ISATAP interface (RFC4214)   
        IFF_ISATAP = nil #value is unknown, used for indexing.
        # per link layer defined bit 0   
        IFF_LINK0 = nil #value is unknown, used for indexing.
        # per link layer defined bit 1   
        IFF_LINK1 = nil #value is unknown, used for indexing.
        # per link layer defined bit 2   
        IFF_LINK2 = nil #value is unknown, used for indexing.
        # hardware address change when it's running   
        IFF_LIVE_ADDR_CHANGE = nil #value is unknown, used for indexing.
        # loopback net   
        IFF_LOOPBACK = nil #value is unknown, used for indexing.
        # driver signals L1 up   
        IFF_LOWER_UP = nil #value is unknown, used for indexing.
        # device used as macvlan port   
        IFF_MACVLAN_PORT = nil #value is unknown, used for indexing.
        # master of a load balancer   
        IFF_MASTER = nil #value is unknown, used for indexing.
        # bonding master, 802.3ad.   
        IFF_MASTER_8023AD = nil #value is unknown, used for indexing.
        # bonding master, balance-alb.   
        IFF_MASTER_ALB = nil #value is unknown, used for indexing.
        # bonding master, ARP mon in use   
        IFF_MASTER_ARPMON = nil #value is unknown, used for indexing.
        # user-requested monitor mode   
        IFF_MONITOR = nil #value is unknown, used for indexing.
        # supports multicast   
        IFF_MULTICAST = nil #value is unknown, used for indexing.
        # no address resolution protocol   
        IFF_NOARP = nil #value is unknown, used for indexing.
        # avoid use of trailers   
        IFF_NOTRAILERS = nil #value is unknown, used for indexing.
        # transmission in progress   
        IFF_OACTIVE = nil #value is unknown, used for indexing.
        # device used as Open vSwitch datapath port   
        IFF_OVS_DATAPATH = nil #value is unknown, used for indexing.
        # point-to-point link   
        IFF_POINTOPOINT = nil #value is unknown, used for indexing.
        # can set media type   
        IFF_PORTSEL = nil #value is unknown, used for indexing.
        # user-requested promisc mode   
        IFF_PPROMISC = nil #value is unknown, used for indexing.
        # receive all packets   
        IFF_PROMISC = nil #value is unknown, used for indexing.
        # interface is being renamed   
        IFF_RENAMING = nil #value is unknown, used for indexing.
        # routing entry installed   
        IFF_ROUTE = nil #value is unknown, used for indexing.
        # resources allocated   
        IFF_RUNNING = nil #value is unknown, used for indexing.
        # can't hear own transmissions   
        IFF_SIMPLEX = nil #value is unknown, used for indexing.
        # slave of a load balancer   
        IFF_SLAVE = nil #value is unknown, used for indexing.
        # bonding slave not the curr. active   
        IFF_SLAVE_INACTIVE = nil #value is unknown, used for indexing.
        # need ARPs for validation   
        IFF_SLAVE_NEEDARP = nil #value is unknown, used for indexing.
        # interface manages own routes   
        IFF_SMART = nil #value is unknown, used for indexing.
        # static ARP   
        IFF_STATICARP = nil #value is unknown, used for indexing.
        # sending custom FCS   
        IFF_SUPP_NOFCS = nil #value is unknown, used for indexing.
        # used as team port   
        IFF_TEAM_PORT = nil #value is unknown, used for indexing.
        # sharing skbs on transmit   
        IFF_TX_SKB_SHARING = nil #value is unknown, used for indexing.
        # unicast filtering   
        IFF_UNICAST_FLT = nil #value is unknown, used for indexing.
        # interface is up   
        IFF_UP = nil #value is unknown, used for indexing.
        # WAN HDLC device   
        IFF_WAN_HDLC = nil #value is unknown, used for indexing.
        # dev_hard_start_xmit() is allowed to release skb->dst   
        IFF_XMIT_DST_RELEASE = nil #value is unknown, used for indexing.
        # volatile flags   
        IFF_VOLATILE = nil #value is unknown, used for indexing.
        # flags not changeable   
        IFF_CANTCHANGE = nil #value is unknown, used for indexing.
    end
    # Socket::Ifaddr represents a result of getifaddrs() function.
    class Ifaddr < Data
        # ifaddr.inspect => string
        # 
        # Returns a string to show contents of _ifaddr_.
        def inspect()
            #This is a stub, used for indexing
        end
        # ifaddr.name => string
        # 
        # Returns the interface name of _ifaddr_.
        def name()
            #This is a stub, used for indexing
        end
        # ifaddr.ifindex => integer
        # 
        # Returns the interface index of _ifaddr_.
        def ifindex()
            #This is a stub, used for indexing
        end
        # ifaddr.flags => integer
        # 
        # Returns the flags of _ifaddr_.
        def flags()
            #This is a stub, used for indexing
        end
        # ifaddr.addr => addrinfo
        # 
        # Returns the address of _ifaddr_.
        # nil is returned if address is not available in _ifaddr_.
        def addr()
            #This is a stub, used for indexing
        end
        # ifaddr.netmask => addrinfo
        # 
        # Returns the netmask address of _ifaddr_.
        # nil is returned if netmask is not available in _ifaddr_.
        def netmask()
            #This is a stub, used for indexing
        end
        # ifaddr.broadaddr => addrinfo
        # 
        # Returns the broadcast address of _ifaddr_.
        # nil is returned if the flags doesn't have IFF_BROADCAST.
        def broadaddr()
            #This is a stub, used for indexing
        end
        # ifaddr.dstaddr => addrinfo
        # 
        # Returns the destination address of _ifaddr_.
        # nil is returned if the flags doesn't have IFF_POINTOPOINT.
        def dstaddr()
            #This is a stub, used for indexing
        end
        # ifaddr.vhid => Integer
        # 
        # Returns the vhid address of _ifaddr_.
        # nil is returned if there is no vhid.
        def vhid()
            #This is a stub, used for indexing
        end
    end
    # Socket::Option represents a socket option used by
    # BasicSocket#getsockopt and BasicSocket#setsockopt.  A socket option
    # contains the socket #family, protocol #level, option name #optname and
    # option value #data.
    class Option
        # Socket::Option.new(family, level, optname, data) => sockopt
        # 
        # Returns a new Socket::Option object.
        # 
        #   sockopt = Socket::Option.new(:INET, :SOCKET, :KEEPALIVE, [1].pack("i"))
        #   p sockopt #=> #<Socket::Option: INET SOCKET KEEPALIVE 1>
        def initialize(family, level, optname, data)
            #This is a stub, used for indexing
        end
        # sockopt.family => integer
        # 
        # returns the socket family as an integer.
        # 
        #   p Socket::Option.new(:INET6, :IPV6, :RECVPKTINFO, [1].pack("i!")).family
        #   #=> 10
        def family()
            #This is a stub, used for indexing
        end
        # sockopt.level => integer
        # 
        # returns the socket level as an integer.
        # 
        #   p Socket::Option.new(:INET6, :IPV6, :RECVPKTINFO, [1].pack("i!")).level
        #   #=> 41
        def level()
            #This is a stub, used for indexing
        end
        # sockopt.optname => integer
        # 
        # returns the socket option name as an integer.
        # 
        #   p Socket::Option.new(:INET6, :IPV6, :RECVPKTINFO, [1].pack("i!")).optname
        #   #=> 2
        def optname()
            #This is a stub, used for indexing
        end
        # sockopt.data => string
        # 
        # returns the socket option data as a string.
        # 
        #   p Socket::Option.new(:INET6, :IPV6, :RECVPKTINFO, [1].pack("i!")).data
        #   #=> "\x01\x00\x00\x00"
        def data()
            #This is a stub, used for indexing
        end
        # sockopt.inspect => string
        # 
        # Returns a string which shows sockopt in human-readable form.
        # 
        #   p Socket::Option.new(:INET, :SOCKET, :KEEPALIVE, [1].pack("i")).inspect
        #   #=> "#<Socket::Option: INET SOCKET KEEPALIVE 1>"
        def inspect()
            #This is a stub, used for indexing
        end
        # Socket::Option.int(family, level, optname, integer) => sockopt
        # 
        # Creates a new Socket::Option object which contains an int as data.
        # 
        # The size and endian is dependent on the platform.
        # 
        #   p Socket::Option.int(:INET, :SOCKET, :KEEPALIVE, 1)
        #   #=> #<Socket::Option: INET SOCKET KEEPALIVE 1>
        def self.int(family, level, optname, integer)
            #This is a stub, used for indexing
        end
        # sockopt.int => integer
        # 
        # Returns the data in _sockopt_ as an int.
        # 
        # The size and endian is dependent on the platform.
        # 
        #   sockopt = Socket::Option.int(:INET, :SOCKET, :KEEPALIVE, 1)
        #   p sockopt.int => 1
        def int()
            #This is a stub, used for indexing
        end
        # Socket::Option.byte(family, level, optname, integer) => sockopt
        # 
        # Creates a new Socket::Option object which contains a byte as data.
        # 
        #   p Socket::Option.byte(:INET, :SOCKET, :KEEPALIVE, 1)
        #   #=> #<Socket::Option: INET SOCKET KEEPALIVE 1>
        def self.byte(family, level, optname, integer)
            #This is a stub, used for indexing
        end
        # sockopt.byte => integer
        # 
        # Returns the data in _sockopt_ as an byte.
        # 
        #   sockopt = Socket::Option.byte(:INET, :SOCKET, :KEEPALIVE, 1)
        #   p sockopt.byte => 1
        def byte()
            #This is a stub, used for indexing
        end
        # Socket::Option.bool(family, level, optname, bool) => sockopt
        # 
        # Creates a new Socket::Option object which contains boolean as data.
        # Actually 0 or 1 as int is used.
        # 
        #   require 'socket'
        # 
        #   p Socket::Option.bool(:INET, :SOCKET, :KEEPALIVE, true)
        #   #=> #<Socket::Option: INET SOCKET KEEPALIVE 1>
        # 
        #   p Socket::Option.bool(:INET, :SOCKET, :KEEPALIVE, false)
        #   #=> #<Socket::Option: AF_INET SOCKET KEEPALIVE 0>
        def self.bool(family, level, optname, bool)
            #This is a stub, used for indexing
        end
        # sockopt.bool => true or false
        # 
        # Returns the data in _sockopt_ as an boolean value.
        # 
        #   sockopt = Socket::Option.int(:INET, :SOCKET, :KEEPALIVE, 1)
        #   p sockopt.bool => true
        def bool()
            #This is a stub, used for indexing
        end
        # Socket::Option.linger(onoff, secs) => sockopt
        # 
        # Creates a new Socket::Option object for SOL_SOCKET/SO_LINGER.
        # 
        # _onoff_ should be an integer or a boolean.
        # 
        # _secs_ should be the number of seconds.
        # 
        #   p Socket::Option.linger(true, 10)
        #   #=> #<Socket::Option: UNSPEC SOCKET LINGER on 10sec>
        def self.linger(onoff, secs)
            #This is a stub, used for indexing
        end
        # sockopt.linger => [bool, seconds]
        # 
        # Returns the linger data in _sockopt_ as a pair of boolean and integer.
        # 
        #   sockopt = Socket::Option.linger(true, 10)
        #   p sockopt.linger => [true, 10]
        def linger()
            #This is a stub, used for indexing
        end
        # Socket::Option.ipv4_multicast_ttl(integer) => sockopt
        # 
        # Creates a new Socket::Option object for IP_MULTICAST_TTL.
        # 
        # The size is dependent on the platform.
        # 
        #   p Socket::Option.ipv4_multicast_ttl(10)
        #   #=> #<Socket::Option: INET IP MULTICAST_TTL 10>
        def self.ipv4_multicast_ttl(integer)
            #This is a stub, used for indexing
        end
        # sockopt.ipv4_multicast_ttl => integer
        # 
        # Returns the ipv4_multicast_ttl data in _sockopt_ as an integer.
        # 
        #   sockopt = Socket::Option.ipv4_multicast_ttl(10)
        #   p sockopt.ipv4_multicast_ttl => 10
        def ipv4_multicast_ttl()
            #This is a stub, used for indexing
        end
        # Socket::Option.ipv4_multicast_loop(integer) => sockopt
        # 
        # Creates a new Socket::Option object for IP_MULTICAST_LOOP.
        # 
        # The size is dependent on the platform.
        # 
        #   sockopt = Socket::Option.int(:INET, :IPPROTO_IP, :IP_MULTICAST_LOOP, 1)
        #   p sockopt.int => 1
        # 
        #   p Socket::Option.ipv4_multicast_loop(10)
        #   #=> #<Socket::Option: INET IP MULTICAST_LOOP 10>
        def self.ipv4_multicast_loop(integer)
            #This is a stub, used for indexing
        end
        # sockopt.ipv4_multicast_loop => integer
        # 
        # Returns the ipv4_multicast_loop data in _sockopt_ as an integer.
        # 
        #   sockopt = Socket::Option.ipv4_multicast_loop(10)
        #   p sockopt.ipv4_multicast_loop => 10
        def ipv4_multicast_loop()
            #This is a stub, used for indexing
        end
        # sockopt.unpack(template) => array
        # 
        # Calls String#unpack on sockopt.data.
        # 
        #   sockopt = Socket::Option.new(:INET, :SOCKET, :KEEPALIVE, [1].pack("i"))
        #   p sockopt.unpack("i")      #=> [1]
        #   p sockopt.data.unpack("i") #=> [1]
        def unpack(template)
            #This is a stub, used for indexing
        end
        # sockopt.to_s => string
        # 
        # returns the socket option data as a string.
        # 
        #   p Socket::Option.new(:INET6, :IPV6, :RECVPKTINFO, [1].pack("i!")).data
        #   #=> "\x01\x00\x00\x00"
        def to_s()
            #This is a stub, used for indexing
        end
    end
end
