/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.ListCast;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.StringComparator;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.TypedTreeMap;

public class MacroExpander {
    private static final String MACRO = "Macro:";
    private Map macros = new TypedTreeMap(StringComparator.instance, (Cast)StringCast.instance, (Cast)ListCast.instance);

    public MacroExpander(Reader in) throws IOException {
        BufferedReader br = new BufferedReader(in);
        while (this.readInMacro(br)) {
        }
        in.close();
    }

    private boolean readInMacro(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (!line.startsWith(MACRO)) continue;
            String name = line.substring(MACRO.length());
            TypedLinkedList macro = new TypedLinkedList(StringCast.instance);
            while ((line = in.readLine()) != null) {
                if (line.equals("$")) {
                    this.macros.put(name, macro);
                    return true;
                }
                macro.add(line);
            }
            this.macros.put(name, macro);
            return false;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + this.macros;
    }

    public void apply(BufferedWriter out, String macroName) throws IOException {
        this.apply(out, macroName, null);
    }

    public void apply(BufferedWriter out, String macroName, String[] arguments) throws IOException {
        List macro = (List)this.macros.get(macroName);
        ListIterator li = macro.listIterator();
        while (li.hasNext()) {
            if (li.nextIndex() != 0) {
                out.newLine();
            }
            String line = (String)li.next();
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                if (c == '$') {
                    StringBuffer index = new StringBuffer();
                    while ((c = line.charAt(++i)) != '$') {
                        index.append(c);
                    }
                    if (index.length() == 0) {
                        out.write(36);
                        continue;
                    }
                    out.write(arguments[Integer.parseInt(index.toString())]);
                    continue;
                }
                out.write(c);
            }
        }
    }
}

