/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.List;
import javax.imageio.metadata.IIOMetadata;

public class IIOImage {
    protected RenderedImage image;
    protected IIOMetadata metadata;
    protected Raster raster;
    protected List thumbnails;

    public IIOMetadata getMetadata() {
        return this.metadata;
    }

    public int getNumThumbnails() {
        int n = 0;
        if (this.thumbnails != null) {
            n = this.thumbnails.size();
        }
        return n;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    public BufferedImage getThumbnail(int index) {
        return (BufferedImage)this.thumbnails.get(index);
    }

    public List getThumbnails() {
        return this.thumbnails;
    }

    public boolean hasRaster() {
        boolean bl = false;
        if (this.raster != null) {
            bl = true;
        }
        return bl;
    }

    public void setMetadata(IIOMetadata metadata) {
        this.metadata = metadata;
    }

    public void setRaster(Raster raster) {
        if (raster == null) {
            throw new IllegalArgumentException("raster may not be null");
        }
        this.image = null;
        this.raster = raster;
    }

    public void setRenderedImage(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("image may not be null");
        }
        this.image = image;
        this.raster = null;
    }

    public void setThumbnails(List thumbnails) {
        this.thumbnails = thumbnails;
    }

    public IIOImage(Raster raster, List thumbnails, IIOMetadata metadata) {
        if (raster == null) {
            throw new IllegalArgumentException("raster may not be null");
        }
        this.raster = raster;
        this.thumbnails = thumbnails;
        this.metadata = metadata;
    }

    public IIOImage(RenderedImage image, List thumbnails, IIOMetadata metadata) {
        if (image == null) {
            throw new IllegalArgumentException("image may not be null");
        }
        this.image = image;
        this.thumbnails = thumbnails;
        this.metadata = metadata;
    }
}

