/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.fife.ui.WebLookAndFeelUtils;

public class CustomizableToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    private JPopupMenu popupMenu;
    private JMenu addRemoveMenu;
    private MouseInputAdapter mia;
    private boolean showText;
    private static final String MSG = "org.fife.ui.CustomizableToolBar";

    public CustomizableToolBar() {
    }

    public CustomizableToolBar(int orientation) {
        super(orientation);
    }

    public CustomizableToolBar(String name) {
        super(name);
    }

    public CustomizableToolBar(String name, int orientation) {
        super(name, orientation);
    }

    public void addNotify() {
        super.addNotify();
        if (WebLookAndFeelUtils.isWebLookAndFeelInstalled()) {
            WebLookAndFeelUtils.fixToolbarButtons(this);
        }
    }

    protected JButton createButton(Action a) {
        JButton b = new JButton(a);
        b.setToolTipText((String)a.getValue("Name"));
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        if (this.showText) {
            b.setText((String)a.getValue("Name"));
        } else {
            b.setText(null);
        }
        String desc = (String)a.getValue("ShortDescription");
        if (desc != null) {
            b.getAccessibleContext().setAccessibleDescription(desc);
        }
        return b;
    }

    private void createPopupMenu() {
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        this.popupMenu = new JPopupMenu();
        String temp = msg.getString("PopupMenu.LockToolbar.txt");
        LockAction lockAction = new LockAction(temp);
        JCheckBoxMenuItem lockMenuItem = new JCheckBoxMenuItem(lockAction);
        lockMenuItem.setMnemonic(76);
        this.popupMenu.add(lockMenuItem);
        this.popupMenu.addSeparator();
        temp = msg.getString("PopupMenu.AddRemoveButtons.txt");
        this.addRemoveMenu = new JMenu(temp);
        this.addRemoveMenu.setMnemonic(65);
        this.populateAddRemovePopupMenu(msg);
        this.popupMenu.add(this.addRemoveMenu);
    }

    public boolean getShowText() {
        return this.showText;
    }

    public void makeCustomizable() {
        int i;
        if (this.mia != null) {
            this.removeMouseListener(this.mia);
            for (i = 0; i < this.getComponentCount(); ++i) {
                this.getComponentAtIndex(i).removeMouseListener(this.mia);
            }
        }
        this.mia = new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            public void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    if (CustomizableToolBar.this.popupMenu == null) {
                        CustomizableToolBar.this.createPopupMenu();
                    }
                    CustomizableToolBar.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                }
            }
        };
        this.addMouseListener(this.mia);
        for (i = 0; i < this.getComponentCount(); ++i) {
            this.getComponentAtIndex(i).addMouseListener(this.mia);
        }
    }

    protected void populateAddRemovePopupMenu(ResourceBundle msg) {
        JPopupMenu popupMenu = this.addRemoveMenu.getPopupMenu();
        popupMenu.removeAll();
        Component[] components = this.getComponents();
        int num = components.length;
        for (int i = 0; i < num; ++i) {
            if (!(components[i] instanceof JButton)) continue;
            final JButton button = (JButton)components[i];
            String title = button.getText();
            if (title == null) {
                title = button.getToolTipText();
            }
            if (title == null) {
                title = msg.getString("PopupMenu.Unknown.txt");
            }
            JCheckBoxMenuItem cbMenuItem = new JCheckBoxMenuItem(new AbstractAction(title){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent e) {
                    button.setVisible(!button.isVisible());
                    CustomizableToolBar.this.repaint();
                }
            });
            cbMenuItem.setSelected(button.isVisible());
            popupMenu.add(cbMenuItem);
        }
        popupMenu.addSeparator();
        String temp = msg.getString("PopupMenu.ResetToolBar.txt");
        ResetAction resetAction = new ResetAction(temp);
        popupMenu.add(new JMenuItem(resetAction));
    }

    public void setShowText(boolean show) {
        this.showText = show;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JMenuItem mi;
            Component c = this.getComponent(i);
            if (!(c instanceof JMenuItem) || (mi = (JMenuItem)c).getAction() == null) continue;
            String text = show ? (String)mi.getAction().getValue("Name") : null;
            mi.setText(text);
        }
    }

    public void setUI(ToolBarUI ui) {
        super.setUI(ui);
        if (WebLookAndFeelUtils.isWebLookAndFeelInstalled()) {
            WebLookAndFeelUtils.fixToolbarButtons(this);
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
        }
    }

    private class ResetAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ResetAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            Component[] c = CustomizableToolBar.this.getComponents();
            int num = c.length;
            for (int i = 0; i < num; ++i) {
                if (!(c[i] instanceof JButton)) continue;
                c[i].setVisible(true);
            }
        }
    }

    private class LockAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LockAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            ToolBarUI ui = CustomizableToolBar.this.getUI();
            if (ui instanceof BasicToolBarUI) {
                boolean floating = ((BasicToolBarUI)ui).isFloating();
                if (floating) {
                    ((BasicToolBarUI)ui).setFloating(false, new Point(0, 0));
                    CustomizableToolBar.this.setFloatable(false);
                } else {
                    CustomizableToolBar.this.setFloatable(!CustomizableToolBar.this.isFloatable());
                }
            } else {
                CustomizableToolBar cbt;
                cbt.setFloatable(!(cbt = CustomizableToolBar.this).isFloatable());
            }
        }
    }
}

