/*
 * Decompiled with CFR 0.152.
 */
package writer2latex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.OfficeDocument;
import org.openoffice.xmerge.converter.xml.sxc.SxcDocument;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import writer2latex.bibtex.DocumentSerializerImpl;
import writer2latex.latex.ConverterPalette;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.xmerge.SxiDocument;

public final class Application {
    private static final String VERSION = "0.4 beta2";
    private static final String DATE = "2004-12-29";
    private String sOutputFormat = null;
    private String toMime = null;
    private String sFileName = null;
    private String sOutPathName = null;
    private String sOutFileName = null;
    private String sConfigFileName = null;
    Config config;

    public static String getVersion() {
        return VERSION;
    }

    public static String getDate() {
        return DATE;
    }

    public static final void main(String[] args) {
        try {
            Application app = new Application();
            app.parseCommandLine(args);
            System.out.println("Starting conversion...");
            app.doConversion();
            System.out.println("Done!");
        }
        catch (IllegalArgumentException ex) {
            String msg = ex.getMessage();
            Application.showUsage(msg);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg != null) {
                System.out.println("\n" + msg);
            }
            ex.printStackTrace();
        }
    }

    private void doConversion() {
        boolean bFlat = this.sFileName.toLowerCase().endsWith(".xml");
        boolean bCalc = this.sFileName.toLowerCase().endsWith(".sxc");
        boolean bImpress = this.sFileName.toLowerCase().endsWith(".sxi");
        ConvertData dataOut = null;
        OfficeDocument oooDoc = bCalc ? new SxcDocument(this.sFileName) : (bImpress ? new SxiDocument(this.sFileName) : new SxwDocument(this.sFileName));
        File f = new File(this.sFileName);
        try {
            if (!f.exists()) {
                System.out.println("I'm sorry, I can't find " + this.sFileName);
                System.exit(0);
            }
            FileInputStream fis = new FileInputStream(f);
            oooDoc.read(fis, !bFlat);
        }
        catch (IOException e) {
            System.out.println("Oops, there was an error reading " + this.sFileName);
            e.printStackTrace();
        }
        try {
            Object converter;
            if (this.toMime.equals("application/x-latex")) {
                converter = new ConverterPalette((SxwDocument)oooDoc, this.sConfigFileName);
                ((ConverterPalette)converter).setOutFileName(this.sOutFileName);
                dataOut = ((ConverterPalette)converter).convert();
            } else if (this.toMime.equals("application/x-bibtex")) {
                converter = new DocumentSerializerImpl((SxwDocument)oooDoc);
                ((DocumentSerializerImpl)converter).setOutFileName(this.sOutFileName);
                dataOut = ((DocumentSerializerImpl)converter).serialize();
            } else if (this.toMime.equals("text/html")) {
                converter = new writer2latex.xhtml.DocumentSerializerImpl(oooDoc, 0, this.sConfigFileName);
                ((writer2latex.xhtml.DocumentSerializerImpl)converter).setOutFileName(this.sOutFileName);
                dataOut = ((writer2latex.xhtml.DocumentSerializerImpl)converter).serialize();
            } else if (this.toMime.equals("application/xhtml+xml")) {
                converter = new writer2latex.xhtml.DocumentSerializerImpl(oooDoc, 2, this.sConfigFileName);
                ((writer2latex.xhtml.DocumentSerializerImpl)converter).setOutFileName(this.sOutFileName);
                dataOut = ((writer2latex.xhtml.DocumentSerializerImpl)converter).serialize();
            } else if (this.toMime.equals("application/xml")) {
                converter = new writer2latex.xhtml.DocumentSerializerImpl(oooDoc, 3, this.sConfigFileName);
                ((writer2latex.xhtml.DocumentSerializerImpl)converter).setOutFileName(this.sOutFileName);
                dataOut = ((writer2latex.xhtml.DocumentSerializerImpl)converter).serialize();
            }
        }
        catch (Exception e) {
            System.out.println("Conversion failed");
            e.printStackTrace();
        }
        File dir = new File(this.sOutPathName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Enumeration docEnum = dataOut.getDocumentEnumeration();
        while (docEnum.hasMoreElements()) {
            Document docOut = (Document)docEnum.nextElement();
            String fileName = this.sOutPathName + docOut.getFileName();
            try {
                FileOutputStream fos = new FileOutputStream(fileName);
                docOut.write(fos);
                fos.flush();
                fos.close();
            }
            catch (Exception writeExcept) {
                System.out.println("\nThere was an error writing out file <" + fileName + ">");
                writeExcept.printStackTrace();
            }
        }
    }

    private static void showUsage(String msg) {
        System.out.println();
        System.out.println("This is Writer2LaTeX, Version 0.4 beta2 (2004-12-29)");
        System.out.println();
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println();
        System.out.println("Usage:");
        System.out.println("   java -jar <path>/writer2latex.jar <options> <document> [<output path/file name>]");
        System.out.println("where <options> is one of the following:");
        System.out.println("   [-latex] [-config <configuration file>]");
        System.out.println("   -bibtex");
        System.out.println("   -xhtml [-config <configuration file>]");
        System.out.println("   -xhtml+mathml [-config <configuration file>]");
        System.out.println("   -xhtml+mathml+xsl [-config <configuration file>]");
    }

    private void parseCommandLine(String[] args) throws IllegalArgumentException {
        String sFullOutFileName;
        if (args.length == 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        String sArg = this.getArg(i, args);
        if ("-xhtml".equals(sArg)) {
            this.sOutputFormat = "xhtml";
            this.toMime = "text/html";
            ++i;
        } else if ("-xhtml+mathml".equals(sArg)) {
            this.sOutputFormat = "xhtml";
            this.toMime = "application/xhtml+xml";
            ++i;
        } else if ("-xhtml+mathml+xsl".equals(sArg)) {
            this.sOutputFormat = "xhtml";
            this.toMime = "application/xml";
            ++i;
        } else if ("-bibtex".equals(sArg)) {
            this.sOutputFormat = "BibTeX";
            this.toMime = "application/x-bibtex";
            ++i;
        } else if ("-latex".equals(sArg)) {
            this.sOutputFormat = "LaTeX";
            this.toMime = "application/x-latex";
            ++i;
        } else {
            this.sOutputFormat = "LaTeX";
            this.toMime = "application/x-latex";
        }
        sArg = this.getArg(i, args);
        if ("-config".equals(sArg)) {
            int n = ++i;
            this.sConfigFileName = this.getArg(n, args);
        }
        int n = ++i;
        this.sFileName = this.getArg(n, args);
        if ((sFullOutFileName = ++i < args.length ? this.getArg(i, args) : Misc.removeExtension(this.sFileName)).endsWith(File.separator)) {
            this.sOutPathName = sFullOutFileName;
            this.sOutFileName = new File(this.sFileName).getName();
        } else {
            File f = new File(sFullOutFileName);
            this.sOutPathName = f.getParent();
            this.sOutPathName = this.sOutPathName == null ? "" : this.sOutPathName + File.separator;
            this.sOutFileName = f.getName();
        }
        this.sOutFileName = Misc.removeExtension(this.sOutFileName);
        System.out.println();
        System.out.println("This is Writer2" + this.sOutputFormat + ", Version " + VERSION + " (" + DATE + ")");
        System.out.println();
    }

    private String getArg(int i, String[] args) throws IllegalArgumentException {
        if (i < args.length) {
            return args[i];
        }
        throw new IllegalArgumentException("I'm sorry, the commandline ended abnormally");
    }

    static {
        VERSION = VERSION;
        DATE = DATE;
    }
}

