/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.Reader;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.impl.JsonNumericParserBase;
import org.codehaus.jackson.io.IOContext;

public abstract class ReaderBasedParserBase
extends JsonNumericParserBase {
    protected Reader _reader;
    protected char[] _inputBuffer;

    protected ReaderBasedParserBase(IOContext iOContext, int n, Reader reader) {
        super(iOContext, n);
        this._reader = reader;
        this._inputBuffer = iOContext.allocTokenBuffer();
    }

    protected final boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        if (this._reader != null) {
            int n = this._reader.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n > 0) {
                this._inputPtr = 0;
                this._inputEnd = n;
                return true;
            }
            this._closeInput();
            if (n == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
            }
        }
        return false;
    }

    protected char getNextChar(String string) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(string);
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected void _closeInput() throws IOException {
        if (this._reader != null) {
            if (this._ioContext.isResourceManaged() || this.isFeatureEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._reader.close();
            }
            this._reader = null;
        }
    }

    protected void _releaseBuffers() throws IOException {
        super._releaseBuffers();
        char[] cArray = this._inputBuffer;
        if (cArray != null) {
            this._inputBuffer = null;
            this._ioContext.releaseTokenBuffer(cArray);
        }
    }
}

