/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.CreateKeyspaceStatement;
import org.apache.cassandra.cql3.statements.CreateTableStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.StressYaml;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.RatioDistributionFactory;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.generate.TokenRangeIterator;
import org.apache.cassandra.stress.generate.values.BigDecimals;
import org.apache.cassandra.stress.generate.values.BigIntegers;
import org.apache.cassandra.stress.generate.values.Booleans;
import org.apache.cassandra.stress.generate.values.Bytes;
import org.apache.cassandra.stress.generate.values.Dates;
import org.apache.cassandra.stress.generate.values.Doubles;
import org.apache.cassandra.stress.generate.values.Floats;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;
import org.apache.cassandra.stress.generate.values.Inets;
import org.apache.cassandra.stress.generate.values.Integers;
import org.apache.cassandra.stress.generate.values.Lists;
import org.apache.cassandra.stress.generate.values.LocalDates;
import org.apache.cassandra.stress.generate.values.Longs;
import org.apache.cassandra.stress.generate.values.Sets;
import org.apache.cassandra.stress.generate.values.SmallInts;
import org.apache.cassandra.stress.generate.values.Strings;
import org.apache.cassandra.stress.generate.values.TimeUUIDs;
import org.apache.cassandra.stress.generate.values.Times;
import org.apache.cassandra.stress.generate.values.TinyInts;
import org.apache.cassandra.stress.generate.values.UUIDs;
import org.apache.cassandra.stress.operations.userdefined.SchemaInsert;
import org.apache.cassandra.stress.operations.userdefined.SchemaQuery;
import org.apache.cassandra.stress.operations.userdefined.TokenRangeQuery;
import org.apache.cassandra.stress.operations.userdefined.ValidatingSchemaQuery;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.ConnectionAPI;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionRatioDistribution;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JavaDriverClient;
import org.apache.cassandra.stress.util.ResultLogger;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ThriftConversion;
import org.apache.thrift.TException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;

public class StressProfile
implements Serializable {
    private String keyspaceCql;
    private String tableCql;
    private List<String> extraSchemaDefinitions;
    public final String seedStr = "seed for stress";
    public String keyspaceName;
    public String tableName;
    private Map<String, GeneratorConfig> columnConfigs;
    private Map<String, StressYaml.QueryDef> queries;
    public Map<String, StressYaml.TokenRangeQueryDef> tokenRangeQueries;
    private Map<String, String> insert;
    private boolean schemaCreated = false;
    volatile transient TableMetadata tableMetaData;
    volatile transient Set<TokenRange> tokenRanges;
    volatile transient GeneratorFactory generatorFactory;
    volatile transient BatchStatement.Type batchType;
    volatile transient DistributionFactory partitions;
    volatile transient RatioDistributionFactory selectchance;
    volatile transient RatioDistributionFactory rowPopulation;
    volatile transient PreparedStatement insertStatement;
    volatile transient Integer thriftInsertId;
    volatile transient List<ValidatingSchemaQuery.Factory> validationFactories;
    volatile transient Map<String, SchemaQuery.ArgSelect> argSelects;
    volatile transient Map<String, PreparedStatement> queryStatements;
    volatile transient Map<String, Integer> thriftQueryIds;
    private static final Pattern lowercaseAlphanumeric = Pattern.compile("[a-z0-9_]+");

    public void printSettings(ResultLogger out, StressSettings stressSettings) {
        out.printf("  Keyspace Name: %s%n", this.keyspaceName);
        out.printf("  Keyspace CQL: %n***%n%s***%n%n", this.keyspaceCql);
        out.printf("  Table Name: %s%n", this.tableName);
        out.printf("  Table CQL: %n***%n%s***%n%n", this.tableCql);
        out.printf("  Extra Schema Definitions: %s%n", this.extraSchemaDefinitions);
        if (this.columnConfigs != null) {
            out.printf("  Generator Configs:%n", new Object[0]);
            this.columnConfigs.forEach((k, v) -> out.printf("    %s: %s%n", k, v.getConfigAsString()));
        }
        if (this.queries != null) {
            out.printf("  Query Definitions:%n", new Object[0]);
            this.queries.forEach((k, v) -> out.printf("    %s: %s%n", k, v.getConfigAsString()));
        }
        if (this.tokenRangeQueries != null) {
            out.printf("  Token Range Queries:%n", new Object[0]);
            this.tokenRangeQueries.forEach((k, v) -> out.printf("    %s: %s%n", k, v.getConfigAsString()));
        }
        if (this.insert != null) {
            out.printf("  Insert Settings:%n", new Object[0]);
            this.insert.forEach((k, v) -> out.printf("    %s: %s%n", k, v));
        }
        PartitionGenerator generator = this.newGenerator(stressSettings);
        Distribution visits = stressSettings.insert.visits.get();
        SchemaInsert tmp = this.getInsert(null, generator, null, stressSettings);
        double minBatchSize = this.selectchance.get().min() * (double)this.partitions.get().minValue() * generator.minRowCount * (1.0 / (double)visits.maxValue());
        double maxBatchSize = this.selectchance.get().max() * (double)this.partitions.get().maxValue() * generator.maxRowCount * (1.0 / (double)visits.minValue());
        out.printf("Generating batches with [%d..%d] partitions and [%.0f..%.0f] rows (of [%.0f..%.0f] total rows in the partitions)%n", this.partitions.get().minValue(), this.partitions.get().maxValue(), minBatchSize, maxBatchSize, (double)this.partitions.get().minValue() * generator.minRowCount, (double)this.partitions.get().maxValue() * generator.maxRowCount);
    }

    private void init(StressYaml yaml) throws RequestValidationException {
        block18: {
            String name;
            block17: {
                this.keyspaceName = yaml.keyspace;
                this.keyspaceCql = yaml.keyspace_definition;
                this.tableName = yaml.table;
                this.tableCql = yaml.table_definition;
                this.queries = yaml.queries;
                this.tokenRangeQueries = yaml.token_range_queries;
                this.insert = yaml.insert;
                this.extraSchemaDefinitions = yaml.extra_definitions;
                assert (this.keyspaceName != null) : "keyspace name is required in yaml file";
                assert (this.tableName != null) : "table name is required in yaml file";
                assert (this.queries != null) : "queries map is required in yaml file";
                for (String string : this.queries.keySet()) {
                    assert (!this.tokenRangeQueries.containsKey(string)) : String.format("Found %s in both queries and token_range_queries, please use different names", string);
                }
                if (this.keyspaceCql != null && this.keyspaceCql.length() > 0) {
                    try {
                        name = ((CreateKeyspaceStatement)CQLFragmentParser.parseAnyUnhandled(CqlParser::createKeyspaceStatement, (String)this.keyspaceCql)).keyspace();
                        assert (name.equalsIgnoreCase(this.keyspaceName)) : "Name in keyspace_definition doesn't match keyspace property: '" + name + "' != '" + this.keyspaceName + "'";
                        break block17;
                    }
                    catch (RecognitionException | SyntaxException e) {
                        throw new IllegalArgumentException("There was a problem parsing the keyspace cql: " + e.getMessage());
                    }
                }
                this.keyspaceCql = null;
            }
            if (this.tableCql != null && this.tableCql.length() > 0) {
                try {
                    name = ((CreateTableStatement.RawStatement)CQLFragmentParser.parseAnyUnhandled(CqlParser::createTableStatement, (String)this.tableCql)).columnFamily();
                    assert (name.equalsIgnoreCase(this.tableName)) : "Name in table_definition doesn't match table property: '" + name + "' != '" + this.tableName + "'";
                    break block18;
                }
                catch (RuntimeException | RecognitionException e) {
                    throw new IllegalArgumentException("There was a problem parsing the table cql: " + e.getMessage());
                }
            }
            this.tableCql = null;
        }
        this.columnConfigs = new HashMap<String, GeneratorConfig>();
        if (yaml.columnspec != null) {
            for (Map map : yaml.columnspec) {
                DistributionFactory clustering;
                StressProfile.lowerCase(map);
                String name = (String)map.remove("name");
                DistributionFactory population = !map.containsKey("population") ? null : OptionDistribution.get((String)map.remove("population"));
                DistributionFactory size = !map.containsKey("size") ? null : OptionDistribution.get((String)map.remove("size"));
                DistributionFactory distributionFactory = clustering = !map.containsKey("cluster") ? null : OptionDistribution.get((String)map.remove("cluster"));
                if (!map.isEmpty()) {
                    throw new IllegalArgumentException("Unrecognised option(s) in column spec: " + map);
                }
                if (name == null) {
                    throw new IllegalArgumentException("Missing name argument in column spec");
                }
                GeneratorConfig config = new GeneratorConfig("seed for stress" + name, clustering, size, population);
                this.columnConfigs.put(name, config);
            }
        }
    }

    public void maybeCreateSchema(StressSettings settings) {
        if (!this.schemaCreated) {
            JavaDriverClient client = settings.getJavaDriverClient(false);
            if (this.keyspaceCql != null) {
                try {
                    client.execute(this.keyspaceCql, ConsistencyLevel.ONE);
                }
                catch (AlreadyExistsException alreadyExistsException) {
                    // empty catch block
                }
            }
            client.execute("use " + this.keyspaceName, ConsistencyLevel.ONE);
            if (this.tableCql != null) {
                try {
                    client.execute(this.tableCql, ConsistencyLevel.ONE);
                }
                catch (AlreadyExistsException alreadyExistsException) {
                    // empty catch block
                }
                System.out.println(String.format("Created schema. Sleeping %ss for propagation.", settings.node.nodes.size()));
                Uninterruptibles.sleepUninterruptibly((long)settings.node.nodes.size(), (TimeUnit)TimeUnit.SECONDS);
            }
            if (this.extraSchemaDefinitions != null) {
                for (String extraCql : this.extraSchemaDefinitions) {
                    try {
                        client.execute(extraCql, ConsistencyLevel.ONE);
                    }
                    catch (AlreadyExistsException alreadyExistsException) {}
                }
                System.out.println(String.format("Created extra schema. Sleeping %ss for propagation.", settings.node.nodes.size()));
                Uninterruptibles.sleepUninterruptibly((long)settings.node.nodes.size(), (TimeUnit)TimeUnit.SECONDS);
            }
            this.schemaCreated = true;
        }
        this.maybeLoadSchemaInfo(settings);
    }

    public void truncateTable(StressSettings settings) {
        JavaDriverClient client = settings.getJavaDriverClient(false);
        assert (settings.command.truncate != SettingsCommand.TruncateWhen.NEVER);
        String cql = String.format("TRUNCATE %s.%s", this.keyspaceName, this.tableName);
        client.execute(cql, ConsistencyLevel.ONE);
        System.out.println(String.format("Truncated %s.%s. Sleeping %ss for propagation.", this.keyspaceName, this.tableName, settings.node.nodes.size()));
        Uninterruptibles.sleepUninterruptibly((long)settings.node.nodes.size(), (TimeUnit)TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeLoadSchemaInfo(StressSettings settings) {
        if (this.tableMetaData == null) {
            JavaDriverClient client;
            JavaDriverClient javaDriverClient = client = settings.getJavaDriverClient();
            synchronized (javaDriverClient) {
                if (this.tableMetaData != null) {
                    return;
                }
                TableMetadata metadata = client.getCluster().getMetadata().getKeyspace(this.keyspaceName).getTable(StressProfile.quoteIdentifier(this.tableName));
                if (metadata == null) {
                    throw new RuntimeException("Unable to find table " + this.keyspaceName + "." + this.tableName);
                }
                for (ColumnMetadata col : metadata.getColumns()) {
                    if (this.columnConfigs.containsKey(col.getName())) continue;
                    this.columnConfigs.put(col.getName(), new GeneratorConfig("seed for stress" + col.getName(), null, null, null));
                }
                this.tableMetaData = metadata;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TokenRange> maybeLoadTokenRanges(StressSettings settings) {
        JavaDriverClient client;
        this.maybeLoadSchemaInfo(settings);
        JavaDriverClient javaDriverClient = client = settings.getJavaDriverClient();
        synchronized (javaDriverClient) {
            if (this.tokenRanges != null) {
                return this.tokenRanges;
            }
            Cluster cluster = client.getCluster();
            Metadata metadata = cluster.getMetadata();
            if (metadata == null) {
                throw new RuntimeException("Unable to get metadata");
            }
            ArrayList<TokenRange> sortedRanges = new ArrayList<TokenRange>(metadata.getTokenRanges().size() + 1);
            for (TokenRange range : metadata.getTokenRanges()) {
                if (range.isWrappedAround()) {
                    sortedRanges.addAll(range.unwrap());
                    continue;
                }
                sortedRanges.add(range);
            }
            Collections.sort(sortedRanges);
            this.tokenRanges = new LinkedHashSet<TokenRange>(sortedRanges);
            return this.tokenRanges;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation getQuery(String name, Timer timer, PartitionGenerator generator, SeedManager seeds, StressSettings settings, boolean isWarmup) {
        if (!this.queries.containsKey(name = name.toLowerCase())) {
            throw new IllegalArgumentException("No query defined with name " + name);
        }
        if (this.queryStatements == null) {
            StressProfile stressProfile = this;
            synchronized (stressProfile) {
                if (this.queryStatements == null) {
                    try {
                        JavaDriverClient jclient = settings.getJavaDriverClient();
                        ThriftClient tclient = null;
                        if (settings.mode.api != ConnectionAPI.JAVA_DRIVER_NATIVE) {
                            tclient = settings.getThriftClient();
                        }
                        HashMap<String, PreparedStatement> stmts = new HashMap<String, PreparedStatement>();
                        HashMap<String, Integer> tids = new HashMap<String, Integer>();
                        HashMap<String, SchemaQuery.ArgSelect> args = new HashMap<String, SchemaQuery.ArgSelect>();
                        for (Map.Entry<String, StressYaml.QueryDef> e : this.queries.entrySet()) {
                            stmts.put(e.getKey().toLowerCase(), jclient.prepare(e.getValue().cql));
                            if (tclient != null) {
                                tids.put(e.getKey().toLowerCase(), tclient.prepare_cql3_query(e.getValue().cql, Compression.NONE));
                            }
                            args.put(e.getKey().toLowerCase(), e.getValue().fields == null ? SchemaQuery.ArgSelect.MULTIROW : SchemaQuery.ArgSelect.valueOf(e.getValue().fields.toUpperCase()));
                        }
                        this.thriftQueryIds = tids;
                        this.queryStatements = stmts;
                        this.argSelects = args;
                    }
                    catch (TException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return new SchemaQuery(timer, settings, generator, seeds, this.thriftQueryIds.get(name), this.queryStatements.get(name), ThriftConversion.fromThrift((org.apache.cassandra.thrift.ConsistencyLevel)settings.command.consistencyLevel), this.argSelects.get(name));
    }

    public Operation getBulkReadQueries(String name, Timer timer, StressSettings settings, TokenRangeIterator tokenRangeIterator, boolean isWarmup) {
        StressYaml.TokenRangeQueryDef def = this.tokenRangeQueries.get(name);
        if (def == null) {
            throw new IllegalArgumentException("No bulk read query defined with name " + name);
        }
        return new TokenRangeQuery(timer, settings, this.tableMetaData, tokenRangeIterator, def, isWarmup);
    }

    public PartitionGenerator getOfflineGenerator() {
        CFMetaData cfMetaData = CFMetaData.compile((String)this.tableCql, (String)this.keyspaceName);
        Iterator it = cfMetaData.allColumnsInSelectOrder();
        while (it.hasNext()) {
            ColumnDefinition c2 = (ColumnDefinition)it.next();
            if (this.columnConfigs.containsKey(c2.name.toString())) continue;
            this.columnConfigs.put(c2.name.toString(), new GeneratorConfig("seed for stress" + c2.name.toString(), null, null, null));
        }
        List<Generator> partitionColumns = cfMetaData.partitionKeyColumns().stream().map(c -> new ColumnInfo(c.name.toString(), c.type.asCQL3Type().toString(), "", this.columnConfigs.get(c.name.toString()))).map(c -> c.getGenerator()).collect(Collectors.toList());
        List<Generator> clusteringColumns = cfMetaData.clusteringColumns().stream().map(c -> new ColumnInfo(c.name.toString(), c.type.asCQL3Type().toString(), "", this.columnConfigs.get(c.name.toString()))).map(c -> c.getGenerator()).collect(Collectors.toList());
        List<Generator> regularColumns = com.google.common.collect.Lists.newArrayList((Iterator)cfMetaData.partitionColumns().selectOrderIterator()).stream().map(c -> new ColumnInfo(c.name.toString(), c.type.asCQL3Type().toString(), "", this.columnConfigs.get(c.name.toString()))).map(c -> c.getGenerator()).collect(Collectors.toList());
        return new PartitionGenerator(partitionColumns, clusteringColumns, regularColumns, PartitionGenerator.Order.ARBITRARY);
    }

    public CreateTableStatement.RawStatement getCreateStatement() {
        CreateTableStatement.RawStatement createStatement = (CreateTableStatement.RawStatement)QueryProcessor.parseStatement((String)this.tableCql, CreateTableStatement.RawStatement.class, (String)"CREATE TABLE");
        createStatement.prepareKeyspace(this.keyspaceName);
        return createStatement;
    }

    public SchemaInsert getOfflineInsert(Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        assert (this.tableCql != null);
        CFMetaData cfMetaData = CFMetaData.compile((String)this.tableCql, (String)this.keyspaceName);
        ArrayList allColumns = com.google.common.collect.Lists.newArrayList((Iterator)cfMetaData.allColumnsInSelectOrder());
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(StressProfile.quoteIdentifier(this.keyspaceName)).append(".").append(StressProfile.quoteIdentifier(this.tableName)).append(" (");
        StringBuilder value = new StringBuilder();
        for (ColumnDefinition c : allColumns) {
            sb.append(StressProfile.quoteIdentifier(c.name.toString())).append(", ");
            value.append("?, ");
        }
        sb.delete(sb.lastIndexOf(","), sb.length());
        value.delete(value.lastIndexOf(","), value.length());
        sb.append(") ").append("values(").append((CharSequence)value).append(')');
        if (this.insert == null) {
            this.insert = new HashMap<String, String>();
        }
        StressProfile.lowerCase(this.insert);
        this.partitions = StressProfile.select(settings.insert.batchsize, "partitions", "fixed(1)", this.insert, OptionDistribution.BUILDER);
        this.selectchance = StressProfile.select(settings.insert.selectRatio, "select", "fixed(1)/1", this.insert, OptionRatioDistribution.BUILDER);
        this.rowPopulation = StressProfile.select(settings.insert.rowPopulationRatio, "row-population", "fixed(1)/1", this.insert, OptionRatioDistribution.BUILDER);
        if (generator.maxRowCount > 1.0E8) {
            System.err.printf("WARNING: You have defined a schema that permits very large partitions (%.0f max rows (>100M))%n", generator.maxRowCount);
        }
        String statement = sb.toString();
        String tableCreate = this.tableCql.replaceFirst("\\s+\"?" + this.tableName + "\"?\\s+", " \"" + this.keyspaceName + "\".\"" + this.tableName + "\" ");
        return new SchemaInsert(timer, settings, generator, seedManager, this.selectchance.get(), this.rowPopulation.get(), this.thriftInsertId, statement, tableCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaInsert getInsert(Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        if (this.insertStatement == null) {
            StressProfile stressProfile = this;
            synchronized (stressProfile) {
                if (this.insertStatement == null) {
                    Sets.SetView diff;
                    Iterator iterator;
                    boolean isKeyOnlyTable;
                    this.maybeLoadSchemaInfo(settings);
                    HashSet keyColumns = com.google.common.collect.Sets.newHashSet((Iterable)this.tableMetaData.getPrimaryKey());
                    HashSet allColumns = com.google.common.collect.Sets.newHashSet((Iterable)this.tableMetaData.getColumns());
                    boolean bl = isKeyOnlyTable = keyColumns.size() == allColumns.size();
                    if (!isKeyOnlyTable && keyColumns.size() == allColumns.size() - 1 && (iterator = (diff = com.google.common.collect.Sets.difference((Set)allColumns, (Set)keyColumns)).iterator()).hasNext()) {
                        Object obj = iterator.next();
                        ColumnMetadata col = (ColumnMetadata)obj;
                        isKeyOnlyTable = col.getName().isEmpty();
                    }
                    StringBuilder sb = new StringBuilder();
                    if (!isKeyOnlyTable) {
                        sb.append("UPDATE ").append(StressProfile.quoteIdentifier(this.tableName)).append(" SET ");
                        StringBuilder pred = new StringBuilder();
                        pred.append(" WHERE ");
                        boolean firstCol = true;
                        boolean firstPred = true;
                        block8: for (ColumnMetadata c : this.tableMetaData.getColumns()) {
                            if (keyColumns.contains(c)) {
                                if (firstPred) {
                                    firstPred = false;
                                } else {
                                    pred.append(" AND ");
                                }
                                pred.append(StressProfile.quoteIdentifier(c.getName())).append(" = ?");
                                continue;
                            }
                            if (firstCol) {
                                firstCol = false;
                            } else {
                                sb.append(',');
                            }
                            sb.append(StressProfile.quoteIdentifier(c.getName())).append(" = ");
                            switch (c.getType().getName()) {
                                case SET: 
                                case LIST: 
                                case COUNTER: {
                                    sb.append(StressProfile.quoteIdentifier(c.getName())).append(" + ?");
                                    continue block8;
                                }
                            }
                            sb.append("?");
                        }
                        sb.append((CharSequence)pred);
                    } else {
                        sb.append("INSERT INTO ").append(StressProfile.quoteIdentifier(this.tableName)).append(" (");
                        StringBuilder value = new StringBuilder();
                        for (ColumnMetadata c : this.tableMetaData.getPrimaryKey()) {
                            sb.append(StressProfile.quoteIdentifier(c.getName())).append(", ");
                            value.append("?, ");
                        }
                        sb.delete(sb.lastIndexOf(","), sb.length());
                        value.delete(value.lastIndexOf(","), value.length());
                        sb.append(") ").append("values(").append((CharSequence)value).append(')');
                    }
                    if (this.insert == null) {
                        this.insert = new HashMap<String, String>();
                    }
                    StressProfile.lowerCase(this.insert);
                    this.partitions = StressProfile.select(settings.insert.batchsize, "partitions", "fixed(1)", this.insert, OptionDistribution.BUILDER);
                    this.selectchance = StressProfile.select(settings.insert.selectRatio, "select", "fixed(1)/1", this.insert, OptionRatioDistribution.BUILDER);
                    this.rowPopulation = StressProfile.select(settings.insert.rowPopulationRatio, "row-population", "fixed(1)/1", this.insert, OptionRatioDistribution.BUILDER);
                    BatchStatement.Type type = settings.insert.batchType != null ? settings.insert.batchType : (this.batchType = !this.insert.containsKey("batchtype") ? BatchStatement.Type.LOGGED : BatchStatement.Type.valueOf((String)this.insert.remove("batchtype")));
                    if (!this.insert.isEmpty()) {
                        throw new IllegalArgumentException("Unrecognised insert option(s): " + this.insert);
                    }
                    Distribution visits = settings.insert.visits.get();
                    double minBatchSize = this.selectchance.get().min() * (double)this.partitions.get().minValue() * generator.minRowCount * (1.0 / (double)visits.maxValue());
                    double maxBatchSize = this.selectchance.get().max() * (double)this.partitions.get().maxValue() * generator.maxRowCount * (1.0 / (double)visits.minValue());
                    if (generator.maxRowCount > 1.0E8) {
                        System.err.printf("WARNING: You have defined a schema that permits very large partitions (%.0f max rows (>100M))%n", generator.maxRowCount);
                    }
                    if (this.batchType == BatchStatement.Type.LOGGED && maxBatchSize > 65535.0) {
                        System.err.printf("ERROR: You have defined a workload that generates batches with more than 65k rows (%.0f), but have required the use of LOGGED batches. There is a 65k row limit on a single batch.%n", this.selectchance.get().max() * (double)this.partitions.get().maxValue() * generator.maxRowCount);
                        System.exit(1);
                    }
                    if (maxBatchSize > 100000.0) {
                        System.err.printf("WARNING: You have defined a schema that permits very large batches (%.0f max rows (>100K)). This may OOM this stress client, or the server.%n", this.selectchance.get().max() * (double)this.partitions.get().maxValue() * generator.maxRowCount);
                    }
                    JavaDriverClient client = settings.getJavaDriverClient();
                    String query = sb.toString();
                    if (settings.mode.api != ConnectionAPI.JAVA_DRIVER_NATIVE) {
                        try {
                            this.thriftInsertId = settings.getThriftClient().prepare_cql3_query(query, Compression.NONE);
                        }
                        catch (TException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    this.insertStatement = client.prepare(query);
                }
            }
        }
        return new SchemaInsert(timer, settings, generator, seedManager, this.partitions.get(), this.selectchance.get(), this.rowPopulation.get(), this.thriftInsertId, this.insertStatement, ThriftConversion.fromThrift((org.apache.cassandra.thrift.ConsistencyLevel)settings.command.consistencyLevel), this.batchType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ValidatingSchemaQuery> getValidate(Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        if (this.validationFactories == null) {
            StressProfile stressProfile = this;
            synchronized (stressProfile) {
                if (this.validationFactories == null) {
                    this.maybeLoadSchemaInfo(settings);
                    this.validationFactories = ValidatingSchemaQuery.create(this.tableMetaData, settings);
                }
            }
        }
        ArrayList<ValidatingSchemaQuery> queries = new ArrayList<ValidatingSchemaQuery>();
        for (ValidatingSchemaQuery.Factory factory : this.validationFactories) {
            queries.add(factory.create(timer, settings, generator, seedManager, ThriftConversion.fromThrift((org.apache.cassandra.thrift.ConsistencyLevel)settings.command.consistencyLevel)));
        }
        return queries;
    }

    private static <E> E select(E first, String key, String defValue, Map<String, String> map, Function<String, E> builder) {
        String val = map.remove(key);
        if (first != null) {
            return first;
        }
        if (val != null && val.trim().length() > 0) {
            return (E)builder.apply((Object)val);
        }
        return (E)builder.apply((Object)defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionGenerator newGenerator(StressSettings settings) {
        if (this.generatorFactory == null) {
            StressProfile stressProfile = this;
            synchronized (stressProfile) {
                this.maybeCreateSchema(settings);
                this.maybeLoadSchemaInfo(settings);
                if (this.generatorFactory == null) {
                    this.generatorFactory = new GeneratorFactory();
                }
            }
        }
        return this.generatorFactory.newGenerator(settings);
    }

    public static StressProfile load(URI file) throws IOError {
        try {
            Constructor constructor = new Constructor(StressYaml.class);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            InputStream yamlStream = file.toURL().openStream();
            if (yamlStream.available() == 0) {
                throw new IOException("Unable to load yaml file from: " + file);
            }
            StressYaml profileYaml = (StressYaml)yaml.loadAs(yamlStream, StressYaml.class);
            StressProfile profile = new StressProfile();
            profile.init(profileYaml);
            return profile;
        }
        catch (IOException | RequestValidationException | YAMLException e) {
            throw new IOError(e);
        }
    }

    static <V> void lowerCase(Map<String, V> map) {
        ArrayList reinsert = new ArrayList();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            if (e.getKey().equalsIgnoreCase(e.getKey())) continue;
            reinsert.add(e);
            iter.remove();
        }
        for (Map.Entry entry : reinsert) {
            map.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
        }
    }

    private static String quoteIdentifier(String identifier) {
        return lowercaseAlphanumeric.matcher(identifier).matches() ? identifier : '\"' + identifier + '\"';
    }

    static class ColumnInfo {
        final String name;
        final String type;
        final String collectionType;
        final GeneratorConfig config;

        ColumnInfo(String name, String type, String collectionType, GeneratorConfig config) {
            this.name = name;
            this.type = type;
            this.collectionType = collectionType;
            this.config = config;
        }

        Generator getGenerator() {
            return ColumnInfo.getGenerator(this.name, this.type, this.collectionType, this.config);
        }

        static Generator getGenerator(String name, String type, String collectionType, GeneratorConfig config) {
            switch (type.toUpperCase()) {
                case "ASCII": 
                case "TEXT": 
                case "VARCHAR": {
                    return new Strings(name, config);
                }
                case "BIGINT": 
                case "COUNTER": {
                    return new Longs(name, config);
                }
                case "BLOB": {
                    return new Bytes(name, config);
                }
                case "BOOLEAN": {
                    return new Booleans(name, config);
                }
                case "DECIMAL": {
                    return new BigDecimals(name, config);
                }
                case "DOUBLE": {
                    return new Doubles(name, config);
                }
                case "FLOAT": {
                    return new Floats(name, config);
                }
                case "INET": {
                    return new Inets(name, config);
                }
                case "INT": {
                    return new Integers(name, config);
                }
                case "VARINT": {
                    return new BigIntegers(name, config);
                }
                case "TIMESTAMP": {
                    return new Dates(name, config);
                }
                case "UUID": {
                    return new UUIDs(name, config);
                }
                case "TIMEUUID": {
                    return new TimeUUIDs(name, config);
                }
                case "TINYINT": {
                    return new TinyInts(name, config);
                }
                case "SMALLINT": {
                    return new SmallInts(name, config);
                }
                case "TIME": {
                    return new Times(name, config);
                }
                case "DATE": {
                    return new LocalDates(name, config);
                }
                case "SET": {
                    return new Sets(name, ColumnInfo.getGenerator(name, collectionType, null, config), config);
                }
                case "LIST": {
                    return new Lists(name, ColumnInfo.getGenerator(name, collectionType, null, config), config);
                }
            }
            throw new UnsupportedOperationException("Because of this name: " + name + " if you removed it from the yaml and are still seeing this, make sure to drop table");
        }
    }

    private class GeneratorFactory {
        final List<ColumnInfo> partitionKeys = new ArrayList<ColumnInfo>();
        final List<ColumnInfo> clusteringColumns = new ArrayList<ColumnInfo>();
        final List<ColumnInfo> valueColumns = new ArrayList<ColumnInfo>();

        private GeneratorFactory() {
            HashSet keyColumns = com.google.common.collect.Sets.newHashSet((Iterable)StressProfile.this.tableMetaData.getPrimaryKey());
            for (ColumnMetadata metadata : StressProfile.this.tableMetaData.getPartitionKey()) {
                this.partitionKeys.add(new ColumnInfo(metadata.getName(), metadata.getType().getName().toString(), metadata.getType().isCollection() ? ((DataType)metadata.getType().getTypeArguments().get(0)).getName().toString() : "", (GeneratorConfig)StressProfile.this.columnConfigs.get(metadata.getName())));
            }
            for (ColumnMetadata metadata : StressProfile.this.tableMetaData.getClusteringColumns()) {
                this.clusteringColumns.add(new ColumnInfo(metadata.getName(), metadata.getType().getName().toString(), metadata.getType().isCollection() ? ((DataType)metadata.getType().getTypeArguments().get(0)).getName().toString() : "", (GeneratorConfig)StressProfile.this.columnConfigs.get(metadata.getName())));
            }
            for (ColumnMetadata metadata : StressProfile.this.tableMetaData.getColumns()) {
                if (keyColumns.contains(metadata)) continue;
                this.valueColumns.add(new ColumnInfo(metadata.getName(), metadata.getType().getName().toString(), metadata.getType().isCollection() ? ((DataType)metadata.getType().getTypeArguments().get(0)).getName().toString() : "", (GeneratorConfig)StressProfile.this.columnConfigs.get(metadata.getName())));
            }
        }

        PartitionGenerator newGenerator(StressSettings settings) {
            return new PartitionGenerator(this.get(this.partitionKeys), this.get(this.clusteringColumns), this.get(this.valueColumns), settings.generate.order);
        }

        List<Generator> get(List<ColumnInfo> columnInfos) {
            ArrayList<Generator> result = new ArrayList<Generator>();
            for (ColumnInfo columnInfo : columnInfos) {
                result.add(columnInfo.getGenerator());
            }
            return result;
        }
    }
}

