/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public abstract class StoreBase
implements Lifecycle,
Store {
    protected static String info = "StoreBase/1.0";
    protected static String storeName = "StoreBase";
    protected boolean started = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected Manager manager;

    public String getInfo() {
        return info;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    public Manager getManager() {
        return this.manager;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        String[] keys = null;
        if (!this.started) {
            return;
        }
        try {
            keys = this.keys();
        }
        catch (IOException e) {
            this.manager.getContainer().getLogger().error((Object)"Error getting keys", (Throwable)e);
            return;
        }
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)(this.getStoreName() + ": processExpires check number of " + keys.length + " sessions"));
        }
        for (int i = 0; i < keys.length; ++i) {
            try {
                int timeIdle;
                StandardSession session = (StandardSession)this.load(keys[i]);
                if (session == null || (timeIdle = (int)((timeNow - session.thisAccessedTime) / 1000L)) < session.getMaxInactiveInterval()) continue;
                if (this.manager.getContainer().getLogger().isDebugEnabled()) {
                    this.manager.getContainer().getLogger().debug((Object)(this.getStoreName() + ": processExpires expire store session " + keys[i]));
                }
                if (((PersistentManagerBase)this.manager).isLoaded(keys[i])) {
                    session.recycle();
                } else {
                    session.expire();
                }
                this.remove(keys[i]);
                continue;
            }
            catch (Exception e) {
                this.manager.getContainer().getLogger().error((Object)("Session: " + keys[i] + "; "), (Throwable)e);
                try {
                    this.remove(keys[i]);
                    continue;
                }
                catch (IOException e2) {
                    this.manager.getContainer().getLogger().error((Object)"Error removing key", (Throwable)e2);
                }
            }
        }
    }

    protected ObjectInputStream getObjectInputStream(InputStream is) throws IOException {
        CustomObjectInputStream ois;
        BufferedInputStream bis = new BufferedInputStream(is);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.manager instanceof ManagerBase) {
            ManagerBase managerBase = (ManagerBase)this.manager;
            ois = new CustomObjectInputStream(bis, classLoader, this.manager.getContainer().getLogger(), managerBase.getSessionAttributeValueClassNamePattern(), managerBase.getWarnOnSessionAttributeFilterFailure());
        } else {
            ois = new CustomObjectInputStream(bis, classLoader);
        }
        return ois;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString(this.getStoreName() + ".alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString(this.getStoreName() + ".notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }
}

