/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import org.apache.xml.security.signature.NodeFilter;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformEnvelopedSignature
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        Element element;
        Node node = element = this._transformObject.getElement();
        node = TransformEnvelopedSignature.searchSignatureElement(node);
        xMLSignatureInput.setExcludeNode(node);
        xMLSignatureInput.addNodeFilter(new EnvelopedNodeFilter(node));
        return xMLSignatureInput;
    }

    private static Node searchSignatureElement(Node node) throws TransformationException {
        boolean bl = false;
        while (node != null && node.getNodeType() != 9) {
            Element element = (Element)node;
            if (element.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && element.getLocalName().equals("Signature")) {
                bl = true;
                break;
            }
            node = node.getParentNode();
        }
        if (!bl) {
            throw new TransformationException("envelopedSignatureTransformNotInSignatureElement");
        }
        return node;
    }

    class EnvelopedNodeFilter
    implements NodeFilter {
        Node exclude;

        EnvelopedNodeFilter(Node node) {
            this.exclude = node;
        }

        public boolean isNodeInclude(Node node) {
            return !XMLUtils.isDescendantOrSelf(this.exclude, node);
        }
    }
}

