/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import com.adobe.epubcheck.util.ResourceUtil;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.rng.SAXSchemaReceiverFactory;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLValidator {
    String schemaName;
    Schema schema;

    public XMLValidator(String schemaName) {
        try {
            String resourcePath = ResourceUtil.getResourcePath(schemaName);
            InputStream schemaStream = ResourceUtil.getResourceStream(resourcePath);
            if (schemaStream == null) {
                throw new RuntimeException("Could not find resource " + resourcePath);
            }
            InputSource schemaSource = new InputSource(schemaStream);
            schemaSource.setPublicId("/" + schemaName);
            PropertyMapBuilder mapBuilder = new PropertyMapBuilder();
            mapBuilder.put(ValidateProperty.XML_READER_CREATOR, new XMLReaderCreatorImpl());
            mapBuilder.put(SchemaReceiverFactory.PROPERTY, new SAXSchemaReceiverFactory());
            mapBuilder.put(ValidateProperty.ERROR_HANDLER, new ErrorHandlerImpl());
            AutoSchemaReader schemaReader = new AutoSchemaReader();
            this.schemaName = schemaName;
            this.schema = schemaReader.createSchema(schemaSource, mapBuilder.toPropertyMap());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Internal error: " + e + " " + schemaName);
        }
    }

    private class ErrorHandlerImpl
    implements ErrorHandler {
        private ErrorHandlerImpl() {
        }

        public void error(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }

        public void warning(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }
    }

    private class XMLReaderCreatorImpl
    implements XMLReaderCreator {
        private XMLReaderCreatorImpl() {
        }

        public XMLReader createXMLReader() throws SAXException {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                SAXParser parser = factory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setEntityResolver(new ResourceEntityResolver());
                return reader;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new SAXException(e.toString());
            }
        }
    }

    private class ResourceEntityResolver
    implements EntityResolver {
        private ResourceEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String path = systemId;
            if (path.startsWith("file:/")) {
                path = path.substring(6);
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            InputStream in = ResourceUtil.getResourceStream(ResourceUtil.getResourcePath(path));
            if (in == null) {
                return null;
            }
            InputSource source = new InputSource(in);
            source.setSystemId(systemId);
            return source;
        }
    }
}

