/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.drag.effects;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JTabbedPane;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.RegionChecker;
import org.flexdock.docking.defaults.DefaultRegionChecker;
import org.flexdock.docking.drag.effects.DragPreview;
import org.flexdock.util.SwingUtility;

public abstract class DefaultPreview
implements DragPreview {
    public static final int DEFAULT_TAB_WIDTH = 50;
    public static final int DEFAULT_TAB_HEIGHT = 20;

    public Polygon createPreviewPolygon(Component dockable, DockingPort port, Dockable hover, String targetRegion, Component paintingTarget, Map dragInfo) {
        if (dockable == null || port == null || targetRegion == null || paintingTarget == null) {
            return null;
        }
        if ("UNKNOWN".equals(targetRegion) || !port.isDockingAllowed(dockable, targetRegion)) {
            return null;
        }
        if (hover == null) {
            Rectangle portBounds = ((Component)((Object)port)).getBounds();
            return this.createPolyRect(portBounds);
        }
        Polygon p = null;
        Component srcAxes = hover.getComponent();
        if (this.isOuterRegion(targetRegion)) {
            p = this.createPolyRect(port, srcAxes, targetRegion);
        } else {
            p = this.createPolyTab(port, srcAxes);
            srcAxes = (Component)((Object)port);
        }
        SwingUtility.translate(srcAxes, p, paintingTarget);
        return p;
    }

    protected Polygon createPolyRect(DockingPort port, Component dockable, String region) {
        RegionChecker regionChecker = port.getDockingProperties().getRegionChecker();
        if (regionChecker == null) {
            regionChecker = new DefaultRegionChecker();
        }
        Rectangle r = regionChecker.getSiblingBounds(dockable, region);
        return this.createPolyRect(r);
    }

    protected Polygon createPolyRect(Rectangle r) {
        if (r == null) {
            return null;
        }
        int x2 = r.x + r.width;
        int y2 = r.y + r.height;
        int[] x = new int[]{r.x, x2, x2, r.x};
        int[] y = new int[]{r.y, r.y, y2, y2};
        return new Polygon(x, y, 4);
    }

    protected Polygon createPolyTab(DockingPort port, Component hover) {
        boolean tabsOnTop;
        Component c = port.getDockedComponent();
        Rectangle tabPaneRect = this.createTabbedPaneRect(port, hover);
        if (c == null && port.getDockingProperties().isSingleTabsAllowed() == Boolean.FALSE) {
            return this.createPolyRect(tabPaneRect);
        }
        Rectangle tabRect = new Rectangle(tabPaneRect.x, tabPaneRect.y, 50, 20);
        boolean bl = tabsOnTop = port.getDockingProperties().getTabPlacement() == 1;
        if (c instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)c;
            Rectangle lastTab = tabs.getBoundsAt(tabs.getTabCount() - 1);
            tabRect.height = lastTab.height;
            tabRect.y = lastTab.y;
            tabRect.x = lastTab.x + lastTab.width;
            tabsOnTop = tabs.getTabPlacement() == 1;
        } else {
            int n = tabRect.y = tabsOnTop ? 0 : tabPaneRect.height - 20;
            if (c != null) {
                tabRect.x += 50;
            }
        }
        tabPaneRect.height -= tabRect.height;
        if (tabsOnTop) {
            tabPaneRect.y += tabRect.height;
        }
        if (tabsOnTop) {
            return this.createPolyTabOnTop(tabPaneRect, tabRect);
        }
        return this.createPolyTabOnBottom(tabPaneRect, tabRect);
    }

    protected Rectangle createTabbedPaneRect(DockingPort port, Component hover) {
        Rectangle tabPaneRect = ((Component)((Object)port)).getBounds();
        tabPaneRect.setLocation(0, 0);
        return tabPaneRect;
    }

    protected Polygon createPolyTabOnTop(Rectangle tabPane, Rectangle tab) {
        Polygon p = new Polygon();
        int tabRight = tab.x + tab.width;
        int paneRight = tabPane.x + tabPane.width;
        int paneBottom = tabPane.y + tabPane.height;
        if (tab.x != 0) {
            p.addPoint(tabPane.x, tabPane.y);
            p.addPoint(tab.x, tabPane.y);
        }
        p.addPoint(tab.x, tab.y);
        p.addPoint(tabRight, tab.y);
        p.addPoint(tabRight, tabPane.y);
        p.addPoint(paneRight, tabPane.y);
        p.addPoint(paneRight, paneBottom);
        p.addPoint(tabPane.x, paneBottom);
        return p;
    }

    protected Polygon createPolyTabOnBottom(Rectangle tabPane, Rectangle tab) {
        Polygon p = new Polygon();
        int tabRight = tab.x + tab.width;
        int paneRight = tabPane.x + tabPane.width;
        int paneBottom = tabPane.y + tabPane.height;
        int tabBottom = paneBottom + tab.height;
        p.addPoint(tabPane.x, tabPane.y);
        p.addPoint(paneRight, tabPane.y);
        p.addPoint(paneRight, paneBottom);
        p.addPoint(tabRight, paneBottom);
        p.addPoint(tabRight, tabBottom);
        p.addPoint(tab.x, tabBottom);
        if (tab.x != 0) {
            p.addPoint(tab.x, paneBottom);
            p.addPoint(tabPane.x, paneBottom);
        }
        return p;
    }

    protected boolean isOuterRegion(String region) {
        return "NORTH".equals(region) || "SOUTH".equals(region) || "EAST".equals(region) || "WEST".equals(region);
    }

    public abstract void drawPreview(Graphics2D var1, Polygon var2, Dockable var3, Map var4);
}

