/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Objects;

public final class SessionWindows {
    private final long gapMs;
    private long maintainDurationMs;

    private SessionWindows(long gapMs) {
        this.gapMs = gapMs;
        this.maintainDurationMs = 86400000L;
    }

    public static SessionWindows with(long inactivityGapMs) {
        if (inactivityGapMs <= 0L) {
            throw new IllegalArgumentException("Gap time (inactivityGapMs) cannot be zero or negative.");
        }
        return new SessionWindows(inactivityGapMs);
    }

    public SessionWindows until(long durationMs) throws IllegalArgumentException {
        if (durationMs < this.gapMs) {
            throw new IllegalArgumentException("Window retention time (durationMs) cannot be smaller than window gap.");
        }
        this.maintainDurationMs = durationMs;
        return this;
    }

    public long inactivityGap() {
        return this.gapMs;
    }

    public long maintainMs() {
        return Math.max(this.maintainDurationMs, this.gapMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionWindows that = (SessionWindows)o;
        return this.gapMs == that.gapMs && this.maintainDurationMs == that.maintainDurationMs;
    }

    public int hashCode() {
        return Objects.hash(this.gapMs, this.maintainDurationMs);
    }
}

