require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_VM_PARAM_)) {
    eval 'sub _VM_PARAM_ () {1;}' unless defined(&_VM_PARAM_);
    if(defined(&_KERNEL_OPT)) {
	require './uvm/opt_modular.ph';
	require './uvm/opt_uvm.ph';
    }
    if(defined(&_KERNEL)) {
	require 'sys/types.ph';
	require 'machine/vmparam.ph';
	require 'sys/resourcevar.ph';
    }
    if(defined(&_KERNEL)) {
	if(defined(&PAGE_SIZE)) {
	    if((defined(&PAGE_SIZE) ? &PAGE_SIZE : undef) == 0) {
		die("Invalid\ PAGE_SIZE\ definition");
	    }
	    if(!defined(&MIN_PAGE_SIZE)) {
		eval 'sub MIN_PAGE_SIZE () { &PAGE_SIZE;}' unless defined(&MIN_PAGE_SIZE);
	    }
	    if(!defined(&MAX_PAGE_SIZE)) {
		eval 'sub MAX_PAGE_SIZE () { &PAGE_SIZE;}' unless defined(&MAX_PAGE_SIZE);
	    }
	} else {
	    if(!defined(&MIN_PAGE_SIZE)) {
		die("MIN_PAGE_SIZE\ not\ defined");
	    }
	    if(!defined(&MAX_PAGE_SIZE)) {
		die("MAX_PAGE_SIZE\ not\ defined");
	    }
	}
	if((defined(&MIN_PAGE_SIZE) ? &MIN_PAGE_SIZE : undef) == 0) {
	    die("Invalid\ MIN_PAGE_SIZE\ definition");
	}
	if((defined(&MAX_PAGE_SIZE) ? &MAX_PAGE_SIZE : undef) == 0) {
	    die("Invalid\ MAX_PAGE_SIZE\ definition");
	}
	if(((defined(&MIN_PAGE_SIZE) ? &MIN_PAGE_SIZE : undef) != (defined(&MAX_PAGE_SIZE) ? &MAX_PAGE_SIZE : undef))) {
	    eval 'sub __uvmexp_pagesize () {1;}' unless defined(&__uvmexp_pagesize);
	    if(defined(&_LKM) || defined(&_MODULE)) {
		undef(&PAGE_SIZE) if defined(&PAGE_SIZE);
		undef(&PAGE_MASK) if defined(&PAGE_MASK);
		undef(&PAGE_SHIFT) if defined(&PAGE_SHIFT);
	    }
	}
	if(!defined(&PAGE_SIZE)) {
	    eval 'sub PAGE_SIZE () {(* &uvmexp_pagesize);}' unless defined(&PAGE_SIZE);
	    eval 'sub PAGE_MASK () {(* &uvmexp_pagemask);}' unless defined(&PAGE_MASK);
	    eval 'sub PAGE_SHIFT () {(* &uvmexp_pageshift);}' unless defined(&PAGE_SHIFT);
	}
    }
    eval 'sub VM_METER () {1;}' unless defined(&VM_METER);
    eval 'sub VM_LOADAVG () {2;}' unless defined(&VM_LOADAVG);
    eval 'sub VM_UVMEXP () {3;}' unless defined(&VM_UVMEXP);
    eval 'sub VM_NKMEMPAGES () {4;}' unless defined(&VM_NKMEMPAGES);
    eval 'sub VM_UVMEXP2 () {5;}' unless defined(&VM_UVMEXP2);
    eval 'sub VM_ANONMIN () {6;}' unless defined(&VM_ANONMIN);
    eval 'sub VM_EXECMIN () {7;}' unless defined(&VM_EXECMIN);
    eval 'sub VM_FILEMIN () {8;}' unless defined(&VM_FILEMIN);
    eval 'sub VM_MAXSLP () {9;}' unless defined(&VM_MAXSLP);
    eval 'sub VM_USPACE () {10;}' unless defined(&VM_USPACE);
    eval 'sub VM_ANONMAX () {11;}' unless defined(&VM_ANONMAX);
    eval 'sub VM_EXECMAX () {12;}' unless defined(&VM_EXECMAX);
    eval 'sub VM_FILEMAX () {13;}' unless defined(&VM_FILEMAX);
    eval 'sub VM_MINADDRESS () {14;}' unless defined(&VM_MINADDRESS);
    eval 'sub VM_MAXADDRESS () {15;}' unless defined(&VM_MAXADDRESS);
    eval 'sub VM_PROC () {16;}' unless defined(&VM_PROC);
    eval 'sub VM_GUARD_SIZE () {17;}' unless defined(&VM_GUARD_SIZE);
    eval 'sub VM_THREAD_GUARD_SIZE () {18;}' unless defined(&VM_THREAD_GUARD_SIZE);
    eval 'sub VM_PROC_MAP () {1;}' unless defined(&VM_PROC_MAP);
    unless(defined(&ASSEMBLER)) {
	if(defined(&_KERNEL)) {
	    eval 'sub atop {
	        my($x) = @_;
    		eval q(((( &paddr_t)($x)) >>  &PAGE_SHIFT));
	    }' unless defined(&atop);
	    eval 'sub ptoa {
	        my($x) = @_;
    		eval q(((( &paddr_t)($x)) <<  &PAGE_SHIFT));
	    }' unless defined(&ptoa);
	    eval 'sub round_page {
	        my($x) = @_;
    		eval q(((($x) +  &PAGE_MASK) & ~ &PAGE_MASK));
	    }' unless defined(&round_page);
	    eval 'sub trunc_page {
	        my($x) = @_;
    		eval q((($x) & ~ &PAGE_MASK));
	    }' unless defined(&trunc_page);
	    unless(defined(&VM_DEFAULT_ADDRESS_BOTTOMUP)) {
		eval 'sub VM_DEFAULT_ADDRESS_BOTTOMUP {
		    my($da, $sz) = @_;
    		    eval q( &round_page(( &vaddr_t)($da) + ( &vsize_t) &maxdmap));
		}' unless defined(&VM_DEFAULT_ADDRESS_BOTTOMUP);
	    }
	    unless(defined(&VM_DEFAULT_ADDRESS_TOPDOWN)) {
		eval 'sub VM_DEFAULT_ADDRESS_TOPDOWN {
		    my($da, $sz) = @_;
    		    eval q( &trunc_page( &VM_MAXUSER_ADDRESS -  &MAXSSIZ - ($sz) -  &user_stack_guard_size));
		}' unless defined(&VM_DEFAULT_ADDRESS_TOPDOWN);
	    }
	} else {
	    eval 'sub round_page {
	        my($x) = @_;
    		eval q((((( &vaddr_t)($x) + ( &vm_page_size - 1)) /  &vm_page_size) *  &vm_page_size));
	    }' unless defined(&round_page);
	    eval 'sub trunc_page {
	        my($x) = @_;
    		eval q((((( &vaddr_t)($x)) /  &vm_page_size) *  &vm_page_size));
	    }' unless defined(&trunc_page);
	}
    }
}
1;
