/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.event;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IDirectoryListener;
import org.netbeans.lib.cvsclient.event.IEntryListener;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.event.IFileInfoListener;
import org.netbeans.lib.cvsclient.event.IMessageListener;
import org.netbeans.lib.cvsclient.event.IModuleExpansionListener;
import org.netbeans.lib.cvsclient.event.ITerminationListener;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;

public final class EventManager
implements IEventSender,
ICvsListenerRegistry {
    private final List<ITerminationListener> terminationListeners = new ArrayList<ITerminationListener>();
    private final List<IMessageListener> messageListener = new ArrayList<IMessageListener>();
    private final List<IModuleExpansionListener> moduleExpansionListeners = new ArrayList<IModuleExpansionListener>();
    private final List<IFileInfoListener> fileInfoListeners = new ArrayList<IFileInfoListener>();
    private final List<IEntryListener> entryListeners = new ArrayList<IEntryListener>();
    private final List<IDirectoryListener> directoryListeners = new ArrayList<IDirectoryListener>();
    private final String myCharset;

    public EventManager(String charset) {
        this.myCharset = charset;
    }

    @Override
    public synchronized void addTerminationListener(ITerminationListener listener) {
        this.terminationListeners.add(listener);
    }

    @Override
    public synchronized void removeTerminationListener(ITerminationListener listener) {
        this.terminationListeners.remove(listener);
    }

    @Override
    public synchronized void addMessageListener(IMessageListener listener) {
        this.messageListener.add(listener);
    }

    @Override
    public synchronized void removeMessageListener(IMessageListener listener) {
        this.messageListener.remove(listener);
    }

    @Override
    public synchronized void addModuleExpansionListener(IModuleExpansionListener listener) {
        this.moduleExpansionListeners.add(listener);
    }

    @Override
    public synchronized void removeModuleExpansionListener(IModuleExpansionListener listener) {
        this.moduleExpansionListeners.remove(listener);
    }

    @Override
    public void addEntryListener(IEntryListener listener) {
        this.entryListeners.add(listener);
    }

    @Override
    public void removeEntryListener(IEntryListener listener) {
        this.entryListeners.remove(listener);
    }

    @Override
    public synchronized void addFileInfoListener(IFileInfoListener listener) {
        this.fileInfoListeners.add(listener);
    }

    @Override
    public synchronized void removeFileInfoListener(IFileInfoListener listener) {
        this.fileInfoListeners.remove(listener);
    }

    @Override
    public synchronized void addDirectoryListener(IDirectoryListener listener) {
        this.directoryListeners.add(listener);
    }

    @Override
    public synchronized void removeDirectoryListener(IDirectoryListener listener) {
        this.directoryListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTerminationListeners(boolean error) {
        ITerminationListener[] iTerminationListenerArray = this;
        synchronized (this) {
            if (this.terminationListeners.isEmpty()) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            ITerminationListener[] copiedListeners = new ITerminationListener[this.terminationListeners.size()];
            this.terminationListeners.toArray(copiedListeners);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (ITerminationListener copiedListener : copiedListeners) {
                copiedListener.commandTerminated(error);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessageListeners(byte[] message, boolean error, boolean tagged) {
        IMessageListener[] copiedListeners;
        EventManager eventManager = this;
        synchronized (eventManager) {
            if (this.messageListener.isEmpty()) {
                return;
            }
            copiedListeners = new IMessageListener[this.messageListener.size()];
            this.messageListener.toArray(copiedListeners);
        }
        try {
            String stringMessage = new String(message, this.myCharset);
            for (IMessageListener copiedListener : copiedListeners) {
                copiedListener.messageSent(stringMessage, message, error, tagged);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyModuleExpansionListeners(String module) {
        IModuleExpansionListener[] iModuleExpansionListenerArray = this;
        synchronized (this) {
            if (this.moduleExpansionListeners.isEmpty()) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            IModuleExpansionListener[] copiedListeners = new IModuleExpansionListener[this.moduleExpansionListeners.size()];
            this.moduleExpansionListeners.toArray(copiedListeners);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (IModuleExpansionListener copiedListener : copiedListeners) {
                copiedListener.moduleExpanded(module);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFileInfoListeners(Object fileInfoContainer) {
        IFileInfoListener[] iFileInfoListenerArray = this;
        synchronized (this) {
            if (this.fileInfoListeners.isEmpty()) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            IFileInfoListener[] copiedListeners = new IFileInfoListener[this.fileInfoListeners.size()];
            this.fileInfoListeners.toArray(copiedListeners);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (IFileInfoListener copiedListener : copiedListeners) {
                copiedListener.fileInfoGenerated(fileInfoContainer);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFileInfoListeners(byte[] bytes) {
        IMessageListener[] iMessageListenerArray = this;
        synchronized (this) {
            if (this.messageListener.isEmpty()) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            IMessageListener[] copiedListeners = new IMessageListener[this.messageListener.size()];
            this.messageListener.toArray(copiedListeners);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (IMessageListener copiedListener : copiedListeners) {
                copiedListener.binaryMessageSent(bytes);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEntryListeners(FileObject fileObject, Entry entry) {
        IEntryListener[] iEntryListenerArray = this;
        synchronized (this) {
            if (this.entryListeners.isEmpty()) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            IEntryListener[] copiedListeners = new IEntryListener[this.entryListeners.size()];
            this.entryListeners.toArray(copiedListeners);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (IEntryListener copiedListener : copiedListeners) {
                copiedListener.gotEntry(fileObject, entry);
            }
            return;
        }
    }

    @Override
    public void notifyDirectoryListeners(DirectoryObject directoryObject, boolean setStatic) {
        Iterator<IDirectoryListener> iterator = this.directoryListeners.iterator();
        while (iterator.hasNext()) {
            IDirectoryListener directoryListener1;
            IDirectoryListener directoryListener = directoryListener1 = iterator.next();
            directoryListener.processingDirectory(directoryObject);
        }
    }
}

