/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.InplaceButton;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkCommandHistoryList;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.ui.FrameworkToolWindowComponent;
import com.jetbrains.php.framework.ui.FrameworkUiUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkRunConsoleAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(FrameworkRunConsoleAction.class);
    @NonNls
    private static final String DIMENSION_KEY = "FrameworkRunConsoleActionPopup";
    public static final Key<JBPopup> FRAMEWORK_COMMAND_POPUP_IN_DOCUMENT_KEY = Key.create((String)"FRAMEWORK_COMMAND_POPUP_IN_DOCUMENT_KEY");
    private static final Key<JBPopup> FRAMEWORK_COMMAND_POPUP_IN_PROJECT_KEY = Key.create((String)"FRAMEWORK_COMMAND_POPUP_IN_PROJECT_KEY");

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FrameworkRunConsoleAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null && !project.isDefault());
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            FrameworkRunConsoleAction.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((project = (Project)event.getData(CommonDataKeys.PROJECT)) != null);
        FrameworkRunConsoleAction.applyConsoleSettings(project, null, true, true);
    }

    public static void applyConsoleSettingsToAllProjects() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FrameworkRunConsoleAction.applyConsoleSettings(project, null, false, false);
        }
    }

    public static void applyConsoleSettings(final @NotNull Project project, @Nullable String consoleText, boolean forceConsoleVisibility, boolean selectAll) {
        FrameworkToolWindowComponent toolWindowComponent;
        ToolWindow toolWindow;
        EditorTextField textField;
        JBPopup oldPopup;
        if (project == null) {
            FrameworkRunConsoleAction.$$$reportNull$$$0(2);
        }
        if (consoleText == null && (oldPopup = (JBPopup)project.getUserData(FRAMEWORK_COMMAND_POPUP_IN_PROJECT_KEY)) != null && !oldPopup.isDisposed() && (textField = (EditorTextField)oldPopup.getUserData(EditorTextField.class)) != null) {
            consoleText = StringUtil.notNullize((String)textField.getText());
        }
        FrameworkRunConsoleAction.disposeOldPopup(project);
        if (!FrameworkDataService.isConsoleInToolWindow()) {
            if (forceConsoleVisibility) {
                final EditorTextField textComponent = FrameworkUiUtils.createEditorField(project, FrameworkCommandHistoryList.getInstance(project));
                Dimension preferredSize = textComponent.getPreferredSize();
                preferredSize.width = 300;
                textComponent.setPreferredSize(preferredSize);
                textComponent.setMinimumSize(preferredSize);
                if (consoleText != null) {
                    textComponent.setText(consoleText);
                }
                if (selectAll) {
                    textComponent.selectAll();
                    Editor editor = textComponent.getEditor();
                    if (editor != null) {
                        editor.getCaretModel().moveToOffset(StringUtil.notNullize((String)textComponent.getText()).length());
                    }
                }
                ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)textComponent, (JComponent)textComponent);
                JBPopup popup = builder.setCancelOnClickOutside(false).setBelongsToGlobalPopupStack(false).setRequestFocus(true).setResizable(true).setMovable(true).setDimensionServiceKey(project, DIMENSION_KEY, true).setCommandButton((ActiveComponent)new InplaceButton(FrameworkBundle.message("framework.console.fix.button.tip", new Object[0]), AllIcons.Actions.MoveTo2, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FrameworkDataService.setConsoleInToolWindow(true);
                        String oldText = textComponent.getText();
                        FrameworkRunConsoleAction.applyConsoleSettings(project, StringUtil.notNullize((String)oldText), true, false);
                    }
                })).setTitle(FrameworkBundle.message("framework.commands.form.messages.title.command.line.tools", new Object[0])).addUserData((Object)textComponent).createPopup();
                textComponent.getDocument().putUserData(FRAMEWORK_COMMAND_POPUP_IN_DOCUMENT_KEY, (Object)popup);
                project.putUserData(FRAMEWORK_COMMAND_POPUP_IN_PROJECT_KEY, (Object)popup);
                Disposer.register((Disposable)project, (Disposable)new Disposable(){

                    public void dispose() {
                        FrameworkRunConsoleAction.disposeOldPopup(project);
                    }
                });
                popup.showCenteredInCurrentWindow(project);
            }
            if ((toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(FrameworkUiUtils.TOOL_WINDOW_ID)) == null) {
                return;
            }
            toolWindowComponent = FrameworkToolWindowComponent.getToolWindowComponent(toolWindow.getContentManager());
            toolWindowComponent.setTextFieldVisible(false);
        } else {
            toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(FrameworkUiUtils.TOOL_WINDOW_ID);
            if (toolWindow == null) {
                if (forceConsoleVisibility) {
                    toolWindow = FrameworkUiUtils.getOrRegisterToolWindow(project);
                } else {
                    return;
                }
            }
            toolWindowComponent = FrameworkToolWindowComponent.getToolWindowComponent(toolWindow.getContentManager());
            toolWindowComponent.setTextFieldVisible(true);
            if (consoleText != null) {
                toolWindowComponent.setText(consoleText);
            }
            if (selectAll) {
                toolWindowComponent.selectAllAndMoveCaret();
            }
            toolWindow.activate(() -> {
                if (project == null) {
                    FrameworkRunConsoleAction.$$$reportNull$$$0(3);
                }
                toolWindowComponent.requestFocusInEditor(project);
            }, true);
        }
    }

    private static void disposeOldPopup(Project project) {
        JBPopup oldPopup = (JBPopup)project.getUserData(FRAMEWORK_COMMAND_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            if (!oldPopup.isDisposed()) {
                Disposer.dispose((Disposable)oldPopup);
            }
            project.putUserData(FRAMEWORK_COMMAND_POPUP_IN_PROJECT_KEY, null);
        }
    }

    public static void clearInputEditorCache(Project project) {
        if (FrameworkDataService.isConsoleInToolWindow()) {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(FrameworkUiUtils.TOOL_WINDOW_ID);
            if (toolWindow == null) {
                return;
            }
            FrameworkToolWindowComponent toolWindowComponent = FrameworkToolWindowComponent.getToolWindowComponent(toolWindow.getContentManager());
            toolWindowComponent.cleaEditorCache();
        } else {
            FrameworkRunConsoleAction.disposeOldPopup(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/framework/FrameworkRunConsoleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyConsoleSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$applyConsoleSettings$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

