/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.framework.FrameworkInfoPopupTypedHandler;
import com.jetbrains.php.framework.completion.FrameworkCompletionContributor;
import com.jetbrains.php.framework.completion.FrameworkLookupElement;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkOption;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class FrameworkOptionLookupElement
extends LookupElement
implements FrameworkLookupElement {
    private final FrameworkOption myOption;
    private final PsiFile myPsiFile;
    private final FrameworkCommand myCommand;
    private final boolean myUseShortcut;

    private FrameworkOptionLookupElement(FrameworkOption option, @NotNull PsiFile psiFile, FrameworkCommand command, boolean useShortcut) {
        if (psiFile == null) {
            FrameworkOptionLookupElement.$$$reportNull$$$0(0);
        }
        this.myCommand = command;
        this.myUseShortcut = useShortcut;
        this.myOption = option;
        this.myPsiFile = psiFile;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            FrameworkOptionLookupElement.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public String getTitleForHelp() {
        String string = this.getLookupString();
        if (string == null) {
            FrameworkOptionLookupElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getHelp() {
        return this.myOption.getHelp();
    }

    @Override
    @NotNull
    public String getCommandForHelp() {
        String string = this.getAliasedCommand();
        if (string == null) {
            FrameworkOptionLookupElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getAliasedCommand() {
        return this.myCommand.getAliasedBasicText();
    }

    @NotNull
    public String getLookupString() {
        if (this.myUseShortcut) {
            String string = this.myOption.getShortcut();
            if (string == null) {
                FrameworkOptionLookupElement.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.myOption.getName();
        if (string == null) {
            FrameworkOptionLookupElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setTypeGrayed(true);
        if (this.myUseShortcut) {
            presentation.setItemText(this.myOption.getShortcut());
            presentation.setTypeText(this.myOption.getName());
        } else {
            presentation.setItemText(this.myOption.getName());
            if (this.myOption.hasShortcut()) {
                presentation.setTypeText(this.myOption.getShortcut());
            }
        }
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            FrameworkOptionLookupElement.$$$reportNull$$$0(6);
        }
        Editor editor = context.getEditor();
        FrameworkCompletionContributor.destroyInfoPopup(editor);
        this.myOption.handleInsert(context);
        if (!this.myOption.hasValue()) {
            FrameworkInfoPopupTypedHandler.showInfoPopup(editor.getDocument().getText(), editor, this.myCommand);
        }
    }

    public static Iterable<LookupElement> createElements(FrameworkOption option, PsiFile file, FrameworkCommand command) {
        if (option.hasShortcut()) {
            return Arrays.asList(new FrameworkOptionLookupElement(option, file, command, false), new FrameworkOptionLookupElement(option, file, command, true));
        }
        return Collections.singletonList(new FrameworkOptionLookupElement(option, file, command, false));
    }

    public FrameworkOption getOption() {
        return this.myOption;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/completion/FrameworkOptionLookupElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/completion/FrameworkOptionLookupElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleForHelp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandForHelp";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

