/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.composer.InterpretersComboWithBrowseButton;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.ui.FrameworkCompositePathDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkPathDialog
extends DialogWrapper {
    @Nullable
    protected final Project myProject;
    private final boolean myNeedsPhp;
    private final String[] myExecutableNames;
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myPathField;
    private JLabel myPathLabel;
    private JPanel myPhpSettingsPanel;
    private JPanel myPhpExecutableComboPlaceholder;
    private InterpretersComboWithBrowseButton myPhpExecutableCombo;
    private JLabel myPhpExecutableLabel;
    protected JPanel myAdditionalPanel;

    protected FrameworkPathDialog(boolean needsPhp, String ... names) {
        super(true);
        this.myNeedsPhp = needsPhp;
        this.myExecutableNames = names;
        this.myProject = null;
        this.$$$setupUI$$$();
        this.initialize(null);
    }

    protected FrameworkPathDialog(@NotNull Component component, boolean needsPhp, String ... names) {
        if (component == null) {
            FrameworkPathDialog.$$$reportNull$$$0(0);
        }
        super(component, false);
        this.myNeedsPhp = needsPhp;
        this.myExecutableNames = names;
        this.$$$setupUI$$$();
        this.myProject = FrameworkUtils.getProject(component);
        this.initialize(component);
    }

    protected final void initialize(final @Nullable Component component) {
        this.setTitle(this.getDialogTitle());
        this.myPathLabel.setText(this.getPathLabelText());
        this.myPathField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(this.getFileChooserTitle(), this.getFileChooserDescription(), (ComponentWithBrowseButton)this.myPathField, null, this.getFileChooserDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                return FrameworkPathDialog.this.getInitialFile(component);
            }
        });
        this.myPhpExecutableLabel.setText(FrameworkBundle.message("framework.com.path.dlg.path.to.php.executable", new Object[0]));
        this.myPhpExecutableCombo = new InterpretersComboWithBrowseButton(this.myProject);
        this.myPhpExecutableComboPlaceholder.add((Component)this.myPhpExecutableCombo, "Center");
        this.myPhpSettingsPanel.setVisible(this.myNeedsPhp);
        this.setModal(true);
        this.init();
        this.pack();
        this.initValidation();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String path = this.getPath();
        if (path == null) {
            if (this.myExecutableNames.length == 1) {
                return new ValidationInfo(FrameworkBundle.message("framework.path.dialog.0.not.chosen", this.myExecutableNames[0]), (JComponent)this.myPathField);
            }
            if (this.myExecutableNames.length == 2) {
                return new ValidationInfo(FrameworkBundle.message("framework.path.dialog.neither.file.0.nor.1.is.chosen", this.myExecutableNames[0], this.myExecutableNames[1]), (JComponent)this.myPathField);
            }
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(FrameworkBundle.message("framework.path.dialog.none.of.expected.files.is.chosen", this.myPathField.getText()));
            messageBuilder.append('\n');
            for (String name : this.myExecutableNames) {
                messageBuilder.append(name).append(", ");
            }
            return new ValidationInfo(messageBuilder.substring(0, messageBuilder.length() - 2), (JComponent)this.myPathField);
        }
        if (path.isEmpty()) {
            new ValidationInfo(FrameworkBundle.message("framework.path.dialog.path.not.provided", new Object[0]), (JComponent)this.myPathField);
        }
        if (this.myNeedsPhp) {
            return FrameworkCompositePathDialog.createStandardValidationInfo((JComponent)this.myPhpExecutableCombo, this.getPhpExecutablePath(), PhpProjectConfigurationFacade.PHP_EXECUTABLE, FrameworkBundle.message("framework.php.executable", new Object[0]));
        }
        return null;
    }

    @Nullable
    public final String getPath() {
        String text = this.myPathField.getText();
        for (String name : this.myExecutableNames) {
            String path = FrameworkPathDialog.findFileInProvidedPath(text, name);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    @Nullable
    private String getPhpExecutablePath() {
        assert (this.myNeedsPhp);
        return FrameworkCompositePathDialog.getPhpComboExecutablePath(this.myPhpExecutableCombo);
    }

    public Data getData() {
        return new Data(StringUtil.notNullize((String)this.getPath()), StringUtil.notNullize((String)this.getPhpExecutablePath()));
    }

    @Nullable
    public static String findFileInProvidedPath(String providedPath, String ... fileNames) {
        if (StringUtil.isEmpty((String)providedPath)) {
            return "";
        }
        File providedFile = new File(providedPath);
        if (providedFile.exists()) {
            String name = providedFile.getName();
            for (String fileName : fileNames) {
                if (!name.equals(fileName)) continue;
                return FileUtil.toSystemDependentName((String)providedFile.getPath());
            }
        }
        return null;
    }

    protected final JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public final JComponent getPreferredFocusedComponent() {
        return this.myPathField.getTextField();
    }

    protected String getPathFieldText() {
        return this.myPathField.getText();
    }

    protected abstract String getDialogTitle();

    protected abstract String getFileChooserTitle();

    protected abstract String getFileChooserDescription();

    protected abstract FileChooserDescriptor getFileChooserDescriptor();

    protected abstract String getPathLabelText();

    @Nullable
    protected VirtualFile getInitialFile(@Nullable Component component) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/php/framework/ui/FrameworkPathDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPathLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/FrameworkBundle").getString("framework.zend1.path.to.zf.tool"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPhpSettingsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myPhpExecutableComboPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPhpExecutableLabel = jLabel = new JLabel();
        jLabel.setText("php-executable-path");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdditionalPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static class Data {
        public static final Data EMPTY = new Data("", "");
        @NotNull
        private final String myPath;
        @NotNull
        private final String myPhpPath;

        private Data(@NotNull String path, @NotNull String phpPath) {
            if (path == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (phpPath == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.myPath = path;
            this.myPhpPath = phpPath;
        }

        @NotNull
        public String getPath(boolean quoteIfNeeded) {
            if (quoteIfNeeded && this.myPath.contains(" ")) {
                String string = "\"" + this.myPath + "\"";
                if (string == null) {
                    Data.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = this.myPath;
            if (string == null) {
                Data.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getPhpPath(boolean quoteIfNeeded) {
            if (quoteIfNeeded && this.myPhpPath.contains(" ")) {
                String string = "\"" + this.myPhpPath + "\"";
                if (string == null) {
                    Data.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = this.myPhpPath;
            if (string == null) {
                Data.$$$reportNull$$$0(5);
            }
            return string;
        }

        public static Data parseInvokeText(@Nullable String invokeText) {
            if (invokeText == null) {
                return EMPTY;
            }
            List elements = StringUtil.splitHonorQuotes((String)invokeText, (char)' ');
            if (elements.isEmpty()) {
                return EMPTY;
            }
            if (elements.size() == 1) {
                return new Data(StringUtil.unquoteString((String)((String)elements.get(0))), "");
            }
            return new Data(StringUtil.unquoteString((String)((String)elements.get(1))), StringUtil.unquoteString((String)((String)elements.get(0))));
        }

        public String[] createCommand(String ... args) {
            String[] result = new String[args.length + 2];
            result[0] = this.getPhpPath(false);
            result[1] = this.getPath(false);
            System.arraycopy(args, 0, result, 2, args.length);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpPath";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkPathDialog$Data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkPathDialog$Data";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPhpPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

