/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.jetbrains.php.phing.dom.PhingCreateTargetQuickFix;
import com.jetbrains.php.phing.dom.PhingDomReferenceBase;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.TargetResolver;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedPhingTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingDomTargetReference
extends PhingDomReferenceBase
implements BindablePsiReference,
LocalQuickFixProvider {
    private final ReferenceGroup myGroup;

    public PhingDomTargetReference(PsiElement element) {
        super(element, true);
        this.myGroup = null;
    }

    public PhingDomTargetReference(PsiElement element, TextRange range, ReferenceGroup group) {
        super(element, range, true);
        this.myGroup = group;
        group.addReference(this);
    }

    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)MyResolver.INSTANCE, false, false);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        TargetResolver.Result result;
        PhingPredefinedTarget pointingToTarget;
        DomElement targetDomElement;
        if (element == null) {
            PhingDomTargetReference.$$$reportNull$$$0(0);
        }
        if ((targetDomElement = PhingDomTargetReference.toDomElement(element)) != null && (pointingToTarget = (PhingPredefinedTarget)targetDomElement.getParentOfType(PhingPredefinedTarget.class, false)) != null && (result = this.doResolve(null)) != null) {
            Map<String, PhingPredefinedTarget> variants = result.getVariants();
            String newName = null;
            if (!variants.isEmpty()) {
                ArrayList<Pair> prefixNamePairs = new ArrayList<Pair>();
                for (Map.Entry<String, PhingPredefinedTarget> entry : variants.entrySet()) {
                    String candidateTargetName;
                    String candidateName;
                    PhingPredefinedTarget candidateTarget = entry.getValue();
                    if (!pointingToTarget.equals(candidateTarget) || !(candidateName = entry.getKey()).endsWith(candidateTargetName = candidateTarget.findName().getRawText())) continue;
                    String prefix = candidateName.substring(0, candidateName.length() - candidateTargetName.length());
                    prefixNamePairs.add(Pair.create((Object)prefix, (Object)candidateName));
                }
                String currentRefText = this.getCanonicalText();
                for (Pair pair : prefixNamePairs) {
                    String prefix = (String)pair.getFirst();
                    String effectiveName = (String)pair.getSecond();
                    if (!currentRefText.startsWith(prefix) || newName != null && effectiveName.length() <= newName.length()) continue;
                    newName = effectiveName;
                }
            }
            if (newName != null) {
                this.handleElementRename(newName);
                if (this.myGroup != null) {
                    this.myGroup.textChanged(this, newName);
                }
            }
        }
        return this.getElement();
    }

    @Nullable
    private PhingPredefinedElement getHostingBFDomElement() {
        DomElement selfElement = DomUtil.getDomElement((PsiElement)this.getElement());
        if (selfElement == null) {
            return null;
        }
        return (PhingPredefinedElement)selfElement.getParentOfType(PhingPredefinedElement.class, false);
    }

    @NotNull
    public Object[] getVariants() {
        TargetResolver.Result result = this.doResolve(this.getCanonicalText());
        if (result == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PhingDomTargetReference.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Map<String, PhingPredefinedTarget> variants = result.getVariants();
        ArrayList<LookupElement> resVariants = new ArrayList<LookupElement>();
        Set<String> existing = this.getExistingNames();
        for (String s : variants.keySet()) {
            if (existing.contains(s)) continue;
            LookupElementBuilder builder = LookupElementBuilder.create((String)s).withCaseSensitivity(false);
            LookupElement element = AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)builder);
            resVariants.add(element);
        }
        Object[] objectArray = resVariants.toArray();
        if (objectArray == null) {
            PhingDomTargetReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @Nullable
    private TargetResolver.Result doResolve(@Nullable String referenceText) {
        PhingPredefinedTarget contextTarget;
        PhingPredefinedProject projectToSearchFrom;
        PhingPredefinedElement hostingElement = this.getHostingBFDomElement();
        if (hostingElement == null) {
            return null;
        }
        if (hostingElement instanceof PhingPredefinedPhingTask) {
            PsiFileSystemItem phingFile = (PsiFileSystemItem)((PhingPredefinedPhingTask)hostingElement).findPhingFile().getValue();
            PhingPredefinedProject phingPredefinedProject = projectToSearchFrom = phingFile instanceof PsiFile ? PhingUtils.getPhingDomProjectForcePhingFile((PsiFile)phingFile) : null;
            if (projectToSearchFrom == null) {
                PsiFileSystemItem buildFile = (PsiFileSystemItem)((PhingPredefinedPhingTask)hostingElement).findBuildfile().getValue();
                projectToSearchFrom = buildFile instanceof PsiFile ? PhingUtils.getPhingDomProjectForcePhingFile((PsiFile)buildFile) : null;
            }
            contextTarget = null;
        } else {
            projectToSearchFrom = hostingElement.findPhingProject();
            contextTarget = (PhingPredefinedTarget)hostingElement.getParentOfType(PhingPredefinedTarget.class, false);
        }
        if (projectToSearchFrom == null) {
            return null;
        }
        return TargetResolver.resolve(projectToSearchFrom, contextTarget, referenceText == null ? Collections.emptyList() : Collections.singletonList(referenceText));
    }

    private Set<String> getExistingNames() {
        String dependsString;
        PhingPredefinedElement hostingElement = this.getHostingBFDomElement();
        if (hostingElement == null) {
            return Collections.emptySet();
        }
        PhingPredefinedTarget contextTarget = (PhingPredefinedTarget)hostingElement.getParentOfType(PhingPredefinedTarget.class, false);
        if (contextTarget == null) {
            return Collections.emptySet();
        }
        ArrayListSet existing = new ArrayListSet();
        String selfName = contextTarget.findName().getStringValue();
        if (selfName != null) {
            existing.add(selfName);
        }
        if ((dependsString = contextTarget.findDependsList().getRawText()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(dependsString, ",", false);
            while (tokenizer.hasMoreTokens()) {
                existing.add(tokenizer.nextToken().trim());
            }
        }
        return existing;
    }

    public LocalQuickFix[] getQuickFixes() {
        DomElement targetDomElement = PhingDomTargetReference.toDomElement(this.myElement);
        if (targetDomElement != null) {
            PhingPredefinedProject project = (PhingPredefinedProject)targetDomElement.getParentOfType(PhingPredefinedProject.class, false);
            return new LocalQuickFix[]{new PhingCreateTargetQuickFix(project, this.getCanonicalText())};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/PhingDomTargetReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/PhingDomTargetReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ReferenceGroup {
        private final List<PhingDomTargetReference> myRefs = new ArrayList<PhingDomTargetReference>();

        public void addReference(PhingDomTargetReference ref) {
            this.myRefs.add(ref);
        }

        public void textChanged(PhingDomTargetReference ref, String newText) {
            Integer lengthDelta = null;
            for (PhingDomTargetReference r : this.myRefs) {
                if (lengthDelta != null) {
                    r.setRangeInElement(r.getRangeInElement().shiftRight(lengthDelta.intValue()));
                    continue;
                }
                if (!((Object)((Object)r)).equals((Object)ref)) continue;
                TextRange range = r.getRangeInElement();
                int oldLength = range.getLength();
                lengthDelta = new Integer(newText.length() - oldLength);
                r.setRangeInElement(range.grown(lengthDelta.intValue()));
            }
        }
    }

    private static class MyResolver
    implements ResolveCache.Resolver {
        static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @Nullable
        public PsiElement resolve(@NotNull PsiReference psiReference, boolean incompleteCode) {
            TargetResolver.Result result;
            if (psiReference == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            if ((result = ((PhingDomTargetReference)psiReference).doResolve(psiReference.getCanonicalText())) == null) {
                return null;
            }
            Pair<PhingPredefinedTarget, String> pair = result.getResolvedTarget(psiReference.getCanonicalText());
            if (pair == null || pair.getFirst() == null) {
                return null;
            }
            DomTarget domTarget = pair != null && pair.getFirst() != null ? PhingUtils.getDomTarget((DomElement)pair.getFirst()) : null;
            return domTarget != null ? PomService.convertToPsi(domTarget) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReference", "com/jetbrains/php/phing/dom/PhingDomTargetReference$MyResolver", "resolve"));
        }
    }
}

