/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingStateService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingConfigurable
implements SearchableConfigurable {
    @NonNls
    public static final String PHING_EXECUTABLE = "phing" + (SystemInfo.isWindows ? ".bat" : "");
    private final Project myProject;
    private JPanel myMainPanel;
    private JLabel myPathLabel;
    private TextFieldWithBrowseButton myPhingTextField;
    private JLabel myErrorInfoLabel;
    private HyperlinkLabel myDownloadLabel;

    public PhingConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myPathLabel.setText(PhingBundle.message("phing.properties.label.path.to.phing", new Object[0]));
        this.myErrorInfoLabel.setIcon(UIUtil.getBalloonWarningIcon());
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        descriptor.setTitle(PhingBundle.message("phing.path.chooser.message.phing.properties.label.path.to.phing", new Object[0]));
        descriptor.setDescription(PhingBundle.message("phing.path.chooser.text.specify.phing.executable.or.phar", new Object[0]));
        this.myPhingTextField.addBrowseFolderListener(new TextBrowseFolderListener(descriptor, project));
        this.myPhingTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String path;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((path = PhingConfigurable.this.getValidPath()) == null || new File(path).isDirectory()) {
                    PhingConfigurable.this.myErrorInfoLabel.setText(PhingBundle.message("phing.neither.file.phing.nor.phing.phar.is.chosen", PHING_EXECUTABLE));
                    PhingConfigurable.this.myErrorInfoLabel.setVisible(true);
                } else if (path.isEmpty()) {
                    PhingConfigurable.this.notifyNoPathProvided();
                } else {
                    PhingConfigurable.this.myErrorInfoLabel.setVisible(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phing/ui/PhingConfigurable$1", "textChanged"));
            }
        });
        this.myDownloadLabel.setHyperlinkText(PhingBundle.message("phing.path.form.download.label", new Object[0]));
        PhingConfigurable.setUpDownloadLink(project, this.myDownloadLabel, this.myPhingTextField, this.myMainPanel);
        PhingStateService phingState = PhingStateService.getInstance(project);
        this.myPhingTextField.setText("initialize");
        String path = phingState.getPhingPath();
        if (path != null) {
            this.myPhingTextField.setText(path);
        } else {
            this.myPhingTextField.setText("");
        }
    }

    public void setPathLabelTextMoreDescriptive() {
        this.myPathLabel.setText(PhingBundle.message("phing.properties.label.path.to.phing.or.phar.for.project", new Object[0]));
    }

    public JPanel getComponent() {
        return this.myMainPanel;
    }

    private void notifyNoPathProvided() {
        this.myErrorInfoLabel.setText(PhingBundle.message("phing.path.not.provided", new Object[0]));
        this.myErrorInfoLabel.setVisible(true);
    }

    @NotNull
    private String getPath() {
        String fileInProvidedPath = this.getValidPath();
        String string = fileInProvidedPath == null ? this.myPhingTextField.getText() : fileInProvidedPath;
        if (string == null) {
            PhingConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private String getValidPath() {
        return PhingStateService.findValidPath(this.myPhingTextField.getText());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPhingTextField.getTextField();
    }

    @Nls
    public String getDisplayName() {
        return PhingBundle.message("phing.configurable.display.name", new Object[0]);
    }

    @NonNls
    public String getHelpTopic() {
        return "settings.phing";
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        PhingStateService stateService = PhingStateService.getInstance(this.myProject);
        String oldPath = StringUtil.nullize((String)stateService.getPhingPath());
        String newPath = StringUtil.nullize((String)this.getPath());
        return !(oldPath != null ? oldPath.equals(newPath) : newPath == null);
    }

    public void apply() {
        PhingStateService stateService = PhingStateService.getInstance(this.myProject);
        stateService.setPhingPath(this.getPath());
    }

    public void reset() {
        PhingStateService stateService = PhingStateService.getInstance(this.myProject);
        this.myPhingTextField.setText(stateService.getPhingPath());
    }

    public void disposeUIResources() {
    }

    public static void downloadFile(@Nullable Project project, @Nullable JComponent component, @NotNull TextFieldWithBrowseButton textField) {
        VirtualFile baseDir;
        FileChooserDescriptor descriptor;
        VirtualFile toDir;
        if (textField == null) {
            PhingConfigurable.$$$reportNull$$$0(1);
        }
        if ((toDir = FileChooser.chooseFile((FileChooserDescriptor)(descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(IdeBundle.message((String)"dialog.directory.for.downloaded.files.title", (Object[])new Object[0])).withDescription(IdeBundle.message((String)"dialog.directory.for.downloaded.files.description", (Object[])new Object[0]))), (Component)component, (Project)project, (VirtualFile)(baseDir = project != null ? project.getBaseDir() : null))) == null) {
            return;
        }
        File targetDir = VfsUtilCore.virtualToIoFile((VirtualFile)toDir);
        File targetFile = FileUtil.findSequentNonexistentFile((File)targetDir, (String)"phing-latest", (String)"phar");
        PhingConfigurable.downloadWithProgress(targetFile, project, targetFile.getName(), textField);
    }

    private static void downloadWithProgress(final @NotNull File targetFile, @Nullable Project project, final @NotNull String fileName, final @NotNull TextFieldWithBrowseButton textField) {
        if (targetFile == null) {
            PhingConfigurable.$$$reportNull$$$0(2);
        }
        if (fileName == null) {
            PhingConfigurable.$$$reportNull$$$0(3);
        }
        if (textField == null) {
            PhingConfigurable.$$$reportNull$$$0(4);
        }
        new Task.Backgroundable(project, IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{fileName})){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean shouldTry = true;
                while (shouldTry) {
                    try {
                        DownloadUtil.downloadAtomically((ProgressIndicator)indicator, (String)"https://www.phing.info/get/phing-latest.phar", (File)targetFile);
                        shouldTry = false;
                    }
                    catch (IOException e) {
                        shouldTry = IOExceptionDialog.showErrorDialog((String)IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{fileName}), (String)e.getMessage());
                    }
                }
                if (targetFile.exists()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (textField == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (targetFile == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        textField.setText(targetFile.getPath());
                    });
                    LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(targetFile), true, false, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textField";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetFile";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/phing/ui/PhingConfigurable$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
    }

    public static void setUpDownloadLink(final @Nullable Project project, @NotNull HyperlinkLabel label, final @NotNull TextFieldWithBrowseButton textField, final @Nullable JPanel mainPanel) {
        if (label == null) {
            PhingConfigurable.$$$reportNull$$$0(5);
        }
        if (textField == null) {
            PhingConfigurable.$$$reportNull$$$0(6);
        }
        label.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                PhingConfigurable.downloadFile(project, mainPanel, textField);
            }
        });
    }

    @NotNull
    public String getId() {
        String string = StringUtil.notNullize((String)this.getHelpTopic());
        if (string == null) {
            PhingConfigurable.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/ui/PhingConfigurable";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/ui/PhingConfigurable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "downloadWithProgress";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setUpDownloadLink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPathLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/PhingBundle").getString("phing.properties.label.path.to.phing"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPhingTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(300, -1), null, null));
        this.myErrorInfoLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDownloadLabel = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setText("");
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

