/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildListener;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingExecutionHandler;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTarget;
import com.jetbrains.php.phing.ui.PhingConfigurable;
import com.jetbrains.php.phing.ui.explorer.PhingExplorer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingRunAction
extends AnAction {
    public static final DataKey<PhingBuildFile> SELECTED_BUILD_FILE = DataKey.create((String)"selectedPhingBuildFile");
    public static final DataKey<String> SELECTED_TARGET = DataKey.create((String)"selectedPhingTarget");

    public PhingRunAction() {
        super(PhingBundle.message("run.phing.file.or.target.action.name", new Object[0]), PhingBundle.message("run.phing.file.or.target.action.description", new Object[0]), AllIcons.Actions.Execute);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            PhingRunAction.$$$reportNull$$$0(0);
        }
        PhingBuildFile buildFile = PhingRunAction.getBuildFile(event);
        String targetName = PhingRunAction.getTarget(event);
        if (buildFile == null) {
            return;
        }
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        PhingStateService service = PhingStateService.getInstance(project);
        if (!PhingRunAction.requestValidPhingPath(buildFile, project, service)) {
            return;
        }
        PhingExecutionHandler.runBuild(buildFile, targetName, null, PhingBuildListener.NULL, event.getDataContext());
    }

    public static boolean requestValidPhingPath(PhingBuildFile buildFile, Project project, PhingStateService service) {
        if (PhingStateService.isPhingPathInvalid(service.getPhingPath())) {
            PsiFile psiFile;
            boolean isOk = ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PhingConfigurable(project));
            if (isOk && (psiFile = PsiManager.getInstance((Project)project).findFile(buildFile.getFile())) != null) {
                DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
            }
            if (PhingStateService.isPhingPathInvalid(service.getPhingPath())) {
                return false;
            }
        }
        return true;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            PhingRunAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        String place = event.getPlace();
        if ("PhingExplorerToolbar".equals(place)) {
            if (PhingExplorer.PHING_EXPLORER_KEY.getData(event.getDataContext()) != null) {
                presentation.setEnabled(PhingRunAction.getBuildFile(event) != null);
            }
            presentation.setText(PhingBundle.message("run.phing.file.or.target.action.name", new Object[0]));
        } else {
            presentation.setVisible(PhingRunAction.getBuildFile(event) != null);
            String targetName = PhingRunAction.getTarget(event);
            if (targetName != null) {
                presentation.setText(PhingBundle.message("run.phing.target.action.name", targetName));
            } else {
                presentation.setText(PhingBundle.message("run.phing.build.action.name", new Object[0]));
            }
        }
    }

    @Nullable
    private static String getTarget(AnActionEvent event) {
        if ("EditorPopup".equals(event.getPlace())) {
            PsiElement element;
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                return null;
            }
            int offset = editor.getCaretModel().getOffset();
            Project project = event.getProject();
            if (project == null) {
                return null;
            }
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (!(file instanceof XmlFile)) {
                return null;
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            }
            if ((element = file.findElementAt(offset)) == null) {
                return null;
            }
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (parentTag == null) {
                return null;
            }
            DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(parentTag);
            if (!(domElement instanceof PhingPredefinedElement)) {
                return null;
            }
            PhingPredefinedTarget target = (PhingPredefinedTarget)domElement.getParentOfType(PhingPredefinedTarget.class, false);
            if (target != null) {
                return (String)target.findName().getValue();
            }
            return null;
        }
        return (String)event.getData(SELECTED_TARGET);
    }

    @Nullable
    private static PhingBuildFile getBuildFile(AnActionEvent event) {
        if ("EditorPopup".equals(event.getPlace())) {
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                return null;
            }
            Project project = event.getProject();
            if (project == null) {
                return null;
            }
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (!(file instanceof XmlFile)) {
                return null;
            }
            DomFileDescription description = DomManager.getDomManager((Project)project).getDomFileDescription((XmlFile)file);
            if (description == null || !PhingPredefinedElement.class.isAssignableFrom(description.getRootElementClass())) {
                return null;
            }
            VirtualFile vFile = file.getVirtualFile();
            if (vFile == null) {
                return null;
            }
            PhingStateService service = PhingStateService.getInstance(project);
            PhingBuildFile buildFile = service.getBuildFile(vFile);
            if (buildFile != null) {
                return buildFile;
            }
            return new PhingBuildFile(vFile, project);
        }
        return (PhingBuildFile)event.getData(SELECTED_BUILD_FILE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/jetbrains/php/phing/ui/PhingRunAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

