/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentProjectLevelSetupForm {
    private static final Logger LOG = Logger.getInstance(DeploymentProjectLevelSetupForm.class);
    private JPanel myMainPanel;
    private JPanel myDeploymentProjectLevelServerSetupPanel;
    private HyperlinkLabel myDeploymentLevelWarningLabel;
    private ActionLink myDeploymentCreateAppLevelSeverLink;
    private JBLabel myDeploymentCreateAppLevelLabel;
    private ActionLink myDeploymentMoveServerLink;
    private JBLabel myDeploymentMoveServerLabel;
    private JPanel myCustomActionPanel;
    @Nullable
    private Project myProject;
    @NotNull
    private final Listener myListener;
    @Nullable
    private String myWebServerConfigId;
    @Nullable
    private final CreateRemoteSdkForm.BundleAccessor myBundleAccessor;

    public DeploymentProjectLevelSetupForm(@Nullable Project project, @Nullable CreateRemoteSdkForm.BundleAccessor bundleAccessor, @NotNull Listener listener) {
        if (listener == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myBundleAccessor = bundleAccessor;
        this.myListener = listener;
        String createTooltip = "Created deployment server will be visible for all projects";
        this.$$$setupUI$$$();
        this.myDeploymentCreateAppLevelLabel.setToolTipText("Created deployment server will be visible for all projects");
        this.myDeploymentCreateAppLevelSeverLink.setToolTipText("Created deployment server will be visible for all projects");
        String moveTooltip = "Deployment server will be visible for all projects";
        this.myDeploymentMoveServerLink.setToolTipText("Deployment server will be visible for all projects");
        this.myDeploymentMoveServerLabel.setToolTipText("Deployment server will be visible for all projects");
        this.myDeploymentProjectLevelServerSetupPanel.setBorder((Border)JBUI.Borders.empty((int)JBUI.scale((int)10), (int)0, (int)0, (int)0));
        this.configureDeploymentLevelWarning();
    }

    private void configureDeploymentLevelWarning() {
        String message = this.myBundleAccessor == null ? null : this.myBundleAccessor.messageOrNull("remote.interpreter.entity.name", new Object[0]);
        String mainMessage = "{0} is saved in <a href=#>IDE settings</a>, so it needs the deployment server to be saved there too. Which do you prefer?";
        this.myDeploymentLevelWarningLabel.setHtmlText(MessageFormat.format("{0} is saved in <a href=#>IDE settings</a>, so it needs the deployment server to be saved there too. Which do you prefer?", StringUtil.notNullize((String)message, (String)"Remote SDK")));
        this.myDeploymentLevelWarningLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpManager.getInstance().invokeHelp("concepts.project.settings");
                }
            }
        });
    }

    protected void createUIComponents() {
        this.myDeploymentCreateAppLevelSeverLink = new ActionLink("Create", new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                GroupedServersConfigManager instance = GroupedServersConfigManager.getInstance((Project)DeploymentProjectLevelSetupForm.this.myProject);
                WebServerConfig server = instance.findServer(DeploymentProjectLevelSetupForm.this.myWebServerConfigId);
                LOG.assertTrue(server != null, (Object)("Server with id " + DeploymentProjectLevelSetupForm.this.myWebServerConfigId + " not found"));
                LOG.assertTrue(server.isProjectLevel(), (Object)"IDE-level server with actions shown");
                WebServerConfig global = server.cloneWithNewIdAndCredentials();
                global.setIsProjectLevel(false);
                global.setName("Copy of project-level server '" + global.getName() + "'");
                instance.setUniqueName(global);
                PublishConfig publishConfig = PublishConfig.getInstance((Project)(DeploymentProjectLevelSetupForm.this.myProject == null ? ProjectManager.getInstance().getDefaultProject() : DeploymentProjectLevelSetupForm.this.myProject));
                List oldPaths = publishConfig.getExcludedPaths(server.getId());
                publishConfig.setExcludedPaths(global.getId(), oldPaths);
                List oldMappings = publishConfig.getPathMappings(server.getId());
                publishConfig.setPathMappings(global.getId(), oldMappings);
                instance.addServer(global);
                DeploymentProjectLevelSetupForm.this.myListener.onConfigCopied(global);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/DeploymentProjectLevelSetupForm$2", "actionPerformed"));
            }
        });
        this.myDeploymentMoveServerLink = new ActionLink("Move", new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                GroupedServersConfigManager instance = GroupedServersConfigManager.getInstance((Project)DeploymentProjectLevelSetupForm.this.myProject);
                WebServerConfig server = instance.findServer(DeploymentProjectLevelSetupForm.this.myWebServerConfigId);
                LOG.assertTrue(server != null, (Object)("Server with id " + DeploymentProjectLevelSetupForm.this.myWebServerConfigId + " not found"));
                LOG.assertTrue(server.isProjectLevel(), (Object)"IDE-level server with actions shown");
                WebServerConfig movedServer = instance.moveServer(server);
                DeploymentProjectLevelSetupForm.this.myListener.onConfigMoved(movedServer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/DeploymentProjectLevelSetupForm$3", "actionPerformed"));
            }
        });
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    public JPanel getCustomActionPanel() {
        JPanel jPanel = this.myCustomActionPanel;
        if (jPanel == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    public ActionLink getDeploymentMoveServerLink() {
        ActionLink actionLink = this.myDeploymentMoveServerLink;
        if (actionLink == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(3);
        }
        return actionLink;
    }

    @NotNull
    public HyperlinkLabel getDeploymentLevelWarningLabel() {
        HyperlinkLabel hyperlinkLabel = this.myDeploymentLevelWarningLabel;
        if (hyperlinkLabel == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(4);
        }
        return hyperlinkLabel;
    }

    @NotNull
    public JBLabel getDeploymentMoveServerLabel() {
        JBLabel jBLabel = this.myDeploymentMoveServerLabel;
        if (jBLabel == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(5);
        }
        return jBLabel;
    }

    public void setWebServerConfigId(@Nullable String webServerConfigId) {
        this.myWebServerConfigId = webServerConfigId;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/DeploymentProjectLevelSetupForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/DeploymentProjectLevelSetupForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomActionPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentMoveServerLink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentLevelWarningLabel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentMoveServerLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeploymentProjectLevelServerSetupPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeploymentLevelWarningLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ActionLink actionLink = this.myDeploymentCreateAppLevelSeverLink;
        actionLink.setText("Create");
        Component component = jPanel5.add((Component)actionLink);
        this.myDeploymentCreateAppLevelLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("copy of this deployment server in IDE settings");
        Component component2 = jPanel5.add((Component)jBLabel2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ActionLink actionLink2 = this.myDeploymentMoveServerLink;
        actionLink2.setText("Move");
        Component component3 = jPanel6.add((Component)actionLink2);
        this.myDeploymentMoveServerLabel = jBLabel = new JBLabel();
        jBLabel.setText("this server to IDE settings");
        Component component4 = jPanel6.add((Component)jBLabel);
        this.myCustomActionPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static interface Listener {
        public void onConfigCopied(@NotNull WebServerConfig var1);

        public void onConfigMoved(@NotNull WebServerConfig var1);
    }
}

